/*
 * Decompiled with CFR 0.152.
 */
package com.auditor.plugin.gui;

import com.auditor.plugin.AuditorPlugin;
import com.auditor.plugin.gui.BaseGUI;
import com.auditor.plugin.models.PlayerProfile;
import com.auditor.plugin.models.TransactionData;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class PlayerAnalysisGUI
extends BaseGUI {
    private final String targetPlayerName;
    private final OfflinePlayer targetPlayer;

    public PlayerAnalysisGUI(AuditorPlugin plugin, Player player, String targetPlayerName) {
        super(plugin, player, "\u00a76\u00a7lPlayer Analysis: " + targetPlayerName, 54);
        this.targetPlayerName = targetPlayerName;
        this.targetPlayer = Bukkit.getOfflinePlayer((String)targetPlayerName);
    }

    @Override
    protected void setupItems() {
        this.fillBorder(Material.GRAY_STAINED_GLASS_PANE);
        if (this.targetPlayer.getUniqueId() != null) {
            PlayerProfile profile = this.plugin.getDatabase().getPlayerProfile(this.targetPlayer.getUniqueId());
            this.inventory.setItem(13, this.createPlayerInfoItem(profile));
            this.inventory.setItem(20, this.createTransactionHistoryItem(profile));
            this.inventory.setItem(22, this.createRiskAssessmentItem(profile));
            this.inventory.setItem(24, this.createFlagsItem(profile));
            this.inventory.setItem(45, this.createBackItem());
            this.inventory.setItem(49, this.createRefreshItem());
        } else {
            this.inventory.setItem(22, this.createPlayerNotFoundItem());
            this.inventory.setItem(45, this.createBackItem());
        }
    }

    private ItemStack createPlayerInfoItem(PlayerProfile profile) {
        ArrayList<String> lore = new ArrayList<String>();
        if (profile != null) {
            lore.add("\u00a77Basic player information");
            lore.add("");
            lore.add("\u00a7bFirst Seen: \u00a7f" + this.formatTime(profile.getFirstSeen()));
            lore.add("\u00a7bLast Activity: \u00a7f" + this.formatTime(profile.getLastActivity()));
            lore.add("\u00a7bTotal Transactions: \u00a7f" + profile.getTotalTransactions());
            lore.add("\u00a7bTotal Spent: \u00a7f$" + this.formatNumber(profile.getTotalSpent()));
            lore.add("\u00a7bTotal Earned: \u00a7f$" + this.formatNumber(profile.getTotalEarned()));
            lore.add("\u00a7bLargest Transaction: \u00a7f$" + this.formatNumber(profile.getLargestTransaction()));
        } else {
            lore.add("\u00a77No data available for this player");
            lore.add("\u00a77Player may not have any transactions");
        }
        return this.createItem(Material.PLAYER_HEAD, "\u00a7b\u00a7lPlayer Information", lore);
    }

    private ItemStack createTransactionHistoryItem(PlayerProfile profile) {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77View recent transaction history");
        lore.add("");
        if (profile != null && this.targetPlayer.getUniqueId() != null) {
            List<TransactionData> transactions = this.plugin.getDatabase().getPlayerTransactions(this.targetPlayer.getUniqueId(), 5);
            if (!transactions.isEmpty()) {
                lore.add("\u00a7eRecent Transactions:");
                for (TransactionData transaction : transactions) {
                    String amountStr = (transaction.getAmount() >= 0.0 ? "+" : "") + this.formatNumber(transaction.getAmount());
                    lore.add("\u00a77- " + amountStr + " (" + this.formatTime(transaction.getTimestamp()) + ")");
                }
            } else {
                lore.add("\u00a77No transactions found");
            }
        } else {
            lore.add("\u00a77No transaction data available");
        }
        lore.add("");
        lore.add("\u00a7eClick to view full history");
        return this.createItem(Material.BOOK, "\u00a7e\u00a7lTransaction History", lore);
    }

    private ItemStack createRiskAssessmentItem(PlayerProfile profile) {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Player risk assessment and scoring");
        lore.add("");
        if (profile != null) {
            String riskColor = this.getRiskColor(profile.getRiskLevel());
            lore.add("\u00a7bRisk Level: " + riskColor + profile.getRiskLevel());
            lore.add("\u00a7bRisk Score: \u00a7f" + profile.getRiskScore() + "/100");
            lore.add("");
            lore.add("\u00a77Risk factors:");
            lore.add("\u00a77- Transaction frequency");
            lore.add("\u00a77- Amount patterns");
            lore.add("\u00a77- Behavioral anomalies");
        } else {
            lore.add("\u00a77No risk assessment available");
        }
        Material material = profile != null && profile.getRiskLevel().equals("HIGH") ? Material.RED_STAINED_GLASS : Material.GREEN_STAINED_GLASS;
        return this.createItem(material, "\u00a7c\u00a7lRisk Assessment", lore);
    }

    private ItemStack createFlagsItem(PlayerProfile profile) {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Player flags and monitoring status");
        lore.add("");
        if (profile != null) {
            if (profile.isMonitored()) {
                lore.add("\u00a7cMonitoring: \u00a7aEnabled");
            } else {
                lore.add("\u00a7cMonitoring: \u00a77Disabled");
            }
            if (profile.getFlags() != null && !profile.getFlags().isEmpty()) {
                lore.add("\u00a7cFlags: \u00a7f" + profile.getFlags());
            } else {
                lore.add("\u00a7cFlags: \u00a77None");
            }
            if (profile.getNotes() != null && !profile.getNotes().isEmpty()) {
                lore.add("\u00a7bNotes: \u00a7f" + profile.getNotes());
            }
        } else {
            lore.add("\u00a77No flags or monitoring data");
        }
        lore.add("");
        lore.add("\u00a7eClick to manage flags");
        return this.createItem(Material.REDSTONE, "\u00a7c\u00a7lFlags & Monitoring", lore);
    }

    private ItemStack createPlayerNotFoundItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a7cPlayer not found or no data available");
        lore.add("");
        lore.add("\u00a77Please check the player name");
        lore.add("\u00a77and try again");
        return this.createItem(Material.BARRIER, "\u00a7c\u00a7lPlayer Not Found", lore);
    }

    private ItemStack createBackItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Return to dashboard");
        return this.createItem(Material.ARROW, "\u00a7a\u00a7lBack to Dashboard", lore);
    }

    private ItemStack createRefreshItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Refresh player data");
        return this.createItem(Material.ARROW, "\u00a7a\u00a7lRefresh", lore);
    }

    private String getRiskColor(String riskLevel) {
        switch (riskLevel.toUpperCase()) {
            case "LOW": {
                return "\u00a7a";
            }
            case "MEDIUM": {
                return "\u00a7e";
            }
            case "HIGH": {
                return "\u00a7c";
            }
            case "CRITICAL": {
                return "\u00a74";
            }
        }
        return "\u00a77";
    }

    @Override
    public void handleClick(int slot, ClickType clickType) {
        switch (slot) {
            case 20: {
                if (this.targetPlayer.getUniqueId() != null) {
                    this.plugin.getGUIManager().openTransactionHistory(this.player, this.targetPlayerName, this.targetPlayer.getUniqueId());
                    break;
                }
                this.player.sendMessage("\u00a76[Auditor] \u00a7cPlayer not found - cannot view transaction history.");
                break;
            }
            case 24: {
                if (this.targetPlayer.getUniqueId() != null) {
                    this.plugin.getGUIManager().openFlagManagement(this.player, this.targetPlayerName, this.targetPlayer.getUniqueId());
                    break;
                }
                this.player.sendMessage("\u00a76[Auditor] \u00a7cPlayer not found - cannot manage flags.");
                break;
            }
            case 45: {
                this.plugin.getGUIManager().openDashboard(this.player);
                break;
            }
            case 49: {
                if (this.targetPlayer.getUniqueId() != null) {
                    this.refresh();
                    this.player.sendMessage("\u00a76[Auditor] \u00a7aPlayer data refreshed!");
                    break;
                }
                this.player.sendMessage("\u00a76[Auditor] \u00a7cCannot refresh - player not found.");
            }
        }
    }
}

