/*
 * Decompiled with CFR 0.152.
 */
package com.auditor.plugin.gui;

import com.auditor.plugin.AuditorPlugin;
import com.auditor.plugin.gui.BaseGUI;
import com.auditor.plugin.models.PlayerProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;

public class PlayerSelectionGUI
extends BaseGUI {
    private int currentPage = 0;
    private final int playersPerPage = 28;
    private List<PlayerProfile> allPlayers;
    private List<PlayerProfile> displayedPlayers;

    public PlayerSelectionGUI(AuditorPlugin plugin, Player player) {
        super(plugin, player, "\u00a76\u00a7lSelect Player to Analyze", 54);
        this.loadPlayers();
    }

    private void loadPlayers() {
        this.allPlayers = new ArrayList<PlayerProfile>();
        List<PlayerProfile> dbPlayers = this.plugin.getDatabase().getTopPlayersByTransactions(10000);
        this.plugin.getLogger().info("[PlayerSelection] Loaded " + dbPlayers.size() + " players from database");
        this.allPlayers.addAll(dbPlayers);
        for (Object onlinePlayer : Bukkit.getOnlinePlayers()) {
            boolean bl = this.allPlayers.stream().anyMatch(arg_0 -> PlayerSelectionGUI.lambda$loadPlayers$0((Player)onlinePlayer, arg_0));
            if (bl) continue;
            PlayerProfile onlineProfile = new PlayerProfile(onlinePlayer.getUniqueId(), onlinePlayer.getName(), System.currentTimeMillis(), System.currentTimeMillis(), 0, 0.0, 0.0, 0.0, 0.0, 0, "LOW", "", "", false);
            this.allPlayers.add(0, onlineProfile);
            this.plugin.getLogger().info("[PlayerSelection] Added online player not in DB: " + onlinePlayer.getName());
        }
        if (this.allPlayers.isEmpty()) {
            String[] genericNames;
            this.plugin.getLogger().info("[PlayerSelection] No players found, creating sample profiles for demonstration");
            HashMap<String, UUID> realMinecraftAccounts = new HashMap<String, UUID>();
            realMinecraftAccounts.put("Notch", UUID.fromString("069a79f4-44e9-4726-a5be-fca90e38aaf5"));
            realMinecraftAccounts.put("jeb_", UUID.fromString("853c80ef-3c37-49fd-aa49-938b674adae6"));
            realMinecraftAccounts.put("Dinnerbone", UUID.fromString("61699b2e-d327-4a01-9f1e-0ea8c3f06bc6"));
            realMinecraftAccounts.put("Grumm", UUID.fromString("e6b5c088-0680-44df-9e1b-9bf11792291b"));
            for (Map.Entry entry : realMinecraftAccounts.entrySet()) {
                PlayerProfile sampleProfile = new PlayerProfile((UUID)entry.getValue(), (String)entry.getKey(), System.currentTimeMillis() - (long)((int)(Math.random() * 7.0 * 24.0 * 60.0 * 60.0 * 1000.0)), System.currentTimeMillis() - (long)((int)(Math.random() * 24.0 * 60.0 * 60.0 * 1000.0)), (int)(Math.random() * 100.0) + 1, Math.random() * 50000.0, Math.random() * 45000.0, Math.random() * 100000.0, Math.random() * 75000.0, (int)(Math.random() * 50.0), Math.random() > 0.7 ? "HIGH" : (Math.random() > 0.4 ? "MEDIUM" : "LOW"), Math.random() > 0.8 ? "SUSPICIOUS,BOT_SUSPECTED" : (Math.random() > 0.6 ? "TRUSTED" : ""), "", Math.random() > 0.8);
                this.allPlayers.add(sampleProfile);
                this.plugin.getLogger().info("[PlayerSelection] Created sample profile for " + (String)entry.getKey() + " with real UUID");
            }
            for (String name : genericNames = new String[]{"TestUser1", "TestUser2", "SamplePlayer"}) {
                PlayerProfile sampleProfile = new PlayerProfile(UUID.nameUUIDFromBytes(("OfflinePlayer:" + name).getBytes()), name, System.currentTimeMillis() - (long)((int)(Math.random() * 7.0 * 24.0 * 60.0 * 60.0 * 1000.0)), System.currentTimeMillis() - (long)((int)(Math.random() * 24.0 * 60.0 * 60.0 * 1000.0)), (int)(Math.random() * 100.0) + 1, Math.random() * 50000.0, Math.random() * 45000.0, Math.random() * 100000.0, Math.random() * 75000.0, (int)(Math.random() * 50.0), Math.random() > 0.7 ? "HIGH" : (Math.random() > 0.4 ? "MEDIUM" : "LOW"), Math.random() > 0.8 ? "SUSPICIOUS,BOT_SUSPECTED" : (Math.random() > 0.6 ? "TRUSTED" : ""), "", Math.random() > 0.8);
                this.allPlayers.add(sampleProfile);
                this.plugin.getLogger().info("[PlayerSelection] Created generic sample profile for " + name);
            }
        }
        this.plugin.getLogger().info("[PlayerSelection] Total players available: " + this.allPlayers.size());
        this.allPlayers.sort((p1, p2) -> {
            boolean p2Online;
            boolean p1Online = Bukkit.getPlayer((UUID)p1.getPlayerUUID()) != null;
            boolean bl = p2Online = Bukkit.getPlayer((UUID)p2.getPlayerUUID()) != null;
            if (p1Online && !p2Online) {
                return -1;
            }
            if (!p1Online && p2Online) {
                return 1;
            }
            int activityCompare = Long.compare(p2.getLastActivity(), p1.getLastActivity());
            if (activityCompare != 0) {
                return activityCompare;
            }
            return Integer.compare(p2.getTotalTransactions(), p1.getTotalTransactions());
        });
        for (int i = 0; i < Math.min(5, this.allPlayers.size()); ++i) {
            PlayerProfile p = this.allPlayers.get(i);
            this.plugin.getLogger().info("[PlayerSelection] Player " + (i + 1) + ": " + p.getPlayerName() + " (Transactions: " + p.getTotalTransactions() + ", Risk: " + p.getRiskLevel() + ")");
        }
        this.displayedPlayers = new ArrayList<PlayerProfile>(this.allPlayers);
    }

    @Override
    protected void setupItems() {
        this.fillBorder(Material.GRAY_STAINED_GLASS_PANE);
        int startIndex = this.currentPage * 28;
        int endIndex = Math.min(startIndex + 28, this.displayedPlayers.size());
        this.plugin.getLogger().info("[PlayerSelection] Displaying players " + startIndex + " to " + endIndex + " of " + this.displayedPlayers.size() + " total");
        int[] playerSlots = new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};
        int slotIndex = 0;
        for (int i = startIndex; i < endIndex && slotIndex < playerSlots.length; ++slotIndex, ++i) {
            PlayerProfile profile = this.displayedPlayers.get(i);
            this.inventory.setItem(playerSlots[slotIndex], this.createPlayerHeadItem(profile));
            this.plugin.getLogger().info("[PlayerSelection] Placed " + profile.getPlayerName() + " at slot " + playerSlots[slotIndex]);
        }
        if (this.currentPage > 0) {
            this.inventory.setItem(45, this.createPreviousPageItem());
        }
        this.inventory.setItem(49, this.createBackItem());
        if (endIndex < this.displayedPlayers.size()) {
            this.inventory.setItem(53, this.createNextPageItem());
        }
        this.inventory.setItem(46, this.createOnlinePlayersFilterItem());
        this.inventory.setItem(47, this.createAllPlayersFilterItem());
        this.inventory.setItem(51, this.createSearchInfoItem());
        this.inventory.setItem(52, this.createRefreshItem());
    }

    private ItemStack createPlayerHeadItem(PlayerProfile profile) {
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
        SkullMeta meta = (SkullMeta)skull.getItemMeta();
        if (meta != null) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)profile.getPlayerUUID());
            try {
                meta.setOwningPlayer(offlinePlayer);
                this.plugin.getLogger().info("[PlayerSelection] Set skull owning player to: " + profile.getPlayerName() + " (UUID: " + profile.getPlayerUUID() + ")");
            }
            catch (NoSuchMethodError e) {
                try {
                    meta.setOwner(profile.getPlayerName());
                    this.plugin.getLogger().info("[PlayerSelection] Using deprecated setOwner for: " + profile.getPlayerName());
                }
                catch (Exception e2) {
                    this.plugin.getLogger().warning("[PlayerSelection] Failed to set skull owner: " + e2.getMessage());
                }
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("[PlayerSelection] Failed to set skull owning player for " + profile.getPlayerName() + ": " + e.getMessage());
                try {
                    meta.setOwner(profile.getPlayerName());
                }
                catch (Exception e2) {}
            }
        } else {
            this.plugin.getLogger().warning("[PlayerSelection] SkullMeta is null for " + profile.getPlayerName());
        }
        meta.setDisplayName("\u00a7b\u00a7l" + profile.getPlayerName());
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Click to analyze this player");
        lore.add("");
        OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)profile.getPlayerUUID());
        boolean isOnline = offlinePlayer.isOnline();
        lore.add("\u00a7bStatus: " + (isOnline ? "\u00a7aOnline" : "\u00a77Offline"));
        if (profile.getTotalTransactions() > 0) {
            lore.add("\u00a7bTransactions: \u00a7f" + profile.getTotalTransactions());
            lore.add("\u00a7bTotal Spent: \u00a7f$" + this.formatNumber(profile.getTotalSpent()));
            lore.add("\u00a7bTotal Earned: \u00a7f$" + this.formatNumber(profile.getTotalEarned()));
            lore.add("\u00a7bRisk Level: " + this.getRiskColor(profile.getRiskLevel()) + profile.getRiskLevel());
            lore.add("\u00a7bLast Activity: \u00a7f" + this.formatTime(profile.getLastActivity()));
        } else {
            lore.add("\u00a77No transaction data available");
            if (isOnline) {
                lore.add("\u00a77Player is currently online");
            }
        }
        lore.add("");
        lore.add("\u00a7eClick to view detailed analysis");
        meta.setLore(lore);
        skull.setItemMeta((ItemMeta)meta);
        return skull;
    }

    private ItemStack createPreviousPageItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Go to previous page");
        lore.add("\u00a77Page " + this.currentPage + " of " + this.getTotalPages());
        return this.createItem(Material.ARROW, "\u00a7a\u00a7lPrevious Page", lore);
    }

    private ItemStack createNextPageItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Go to next page");
        lore.add("\u00a77Page " + (this.currentPage + 2) + " of " + this.getTotalPages());
        return this.createItem(Material.ARROW, "\u00a7a\u00a7lNext Page", lore);
    }

    private ItemStack createOnlinePlayersFilterItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Show only online players");
        lore.add("\u00a77Currently online: \u00a7f" + Bukkit.getOnlinePlayers().size());
        return this.createItem(Material.LIME_STAINED_GLASS, "\u00a7a\u00a7lOnline Players", lore);
    }

    private ItemStack createAllPlayersFilterItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Show all tracked players");
        lore.add("\u00a77Total players: \u00a7f" + this.allPlayers.size());
        return this.createItem(Material.WHITE_STAINED_GLASS, "\u00a7f\u00a7lAll Players", lore);
    }

    private ItemStack createSearchInfoItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77To search for a specific player:");
        lore.add("\u00a77Use command: \u00a7f/auditor player <name>");
        lore.add("");
        lore.add("\u00a77Showing page " + (this.currentPage + 1) + " of " + this.getTotalPages());
        lore.add("\u00a77Displaying: \u00a7f" + this.displayedPlayers.size() + " players");
        lore.add("\u00a77Total in database: \u00a7f" + this.allPlayers.size());
        return this.createItem(Material.COMPASS, "\u00a7e\u00a7lSearch Info", lore);
    }

    private ItemStack createBackItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Return to dashboard");
        return this.createItem(Material.BARRIER, "\u00a7c\u00a7lBack to Dashboard", lore);
    }

    private ItemStack createRefreshItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Refresh player list");
        lore.add("\u00a77Updates online status and data");
        return this.createItem(Material.ARROW, "\u00a7a\u00a7lRefresh", lore);
    }

    private int getTotalPages() {
        return (int)Math.ceil((double)this.displayedPlayers.size() / 28.0);
    }

    private String getRiskColor(String riskLevel) {
        switch (riskLevel.toUpperCase()) {
            case "LOW": {
                return "\u00a7a";
            }
            case "MEDIUM": {
                return "\u00a7e";
            }
            case "HIGH": {
                return "\u00a7c";
            }
            case "CRITICAL": {
                return "\u00a74";
            }
        }
        return "\u00a77";
    }

    @Override
    public void handleClick(int slot, ClickType clickType) {
        if (slot >= 0 && slot < 45 && this.inventory.getItem(slot) != null && this.inventory.getItem(slot).getType() == Material.PLAYER_HEAD) {
            int playerIndex = this.getPlayerIndexFromSlot(slot);
            this.plugin.getLogger().info("[PlayerSelection] Clicked slot " + slot + " which corresponds to player index " + playerIndex);
            if (playerIndex >= 0 && playerIndex < this.displayedPlayers.size()) {
                PlayerProfile profile = this.displayedPlayers.get(playerIndex);
                this.plugin.getLogger().info("[PlayerSelection] Opening analysis for player: " + profile.getPlayerName());
                this.plugin.getGUIManager().openPlayerAnalysis(this.player, profile.getPlayerName());
                return;
            }
            this.plugin.getLogger().warning("[PlayerSelection] Invalid player index " + playerIndex + " (total players: " + this.displayedPlayers.size() + ")");
        }
        switch (slot) {
            case 45: {
                if (this.currentPage <= 0) break;
                --this.currentPage;
                this.refresh();
                break;
            }
            case 46: {
                this.filterOnlinePlayers();
                break;
            }
            case 47: {
                this.displayedPlayers = new ArrayList<PlayerProfile>(this.allPlayers);
                this.currentPage = 0;
                this.refresh();
                this.player.sendMessage("\u00a76[Auditor] \u00a7aShowing all " + this.displayedPlayers.size() + " players");
                break;
            }
            case 49: {
                this.plugin.getGUIManager().openDashboard(this.player);
                break;
            }
            case 52: {
                this.loadPlayers();
                this.refresh();
                this.player.sendMessage("\u00a76[Auditor] \u00a7aPlayer list refreshed!");
                break;
            }
            case 53: {
                if ((this.currentPage + 1) * 28 >= this.displayedPlayers.size()) break;
                ++this.currentPage;
                this.refresh();
            }
        }
    }

    private int getPlayerIndexFromSlot(int slot) {
        int[] playerSlots = new int[]{10, 11, 12, 13, 14, 15, 16, 19, 20, 21, 22, 23, 24, 25, 28, 29, 30, 31, 32, 33, 34, 37, 38, 39, 40, 41, 42, 43};
        for (int i = 0; i < playerSlots.length; ++i) {
            if (playerSlots[i] != slot) continue;
            return this.currentPage * 28 + i;
        }
        return -1;
    }

    private void filterOnlinePlayers() {
        boolean currentPlayerExists;
        this.displayedPlayers = new ArrayList<PlayerProfile>();
        for (PlayerProfile profile : this.allPlayers) {
            OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((UUID)profile.getPlayerUUID());
            if (!offlinePlayer.isOnline()) continue;
            this.displayedPlayers.add(profile);
        }
        if (this.displayedPlayers.isEmpty() && !(currentPlayerExists = this.allPlayers.stream().anyMatch(p -> p.getPlayerUUID().equals(this.player.getUniqueId())))) {
            PlayerProfile currentPlayerProfile = new PlayerProfile(this.player.getUniqueId(), this.player.getName(), System.currentTimeMillis(), System.currentTimeMillis(), 0, 0.0, 0.0, 0.0, 0.0, 0, "LOW", "", "", false);
            this.displayedPlayers.add(currentPlayerProfile);
            this.plugin.getLogger().info("[PlayerSelection] Added current player " + this.player.getName() + " to display");
        }
        this.currentPage = 0;
        this.refresh();
        this.player.sendMessage("\u00a76[Auditor] \u00a7aShowing " + this.displayedPlayers.size() + " online players");
    }

    private static /* synthetic */ boolean lambda$loadPlayers$0(Player onlinePlayer, PlayerProfile p) {
        return p.getPlayerUUID().equals(onlinePlayer.getUniqueId());
    }
}

