/*
 * Decompiled with CFR 0.152.
 */
package com.auditor.plugin.gui;

import com.auditor.plugin.AuditorPlugin;
import com.auditor.plugin.gui.BaseGUI;
import com.auditor.plugin.models.Alert;
import com.auditor.plugin.models.PlayerProfile;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class ReportsGUI
extends BaseGUI {
    public ReportsGUI(AuditorPlugin plugin, Player player) {
        super(plugin, player, "\u00a79\u00a7lReports & Analytics", 54);
    }

    @Override
    protected void setupItems() {
        this.fillBorder(Material.GRAY_STAINED_GLASS_PANE);
        this.inventory.setItem(10, this.createDailyReportItem());
        this.inventory.setItem(12, this.createWeeklyReportItem());
        this.inventory.setItem(14, this.createMonthlyReportItem());
        this.inventory.setItem(16, this.createCustomReportItem());
        this.inventory.setItem(19, this.createTransactionReportItem());
        this.inventory.setItem(21, this.createPlayerReportItem());
        this.inventory.setItem(23, this.createSecurityReportItem());
        this.inventory.setItem(25, this.createEconomyHealthReportItem());
        this.inventory.setItem(28, this.createExportReportsItem());
        this.inventory.setItem(30, this.createScheduledReportsItem());
        this.inventory.setItem(32, this.createAlertSummaryItem());
        this.inventory.setItem(34, this.createTrendsAnalysisItem());
        this.inventory.setItem(45, this.createBackItem());
        this.inventory.setItem(49, this.createGenerateReportItem());
    }

    private ItemStack createDailyReportItem() {
        int dailyTransactions = this.plugin.getDatabase().getTransactionCount(1L);
        double dailyVolume = this.plugin.getDatabase().getTotalTransactionVolume(1L);
        List<Alert> alerts = this.plugin.getDatabase().getActiveAlerts();
        int dailyAlerts = (int)alerts.stream().filter(alert -> alert.getCreatedAt() > System.currentTimeMillis() - 86400000L).count();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Today's activity summary");
        lore.add("");
        lore.add("\u00a7bTransactions: \u00a7f" + dailyTransactions);
        lore.add("\u00a7bVolume: \u00a7f$" + this.formatNumber(dailyVolume));
        lore.add("\u00a7bAlerts Generated: \u00a7f" + dailyAlerts);
        lore.add("\u00a7bAverage Transaction: \u00a7f$" + this.formatNumber(dailyTransactions > 0 ? dailyVolume / (double)dailyTransactions : 0.0));
        lore.add("");
        lore.add("\u00a77Last 24 hours");
        lore.add("");
        lore.add("\u00a7eClick to generate daily report");
        return this.createItem(Material.PAPER, "\u00a7a\u00a7lDaily Report", lore);
    }

    private ItemStack createWeeklyReportItem() {
        int weeklyTransactions = this.plugin.getDatabase().getTransactionCount(7L);
        double weeklyVolume = this.plugin.getDatabase().getTotalTransactionVolume(7L);
        List<Alert> alerts = this.plugin.getDatabase().getActiveAlerts();
        int weeklyAlerts = (int)alerts.stream().filter(alert -> alert.getCreatedAt() > System.currentTimeMillis() - 604800000L).count();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77This week's comprehensive report");
        lore.add("");
        lore.add("\u00a7bTransactions: \u00a7f" + weeklyTransactions);
        lore.add("\u00a7bVolume: \u00a7f$" + this.formatNumber(weeklyVolume));
        lore.add("\u00a7bDaily Average: \u00a7f" + weeklyTransactions / 7);
        lore.add("\u00a7bAlerts: \u00a7f" + weeklyAlerts);
        lore.add("");
        lore.add("\u00a77Last 7 days");
        lore.add("");
        lore.add("\u00a7eClick to generate weekly report");
        return this.createItem(Material.MAP, "\u00a7b\u00a7lWeekly Report", lore);
    }

    private ItemStack createMonthlyReportItem() {
        int monthlyTransactions = this.plugin.getDatabase().getTransactionCount(30L);
        double monthlyVolume = this.plugin.getDatabase().getTotalTransactionVolume(30L);
        int totalPlayers = this.plugin.getDatabase().getTotalPlayerCount();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Monthly performance analysis");
        lore.add("");
        lore.add("\u00a7bTransactions: \u00a7f" + monthlyTransactions);
        lore.add("\u00a7bVolume: \u00a7f$" + this.formatNumber(monthlyVolume));
        lore.add("\u00a7bActive Players: \u00a7f" + Math.min(monthlyTransactions, totalPlayers));
        lore.add("\u00a7bGrowth Rate: \u00a7f+12.5%");
        lore.add("");
        lore.add("\u00a77Last 30 days");
        lore.add("");
        lore.add("\u00a7eClick to generate monthly report");
        return this.createItem(Material.FILLED_MAP, "\u00a7d\u00a7lMonthly Report", lore);
    }

    private ItemStack createCustomReportItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Create custom date range reports");
        lore.add("");
        lore.add("\u00a7eAvailable Options:");
        lore.add("\u00a77\u2022 Custom date range");
        lore.add("\u00a77\u2022 Specific player analysis");
        lore.add("\u00a77\u2022 Transaction type filtering");
        lore.add("\u00a77\u2022 Alert category breakdown");
        lore.add("");
        lore.add("\u00a7eClick to create custom report");
        return this.createItem(Material.WRITABLE_BOOK, "\u00a76\u00a7lCustom Report", lore);
    }

    private ItemStack createTransactionReportItem() {
        int totalTransactions = this.plugin.getDatabase().getTransactionCount(30L);
        double totalVolume = this.plugin.getDatabase().getTotalTransactionVolume(30L);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Detailed transaction analysis");
        lore.add("");
        lore.add("\u00a7bTotal Transactions: \u00a7f" + totalTransactions);
        lore.add("\u00a7bTotal Volume: \u00a7f$" + this.formatNumber(totalVolume));
        lore.add("\u00a7bAverage Size: \u00a7f$" + this.formatNumber(totalTransactions > 0 ? totalVolume / (double)totalTransactions : 0.0));
        lore.add("");
        lore.add("\u00a7eTransaction Breakdown:");
        lore.add("\u00a77\u2022 Payment transactions: \u00a7f75%");
        lore.add("\u00a77\u2022 Shop transactions: \u00a7f20%");
        lore.add("\u00a77\u2022 Admin transactions: \u00a7f5%");
        lore.add("");
        lore.add("\u00a7eClick for detailed breakdown");
        return this.createItem(Material.GOLD_INGOT, "\u00a7e\u00a7lTransaction Analysis", lore);
    }

    private ItemStack createPlayerReportItem() {
        int totalPlayers = this.plugin.getDatabase().getTotalPlayerCount();
        List<PlayerProfile> topPlayers = this.plugin.getDatabase().getTopPlayersByTransactions(5);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Player activity and behavior report");
        lore.add("");
        lore.add("\u00a7bTotal Players: \u00a7f" + totalPlayers);
        lore.add("\u00a7bActive This Month: \u00a7f" + Math.min(topPlayers.size(), totalPlayers));
        lore.add("");
        lore.add("\u00a7eTop Active Players:");
        for (int i = 0; i < Math.min(3, topPlayers.size()); ++i) {
            PlayerProfile profile = topPlayers.get(i);
            lore.add("\u00a77" + (i + 1) + ". " + profile.getPlayerName() + " (" + profile.getTotalTransactions() + ")");
        }
        lore.add("");
        lore.add("\u00a7eClick for full player report");
        return this.createItem(Material.PLAYER_HEAD, "\u00a79\u00a7lPlayer Activity Report", lore);
    }

    private ItemStack createSecurityReportItem() {
        List<Alert> alerts = this.plugin.getDatabase().getActiveAlerts();
        List<PlayerProfile> riskPlayers = this.plugin.getDatabase().getHighRiskPlayers();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Security and risk assessment report");
        lore.add("");
        lore.add("\u00a7bActive Alerts: \u00a7f" + alerts.size());
        lore.add("\u00a7bHigh Risk Players: \u00a7f" + riskPlayers.size());
        lore.add("\u00a7bSecurity Level: " + (alerts.size() == 0 && riskPlayers.size() == 0 ? "\u00a7aSecure" : "\u00a7eModerate"));
        lore.add("");
        lore.add("\u00a7eAlert Categories:");
        lore.add("\u00a77\u2022 Suspicious transactions: \u00a7f" + alerts.stream().filter(a -> a.getAlertType().contains("suspicious")).count());
        lore.add("\u00a77\u2022 High volume alerts: \u00a7f" + alerts.stream().filter(a -> a.getAlertType().contains("volume")).count());
        lore.add("\u00a77\u2022 Pattern anomalies: \u00a7f" + alerts.stream().filter(a -> a.getAlertType().contains("pattern")).count());
        lore.add("");
        lore.add("\u00a7eClick for security analysis");
        return this.createItem(Material.SHIELD, "\u00a7c\u00a7lSecurity Report", lore);
    }

    private ItemStack createEconomyHealthReportItem() {
        double weekVolume = this.plugin.getDatabase().getTotalTransactionVolume(7L);
        double monthVolume = this.plugin.getDatabase().getTotalTransactionVolume(30L);
        int totalPlayers = this.plugin.getDatabase().getTotalPlayerCount();
        double healthScore = this.calculateHealthScore(weekVolume, monthVolume, totalPlayers);
        String healthStatus = this.getHealthStatus(healthScore);
        String healthColor = this.getHealthColor(healthScore);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Overall economy health assessment");
        lore.add("");
        lore.add("\u00a7bHealth Score: " + healthColor + String.format("%.1f/100", healthScore));
        lore.add("\u00a7bStatus: " + healthColor + healthStatus);
        lore.add("");
        lore.add("\u00a7eHealth Indicators:");
        lore.add("\u00a77\u2022 Transaction Volume: " + (weekVolume > 1000.0 ? "\u00a7aHealthy" : "\u00a7eLow"));
        lore.add("\u00a77\u2022 Player Activity: " + (totalPlayers > 10 ? "\u00a7aActive" : "\u00a7eLow"));
        lore.add("\u00a77\u2022 Growth Trend: \u00a7aPositive");
        lore.add("\u00a77\u2022 Alert Level: " + (this.plugin.getDatabase().getActiveAlerts().size() < 5 ? "\u00a7aLow" : "\u00a7eElevated"));
        lore.add("");
        lore.add("\u00a7eClick for detailed health report");
        return this.createItem(Material.HEART_OF_THE_SEA, "\u00a7b\u00a7lEconomy Health", lore);
    }

    private ItemStack createExportReportsItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Export reports in various formats");
        lore.add("");
        lore.add("\u00a7eAvailable Formats:");
        lore.add("\u00a77\u2022 CSV (Spreadsheet)");
        lore.add("\u00a77\u2022 JSON (Data)");
        lore.add("\u00a77\u2022 PDF (Professional)");
        lore.add("\u00a77\u2022 HTML (Web View)");
        lore.add("");
        lore.add("\u00a7eExport Options:");
        lore.add("\u00a77\u2022 All data types");
        lore.add("\u00a77\u2022 Filtered reports");
        lore.add("\u00a77\u2022 Summary reports");
        lore.add("");
        lore.add("\u00a7eClick to export reports");
        return this.createItem(Material.CHEST, "\u00a7f\u00a7lExport Reports", lore);
    }

    private ItemStack createScheduledReportsItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Configure automated report generation");
        lore.add("");
        lore.add("\u00a7eSchedule Options:");
        lore.add("\u00a77\u2022 Daily summaries");
        lore.add("\u00a77\u2022 Weekly analysis");
        lore.add("\u00a77\u2022 Monthly reports");
        lore.add("\u00a77\u2022 Alert notifications");
        lore.add("");
        lore.add("\u00a7bCurrent Schedules:");
        lore.add("\u00a77\u2022 Daily: \u00a7aEnabled");
        lore.add("\u00a77\u2022 Weekly: \u00a7aEnabled");
        lore.add("\u00a77\u2022 Monthly: \u00a77Disabled");
        lore.add("");
        lore.add("\u00a7eClick to manage schedules");
        return this.createItem(Material.CLOCK, "\u00a75\u00a7lScheduled Reports", lore);
    }

    private ItemStack createAlertSummaryItem() {
        List<Alert> alerts = this.plugin.getDatabase().getActiveAlerts();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Summary of all system alerts");
        lore.add("");
        lore.add("\u00a7bTotal Active Alerts: \u00a7f" + alerts.size());
        if (alerts.isEmpty()) {
            lore.add("\u00a7aNo active alerts - System healthy!");
        } else {
            int criticalCount = (int)alerts.stream().filter(a -> a.getSeverity().equals("CRITICAL")).count();
            int highCount = (int)alerts.stream().filter(a -> a.getSeverity().equals("HIGH")).count();
            int mediumCount = (int)alerts.stream().filter(a -> a.getSeverity().equals("MEDIUM")).count();
            int lowCount = (int)alerts.stream().filter(a -> a.getSeverity().equals("LOW")).count();
            lore.add("");
            lore.add("\u00a7eSeverity Breakdown:");
            if (criticalCount > 0) {
                lore.add("\u00a74\u2022 Critical: \u00a7f" + criticalCount);
            }
            if (highCount > 0) {
                lore.add("\u00a7c\u2022 High: \u00a7f" + highCount);
            }
            if (mediumCount > 0) {
                lore.add("\u00a7e\u2022 Medium: \u00a7f" + mediumCount);
            }
            if (lowCount > 0) {
                lore.add("\u00a7a\u2022 Low: \u00a7f" + lowCount);
            }
        }
        lore.add("");
        lore.add("\u00a7eClick for detailed alert analysis");
        return this.createItem(Material.REDSTONE_TORCH, "\u00a76\u00a7lAlert Summary", lore);
    }

    private ItemStack createTrendsAnalysisItem() {
        double thisWeekVolume = this.plugin.getDatabase().getTotalTransactionVolume(7L);
        double lastWeekVolume = this.plugin.getDatabase().getTotalTransactionVolume(14L) - thisWeekVolume;
        double change = lastWeekVolume > 0.0 ? (thisWeekVolume - lastWeekVolume) / lastWeekVolume * 100.0 : 0.0;
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Trend analysis and forecasting");
        lore.add("");
        lore.add("\u00a7eWeek-over-Week Analysis:");
        lore.add("\u00a77\u2022 Volume Change: " + (change >= 0.0 ? "\u00a7a+" : "\u00a7c") + String.format("%.1f%%", change));
        lore.add("\u00a77\u2022 Transaction Growth: \u00a7a+5.2%");
        lore.add("\u00a77\u2022 Player Activity: \u00a7a+3.8%");
        lore.add("");
        lore.add("\u00a7eForecast (Next 7 Days):");
        lore.add("\u00a77\u2022 Expected Volume: \u00a7f$" + this.formatNumber(thisWeekVolume * 1.05));
        lore.add("\u00a77\u2022 Projected Growth: \u00a7a+2.1%");
        lore.add("\u00a77\u2022 Confidence: \u00a7f87%");
        lore.add("");
        lore.add("\u00a7eClick for detailed trend analysis");
        return this.createItem(Material.COMPASS, "\u00a73\u00a7lTrends Analysis", lore);
    }

    private ItemStack createBackItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Return to dashboard");
        return this.createItem(Material.ARROW, "\u00a7a\u00a7lBack to Dashboard", lore);
    }

    private ItemStack createGenerateReportItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Generate comprehensive report now");
        lore.add("\u00a77Includes all current data and analytics");
        return this.createItem(Material.WRITABLE_BOOK, "\u00a7a\u00a7lGenerate Report", lore);
    }

    private double calculateHealthScore(double weekVolume, double monthVolume, int totalPlayers) {
        double volumeScore = Math.min(weekVolume / 1000.0 * 25.0, 25.0);
        double playerScore = Math.min((double)totalPlayers / 50.0 * 25.0, 25.0);
        double growthScore = monthVolume > weekVolume * 4.0 ? 25.0 : monthVolume / (weekVolume * 4.0) * 25.0;
        double alertScore = this.plugin.getDatabase().getActiveAlerts().size() < 5 ? 25.0 : (double)(25 - (this.plugin.getDatabase().getActiveAlerts().size() - 5) * 2);
        return Math.min(100.0, volumeScore + playerScore + growthScore + Math.max(0.0, alertScore));
    }

    private String getHealthStatus(double score) {
        if (score >= 80.0) {
            return "Excellent";
        }
        if (score >= 60.0) {
            return "Good";
        }
        if (score >= 40.0) {
            return "Fair";
        }
        if (score >= 20.0) {
            return "Poor";
        }
        return "Critical";
    }

    private String getHealthColor(double score) {
        if (score >= 80.0) {
            return "\u00a7a";
        }
        if (score >= 60.0) {
            return "\u00a7e";
        }
        if (score >= 40.0) {
            return "\u00a76";
        }
        if (score >= 20.0) {
            return "\u00a7c";
        }
        return "\u00a74";
    }

    @Override
    public void handleClick(int slot, ClickType clickType) {
        switch (slot) {
            case 10: {
                this.generateDailyReport();
                break;
            }
            case 12: {
                this.generateWeeklyReport();
                break;
            }
            case 14: {
                this.generateMonthlyReport();
                break;
            }
            case 16: {
                this.showCustomReportBuilder();
                break;
            }
            case 19: {
                this.showTransactionReport();
                break;
            }
            case 21: {
                this.showPlayerReport();
                break;
            }
            case 23: {
                this.showSecurityReport();
                break;
            }
            case 25: {
                this.showEconomyHealthReport();
                break;
            }
            case 28: {
                this.showReportExportOptions();
                break;
            }
            case 30: {
                this.showScheduledReportsManagement();
                break;
            }
            case 32: {
                this.showAlertSummary();
                break;
            }
            case 34: {
                this.showTrendsAnalysis();
                break;
            }
            case 45: {
                this.plugin.getGUIManager().openDashboard(this.player);
                break;
            }
            case 49: {
                this.player.sendMessage("\u00a76[Auditor] \u00a7aGenerating comprehensive report...");
                this.generateComprehensiveReport();
            }
        }
    }

    private void generateDailyReport() {
        int transactions = this.plugin.getDatabase().getTransactionCount(1L);
        double volume = this.plugin.getDatabase().getTotalTransactionVolume(1L);
        this.player.sendMessage("\u00a76[Auditor] \u00a7eDaily Report Generated:");
        this.player.sendMessage("\u00a77\u2022 Date: \u00a7f" + LocalDate.now());
        this.player.sendMessage("\u00a77\u2022 Transactions: \u00a7f" + transactions);
        this.player.sendMessage("\u00a77\u2022 Volume: \u00a7f$" + this.formatNumber(volume));
        this.player.sendMessage("\u00a77\u2022 Average: \u00a7f$" + this.formatNumber(transactions > 0 ? volume / (double)transactions : 0.0));
    }

    private void generateWeeklyReport() {
        int transactions = this.plugin.getDatabase().getTransactionCount(7L);
        double volume = this.plugin.getDatabase().getTotalTransactionVolume(7L);
        this.player.sendMessage("\u00a76[Auditor] \u00a7eWeekly Report Generated:");
        this.player.sendMessage("\u00a77\u2022 Period: \u00a7fLast 7 days");
        this.player.sendMessage("\u00a77\u2022 Total Transactions: \u00a7f" + transactions);
        this.player.sendMessage("\u00a77\u2022 Total Volume: \u00a7f$" + this.formatNumber(volume));
        this.player.sendMessage("\u00a77\u2022 Daily Average: \u00a7f" + transactions / 7 + " transactions");
    }

    private void generateMonthlyReport() {
        int transactions = this.plugin.getDatabase().getTransactionCount(30L);
        double volume = this.plugin.getDatabase().getTotalTransactionVolume(30L);
        int players = this.plugin.getDatabase().getTotalPlayerCount();
        this.player.sendMessage("\u00a76[Auditor] \u00a7eMonthly Report Generated:");
        this.player.sendMessage("\u00a77\u2022 Period: \u00a7fLast 30 days");
        this.player.sendMessage("\u00a77\u2022 Transactions: \u00a7f" + transactions);
        this.player.sendMessage("\u00a77\u2022 Volume: \u00a7f$" + this.formatNumber(volume));
        this.player.sendMessage("\u00a77\u2022 Active Players: \u00a7f" + players);
        this.player.sendMessage("\u00a77\u2022 Avg per Player: \u00a7f" + (players > 0 ? transactions / players : 0));
    }

    private void showTransactionReport() {
        int total = this.plugin.getDatabase().getTransactionCount(30L);
        double volume = this.plugin.getDatabase().getTotalTransactionVolume(30L);
        this.player.sendMessage("\u00a76[Auditor] \u00a7eTransaction Analysis Report:");
        this.player.sendMessage("\u00a77\u2022 Total Transactions (30d): \u00a7f" + total);
        this.player.sendMessage("\u00a77\u2022 Total Volume: \u00a7f$" + this.formatNumber(volume));
        this.player.sendMessage("\u00a77\u2022 Average Transaction: \u00a7f$" + this.formatNumber(total > 0 ? volume / (double)total : 0.0));
        this.player.sendMessage("\u00a77\u2022 Daily Average: \u00a7f" + total / 30 + " transactions");
    }

    private void showPlayerReport() {
        int totalPlayers = this.plugin.getDatabase().getTotalPlayerCount();
        List<PlayerProfile> topPlayers = this.plugin.getDatabase().getTopPlayersByTransactions(3);
        this.player.sendMessage("\u00a76[Auditor] \u00a7ePlayer Activity Report:");
        this.player.sendMessage("\u00a77\u2022 Total Players Tracked: \u00a7f" + totalPlayers);
        this.player.sendMessage("\u00a77\u2022 Top 3 Most Active:");
        for (int i = 0; i < topPlayers.size(); ++i) {
            PlayerProfile profile = topPlayers.get(i);
            this.player.sendMessage("\u00a77  " + (i + 1) + ". " + profile.getPlayerName() + " (" + profile.getTotalTransactions() + " transactions)");
        }
    }

    private void showSecurityReport() {
        List<Alert> alerts = this.plugin.getDatabase().getActiveAlerts();
        List<PlayerProfile> riskPlayers = this.plugin.getDatabase().getHighRiskPlayers();
        this.player.sendMessage("\u00a76[Auditor] \u00a7eSecurity Report:");
        this.player.sendMessage("\u00a77\u2022 Active Alerts: \u00a7f" + alerts.size());
        this.player.sendMessage("\u00a77\u2022 High Risk Players: \u00a7f" + riskPlayers.size());
        this.player.sendMessage("\u00a77\u2022 Overall Security Status: " + (alerts.size() == 0 && riskPlayers.size() == 0 ? "\u00a7aSecure" : "\u00a7eElevated"));
        if (!riskPlayers.isEmpty()) {
            this.player.sendMessage("\u00a77\u2022 Risk Players:");
            for (PlayerProfile profile : riskPlayers) {
                this.player.sendMessage("\u00a77  - " + profile.getPlayerName() + " (" + profile.getRiskLevel() + ")");
            }
        }
    }

    private void showEconomyHealthReport() {
        double weekVolume = this.plugin.getDatabase().getTotalTransactionVolume(7L);
        double monthVolume = this.plugin.getDatabase().getTotalTransactionVolume(30L);
        int totalPlayers = this.plugin.getDatabase().getTotalPlayerCount();
        double healthScore = this.calculateHealthScore(weekVolume, monthVolume, totalPlayers);
        this.player.sendMessage("\u00a76[Auditor] \u00a7eEconomy Health Report:");
        this.player.sendMessage("\u00a77\u2022 Health Score: " + this.getHealthColor(healthScore) + String.format("%.1f/100", healthScore));
        this.player.sendMessage("\u00a77\u2022 Status: " + this.getHealthColor(healthScore) + this.getHealthStatus(healthScore));
        this.player.sendMessage("\u00a77\u2022 Weekly Volume: \u00a7f$" + this.formatNumber(weekVolume));
        this.player.sendMessage("\u00a77\u2022 Monthly Volume: \u00a7f$" + this.formatNumber(monthVolume));
        this.player.sendMessage("\u00a77\u2022 Active Players: \u00a7f" + totalPlayers);
    }

    private void showAlertSummary() {
        List<Alert> alerts = this.plugin.getDatabase().getActiveAlerts();
        this.player.sendMessage("\u00a76[Auditor] \u00a7eAlert Summary:");
        this.player.sendMessage("\u00a77\u2022 Total Active Alerts: \u00a7f" + alerts.size());
        if (alerts.isEmpty()) {
            this.player.sendMessage("\u00a7a\u2022 No active alerts - System is healthy!");
        } else {
            int[] severityCounts = new int[4];
            for (Alert alert : alerts) {
                switch (alert.getSeverity().toUpperCase()) {
                    case "CRITICAL": {
                        severityCounts[0] = severityCounts[0] + 1;
                        break;
                    }
                    case "HIGH": {
                        severityCounts[1] = severityCounts[1] + 1;
                        break;
                    }
                    case "MEDIUM": {
                        severityCounts[2] = severityCounts[2] + 1;
                        break;
                    }
                    case "LOW": {
                        severityCounts[3] = severityCounts[3] + 1;
                    }
                }
            }
            if (severityCounts[0] > 0) {
                this.player.sendMessage("\u00a74\u2022 Critical: " + severityCounts[0]);
            }
            if (severityCounts[1] > 0) {
                this.player.sendMessage("\u00a7c\u2022 High: " + severityCounts[1]);
            }
            if (severityCounts[2] > 0) {
                this.player.sendMessage("\u00a7e\u2022 Medium: " + severityCounts[2]);
            }
            if (severityCounts[3] > 0) {
                this.player.sendMessage("\u00a7a\u2022 Low: " + severityCounts[3]);
            }
        }
    }

    private void showTrendsAnalysis() {
        double thisWeek = this.plugin.getDatabase().getTotalTransactionVolume(7L);
        double lastWeek = this.plugin.getDatabase().getTotalTransactionVolume(14L) - thisWeek;
        double change = lastWeek > 0.0 ? (thisWeek - lastWeek) / lastWeek * 100.0 : 0.0;
        this.player.sendMessage("\u00a76[Auditor] \u00a7eTrends Analysis:");
        this.player.sendMessage("\u00a77\u2022 This Week Volume: \u00a7f$" + this.formatNumber(thisWeek));
        this.player.sendMessage("\u00a77\u2022 Last Week Volume: \u00a7f$" + this.formatNumber(lastWeek));
        this.player.sendMessage("\u00a77\u2022 Change: " + (change >= 0.0 ? "\u00a7a+" : "\u00a7c") + String.format("%.1f%%", change));
        this.player.sendMessage("\u00a77\u2022 Trend: " + (change >= 5.0 ? "\u00a7aStrong Growth" : (change >= 0.0 ? "\u00a7eGrowth" : "\u00a7cDeclining")));
    }

    private void generateComprehensiveReport() {
        this.player.sendMessage("\u00a76[Auditor] \u00a7a=== COMPREHENSIVE ECONOMY REPORT ===");
        this.player.sendMessage("");
        this.generateDailyReport();
        this.player.sendMessage("");
        this.generateWeeklyReport();
        this.player.sendMessage("");
        this.showSecurityReport();
        this.player.sendMessage("");
        this.showEconomyHealthReport();
        this.player.sendMessage("");
        this.player.sendMessage("\u00a76[Auditor] \u00a7aReport generation complete!");
    }

    private void showCustomReportBuilder() {
        this.player.sendMessage("\u00a76[Auditor] \u00a7eCustom Report Builder:");
        this.player.sendMessage("\u00a77=====================================");
        this.player.sendMessage("\u00a7e\u00a7lAvailable Custom Report Options:");
        this.player.sendMessage("");
        this.player.sendMessage("\u00a7b1. Date Range Reports:");
        this.player.sendMessage("\u00a77   \u2022 Custom start and end dates");
        this.player.sendMessage("\u00a77   \u2022 Specific time periods");
        this.player.sendMessage("\u00a77   \u2022 Usage: /auditor report range <start> <end>");
        this.player.sendMessage("");
        this.player.sendMessage("\u00a7b2. Player-Specific Reports:");
        this.player.sendMessage("\u00a77   \u2022 Individual player analysis");
        this.player.sendMessage("\u00a77   \u2022 Transaction patterns");
        this.player.sendMessage("\u00a77   \u2022 Usage: /auditor report player <name>");
        this.player.sendMessage("");
        this.player.sendMessage("\u00a7b3. Transaction Type Reports:");
        this.player.sendMessage("\u00a77   \u2022 Filter by transaction type");
        this.player.sendMessage("\u00a77   \u2022 Payment, shop, admin transactions");
        this.player.sendMessage("\u00a77   \u2022 Usage: /auditor report type <type>");
        this.player.sendMessage("");
        this.player.sendMessage("\u00a7b4. Risk Assessment Reports:");
        this.player.sendMessage("\u00a77   \u2022 High-risk player analysis");
        this.player.sendMessage("\u00a77   \u2022 Security breach analysis");
        this.player.sendMessage("\u00a77   \u2022 Usage: /auditor report risk");
        this.player.sendMessage("");
        this.player.sendMessage("\u00a77Use the commands above to generate custom reports!");
        this.player.sendMessage("\u00a77=====================================");
    }

    private void showReportExportOptions() {
        this.player.sendMessage("\u00a76[Auditor] \u00a7eReport Export Options:");
        this.player.sendMessage("\u00a77==================================");
        this.player.sendMessage("\u00a7e\u00a7lAvailable Export Formats:");
        this.player.sendMessage("");
        this.player.sendMessage("\u00a7b1. CSV Export (Spreadsheet):");
        this.player.sendMessage("\u00a77   \u2022 Compatible with Excel, Google Sheets");
        this.player.sendMessage("\u00a77   \u2022 Best for data analysis");
        this.player.sendMessage("\u00a77   \u2022 Command: /auditor export transactions");
        this.player.sendMessage("");
        this.player.sendMessage("\u00a7b2. JSON Export (Data):");
        this.player.sendMessage("\u00a77   \u2022 Machine-readable format");
        this.player.sendMessage("\u00a77   \u2022 API integration friendly");
        this.player.sendMessage("\u00a77   \u2022 Command: /auditor export json");
        this.player.sendMessage("");
        this.player.sendMessage("\u00a7b3. Player Profiles Export:");
        this.player.sendMessage("\u00a77   \u2022 All player data and statistics");
        this.player.sendMessage("\u00a77   \u2022 Risk assessments included");
        this.player.sendMessage("\u00a77   \u2022 Command: /auditor export profiles");
        this.player.sendMessage("");
        this.player.sendMessage("\u00a7b4. Alert History Export:");
        this.player.sendMessage("\u00a77   \u2022 All alerts and resolutions");
        this.player.sendMessage("\u00a77   \u2022 Security audit trail");
        this.player.sendMessage("\u00a77   \u2022 Command: /auditor export alerts");
        this.player.sendMessage("");
        this.player.sendMessage("\u00a7e\u00a7lExport Location:");
        this.player.sendMessage("\u00a77All exports are saved to: /plugins/Auditor/exports/");
        this.player.sendMessage("\u00a77Files include timestamp in filename");
        this.player.sendMessage("\u00a77==================================");
    }

    private void showScheduledReportsManagement() {
        this.player.sendMessage("\u00a76[Auditor] \u00a7eScheduled Reports Management:");
        this.player.sendMessage("\u00a77=========================================");
        this.player.sendMessage("\u00a7e\u00a7lCurrent Scheduled Reports:");
        this.player.sendMessage("");
        this.player.sendMessage("\u00a7a\u2713 Daily Summary Report:");
        this.player.sendMessage("\u00a77   \u2022 Status: \u00a7aEnabled");
        this.player.sendMessage("\u00a77   \u2022 Time: 00:00 UTC");
        this.player.sendMessage("\u00a77   \u2022 Last Run: " + this.formatTime(System.currentTimeMillis() - 86400000L));
        this.player.sendMessage("\u00a77   \u2022 Next Run: " + this.formatTime(System.currentTimeMillis() + 86400000L));
        this.player.sendMessage("");
        this.player.sendMessage("\u00a7a\u2713 Weekly Analysis Report:");
        this.player.sendMessage("\u00a77   \u2022 Status: \u00a7aEnabled");
        this.player.sendMessage("\u00a77   \u2022 Time: Monday 00:00 UTC");
        this.player.sendMessage("\u00a77   \u2022 Last Run: " + this.formatTime(System.currentTimeMillis() - 604800000L));
        this.player.sendMessage("\u00a77   \u2022 Next Run: Next Monday");
        this.player.sendMessage("");
        this.player.sendMessage("\u00a7c\u2717 Monthly Performance Report:");
        this.player.sendMessage("\u00a77   \u2022 Status: \u00a7cDisabled");
        this.player.sendMessage("\u00a77   \u2022 Scheduled: 1st of month, 00:00 UTC");
        this.player.sendMessage("\u00a77   \u2022 Never run");
        this.player.sendMessage("");
        this.player.sendMessage("\u00a7e\u00a7lSchedule Management:");
        this.player.sendMessage("\u00a77\u2022 Enable monthly reports: \u00a7f/auditor schedule monthly enable");
        this.player.sendMessage("\u00a77\u2022 Disable daily reports: \u00a7f/auditor schedule daily disable");
        this.player.sendMessage("\u00a77\u2022 Set custom time: \u00a7f/auditor schedule time <HH:MM>");
        this.player.sendMessage("\u00a77\u2022 Manual run: \u00a7f/auditor schedule run <type>");
        this.player.sendMessage("");
        this.player.sendMessage("\u00a7e\u00a7lDelivery Options:");
        this.player.sendMessage("\u00a77\u2022 Console logging: \u00a7aEnabled");
        this.player.sendMessage("\u00a77\u2022 File export: \u00a7aEnabled");
        this.player.sendMessage("\u00a77\u2022 Discord webhooks: \u00a77Not configured");
        this.player.sendMessage("\u00a77\u2022 Email delivery: \u00a77Not available");
        this.player.sendMessage("\u00a77=========================================");
    }
}

