/*
 * Decompiled with CFR 0.152.
 */
package com.auditor.plugin.gui;

import com.auditor.plugin.AuditorPlugin;
import com.auditor.plugin.gui.BaseGUI;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class SettingsGUI
extends BaseGUI {
    public SettingsGUI(AuditorPlugin plugin, Player player) {
        super(plugin, player, "\u00a7c\u00a7lAuditor Settings", 54);
    }

    @Override
    protected void setupItems() {
        this.fillBorder(Material.GRAY_STAINED_GLASS_PANE);
        this.inventory.setItem(10, this.createMonitoringSettingsItem());
        this.inventory.setItem(12, this.createAlertSettingsItem());
        this.inventory.setItem(14, this.createHealthSettingsItem());
        this.inventory.setItem(16, this.createDatabaseSettingsItem());
        this.inventory.setItem(28, this.createPermissionSettingsItem());
        this.inventory.setItem(30, this.createExportSettingsItem());
        this.inventory.setItem(32, this.createIntegrationSettingsItem());
        this.inventory.setItem(34, this.createMaintenanceItem());
        this.inventory.setItem(45, this.createBackItem());
        this.inventory.setItem(49, this.createSaveItem());
    }

    private ItemStack createMonitoringSettingsItem() {
        boolean enabled = this.plugin.getConfigManager().isMonitoringEnabled();
        boolean trackAll = this.plugin.getConfigManager().shouldTrackAllTransactions();
        boolean trackCommands = this.plugin.getConfigManager().shouldTrackCommandUsage();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Configure transaction monitoring settings");
        lore.add("");
        lore.add("\u00a7bMonitoring: " + (enabled ? "\u00a7aEnabled" : "\u00a7cDisabled"));
        lore.add("\u00a7bTrack All Transactions: " + (trackAll ? "\u00a7aYes" : "\u00a7cNo"));
        lore.add("\u00a7bTrack Commands: " + (trackCommands ? "\u00a7aYes" : "\u00a7cNo"));
        lore.add("");
        lore.add("\u00a7eClick to toggle monitoring settings");
        Material material = enabled ? Material.LIME_STAINED_GLASS : Material.RED_STAINED_GLASS;
        return this.createItem(material, "\u00a7a\u00a7lTransaction Monitoring", lore);
    }

    private ItemStack createAlertSettingsItem() {
        boolean enabled = this.plugin.getConfigManager().isAlertsEnabled();
        String webhook = this.plugin.getConfigManager().getDiscordWebhook();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Configure alert system settings");
        lore.add("");
        lore.add("\u00a7bAlerts: " + (enabled ? "\u00a7aEnabled" : "\u00a7cDisabled"));
        lore.add("\u00a7bDiscord Webhook: " + (webhook.isEmpty() ? "\u00a7cNot Set" : "\u00a7aConfigured"));
        lore.add("");
        lore.add("\u00a7eClick to configure alert thresholds");
        Material material = enabled ? Material.GOLD_BLOCK : Material.IRON_BLOCK;
        return this.createItem(material, "\u00a76\u00a7lAlert Settings", lore);
    }

    private ItemStack createHealthSettingsItem() {
        boolean enabled = this.plugin.getConfigManager().isHealthChecksEnabled();
        int interval = this.plugin.getConfigManager().getHealthCalculationInterval();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Configure economy health monitoring");
        lore.add("");
        lore.add("\u00a7bHealth Checks: " + (enabled ? "\u00a7aEnabled" : "\u00a7cDisabled"));
        lore.add("\u00a7bCalculation Interval: \u00a7f" + interval + " minutes");
        lore.add("");
        lore.add("\u00a7eClick to modify health settings");
        return this.createItem(Material.HEART_OF_THE_SEA, "\u00a7b\u00a7lHealth Monitoring", lore);
    }

    private ItemStack createDatabaseSettingsItem() {
        int cleanupDays = this.plugin.getConfigManager().getAutoCleanupDays();
        int backupHours = this.plugin.getConfigManager().getBackupIntervalHours();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Configure database maintenance");
        lore.add("");
        lore.add("\u00a7bAuto Cleanup: \u00a7f" + cleanupDays + " days");
        lore.add("\u00a7bBackup Interval: \u00a7f" + backupHours + " hours");
        lore.add("");
        lore.add("\u00a7eClick to adjust database settings");
        return this.createItem(Material.CHEST, "\u00a79\u00a7lDatabase Settings", lore);
    }

    private ItemStack createPermissionSettingsItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Manage permission settings");
        lore.add("");
        lore.add("\u00a77Permission nodes:");
        lore.add("\u00a7f- auditor.admin \u00a77(Full access)");
        lore.add("\u00a7f- auditor.moderator \u00a77(Staff access)");
        lore.add("\u00a7f- auditor.basic \u00a77(Player access)");
        lore.add("");
        lore.add("\u00a7eClick to view permission details");
        return this.createItem(Material.SHIELD, "\u00a7d\u00a7lPermission Settings", lore);
    }

    private ItemStack createExportSettingsItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Configure data export options");
        lore.add("");
        lore.add("\u00a7bExport Format: \u00a7fCSV");
        lore.add("\u00a7bMax Records: \u00a7f10,000");
        lore.add("\u00a7bExport Directory: \u00a7f/plugins/Auditor/exports");
        lore.add("");
        lore.add("\u00a7eClick to configure export settings");
        return this.createItem(Material.PAPER, "\u00a7f\u00a7lExport Settings", lore);
    }

    private ItemStack createIntegrationSettingsItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Configure plugin integrations");
        lore.add("");
        lore.add("\u00a7bVault: \u00a7aConnected");
        lore.add("\u00a7bPlaceholderAPI: \u00a77Disabled");
        lore.add("\u00a7bDiscordSRV: \u00a77Not Found");
        lore.add("");
        lore.add("\u00a7eClick to view integration status");
        return this.createItem(Material.COMPARATOR, "\u00a75\u00a7lIntegrations", lore);
    }

    private ItemStack createMaintenanceItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Database maintenance options");
        lore.add("");
        lore.add("\u00a7e\u2022 Cleanup old data");
        lore.add("\u00a7e\u2022 Create backup");
        lore.add("\u00a7e\u2022 Optimize database");
        lore.add("\u00a7e\u2022 View statistics");
        lore.add("");
        lore.add("\u00a7eClick for maintenance options");
        return this.createItem(Material.ANVIL, "\u00a78\u00a7lMaintenance", lore);
    }

    private ItemStack createBackItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Return to dashboard");
        return this.createItem(Material.ARROW, "\u00a7a\u00a7lBack to Dashboard", lore);
    }

    private ItemStack createSaveItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Save configuration changes");
        lore.add("");
        lore.add("\u00a7eClick to save and reload config");
        return this.createItem(Material.WRITABLE_BOOK, "\u00a7a\u00a7lSave Settings", lore);
    }

    @Override
    public void handleClick(int slot, ClickType clickType) {
        switch (slot) {
            case 10: {
                this.toggleMonitoringSettings();
                break;
            }
            case 12: {
                this.toggleAlertSettings();
                break;
            }
            case 14: {
                this.toggleHealthSettings();
                break;
            }
            case 16: {
                this.toggleDatabaseSettings();
                break;
            }
            case 28: {
                this.plugin.getGUIManager().openPermissionSettings(this.player);
                break;
            }
            case 30: {
                this.plugin.getGUIManager().openExportSettings(this.player);
                break;
            }
            case 32: {
                this.plugin.getGUIManager().openIntegrationSettings(this.player);
                break;
            }
            case 34: {
                this.plugin.getGUIManager().openMaintenanceSettings(this.player);
                break;
            }
            case 45: {
                this.plugin.getGUIManager().openDashboard(this.player);
                break;
            }
            case 49: {
                this.plugin.getConfigManager().reloadConfigs();
                this.refresh();
            }
        }
    }

    private void toggleMonitoringSettings() {
        boolean currentEnabled = this.plugin.getConfigManager().isMonitoringEnabled();
        this.plugin.getConfigManager().setMonitoringEnabled(!currentEnabled);
        this.refresh();
    }

    private void toggleAlertSettings() {
        boolean currentEnabled = this.plugin.getConfigManager().isAlertsEnabled();
        this.plugin.getConfigManager().setAlertsEnabled(!currentEnabled);
        this.refresh();
    }

    private void toggleHealthSettings() {
        boolean currentEnabled = this.plugin.getConfigManager().isHealthChecksEnabled();
        this.plugin.getConfigManager().setHealthChecksEnabled(!currentEnabled);
        this.refresh();
    }

    private void toggleDatabaseSettings() {
        int newDays;
        int currentDays = this.plugin.getConfigManager().getAutoCleanupDays();
        switch (currentDays) {
            case 7: {
                newDays = 14;
                break;
            }
            case 14: {
                newDays = 30;
                break;
            }
            case 30: {
                newDays = 60;
                break;
            }
            default: {
                newDays = 7;
            }
        }
        this.plugin.getConfigManager().setAutoCleanupDays(newDays);
        this.refresh();
    }
}

