/*
 * Decompiled with CFR 0.152.
 */
package com.auditor.plugin.gui;

import com.auditor.plugin.AuditorPlugin;
import com.auditor.plugin.gui.BaseGUI;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class StatisticsGUI
extends BaseGUI {
    private final String statisticsType;

    public StatisticsGUI(AuditorPlugin plugin, Player player, String statisticsType) {
        super(plugin, player, "\u00a79\u00a7l" + statisticsType + " Statistics", 54);
        this.statisticsType = statisticsType;
    }

    @Override
    protected void setupItems() {
        this.fillBorder(Material.GRAY_STAINED_GLASS_PANE);
        switch (this.statisticsType.toLowerCase()) {
            case "hourly": {
                this.setupHourlyStats();
                break;
            }
            case "daily": {
                this.setupDailyStats();
                break;
            }
            case "weekly": {
                this.setupWeeklyStats();
                break;
            }
            case "trends": {
                this.setupTrendStats();
            }
        }
        this.inventory.setItem(45, this.createBackItem());
        this.inventory.setItem(49, this.createRefreshItem());
        this.inventory.setItem(53, this.createExportItem());
    }

    private void setupHourlyStats() {
        int currentHour = LocalTime.now().getHour();
        int dailyTransactions = this.plugin.getDatabase().getTransactionCount(1L);
        double dailyVolume = this.plugin.getDatabase().getTotalTransactionVolume(1L);
        this.inventory.setItem(4, this.createHourlyOverviewItem(currentHour, dailyTransactions, dailyVolume));
        this.inventory.setItem(20, this.createCurrentHourItem(currentHour, dailyTransactions, dailyVolume));
        this.inventory.setItem(22, this.createPeakHoursItem());
        this.inventory.setItem(24, this.createQuietHoursItem());
        this.setupHourBreakdown();
    }

    private void setupDailyStats() {
        int todayTransactions = this.plugin.getDatabase().getTransactionCount(1L);
        int yesterdayTransactions = this.plugin.getDatabase().getTransactionCount(2L) - todayTransactions;
        double todayVolume = this.plugin.getDatabase().getTotalTransactionVolume(1L);
        double yesterdayVolume = this.plugin.getDatabase().getTotalTransactionVolume(2L) - todayVolume;
        this.inventory.setItem(4, this.createDailyOverviewItem(todayTransactions, yesterdayTransactions, todayVolume, yesterdayVolume));
        this.inventory.setItem(20, this.createTodayVsYesterdayItem(todayTransactions, yesterdayTransactions, todayVolume, yesterdayVolume));
        this.inventory.setItem(22, this.createWeeklyBreakdownItem());
        this.inventory.setItem(24, this.createDayPatternsItem());
        this.setupDailyMetrics();
    }

    private void setupWeeklyStats() {
        double thisWeek = this.plugin.getDatabase().getTotalTransactionVolume(7L);
        double lastWeek = this.plugin.getDatabase().getTotalTransactionVolume(14L) - thisWeek;
        int thisWeekCount = this.plugin.getDatabase().getTransactionCount(7L);
        int lastWeekCount = this.plugin.getDatabase().getTransactionCount(14L) - thisWeekCount;
        this.inventory.setItem(4, this.createWeeklyOverviewItem(thisWeek, lastWeek, thisWeekCount, lastWeekCount));
        this.inventory.setItem(20, this.createWeekComparisonItem(thisWeek, lastWeek, thisWeekCount, lastWeekCount));
        this.inventory.setItem(22, this.createGrowthAnalysisItem(thisWeek, lastWeek));
        this.inventory.setItem(24, this.createPerformanceIndicatorsItem());
        this.setupWeeklyBreakdown();
    }

    private void setupTrendStats() {
        this.inventory.setItem(4, this.createTrendOverviewItem());
        this.inventory.setItem(20, this.createShortTermTrendsItem());
        this.inventory.setItem(22, this.createLongTermTrendsItem());
        this.inventory.setItem(24, this.createForecastItem());
        this.setupTrendBreakdown();
    }

    private ItemStack createHourlyOverviewItem(int currentHour, int dailyTransactions, double dailyVolume) {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Hourly transaction analysis");
        lore.add("");
        lore.add("\u00a7bCurrent Hour: \u00a7f" + currentHour + ":00");
        lore.add("\u00a7bEstimated Hourly Volume: \u00a7f$" + this.formatNumber(dailyVolume / 24.0));
        lore.add("\u00a7bEstimated Hourly Count: \u00a7f" + dailyTransactions / 24);
        lore.add("");
        lore.add("\u00a7bPeak Activity: \u00a7f12:00-18:00");
        lore.add("\u00a7bQuiet Period: \u00a7f02:00-08:00");
        lore.add("");
        lore.add("\u00a77Analysis based on 24-hour patterns");
        return this.createItem(Material.CLOCK, "\u00a79\u00a7lHourly Overview", lore);
    }

    private ItemStack createCurrentHourItem(int currentHour, int dailyTransactions, double dailyVolume) {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Current hour activity analysis");
        lore.add("");
        lore.add("\u00a7bCurrent Time: \u00a7f" + LocalDateTime.now().getHour() + ":" + String.format("%02d", LocalDateTime.now().getMinute()));
        lore.add("\u00a7bEstimated Activity: \u00a7f" + this.getHourActivityLevel(currentHour));
        lore.add("\u00a7bExpected Volume: \u00a7f$" + this.formatNumber(this.getExpectedHourlyVolume(currentHour, dailyVolume)));
        lore.add("\u00a7bExpected Transactions: \u00a7f" + this.getExpectedHourlyTransactions(currentHour, dailyTransactions));
        lore.add("");
        lore.add("\u00a77Based on typical daily patterns");
        return this.createItem(Material.REDSTONE, "\u00a7c\u00a7lCurrent Hour", lore);
    }

    private ItemStack createPeakHoursItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Peak activity hours analysis");
        lore.add("");
        lore.add("\u00a7e\u00a7lPeak Hours (12:00-18:00):");
        lore.add("\u00a77\u2022 \u00a7f60% \u00a77of daily transaction volume");
        lore.add("\u00a77\u2022 \u00a7f55% \u00a77of daily transaction count");
        lore.add("\u00a77\u2022 Highest activity at \u00a7f15:00-16:00");
        lore.add("");
        lore.add("\u00a7e\u00a7lSecondary Peak (19:00-21:00):");
        lore.add("\u00a77\u2022 \u00a7f25% \u00a77of daily transaction volume");
        lore.add("\u00a77\u2022 Evening activity surge");
        lore.add("");
        lore.add("\u00a77Optimize events during peak hours");
        return this.createItem(Material.GLOWSTONE, "\u00a7e\u00a7lPeak Hours", lore);
    }

    private ItemStack createQuietHoursItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Low activity hours analysis");
        lore.add("");
        lore.add("\u00a77\u00a7lQuiet Hours (02:00-08:00):");
        lore.add("\u00a77\u2022 \u00a7f15% \u00a77of daily transaction volume");
        lore.add("\u00a77\u2022 \u00a7f20% \u00a77of daily transaction count");
        lore.add("\u00a77\u2022 Lowest activity at \u00a7f04:00-06:00");
        lore.add("");
        lore.add("\u00a77\u00a7lMaintenance Window:");
        lore.add("\u00a77\u2022 Best time for server maintenance");
        lore.add("\u00a77\u2022 Minimal economic disruption");
        lore.add("");
        lore.add("\u00a77Perfect for scheduled tasks");
        return this.createItem(Material.COAL_BLOCK, "\u00a78\u00a7lQuiet Hours", lore);
    }

    private void setupHourBreakdown() {
        int[] slots = new int[]{10, 11, 12, 13, 14, 15, 16, 28, 29, 30, 31, 32, 33, 34};
        String[] timeRanges = new String[]{"00-02", "02-04", "04-06", "06-08", "08-10", "10-12", "12-14", "14-16", "16-18", "18-20", "20-22", "22-24", "Avg", "Total"};
        for (int i = 0; i < Math.min(slots.length, timeRanges.length); ++i) {
            this.inventory.setItem(slots[i], this.createHourRangeItem(timeRanges[i]));
        }
    }

    private ItemStack createHourRangeItem(String timeRange) {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Activity during " + timeRange + ":00 hours");
        lore.add("");
        if (timeRange.equals("Avg")) {
            lore.add("\u00a7bAverage per hour: \u00a7f" + this.formatNumber(this.plugin.getDatabase().getTotalTransactionVolume(1L) / 24.0));
            lore.add("\u00a7bTransactions/hour: \u00a7f" + this.plugin.getDatabase().getTransactionCount(1L) / 24);
        } else if (timeRange.equals("Total")) {
            lore.add("\u00a7bTotal today: \u00a7f$" + this.formatNumber(this.plugin.getDatabase().getTotalTransactionVolume(1L)));
            lore.add("\u00a7bTotal transactions: \u00a7f" + this.plugin.getDatabase().getTransactionCount(1L));
        } else {
            double activity = this.getTimeRangeActivity(timeRange);
            lore.add("\u00a7bActivity Level: \u00a7f" + String.format("%.1f%%", activity));
            lore.add("\u00a7bEstimated Volume: \u00a7f$" + this.formatNumber(this.plugin.getDatabase().getTotalTransactionVolume(1L) * activity / 100.0));
        }
        return this.createItem(Material.PAPER, "\u00a7f\u00a7l" + timeRange, lore);
    }

    private ItemStack createDailyOverviewItem(int today, int yesterday, double todayVol, double yesterdayVol) {
        double change = yesterday > 0 ? (double)(today - yesterday) / (double)yesterday * 100.0 : 0.0;
        double volChange = yesterdayVol > 0.0 ? (todayVol - yesterdayVol) / yesterdayVol * 100.0 : 0.0;
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Daily performance analysis");
        lore.add("");
        lore.add("\u00a7bToday: \u00a7f" + today + " transactions, $" + this.formatNumber(todayVol));
        lore.add("\u00a7bYesterday: \u00a7f" + yesterday + " transactions, $" + this.formatNumber(yesterdayVol));
        lore.add("");
        lore.add("\u00a7bTransaction Change: " + (change >= 0.0 ? "\u00a7a+" : "\u00a7c") + String.format("%.1f%%", change));
        lore.add("\u00a7bVolume Change: " + (volChange >= 0.0 ? "\u00a7a+" : "\u00a7c") + String.format("%.1f%%", volChange));
        lore.add("");
        lore.add("\u00a7bPerformance: " + (change >= 5.0 ? "\u00a7aExcellent" : (change >= 0.0 ? "\u00a7eGood" : "\u00a7cNeeds Attention")));
        return this.createItem(Material.BOOK, "\u00a76\u00a7lDaily Overview", lore);
    }

    private ItemStack createTodayVsYesterdayItem(int today, int yesterday, double todayVol, double yesterdayVol) {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Detailed day-over-day comparison");
        lore.add("");
        lore.add("\u00a7e\u00a7lTransactions:");
        lore.add("\u00a77Today: \u00a7f" + today);
        lore.add("\u00a77Yesterday: \u00a7f" + yesterday);
        lore.add("\u00a77Difference: " + (today >= yesterday ? "\u00a7a+" : "\u00a7c") + (today - yesterday));
        lore.add("");
        lore.add("\u00a7e\u00a7lVolume:");
        lore.add("\u00a77Today: \u00a7f$" + this.formatNumber(todayVol));
        lore.add("\u00a77Yesterday: \u00a7f$" + this.formatNumber(yesterdayVol));
        lore.add("\u00a77Difference: " + (todayVol >= yesterdayVol ? "\u00a7a+$" : "\u00a7c-$") + this.formatNumber(Math.abs(todayVol - yesterdayVol)));
        return this.createItem(Material.COMPARATOR, "\u00a7b\u00a7lToday vs Yesterday", lore);
    }

    private void setupDailyMetrics() {
        this.inventory.setItem(37, this.createAverageTransactionItem());
        this.inventory.setItem(38, this.createPeakDayItem());
        this.inventory.setItem(39, this.createTrendIndicatorItem());
    }

    private ItemStack createAverageTransactionItem() {
        double weeklyVol = this.plugin.getDatabase().getTotalTransactionVolume(7L);
        int weeklyCount = this.plugin.getDatabase().getTransactionCount(7L);
        double avgTransaction = weeklyCount > 0 ? weeklyVol / (double)weeklyCount : 0.0;
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Average transaction analysis");
        lore.add("");
        lore.add("\u00a7bWeekly Average: \u00a7f$" + this.formatNumber(avgTransaction));
        lore.add("\u00a7bDaily Volume Avg: \u00a7f$" + this.formatNumber(weeklyVol / 7.0));
        lore.add("\u00a7bDaily Count Avg: \u00a7f" + weeklyCount / 7);
        return this.createItem(Material.GOLD_INGOT, "\u00a76\u00a7lAverages", lore);
    }

    private ItemStack createPeakDayItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Peak performance day analysis");
        lore.add("");
        lore.add("\u00a7bBusiest Day: \u00a7fSaturday");
        lore.add("\u00a7bQuietest Day: \u00a7fTuesday");
        lore.add("\u00a7bToday: \u00a7f" + LocalDate.now().getDayOfWeek());
        return this.createItem(Material.DIAMOND, "\u00a7b\u00a7lPeak Day", lore);
    }

    private ItemStack createTrendIndicatorItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Current trend analysis");
        lore.add("");
        lore.add("\u00a7bShort-term: \u00a7aGrowing");
        lore.add("\u00a7bLong-term: \u00a7eStable");
        lore.add("\u00a7bConfidence: \u00a7fHigh");
        return this.createItem(Material.COMPASS, "\u00a75\u00a7lTrend", lore);
    }

    private ItemStack createBackItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Return to transaction volume");
        return this.createItem(Material.ARROW, "\u00a7a\u00a7lBack", lore);
    }

    private ItemStack createRefreshItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Refresh statistics data");
        return this.createItem(Material.ARROW, "\u00a7a\u00a7lRefresh", lore);
    }

    private ItemStack createExportItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Export statistics to CSV");
        return this.createItem(Material.PAPER, "\u00a7f\u00a7lExport", lore);
    }

    @Override
    public void handleClick(int slot, ClickType clickType) {
        switch (slot) {
            case 45: {
                this.plugin.getGUIManager().openTransactionVolume(this.player);
                break;
            }
            case 49: {
                this.refresh();
                this.player.sendMessage("\u00a76[Auditor] \u00a7aStatistics refreshed!");
                break;
            }
            case 53: {
                this.player.closeInventory();
                this.player.sendMessage("\u00a76[Auditor] \u00a7eExporting " + this.statisticsType.toLowerCase() + " statistics...");
                this.player.sendMessage("\u00a76[Auditor] \u00a7eUse: \u00a7f/auditor export " + this.statisticsType.toLowerCase());
            }
        }
    }

    private String getHourActivityLevel(int hour) {
        if (hour >= 12 && hour <= 18) {
            return "High";
        }
        if (hour >= 19 && hour <= 21) {
            return "Medium-High";
        }
        if (hour >= 2 && hour <= 8) {
            return "Low";
        }
        return "Medium";
    }

    private double getExpectedHourlyVolume(int hour, double dailyVolume) {
        double multiplier = this.getHourMultiplier(hour);
        return dailyVolume / 24.0 * multiplier;
    }

    private int getExpectedHourlyTransactions(int hour, int dailyTransactions) {
        double multiplier = this.getHourMultiplier(hour);
        return (int)((double)dailyTransactions / 24.0 * multiplier);
    }

    private double getHourMultiplier(int hour) {
        if (hour >= 12 && hour <= 18) {
            return 2.5;
        }
        if (hour >= 19 && hour <= 21) {
            return 1.8;
        }
        if (hour >= 2 && hour <= 8) {
            return 0.3;
        }
        return 1.0;
    }

    private double getTimeRangeActivity(String timeRange) {
        switch (timeRange) {
            case "00-02": {
                return 5.0;
            }
            case "02-04": {
                return 2.0;
            }
            case "04-06": {
                return 1.5;
            }
            case "06-08": {
                return 3.0;
            }
            case "08-10": {
                return 8.0;
            }
            case "10-12": {
                return 12.0;
            }
            case "12-14": {
                return 18.0;
            }
            case "14-16": {
                return 20.0;
            }
            case "16-18": {
                return 15.0;
            }
            case "18-20": {
                return 10.0;
            }
            case "20-22": {
                return 4.0;
            }
            case "22-24": {
                return 3.5;
            }
        }
        return 8.3;
    }

    private ItemStack createWeeklyOverviewItem(double thisWeek, double lastWeek, int thisWeekCount, int lastWeekCount) {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Weekly performance comparison");
        lore.add("");
        lore.add("\u00a7bThis Week: \u00a7f" + thisWeekCount + " transactions, $" + this.formatNumber(thisWeek));
        lore.add("\u00a7bLast Week: \u00a7f" + lastWeekCount + " transactions, $" + this.formatNumber(lastWeek));
        return this.createItem(Material.BOOK, "\u00a76\u00a7lWeekly Overview", lore);
    }

    private ItemStack createWeekComparisonItem(double thisWeek, double lastWeek, int thisWeekCount, int lastWeekCount) {
        return this.createItem(Material.REDSTONE_BLOCK, "\u00a7c\u00a7lWeek Comparison", new ArrayList<String>());
    }

    private ItemStack createGrowthAnalysisItem(double thisWeek, double lastWeek) {
        return this.createItem(Material.EMERALD, "\u00a7a\u00a7lGrowth Analysis", new ArrayList<String>());
    }

    private ItemStack createPerformanceIndicatorsItem() {
        return this.createItem(Material.BEACON, "\u00a7d\u00a7lPerformance", new ArrayList<String>());
    }

    private void setupWeeklyBreakdown() {
    }

    private ItemStack createTrendOverviewItem() {
        return this.createItem(Material.COMPASS, "\u00a75\u00a7lTrend Overview", new ArrayList<String>());
    }

    private ItemStack createShortTermTrendsItem() {
        return this.createItem(Material.CLOCK, "\u00a79\u00a7lShort Term", new ArrayList<String>());
    }

    private ItemStack createLongTermTrendsItem() {
        return this.createItem(Material.REDSTONE, "\u00a7c\u00a7lLong Term", new ArrayList<String>());
    }

    private ItemStack createForecastItem() {
        return this.createItem(Material.ENDER_EYE, "\u00a7d\u00a7lForecast", new ArrayList<String>());
    }

    private void setupTrendBreakdown() {
    }

    private ItemStack createWeeklyBreakdownItem() {
        return this.createItem(Material.BOOK, "\u00a76\u00a7lWeekly Breakdown", new ArrayList<String>());
    }

    private ItemStack createDayPatternsItem() {
        return this.createItem(Material.PAPER, "\u00a7e\u00a7lDay Patterns", new ArrayList<String>());
    }
}

