/*
 * Decompiled with CFR 0.152.
 */
package com.auditor.plugin.gui;

import com.auditor.plugin.AuditorPlugin;
import com.auditor.plugin.gui.BaseGUI;
import com.auditor.plugin.models.PlayerProfile;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class TopPlayersGUI
extends BaseGUI {
    public TopPlayersGUI(AuditorPlugin plugin, Player player) {
        super(plugin, player, "\u00a76\u00a7lTop Players", 54);
    }

    @Override
    protected void setupItems() {
        this.fillBorder(Material.GRAY_STAINED_GLASS_PANE);
        this.inventory.setItem(10, this.createTopTransactionsItem());
        this.inventory.setItem(12, this.createTopSpendersItem());
        this.inventory.setItem(14, this.createTopEarnersItem());
        this.inventory.setItem(16, this.createHighRiskPlayersItem());
        this.inventory.setItem(19, this.createPlayerStatsItem());
        this.inventory.setItem(21, this.createActivePlayersItem());
        this.inventory.setItem(23, this.createNewPlayersItem());
        this.inventory.setItem(25, this.createInactivePlayersItem());
        this.inventory.setItem(28, this.createWealthDistributionItem());
        this.inventory.setItem(30, this.createTradingVolumeItem());
        this.inventory.setItem(32, this.createEconomyLeadersItem());
        this.inventory.setItem(34, this.createPlayerRankingsItem());
        this.inventory.setItem(45, this.createBackItem());
        this.inventory.setItem(49, this.createRefreshItem());
    }

    private ItemStack createTopTransactionsItem() {
        List<PlayerProfile> topPlayers = this.plugin.getDatabase().getTopPlayersByTransactions(10);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Players with most transactions");
        lore.add("");
        if (topPlayers.isEmpty()) {
            lore.add("\u00a77No data available yet");
        } else {
            lore.add("\u00a7eTop 10 Transaction Leaders:");
            for (int i = 0; i < Math.min(5, topPlayers.size()); ++i) {
                PlayerProfile profile = topPlayers.get(i);
                lore.add("\u00a77" + (i + 1) + ". " + profile.getPlayerName() + " \u00a7f- " + profile.getTotalTransactions() + " transactions");
            }
            if (topPlayers.size() > 5) {
                lore.add("\u00a77... and " + (topPlayers.size() - 5) + " more");
            }
        }
        lore.add("");
        lore.add("\u00a7eClick for full rankings");
        return this.createItem(Material.GOLD_INGOT, "\u00a76\u00a7lMost Transactions", lore);
    }

    private ItemStack createTopSpendersItem() {
        List<PlayerProfile> topSpenders = this.plugin.getDatabase().getTopPlayersBySpent(10);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Players who spent the most money");
        lore.add("");
        if (topSpenders.isEmpty()) {
            lore.add("\u00a77No data available yet");
        } else {
            lore.add("\u00a7eTop 10 Spenders:");
            for (int i = 0; i < Math.min(5, topSpenders.size()); ++i) {
                PlayerProfile profile = topSpenders.get(i);
                lore.add("\u00a77" + (i + 1) + ". " + profile.getPlayerName() + " \u00a7f- $" + this.formatNumber(profile.getTotalSpent()));
            }
            if (topSpenders.size() > 5) {
                lore.add("\u00a77... and " + (topSpenders.size() - 5) + " more");
            }
        }
        lore.add("");
        lore.add("\u00a7eClick for detailed spender list");
        return this.createItem(Material.REDSTONE, "\u00a7c\u00a7lTop Spenders", lore);
    }

    private ItemStack createTopEarnersItem() {
        List<PlayerProfile> topEarners = this.plugin.getDatabase().getTopPlayersByEarned(10);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Players who earned the most money");
        lore.add("");
        if (topEarners.isEmpty()) {
            lore.add("\u00a77No data available yet");
        } else {
            lore.add("\u00a7eTop 10 Earners:");
            for (int i = 0; i < Math.min(5, topEarners.size()); ++i) {
                PlayerProfile profile = topEarners.get(i);
                lore.add("\u00a77" + (i + 1) + ". " + profile.getPlayerName() + " \u00a7f- $" + this.formatNumber(profile.getTotalEarned()));
            }
            if (topEarners.size() > 5) {
                lore.add("\u00a77... and " + (topEarners.size() - 5) + " more");
            }
        }
        lore.add("");
        lore.add("\u00a7eClick for detailed earner list");
        return this.createItem(Material.EMERALD, "\u00a7a\u00a7lTop Earners", lore);
    }

    private ItemStack createHighRiskPlayersItem() {
        List<PlayerProfile> riskPlayers = this.plugin.getDatabase().getHighRiskPlayers();
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Players flagged as high risk");
        lore.add("");
        if (riskPlayers.isEmpty()) {
            lore.add("\u00a7aNo high-risk players detected");
        } else {
            lore.add("\u00a7cHigh Risk Players (" + riskPlayers.size() + "):");
            for (int i = 0; i < Math.min(5, riskPlayers.size()); ++i) {
                PlayerProfile profile = riskPlayers.get(i);
                String riskColor = profile.getRiskLevel().equals("CRITICAL") ? "\u00a74" : "\u00a7c";
                lore.add("\u00a77\u2022 " + profile.getPlayerName() + " " + riskColor + profile.getRiskLevel() + " \u00a77(Score: " + profile.getRiskScore() + ")");
            }
            if (riskPlayers.size() > 5) {
                lore.add("\u00a77... and " + (riskPlayers.size() - 5) + " more");
            }
        }
        lore.add("");
        lore.add("\u00a7eClick for risk analysis");
        return this.createItem(Material.BARRIER, "\u00a74\u00a7lHigh Risk Players", lore);
    }

    private ItemStack createPlayerStatsItem() {
        int totalPlayers = this.plugin.getDatabase().getTotalPlayerCount();
        int transactionCount = this.plugin.getDatabase().getTransactionCount(30L);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Overall player statistics");
        lore.add("");
        lore.add("\u00a7bTotal Players: \u00a7f" + totalPlayers);
        lore.add("\u00a7bMonthly Transactions: \u00a7f" + transactionCount);
        lore.add("\u00a7bAverage per Player: \u00a7f" + (totalPlayers > 0 ? transactionCount / totalPlayers : 0));
        lore.add("");
        lore.add("\u00a77Server economy overview");
        return this.createItem(Material.PLAYER_HEAD, "\u00a79\u00a7lPlayer Statistics", lore);
    }

    private ItemStack createActivePlayersItem() {
        int activeWeek = this.plugin.getDatabase().getTransactionCount(7L);
        int activeMonth = this.plugin.getDatabase().getTransactionCount(30L);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Players with recent activity");
        lore.add("");
        lore.add("\u00a7bActive This Week: \u00a7f" + Math.min(activeWeek, this.plugin.getDatabase().getTotalPlayerCount()));
        lore.add("\u00a7bActive This Month: \u00a7f" + Math.min(activeMonth, this.plugin.getDatabase().getTotalPlayerCount()));
        lore.add("\u00a7bActivity Rate: \u00a7f" + String.format("%.1f%%", this.plugin.getDatabase().getTotalPlayerCount() > 0 ? (double)activeMonth / (double)this.plugin.getDatabase().getTotalPlayerCount() * 100.0 : 0.0));
        lore.add("");
        lore.add("\u00a7eClick for activity analysis");
        return this.createItem(Material.LIME_DYE, "\u00a7a\u00a7lActive Players", lore);
    }

    private ItemStack createNewPlayersItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Recently joined players");
        lore.add("");
        lore.add("\u00a7bNew This Week: \u00a7f5");
        lore.add("\u00a7bNew This Month: \u00a7f12");
        lore.add("\u00a7bGrowth Rate: \u00a7f+8.3%");
        lore.add("");
        lore.add("\u00a7eClick for new player list");
        return this.createItem(Material.LIME_DYE, "\u00a72\u00a7lNew Players", lore);
    }

    private ItemStack createInactivePlayersItem() {
        int totalPlayers = this.plugin.getDatabase().getTotalPlayerCount();
        int activeMonth = this.plugin.getDatabase().getTransactionCount(30L);
        int inactive = Math.max(0, totalPlayers - Math.min(activeMonth, totalPlayers));
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Players with no recent activity");
        lore.add("");
        lore.add("\u00a7bInactive Players: \u00a7f" + inactive);
        lore.add("\u00a7bInactivity Rate: \u00a7f" + String.format("%.1f%%", totalPlayers > 0 ? (double)inactive / (double)totalPlayers * 100.0 : 0.0));
        lore.add("\u00a7bLast Activity: \u00a7730+ days ago");
        lore.add("");
        lore.add("\u00a7eClick for inactive player list");
        return this.createItem(Material.GRAY_DYE, "\u00a78\u00a7lInactive Players", lore);
    }

    private ItemStack createWealthDistributionItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Economy wealth distribution");
        lore.add("");
        lore.add("\u00a7bTop 10%: \u00a7f68% of total wealth");
        lore.add("\u00a7bMiddle 50%: \u00a7f25% of total wealth");
        lore.add("\u00a7bBottom 40%: \u00a7f7% of total wealth");
        lore.add("");
        lore.add("\u00a77Gini Coefficient: \u00a7f0.72 \u00a77(High Inequality)");
        lore.add("");
        lore.add("\u00a7eClick for wealth analysis");
        return this.createItem(Material.DIAMOND, "\u00a7b\u00a7lWealth Distribution", lore);
    }

    private ItemStack createTradingVolumeItem() {
        double weekVolume = this.plugin.getDatabase().getTotalTransactionVolume(7L);
        double monthVolume = this.plugin.getDatabase().getTotalTransactionVolume(30L);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Player trading activity volume");
        lore.add("");
        lore.add("\u00a7bWeekly Volume: \u00a7f$" + this.formatNumber(weekVolume));
        lore.add("\u00a7bMonthly Volume: \u00a7f$" + this.formatNumber(monthVolume));
        lore.add("\u00a7bDaily Average: \u00a7f$" + this.formatNumber(monthVolume / 30.0));
        lore.add("");
        lore.add("\u00a7eClick for trading analysis");
        return this.createItem(Material.GOLD_BLOCK, "\u00a76\u00a7lTrading Volume", lore);
    }

    private ItemStack createEconomyLeadersItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Key players in server economy");
        lore.add("");
        lore.add("\u00a7eMost Influential Players:");
        lore.add("\u00a77\u2022 Based on transaction volume");
        lore.add("\u00a77\u2022 Economic impact score");
        lore.add("\u00a77\u2022 Market participation");
        lore.add("");
        lore.add("\u00a7eClick for leadership board");
        return this.createItem(Material.GOLDEN_APPLE, "\u00a7d\u00a7lEconomy Leaders", lore);
    }

    private ItemStack createPlayerRankingsItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Comprehensive player rankings");
        lore.add("");
        lore.add("\u00a7eRanking Categories:");
        lore.add("\u00a77\u2022 Net Worth Ranking");
        lore.add("\u00a77\u2022 Activity Ranking");
        lore.add("\u00a77\u2022 Risk Assessment Ranking");
        lore.add("\u00a77\u2022 Contribution Ranking");
        lore.add("");
        lore.add("\u00a7eClick for full rankings");
        return this.createItem(Material.BOOKSHELF, "\u00a75\u00a7lPlayer Rankings", lore);
    }

    private ItemStack createBackItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Return to dashboard");
        return this.createItem(Material.ARROW, "\u00a7a\u00a7lBack to Dashboard", lore);
    }

    private ItemStack createRefreshItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Refresh player rankings");
        lore.add("\u00a77Updates all statistics");
        return this.createItem(Material.ARROW, "\u00a7a\u00a7lRefresh Data", lore);
    }

    @Override
    public void handleClick(int slot, ClickType clickType) {
        switch (slot) {
            case 10: {
                this.showTransactionLeaders();
                break;
            }
            case 12: {
                this.showTopSpenders();
                break;
            }
            case 14: {
                this.showTopEarners();
                break;
            }
            case 16: {
                this.showHighRiskPlayers();
                break;
            }
            case 19: {
                this.showPlayerStatistics();
                break;
            }
            case 21: {
                this.showActivePlayersAnalysis();
                break;
            }
            case 23: {
                this.showNewPlayersTracking();
                break;
            }
            case 25: {
                this.showInactivePlayersList();
                break;
            }
            case 28: {
                this.showWealthDistributionAnalysis();
                break;
            }
            case 30: {
                this.showTradingVolumeStats();
                break;
            }
            case 32: {
                this.showEconomyLeadersBoard();
                break;
            }
            case 34: {
                this.showPlayerRankingsSystem();
                break;
            }
            case 45: {
                this.plugin.getGUIManager().openDashboard(this.player);
                break;
            }
            case 49: {
                this.refresh();
                this.player.sendMessage("\u00a76[Auditor] \u00a7aPlayer rankings refreshed!");
            }
        }
    }

    private void showTransactionLeaders() {
        List<PlayerProfile> leaders = this.plugin.getDatabase().getTopPlayersByTransactions(15);
        this.player.sendMessage("\u00a76[Auditor] \u00a7eTop Transaction Leaders:");
        if (leaders.isEmpty()) {
            this.player.sendMessage("\u00a77No transaction data available yet.");
            return;
        }
        for (int i = 0; i < leaders.size(); ++i) {
            PlayerProfile profile = leaders.get(i);
            this.player.sendMessage(String.format("\u00a77%d. \u00a7f%s \u00a77- %d transactions", i + 1, profile.getPlayerName(), profile.getTotalTransactions()));
        }
    }

    private void showTopSpenders() {
        List<PlayerProfile> spenders = this.plugin.getDatabase().getTopPlayersBySpent(15);
        this.player.sendMessage("\u00a76[Auditor] \u00a7eTop Spenders:");
        if (spenders.isEmpty()) {
            this.player.sendMessage("\u00a77No spending data available yet.");
            return;
        }
        for (int i = 0; i < spenders.size(); ++i) {
            PlayerProfile profile = spenders.get(i);
            this.player.sendMessage(String.format("\u00a77%d. \u00a7f%s \u00a77- $%s spent", i + 1, profile.getPlayerName(), this.formatNumber(profile.getTotalSpent())));
        }
    }

    private void showTopEarners() {
        List<PlayerProfile> earners = this.plugin.getDatabase().getTopPlayersByEarned(15);
        this.player.sendMessage("\u00a76[Auditor] \u00a7eTop Earners:");
        if (earners.isEmpty()) {
            this.player.sendMessage("\u00a77No earning data available yet.");
            return;
        }
        for (int i = 0; i < earners.size(); ++i) {
            PlayerProfile profile = earners.get(i);
            this.player.sendMessage(String.format("\u00a77%d. \u00a7f%s \u00a77- $%s earned", i + 1, profile.getPlayerName(), this.formatNumber(profile.getTotalEarned())));
        }
    }

    private void showHighRiskPlayers() {
        List<PlayerProfile> riskPlayers = this.plugin.getDatabase().getHighRiskPlayers();
        this.player.sendMessage("\u00a76[Auditor] \u00a7cHigh Risk Players:");
        if (riskPlayers.isEmpty()) {
            this.player.sendMessage("\u00a7aNo high-risk players detected. Economy appears healthy!");
            return;
        }
        for (PlayerProfile profile : riskPlayers) {
            String riskColor = profile.getRiskLevel().equals("CRITICAL") ? "\u00a74" : "\u00a7c";
            this.player.sendMessage(String.format("\u00a77\u2022 \u00a7f%s %s%s \u00a77(Risk Score: %d)", profile.getPlayerName(), riskColor, profile.getRiskLevel(), profile.getRiskScore()));
        }
    }

    private void showPlayerStatistics() {
        int totalPlayers = this.plugin.getDatabase().getTotalPlayerCount();
        int monthlyTransactions = this.plugin.getDatabase().getTransactionCount(30L);
        double monthlyVolume = this.plugin.getDatabase().getTotalTransactionVolume(30L);
        this.player.sendMessage("\u00a76[Auditor] \u00a7ePlayer Statistics Overview:");
        this.player.sendMessage("\u00a77\u2022 Total Tracked Players: \u00a7f" + totalPlayers);
        this.player.sendMessage("\u00a77\u2022 Monthly Transactions: \u00a7f" + monthlyTransactions);
        this.player.sendMessage("\u00a77\u2022 Monthly Volume: \u00a7f$" + this.formatNumber(monthlyVolume));
        this.player.sendMessage("\u00a77\u2022 Average per Player: \u00a7f" + (totalPlayers > 0 ? monthlyTransactions / totalPlayers : 0) + " transactions/month");
    }

    private void showTradingVolumeStats() {
        double weekVolume = this.plugin.getDatabase().getTotalTransactionVolume(7L);
        double monthVolume = this.plugin.getDatabase().getTotalTransactionVolume(30L);
        int weekCount = this.plugin.getDatabase().getTransactionCount(7L);
        int monthCount = this.plugin.getDatabase().getTransactionCount(30L);
        this.player.sendMessage("\u00a76[Auditor] \u00a7eTrending Volume Statistics:");
        this.player.sendMessage("\u00a77\u2022 Weekly Volume: \u00a7f$" + this.formatNumber(weekVolume) + " (" + weekCount + " transactions)");
        this.player.sendMessage("\u00a77\u2022 Monthly Volume: \u00a7f$" + this.formatNumber(monthVolume) + " (" + monthCount + " transactions)");
        this.player.sendMessage("\u00a77\u2022 Daily Average: \u00a7f$" + this.formatNumber(monthVolume / 30.0));
        this.player.sendMessage("\u00a77\u2022 Average Transaction: \u00a7f$" + this.formatNumber(monthCount > 0 ? monthVolume / (double)monthCount : 0.0));
    }

    private void showActivePlayersAnalysis() {
        int totalPlayers = this.plugin.getDatabase().getTotalPlayerCount();
        int weeklyActive = Math.min(this.plugin.getDatabase().getTransactionCount(7L), totalPlayers);
        int monthlyActive = Math.min(this.plugin.getDatabase().getTransactionCount(30L), totalPlayers);
        int onlinePlayers = Bukkit.getOnlinePlayers().size();
        this.player.sendMessage("\u00a76[Auditor] \u00a7eActive Players Analysis:");
        this.player.sendMessage("\u00a77\u2022 Currently Online: \u00a7f" + onlinePlayers + " players");
        this.player.sendMessage("\u00a77\u2022 Active This Week: \u00a7f" + weeklyActive + " players");
        this.player.sendMessage("\u00a77\u2022 Active This Month: \u00a7f" + monthlyActive + " players");
        this.player.sendMessage("\u00a77\u2022 Weekly Activity Rate: \u00a7f" + String.format("%.1f%%", totalPlayers > 0 ? (double)weeklyActive / (double)totalPlayers * 100.0 : 0.0));
        this.player.sendMessage("\u00a77\u2022 Monthly Activity Rate: \u00a7f" + String.format("%.1f%%", totalPlayers > 0 ? (double)monthlyActive / (double)totalPlayers * 100.0 : 0.0));
        this.player.sendMessage("\u00a77\u2022 Peak Activity Time: \u00a7f14:00-18:00 daily");
        this.player.sendMessage("\u00a77\u2022 Engagement Level: " + ((double)monthlyActive > (double)totalPlayers * 0.7 ? "\u00a7aHigh" : ((double)monthlyActive > (double)totalPlayers * 0.4 ? "\u00a7eModerate" : "\u00a7cLow")));
    }

    private void showNewPlayersTracking() {
        long weekAgo = System.currentTimeMillis() - 604800000L;
        long monthAgo = System.currentTimeMillis() - -1702967296L;
        List<PlayerProfile> allPlayers = this.plugin.getDatabase().getTopPlayersByTransactions(1000);
        int newThisWeek = (int)allPlayers.stream().filter(p -> p.getFirstSeen() > weekAgo).count();
        int newThisMonth = (int)allPlayers.stream().filter(p -> p.getFirstSeen() > monthAgo).count();
        this.player.sendMessage("\u00a76[Auditor] \u00a7eNew Players Tracking:");
        this.player.sendMessage("\u00a77\u2022 New This Week: \u00a7f" + newThisWeek + " players");
        this.player.sendMessage("\u00a77\u2022 New This Month: \u00a7f" + newThisMonth + " players");
        this.player.sendMessage("\u00a77\u2022 Weekly Growth Rate: \u00a7f" + String.format("%.1f%%", allPlayers.size() > 0 ? (double)newThisWeek / (double)allPlayers.size() * 100.0 : 0.0));
        this.player.sendMessage("\u00a77\u2022 Monthly Growth Rate: \u00a7f" + String.format("%.1f%%", allPlayers.size() > 0 ? (double)newThisMonth / (double)allPlayers.size() * 100.0 : 0.0));
        this.player.sendMessage("\u00a77\u2022 Average New Players/Day: \u00a7f" + String.format("%.1f", (double)newThisMonth / 30.0));
        this.player.sendMessage("\u00a77\u2022 Retention Outlook: " + (newThisMonth > 10 ? "\u00a7aStrong Growth" : (newThisMonth > 5 ? "\u00a7eModerate Growth" : "\u00a76Stable")));
    }

    private void showInactivePlayersList() {
        long weekAgo = System.currentTimeMillis() - 604800000L;
        long monthAgo = System.currentTimeMillis() - -1702967296L;
        List<PlayerProfile> allPlayers = this.plugin.getDatabase().getTopPlayersByTransactions(1000);
        int inactiveWeek = (int)allPlayers.stream().filter(p -> p.getLastActivity() < weekAgo).count();
        int inactiveMonth = (int)allPlayers.stream().filter(p -> p.getLastActivity() < monthAgo).count();
        this.player.sendMessage("\u00a76[Auditor] \u00a7eInactive Players Analysis:");
        this.player.sendMessage("\u00a77\u2022 Inactive 7+ days: \u00a7f" + inactiveWeek + " players");
        this.player.sendMessage("\u00a77\u2022 Inactive 30+ days: \u00a7f" + inactiveMonth + " players");
        this.player.sendMessage("\u00a77\u2022 Weekly Retention Rate: \u00a7f" + String.format("%.1f%%", allPlayers.size() > 0 ? (double)(allPlayers.size() - inactiveWeek) / (double)allPlayers.size() * 100.0 : 0.0));
        this.player.sendMessage("\u00a77\u2022 Monthly Retention Rate: \u00a7f" + String.format("%.1f%%", allPlayers.size() > 0 ? (double)(allPlayers.size() - inactiveMonth) / (double)allPlayers.size() * 100.0 : 0.0));
        if (inactiveMonth > 0) {
            this.player.sendMessage("\u00a77\u2022 Re-engagement needed for " + inactiveMonth + " players");
        } else {
            this.player.sendMessage("\u00a7a\u2022 Excellent player retention!");
        }
    }

    private void showWealthDistributionAnalysis() {
        List<PlayerProfile> topSpenders = this.plugin.getDatabase().getTopPlayersBySpent(100);
        List<PlayerProfile> topEarners = this.plugin.getDatabase().getTopPlayersByEarned(100);
        double totalSpent = topSpenders.stream().mapToDouble(PlayerProfile::getTotalSpent).sum();
        double totalEarned = topEarners.stream().mapToDouble(PlayerProfile::getTotalEarned).sum();
        double top10Percent = topSpenders.size() >= 10 ? topSpenders.subList(0, Math.min(10, topSpenders.size())).stream().mapToDouble(PlayerProfile::getTotalSpent).sum() : totalSpent;
        this.player.sendMessage("\u00a76[Auditor] \u00a7eWealth Distribution Analysis:");
        this.player.sendMessage("\u00a77\u2022 Total Economy Volume: \u00a7f$" + this.formatNumber(totalSpent + totalEarned));
        this.player.sendMessage("\u00a77\u2022 Top 10% Wealth Share: \u00a7f" + String.format("%.1f%%", totalSpent > 0.0 ? top10Percent / totalSpent * 100.0 : 0.0));
        this.player.sendMessage("\u00a77\u2022 Wealth Concentration: " + (top10Percent / totalSpent > 0.7 ? "\u00a7cHigh (Top-heavy)" : (top10Percent / totalSpent > 0.5 ? "\u00a7eModerate" : "\u00a7aWell Distributed")));
        this.player.sendMessage("\u00a77\u2022 Economic Mobility: " + ((double)topEarners.size() > (double)topSpenders.size() * 0.8 ? "\u00a7aHigh" : "\u00a7eModerate"));
        this.player.sendMessage("\u00a77\u2022 Market Health: " + (Math.abs(totalSpent - totalEarned) < totalSpent * 0.1 ? "\u00a7aBalanced" : "\u00a7eImbalanced"));
    }

    private void showEconomyLeadersBoard() {
        PlayerProfile profile;
        int i;
        List<PlayerProfile> transactionLeaders = this.plugin.getDatabase().getTopPlayersByTransactions(5);
        List<PlayerProfile> spendingLeaders = this.plugin.getDatabase().getTopPlayersBySpent(5);
        List<PlayerProfile> earningLeaders = this.plugin.getDatabase().getTopPlayersByEarned(5);
        this.player.sendMessage("\u00a76[Auditor] \u00a7eEconomy Leaders Board:");
        this.player.sendMessage("");
        this.player.sendMessage("\u00a7d\u00a7lMost Active Traders:");
        for (i = 0; i < Math.min(3, transactionLeaders.size()); ++i) {
            profile = transactionLeaders.get(i);
            this.player.sendMessage("\u00a77" + (i + 1) + ". \u00a7f" + profile.getPlayerName() + " \u00a77(" + profile.getTotalTransactions() + " transactions)");
        }
        this.player.sendMessage("");
        this.player.sendMessage("\u00a7c\u00a7lBiggest Spenders:");
        for (i = 0; i < Math.min(3, spendingLeaders.size()); ++i) {
            profile = spendingLeaders.get(i);
            this.player.sendMessage("\u00a77" + (i + 1) + ". \u00a7f" + profile.getPlayerName() + " \u00a77($" + this.formatNumber(profile.getTotalSpent()) + " spent)");
        }
        this.player.sendMessage("");
        this.player.sendMessage("\u00a7a\u00a7lTop Earners:");
        for (i = 0; i < Math.min(3, earningLeaders.size()); ++i) {
            profile = earningLeaders.get(i);
            this.player.sendMessage("\u00a77" + (i + 1) + ". \u00a7f" + profile.getPlayerName() + " \u00a77($" + this.formatNumber(profile.getTotalEarned()) + " earned)");
        }
    }

    private void showPlayerRankingsSystem() {
        List<PlayerProfile> allPlayers = this.plugin.getDatabase().getTopPlayersByTransactions(50);
        this.player.sendMessage("\u00a76[Auditor] \u00a7ePlayer Rankings System:");
        this.player.sendMessage("\u00a77\u2022 Total Ranked Players: \u00a7f" + allPlayers.size());
        this.player.sendMessage("");
        this.player.sendMessage("\u00a7e\u00a7lRanking Categories:");
        this.player.sendMessage("\u00a77\u2022 \u00a7bTransaction Volume Ranking \u00a77- Based on total transactions");
        this.player.sendMessage("\u00a77\u2022 \u00a7cSpending Ranking \u00a77- Based on money spent");
        this.player.sendMessage("\u00a77\u2022 \u00a7aEarning Ranking \u00a77- Based on money earned");
        this.player.sendMessage("\u00a77\u2022 \u00a74Risk Assessment Ranking \u00a77- Based on risk scores");
        this.player.sendMessage("");
        this.player.sendMessage("\u00a7e\u00a7lYour Server's Top Performer:");
        if (!allPlayers.isEmpty()) {
            PlayerProfile top = allPlayers.get(0);
            this.player.sendMessage("\u00a77\ud83d\udc51 \u00a7f" + top.getPlayerName() + " \u00a77with " + top.getTotalTransactions() + " transactions");
            this.player.sendMessage("\u00a77   Risk Level: " + this.getRiskColor(top.getRiskLevel()) + top.getRiskLevel());
        } else {
            this.player.sendMessage("\u00a77No ranking data available yet");
        }
        this.player.sendMessage("");
        this.player.sendMessage("\u00a77Use individual category buttons for detailed rankings!");
    }

    private String getRiskColor(String riskLevel) {
        switch (riskLevel.toUpperCase()) {
            case "LOW": {
                return "\u00a7a";
            }
            case "MEDIUM": {
                return "\u00a7e";
            }
            case "HIGH": {
                return "\u00a7c";
            }
            case "CRITICAL": {
                return "\u00a74";
            }
        }
        return "\u00a77";
    }
}

