/*
 * Decompiled with CFR 0.152.
 */
package com.auditor.plugin.gui;

import com.auditor.plugin.AuditorPlugin;
import com.auditor.plugin.gui.BaseGUI;
import com.auditor.plugin.models.TransactionData;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class TransactionHistoryGUI
extends BaseGUI {
    private final String targetPlayerName;
    private final UUID targetPlayerUUID;
    private List<TransactionData> transactions;
    private int currentPage = 0;
    private final int transactionsPerPage = 28;

    public TransactionHistoryGUI(AuditorPlugin plugin, Player player, String targetPlayerName, UUID targetPlayerUUID) {
        super(plugin, player, "\u00a7e\u00a7lTransaction History: " + targetPlayerName, 54);
        this.targetPlayerName = targetPlayerName;
        this.targetPlayerUUID = targetPlayerUUID;
        this.loadTransactions();
    }

    private void loadTransactions() {
        this.transactions = this.plugin.getDatabase().getPlayerTransactions(this.targetPlayerUUID, 1000);
    }

    @Override
    protected void setupItems() {
        this.fillBorder(Material.GRAY_STAINED_GLASS_PANE);
        if (this.transactions.isEmpty()) {
            this.inventory.setItem(22, this.createNoTransactionsItem());
        } else {
            this.displayTransactions();
            this.setupPagination();
        }
        this.inventory.setItem(45, this.createBackItem());
        this.inventory.setItem(49, this.createRefreshItem());
        this.inventory.setItem(53, this.createExportItem());
    }

    private void displayTransactions() {
        int startIndex = this.currentPage * 28;
        int endIndex = Math.min(startIndex + 28, this.transactions.size());
        int slot = 10;
        for (int i = startIndex; i < endIndex; ++i) {
            if (slot == 17 || slot == 26 || slot == 35) {
                slot += 3;
            }
            if (slot >= 44) break;
            TransactionData transaction = this.transactions.get(i);
            this.inventory.setItem(slot, this.createTransactionItem(transaction, i + 1));
            ++slot;
        }
    }

    private ItemStack createTransactionItem(TransactionData transaction, int number) {
        boolean isPositive = transaction.getAmount() >= 0.0;
        String amountStr = (isPositive ? "+" : "") + this.formatNumber(transaction.getAmount());
        String amountColor = isPositive ? "\u00a7a" : "\u00a7c";
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Transaction #" + number);
        lore.add("");
        lore.add("\u00a7bAmount: " + amountColor + "$" + amountStr);
        lore.add("\u00a7bType: \u00a7f" + transaction.getTransactionType());
        lore.add("\u00a7bTime: \u00a7f" + this.formatTime(transaction.getTimestamp()));
        if (transaction.getSourcePlugin() != null) {
            lore.add("\u00a7bSource: \u00a7f" + transaction.getSourcePlugin());
        }
        if (transaction.getSourceCommand() != null) {
            lore.add("\u00a7bCommand: \u00a7f" + transaction.getSourceCommand());
        }
        lore.add("");
        lore.add("\u00a77Balance Change:");
        lore.add("\u00a77Before: \u00a7f$" + this.formatNumber(transaction.getBalanceBefore()));
        lore.add("\u00a77After: \u00a7f$" + this.formatNumber(transaction.getBalanceAfter()));
        if (transaction.getWorldName() != null) {
            lore.add("");
            lore.add("\u00a77Location: \u00a7f" + transaction.getWorldName());
            lore.add("\u00a77Coords: \u00a7f(" + transaction.getLocationX() + ", " + transaction.getLocationY() + ", " + transaction.getLocationZ() + ")");
        }
        if (transaction.getTargetPlayerUUID() != null) {
            lore.add("");
            lore.add("\u00a77Target Player: \u00a7f" + transaction.getTargetPlayerUUID().toString());
        }
        lore.add("");
        lore.add("\u00a7eClick for more details");
        Material material = isPositive ? Material.LIME_STAINED_GLASS : Material.RED_STAINED_GLASS;
        return this.createItem(material, amountColor + "\u00a7l$" + amountStr, lore);
    }

    private ItemStack createNoTransactionsItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77No transactions found for this player");
        lore.add("");
        lore.add("\u00a77This player may not have performed");
        lore.add("\u00a77any economy actions yet");
        return this.createItem(Material.BARRIER, "\u00a7c\u00a7lNo Transactions", lore);
    }

    private void setupPagination() {
        ArrayList<String> lore;
        int totalPages = (int)Math.ceil((double)this.transactions.size() / 28.0);
        if (this.currentPage > 0) {
            lore = new ArrayList<String>();
            lore.add("\u00a77Go to previous page");
            lore.add("\u00a77Page " + this.currentPage + " of " + totalPages);
            this.inventory.setItem(48, this.createItem(Material.ARROW, "\u00a7a\u00a7lPrevious Page", lore));
        }
        if (this.currentPage < totalPages - 1) {
            lore = new ArrayList();
            lore.add("\u00a77Go to next page");
            lore.add("\u00a77Page " + (this.currentPage + 2) + " of " + totalPages);
            this.inventory.setItem(50, this.createItem(Material.ARROW, "\u00a7a\u00a7lNext Page", lore));
        }
        ArrayList<String> pageInfo = new ArrayList<String>();
        pageInfo.add("\u00a77Total Transactions: \u00a7f" + this.transactions.size());
        pageInfo.add("\u00a77Current Page: \u00a7f" + (this.currentPage + 1) + "/" + totalPages);
        pageInfo.add("\u00a77Player: \u00a7f" + this.targetPlayerName);
        this.inventory.setItem(4, this.createItem(Material.BOOK, "\u00a76\u00a7lTransaction Info", pageInfo));
    }

    private ItemStack createBackItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Return to player analysis");
        return this.createItem(Material.ARROW, "\u00a7a\u00a7lBack", lore);
    }

    private ItemStack createRefreshItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Refresh transaction history");
        return this.createItem(Material.ARROW, "\u00a7a\u00a7lRefresh", lore);
    }

    private ItemStack createExportItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Export this player's transactions");
        lore.add("\u00a77to CSV file for analysis");
        lore.add("");
        lore.add("\u00a7eClick to export");
        return this.createItem(Material.PAPER, "\u00a7f\u00a7lExport Data", lore);
    }

    @Override
    public void handleClick(int slot, ClickType clickType) {
        switch (slot) {
            case 45: {
                this.plugin.getGUIManager().openPlayerAnalysis(this.player, this.targetPlayerName);
                break;
            }
            case 48: {
                if (this.currentPage <= 0) break;
                --this.currentPage;
                this.refresh();
                break;
            }
            case 49: {
                this.loadTransactions();
                this.currentPage = 0;
                this.refresh();
                this.player.sendMessage("\u00a76[Auditor] \u00a7aTransaction history refreshed!");
                break;
            }
            case 50: {
                int totalPages = (int)Math.ceil((double)this.transactions.size() / 28.0);
                if (this.currentPage >= totalPages - 1) break;
                ++this.currentPage;
                this.refresh();
                break;
            }
            case 53: {
                this.player.closeInventory();
                this.player.sendMessage("\u00a76[Auditor] \u00a7aExporting " + this.targetPlayerName + "'s transactions...");
                this.player.sendMessage("\u00a76[Auditor] \u00a7eUse: \u00a7f/auditor export transactions " + this.targetPlayerName);
                break;
            }
            default: {
                int transactionIndex = this.getTransactionIndexFromSlot(slot);
                if (transactionIndex < 0 || transactionIndex >= this.transactions.size()) break;
                this.showTransactionDetails(this.transactions.get(transactionIndex), transactionIndex + 1);
            }
        }
    }

    private int getTransactionIndexFromSlot(int slot) {
        if (slot < 10 || slot > 43) {
            return -1;
        }
        int row = (slot - 10) / 9;
        int col = (slot - 10) % 9;
        if (col > 6) {
            return -1;
        }
        int slotInPage = row * 7 + col;
        return this.currentPage * 28 + slotInPage;
    }

    private void showTransactionDetails(TransactionData transaction, int number) {
        this.player.sendMessage("\u00a76[Auditor] \u00a7eTransaction #" + number + " Details:");
        this.player.sendMessage("\u00a77==========================================");
        this.player.sendMessage("\u00a7bPlayer: \u00a7f" + this.targetPlayerName);
        this.player.sendMessage("\u00a7bAmount: " + (transaction.getAmount() >= 0.0 ? "\u00a7a+" : "\u00a7c") + "$" + this.formatNumber(transaction.getAmount()));
        this.player.sendMessage("\u00a7bType: \u00a7f" + transaction.getTransactionType());
        this.player.sendMessage("\u00a7bTimestamp: \u00a7f" + this.formatTime(transaction.getTimestamp()));
        if (transaction.getSourcePlugin() != null) {
            this.player.sendMessage("\u00a7bSource Plugin: \u00a7f" + transaction.getSourcePlugin());
        }
        if (transaction.getSourceCommand() != null) {
            this.player.sendMessage("\u00a7bCommand Used: \u00a7f" + transaction.getSourceCommand());
        }
        this.player.sendMessage("\u00a7bBalance Before: \u00a7f$" + this.formatNumber(transaction.getBalanceBefore()));
        this.player.sendMessage("\u00a7bBalance After: \u00a7f$" + this.formatNumber(transaction.getBalanceAfter()));
        if (transaction.getWorldName() != null) {
            this.player.sendMessage("\u00a7bWorld: \u00a7f" + transaction.getWorldName());
            this.player.sendMessage("\u00a7bLocation: \u00a7f(" + transaction.getLocationX() + ", " + transaction.getLocationY() + ", " + transaction.getLocationZ() + ")");
        }
        if (transaction.getTargetPlayerUUID() != null) {
            this.player.sendMessage("\u00a7bTarget Player UUID: \u00a7f" + transaction.getTargetPlayerUUID().toString());
        }
        if (transaction.getAdditionalData() != null && !transaction.getAdditionalData().isEmpty()) {
            this.player.sendMessage("\u00a7bAdditional Data: \u00a7f" + transaction.getAdditionalData());
        }
        this.player.sendMessage("\u00a77==========================================");
    }
}

