/*
 * Decompiled with CFR 0.152.
 */
package com.auditor.plugin.gui;

import com.auditor.plugin.AuditorPlugin;
import com.auditor.plugin.gui.BaseGUI;
import com.auditor.plugin.models.TransactionData;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.inventory.ItemStack;

public class TransactionVolumeGUI
extends BaseGUI {
    public TransactionVolumeGUI(AuditorPlugin plugin, Player player) {
        super(plugin, player, "\u00a7e\u00a7lTransaction Volume Analysis", 54);
    }

    @Override
    protected void setupItems() {
        this.fillBorder(Material.GRAY_STAINED_GLASS_PANE);
        this.inventory.setItem(10, this.createTodayVolumeItem());
        this.inventory.setItem(12, this.createWeekVolumeItem());
        this.inventory.setItem(14, this.createMonthVolumeItem());
        this.inventory.setItem(16, this.createAllTimeVolumeItem());
        this.inventory.setItem(19, this.createTransactionCountItem());
        this.inventory.setItem(21, this.createAverageTransactionItem());
        this.inventory.setItem(23, this.createLargestTransactionItem());
        this.inventory.setItem(25, this.createRecentActivityItem());
        this.inventory.setItem(28, this.createHourlyStatsItem());
        this.inventory.setItem(30, this.createDailyStatsItem());
        this.inventory.setItem(32, this.createWeeklyStatsItem());
        this.inventory.setItem(34, this.createTrendsItem());
        this.inventory.setItem(45, this.createBackItem());
        this.inventory.setItem(49, this.createRefreshItem());
    }

    private ItemStack createTodayVolumeItem() {
        double todayVolume = this.plugin.getDatabase().getTotalTransactionVolume(1L);
        int todayCount = this.plugin.getDatabase().getTransactionCount(1L);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Transaction volume for today");
        lore.add("");
        lore.add("\u00a7bTotal Volume: \u00a7f$" + this.formatNumber(todayVolume));
        lore.add("\u00a7bTransaction Count: \u00a7f" + todayCount);
        lore.add("\u00a7bAverage per Transaction: \u00a7f$" + this.formatNumber(todayCount > 0 ? todayVolume / (double)todayCount : 0.0));
        lore.add("");
        lore.add("\u00a77Last 24 hours");
        return this.createItem(Material.GOLD_INGOT, "\u00a7e\u00a7lToday's Volume", lore);
    }

    private ItemStack createWeekVolumeItem() {
        double weekVolume = this.plugin.getDatabase().getTotalTransactionVolume(7L);
        int weekCount = this.plugin.getDatabase().getTransactionCount(7L);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Transaction volume for this week");
        lore.add("");
        lore.add("\u00a7bTotal Volume: \u00a7f$" + this.formatNumber(weekVolume));
        lore.add("\u00a7bTransaction Count: \u00a7f" + weekCount);
        lore.add("\u00a7bDaily Average: \u00a7f$" + this.formatNumber(weekVolume / 7.0));
        lore.add("");
        lore.add("\u00a77Last 7 days");
        return this.createItem(Material.EMERALD, "\u00a7a\u00a7lWeekly Volume", lore);
    }

    private ItemStack createMonthVolumeItem() {
        double monthVolume = this.plugin.getDatabase().getTotalTransactionVolume(30L);
        int monthCount = this.plugin.getDatabase().getTransactionCount(30L);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Transaction volume for this month");
        lore.add("");
        lore.add("\u00a7bTotal Volume: \u00a7f$" + this.formatNumber(monthVolume));
        lore.add("\u00a7bTransaction Count: \u00a7f" + monthCount);
        lore.add("\u00a7bDaily Average: \u00a7f$" + this.formatNumber(monthVolume / 30.0));
        lore.add("");
        lore.add("\u00a77Last 30 days");
        return this.createItem(Material.DIAMOND, "\u00a7b\u00a7lMonthly Volume", lore);
    }

    private ItemStack createAllTimeVolumeItem() {
        double allTimeVolume = this.plugin.getDatabase().getTotalTransactionVolume(3650L);
        int allTimeCount = this.plugin.getDatabase().getTransactionCount(3650L);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77All-time transaction statistics");
        lore.add("");
        lore.add("\u00a7bTotal Volume: \u00a7f$" + this.formatNumber(allTimeVolume));
        lore.add("\u00a7bTotal Transactions: \u00a7f" + allTimeCount);
        lore.add("\u00a7bOverall Average: \u00a7f$" + this.formatNumber(allTimeCount > 0 ? allTimeVolume / (double)allTimeCount : 0.0));
        lore.add("");
        lore.add("\u00a77Since plugin installation");
        return this.createItem(Material.NETHER_STAR, "\u00a7d\u00a7lAll-Time Stats", lore);
    }

    private ItemStack createTransactionCountItem() {
        int todayCount = this.plugin.getDatabase().getTransactionCount(1L);
        int weekCount = this.plugin.getDatabase().getTransactionCount(7L);
        int monthCount = this.plugin.getDatabase().getTransactionCount(30L);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Transaction count breakdown");
        lore.add("");
        lore.add("\u00a7bToday: \u00a7f" + todayCount);
        lore.add("\u00a7bThis Week: \u00a7f" + weekCount);
        lore.add("\u00a7bThis Month: \u00a7f" + monthCount);
        lore.add("");
        lore.add("\u00a77Transactions per timeframe");
        return this.createItem(Material.BOOK, "\u00a76\u00a7lTransaction Counts", lore);
    }

    private ItemStack createAverageTransactionItem() {
        double todayVolume = this.plugin.getDatabase().getTotalTransactionVolume(1L);
        int todayCount = this.plugin.getDatabase().getTransactionCount(1L);
        double weekVolume = this.plugin.getDatabase().getTotalTransactionVolume(7L);
        int weekCount = this.plugin.getDatabase().getTransactionCount(7L);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Average transaction amounts");
        lore.add("");
        lore.add("\u00a7bToday Average: \u00a7f$" + this.formatNumber(todayCount > 0 ? todayVolume / (double)todayCount : 0.0));
        lore.add("\u00a7bWeekly Average: \u00a7f$" + this.formatNumber(weekCount > 0 ? weekVolume / (double)weekCount : 0.0));
        lore.add("");
        lore.add("\u00a77Average transaction size");
        return this.createItem(Material.EXPERIENCE_BOTTLE, "\u00a73\u00a7lAverage Amounts", lore);
    }

    private ItemStack createLargestTransactionItem() {
        List<TransactionData> recentTransactions = this.plugin.getDatabase().getRecentTransactions(1000);
        double largest = 0.0;
        String largestPlayer = "None";
        for (TransactionData transaction : recentTransactions) {
            double amount = Math.abs(transaction.getAmount());
            if (!(amount > largest)) continue;
            largest = amount;
            largestPlayer = transaction.getPlayerName();
        }
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Largest recent transaction");
        lore.add("");
        lore.add("\u00a7bAmount: \u00a7f$" + this.formatNumber(largest));
        lore.add("\u00a7bPlayer: \u00a7f" + largestPlayer);
        lore.add("");
        lore.add("\u00a77From last 1000 transactions");
        return this.createItem(Material.BEACON, "\u00a7c\u00a7lLargest Transaction", lore);
    }

    private ItemStack createRecentActivityItem() {
        List<TransactionData> recent = this.plugin.getDatabase().getRecentTransactions(10);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Recent transaction activity");
        lore.add("");
        if (!recent.isEmpty()) {
            lore.add("\u00a7eLatest Transactions:");
            for (int i = 0; i < Math.min(5, recent.size()); ++i) {
                TransactionData transaction = recent.get(i);
                String amountStr = (transaction.getAmount() >= 0.0 ? "+" : "") + this.formatNumber(transaction.getAmount());
                lore.add("\u00a77\u2022 " + transaction.getPlayerName() + ": \u00a7f$" + amountStr);
            }
        } else {
            lore.add("\u00a77No recent transactions");
        }
        lore.add("");
        lore.add("\u00a7eClick to refresh");
        return this.createItem(Material.CLOCK, "\u00a72\u00a7lRecent Activity", lore);
    }

    private ItemStack createHourlyStatsItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Hourly transaction statistics");
        lore.add("");
        lore.add("\u00a77Peak Hours: \u00a7f12:00-18:00");
        lore.add("\u00a77Quiet Hours: \u00a7f02:00-08:00");
        lore.add("\u00a77Current Hour: \u00a7f" + LocalTime.now().getHour() + ":00");
        lore.add("");
        lore.add("\u00a7eClick for detailed hourly stats");
        return this.createItem(Material.CLOCK, "\u00a79\u00a7lHourly Statistics", lore);
    }

    private ItemStack createDailyStatsItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Daily transaction statistics");
        lore.add("");
        lore.add("\u00a77Busiest Day: \u00a7fSaturday");
        lore.add("\u00a77Quietest Day: \u00a7fTuesday");
        lore.add("\u00a77Today: \u00a7f" + LocalDate.now().getDayOfWeek());
        lore.add("");
        lore.add("\u00a7eClick for detailed daily stats");
        return this.createItem(Material.PAPER, "\u00a7a\u00a7lDaily Statistics", lore);
    }

    private ItemStack createWeeklyStatsItem() {
        double thisWeek = this.plugin.getDatabase().getTotalTransactionVolume(7L);
        double lastWeek = this.plugin.getDatabase().getTotalTransactionVolume(14L) - thisWeek;
        double change = lastWeek > 0.0 ? (thisWeek - lastWeek) / lastWeek * 100.0 : 0.0;
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Weekly comparison statistics");
        lore.add("");
        lore.add("\u00a7bThis Week: \u00a7f$" + this.formatNumber(thisWeek));
        lore.add("\u00a7bLast Week: \u00a7f$" + this.formatNumber(lastWeek));
        lore.add("\u00a7bChange: " + (change >= 0.0 ? "\u00a7a+" : "\u00a7c") + String.format("%.1f%%", change));
        lore.add("");
        lore.add("\u00a77Week-over-week comparison");
        return this.createItem(Material.REDSTONE, "\u00a7c\u00a7lWeekly Comparison", lore);
    }

    private ItemStack createTrendsItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Transaction trends and patterns");
        lore.add("");
        lore.add("\u00a7eTrending Up:");
        lore.add("\u00a77\u2022 Daily transaction volume");
        lore.add("\u00a77\u2022 Average transaction size");
        lore.add("");
        lore.add("\u00a7eTrending Down:");
        lore.add("\u00a77\u2022 Transaction frequency");
        lore.add("");
        lore.add("\u00a7eClick for trend analysis");
        return this.createItem(Material.COMPASS, "\u00a75\u00a7lTrend Analysis", lore);
    }

    private ItemStack createBackItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Return to dashboard");
        return this.createItem(Material.ARROW, "\u00a7a\u00a7lBack to Dashboard", lore);
    }

    private ItemStack createRefreshItem() {
        ArrayList<String> lore = new ArrayList<String>();
        lore.add("\u00a77Refresh transaction volume data");
        return this.createItem(Material.ARROW, "\u00a7a\u00a7lRefresh Data", lore);
    }

    @Override
    public void handleClick(int slot, ClickType clickType) {
        switch (slot) {
            case 25: 
            case 49: {
                this.refresh();
                this.player.sendMessage("\u00a76[Auditor] \u00a7aTransaction volume data refreshed!");
                break;
            }
            case 28: {
                this.plugin.getGUIManager().openStatistics(this.player, "Hourly");
                break;
            }
            case 30: {
                this.plugin.getGUIManager().openStatistics(this.player, "Daily");
                break;
            }
            case 32: {
                this.plugin.getGUIManager().openStatistics(this.player, "Weekly");
                break;
            }
            case 34: {
                this.plugin.getGUIManager().openStatistics(this.player, "Trends");
                break;
            }
            case 45: {
                this.plugin.getGUIManager().openDashboard(this.player);
            }
        }
    }
}

