/*
 * Decompiled with CFR 0.152.
 */
package com.auditor.plugin.integrations;

import com.auditor.plugin.AuditorPlugin;
import com.auditor.plugin.models.PlayerProfile;
import org.bukkit.OfflinePlayer;

public class AuditorPlaceholders {
    private final AuditorPlugin plugin;

    public AuditorPlaceholders(AuditorPlugin plugin) {
        this.plugin = plugin;
    }

    public void register() {
    }

    public String getIdentifier() {
        return "auditor";
    }

    public String getAuthor() {
        return "WiiZARDD";
    }

    public String getVersion() {
        return this.plugin.getDescription().getVersion();
    }

    public boolean persist() {
        return true;
    }

    public String onRequest(OfflinePlayer player, String params) {
        if (player == null) {
            return "";
        }
        PlayerProfile profile = this.plugin.getDatabase().getPlayerProfile(player.getUniqueId());
        if (profile == null) {
            return "0";
        }
        switch (params.toLowerCase()) {
            case "transactions": {
                return String.valueOf(profile.getTotalTransactions());
            }
            case "spent": {
                return String.format("%.2f", profile.getTotalSpent());
            }
            case "earned": {
                return String.format("%.2f", profile.getTotalEarned());
            }
            case "largest_transaction": {
                return String.format("%.2f", profile.getLargestTransaction());
            }
            case "average_transaction": {
                return String.format("%.2f", profile.getAverageTransaction());
            }
            case "risk_score": {
                return String.valueOf(profile.getRiskScore());
            }
            case "risk_level": {
                return profile.getRiskLevel();
            }
            case "is_monitored": {
                return profile.isMonitored() ? "Yes" : "No";
            }
        }
        return null;
    }
}

