/*
 * Decompiled with CFR 0.152.
 */
package com.auditor.plugin.utils;

import com.auditor.plugin.AuditorPlugin;
import java.io.File;
import java.io.IOException;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class ConfigManager {
    private final AuditorPlugin plugin;
    private FileConfiguration config;
    private FileConfiguration alertsConfig;
    private FileConfiguration messagesConfig;
    private File configFile;
    private File alertsFile;
    private File messagesFile;

    public ConfigManager(AuditorPlugin plugin) {
        this.plugin = plugin;
        this.setupConfigs();
    }

    private void setupConfigs() {
        if (!this.plugin.getDataFolder().exists()) {
            this.plugin.getDataFolder().mkdirs();
        }
        this.configFile = new File(this.plugin.getDataFolder(), "config.yml");
        this.alertsFile = new File(this.plugin.getDataFolder(), "alerts.yml");
        this.messagesFile = new File(this.plugin.getDataFolder(), "messages.yml");
        if (!this.configFile.exists()) {
            this.plugin.saveResource("config.yml", false);
        }
        this.createDefaultAlerts();
        this.createDefaultMessages();
        this.reloadConfigs();
    }

    private void createDefaultAlerts() {
        if (!this.alertsFile.exists()) {
            this.alertsConfig = new YamlConfiguration();
            this.alertsConfig.set("thresholds.spending_spike.enabled", (Object)true);
            this.alertsConfig.set("thresholds.spending_spike.multiplier", (Object)5.0);
            this.alertsConfig.set("thresholds.spending_spike.minimum_amount", (Object)1000);
            this.alertsConfig.set("thresholds.spending_spike.severity", (Object)"MEDIUM");
            this.alertsConfig.set("thresholds.large_transaction.enabled", (Object)true);
            this.alertsConfig.set("thresholds.large_transaction.amount", (Object)50000);
            this.alertsConfig.set("thresholds.large_transaction.severity", (Object)"HIGH");
            this.alertsConfig.set("thresholds.rapid_transactions.enabled", (Object)true);
            this.alertsConfig.set("thresholds.rapid_transactions.count", (Object)20);
            this.alertsConfig.set("thresholds.rapid_transactions.timeframe_minutes", (Object)5);
            this.alertsConfig.set("thresholds.rapid_transactions.severity", (Object)"MEDIUM");
            this.alertsConfig.set("thresholds.possible_duplication.enabled", (Object)true);
            this.alertsConfig.set("thresholds.possible_duplication.amount", (Object)100000);
            this.alertsConfig.set("thresholds.possible_duplication.timeframe_minutes", (Object)1);
            this.alertsConfig.set("thresholds.possible_duplication.severity", (Object)"CRITICAL");
            this.alertsConfig.set("thresholds.dormant_reactivation.enabled", (Object)true);
            this.alertsConfig.set("thresholds.dormant_reactivation.dormant_days", (Object)30);
            this.alertsConfig.set("thresholds.dormant_reactivation.activity_threshold", (Object)10000);
            this.alertsConfig.set("thresholds.dormant_reactivation.severity", (Object)"MEDIUM");
            this.alertsConfig.set("thresholds.wealth_concentration.enabled", (Object)true);
            this.alertsConfig.set("thresholds.wealth_concentration.percentage", (Object)80);
            this.alertsConfig.set("thresholds.wealth_concentration.check_interval_hours", (Object)24);
            this.alertsConfig.set("thresholds.wealth_concentration.severity", (Object)"LOW");
            this.saveAlertsConfig();
        }
    }

    private void createDefaultMessages() {
        if (!this.messagesFile.exists()) {
            this.messagesConfig = new YamlConfiguration();
            this.messagesConfig.set("messages.prefix", (Object)"&6[&eAuditor&6]&r ");
            this.messagesConfig.set("messages.commands.no_permission", (Object)"&cYou don't have permission to use this command.");
            this.messagesConfig.set("messages.commands.player_not_found", (Object)"&cPlayer not found: {player}");
            this.messagesConfig.set("messages.commands.invalid_timeframe", (Object)"&cInvalid timeframe. Use: 1h, 1d, 1w, 1m");
            this.messagesConfig.set("messages.commands.reload_success", (Object)"&aConfiguration reloaded successfully!");
            this.messagesConfig.set("messages.gui.dashboard_title", (Object)"&6&lAuditor Dashboard");
            this.messagesConfig.set("messages.gui.player_analysis_title", (Object)"&6&lPlayer Analysis: {player}");
            this.messagesConfig.set("messages.gui.alerts_title", (Object)"&c&lActive Alerts");
            this.messagesConfig.set("messages.alerts.spending_spike", (Object)"&cPlayer {player} had unusual spending: ${amount}");
            this.messagesConfig.set("messages.alerts.large_transaction", (Object)"&cLarge transaction detected: ${amount}");
            this.messagesConfig.set("messages.alerts.possible_duplication", (Object)"&4CRITICAL: Possible money duplication by {player}");
            this.messagesConfig.set("messages.alerts.rapid_transactions", (Object)"&ePlayer {player} made {count} transactions in {timeframe} minutes");
            this.messagesConfig.set("messages.economy.health_excellent", (Object)"&aEconomy Health: Excellent");
            this.messagesConfig.set("messages.economy.health_good", (Object)"&2Economy Health: Good");
            this.messagesConfig.set("messages.economy.health_fair", (Object)"&eEconomy Health: Fair");
            this.messagesConfig.set("messages.economy.health_poor", (Object)"&cEconomy Health: Poor");
            this.messagesConfig.set("messages.economy.health_critical", (Object)"&4Economy Health: Critical");
            this.saveMessagesConfig();
        }
    }

    public void reloadConfigs() {
        this.config = YamlConfiguration.loadConfiguration((File)this.configFile);
        this.alertsConfig = YamlConfiguration.loadConfiguration((File)this.alertsFile);
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)this.messagesFile);
    }

    public FileConfiguration getConfig() {
        return this.config;
    }

    public FileConfiguration getAlertsConfig() {
        return this.alertsConfig;
    }

    public FileConfiguration getMessagesConfig() {
        return this.messagesConfig;
    }

    public void saveConfig() {
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Could not save config.yml: " + e.getMessage());
        }
    }

    public void saveAlertsConfig() {
        try {
            this.alertsConfig.save(this.alertsFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Could not save alerts.yml: " + e.getMessage());
        }
    }

    public void saveMessagesConfig() {
        try {
            this.messagesConfig.save(this.messagesFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Could not save messages.yml: " + e.getMessage());
        }
    }

    public boolean isMonitoringEnabled() {
        return this.config.getBoolean("auditor.monitoring.enabled", true);
    }

    public boolean shouldTrackAllTransactions() {
        return this.config.getBoolean("auditor.monitoring.track_all_transactions", true);
    }

    public boolean shouldTrackBalanceChanges() {
        return this.config.getBoolean("auditor.monitoring.track_balance_changes", true);
    }

    public boolean shouldTrackCommandUsage() {
        return this.config.getBoolean("auditor.monitoring.track_command_usage", true);
    }

    public boolean shouldTrackLocationData() {
        return this.config.getBoolean("auditor.monitoring.track_location_data", false);
    }

    public int getAutoCleanupDays() {
        return this.config.getInt("auditor.database.auto_cleanup_days", 90);
    }

    public int getBackupIntervalHours() {
        return this.config.getInt("auditor.database.backup_interval_hours", 24);
    }

    public boolean isAlertsEnabled() {
        return this.config.getBoolean("auditor.alerts.enabled", true);
    }

    public String getDiscordWebhook() {
        return this.config.getString("auditor.alerts.discord_webhook", "");
    }

    public int getGUIRefreshInterval() {
        return this.config.getInt("auditor.gui.refresh_interval_seconds", 5);
    }

    public boolean isHealthChecksEnabled() {
        return this.config.getBoolean("auditor.health_checks.enabled", true);
    }

    public int getHealthCalculationInterval() {
        return this.config.getInt("auditor.health_checks.calculation_interval_minutes", 30);
    }

    public void setMonitoringEnabled(boolean enabled) {
        this.config.set("auditor.monitoring.enabled", (Object)enabled);
        this.saveConfigFile();
    }

    public void setAlertsEnabled(boolean enabled) {
        this.config.set("auditor.alerts.enabled", (Object)enabled);
        this.saveConfigFile();
    }

    public void setHealthChecksEnabled(boolean enabled) {
        this.config.set("auditor.health_checks.enabled", (Object)enabled);
        this.saveConfigFile();
    }

    public void setAutoCleanupDays(int days) {
        this.config.set("auditor.database.auto_cleanup_days", (Object)days);
        this.saveConfigFile();
    }

    public void setBackupIntervalHours(int hours) {
        this.config.set("auditor.database.backup_interval_hours", (Object)hours);
        this.saveConfigFile();
    }

    public void setDiscordWebhook(String webhook) {
        this.config.set("auditor.alerts.discord_webhook", (Object)webhook);
        this.saveConfigFile();
    }

    private void saveConfigFile() {
        try {
            this.config.save(this.configFile);
        }
        catch (IOException e) {
            this.plugin.getLogger().warning("Failed to save config: " + e.getMessage());
        }
    }
}

