/*
 * Decompiled with CFR 0.152.
 */
package com.auditor.plugin.utils;

import com.auditor.plugin.AuditorPlugin;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class MessageManager {
    private final AuditorPlugin plugin;

    public MessageManager(AuditorPlugin plugin) {
        this.plugin = plugin;
    }

    public String getMessage(String key) {
        String message = this.plugin.getConfigManager().getMessagesConfig().getString("messages." + key);
        if (message == null) {
            return "\u00a7cMessage not found: " + key;
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)message);
    }

    public String getMessage(String key, String ... replacements) {
        String message = this.getMessage(key);
        for (int i = 0; i < replacements.length; i += 2) {
            if (i + 1 >= replacements.length) continue;
            message = message.replace(replacements[i], replacements[i + 1]);
        }
        return message;
    }

    public void sendMessage(CommandSender sender, String key) {
        String prefix = this.getMessage("prefix");
        String message = this.getMessage(key);
        sender.sendMessage(prefix + message);
    }

    public void sendMessage(CommandSender sender, String key, String ... replacements) {
        String prefix = this.getMessage("prefix");
        String message = this.getMessage(key, replacements);
        sender.sendMessage(prefix + message);
    }

    public void sendRawMessage(CommandSender sender, String message) {
        String prefix = this.getMessage("prefix");
        sender.sendMessage(prefix + ChatColor.translateAlternateColorCodes((char)'&', (String)message));
    }

    public String getPrefix() {
        return this.getMessage("prefix");
    }
}

