/*
 * Decompiled with CFR 0.152.
 */
package com.teashoe.newposts;

import com.teashoe.newposts.ModConfig;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.GsonConfigSerializer;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.minecraft.class_124;
import net.minecraft.class_1269;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_5250;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Newposts
implements ClientModInitializer {
    private boolean newPostAlertEnabled = true;
    private final Set<String> currentPostNumbers = new HashSet<String>();
    private final ScheduledExecutorService scheduler = Executors.newSingleThreadScheduledExecutor();
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"newposts");

    public void onInitializeClient() {
        AutoConfig.register(ModConfig.class, GsonConfigSerializer::new);
        AutoConfig.getConfigHolder(ModConfig.class).registerSaveListener((configHolder, newConfig) -> {
            this.initializePostNumbers();
            return class_1269.field_5812;
        });
        ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> this.initializePostNumbers());
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (this.newPostAlertEnabled && !this.scheduler.isShutdown()) {
                this.scheduler.scheduleAtFixedRate(() -> this.checkNewPosts(client), 0L, 60L, TimeUnit.SECONDS);
            }
        });
    }

    private void initializePostNumbers() {
        String galleryId = ModConfig.get().galleryId;
        String url = "https://gall.dcinside.com/mgallery/board/lists?id=" + galleryId;
        try {
            Document document = Jsoup.connect((String)url).get();
            Elements postList = document.select(".ub-content.us-post");
            for (Element postElement : postList) {
                String number = postElement.select(".gall_num").text();
                this.currentPostNumbers.add(number);
            }
        }
        catch (IOException e) {
            LOGGER.error("\uac8c\uc2dc\ubb3c\uc744 \ucd08\uae30\ud654\ud558\ub294 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4: {}", (Object)e.getMessage());
        }
    }

    private void checkNewPosts(class_310 client) {
        if (client.field_1724 == null) {
            return;
        }
        String galleryId = ModConfig.get().galleryId;
        String url = "https://gall.dcinside.com/mgallery/board/lists?id=" + galleryId;
        try {
            Document document = Jsoup.connect((String)url).get();
            Elements postList = document.select(".ub-content.us-post");
            for (Element postElement : postList) {
                String number = postElement.select(".gall_num").text();
                if (this.currentPostNumbers.contains(number)) continue;
                this.currentPostNumbers.add(number);
                String subject = postElement.select(".gall_subject").text();
                String title = postElement.select(".gall_tit.ub-word").text();
                String author = postElement.select(".gall_writer.ub-writer .nickname em").text();
                String dataIp = postElement.select(".gall_writer").attr("data-ip");
                String dataUid = postElement.select(".gall_writer").attr("data-uid");
                class_5250 authorText = class_2561.method_43470((String)("[" + author + "]")).method_27694(style -> style.method_10977(class_124.field_1068));
                if (!dataIp.isEmpty() && ModConfig.get().showIpAddress) {
                    authorText.method_10852((class_2561)class_2561.method_43470((String)(" (" + dataIp + ")")).method_27694(style -> style.method_10977(class_124.field_1080)));
                }
                if (!dataUid.isEmpty() && ModConfig.get().showuid) {
                    authorText.method_10852((class_2561)class_2561.method_43470((String)(" (" + dataUid + ")")).method_27694(style -> style.method_10977(class_124.field_1080)));
                }
                class_5250 subjectPrefix = class_2561.method_43470((String)"");
                if (!subject.isEmpty()) {
                    subjectPrefix.method_10852((class_2561)class_2561.method_43470((String)("[" + subject + "] ")).method_27694(style -> style.method_10977(class_124.field_1060)));
                }
                class_5250 newPostPrefix = class_2561.method_43470((String)"[\uc0c8\uae00] ").method_27694(style -> style.method_10977(class_124.field_1054));
                class_5250 postDetails = class_2561.method_43470((String)(title + " ")).method_27694(style -> style.method_10958((class_2558)new class_2558.class_10608(URI.create("https://gall.dcinside.com/mgallery/board/view/?id=" + galleryId + "&no=" + number))).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)"\uac8c\uc2dc\ubb3c \ubcf4\uae30"))).method_10977(class_124.field_1068)).method_10852((class_2561)authorText);
                class_5250 combinedPrefix = newPostPrefix.method_10852((class_2561)subjectPrefix);
                class_5250 clickableMessage = combinedPrefix.method_10852((class_2561)postDetails);
                client.execute(() -> {
                    if (client.field_1724 != null) {
                        boolean useSystemChat = ModConfig.get().useSystemChat;
                        client.field_1724.method_7353((class_2561)clickableMessage, useSystemChat);
                        client.field_1724.method_5783(class_3417.field_15224, 1.0f, 1.0f);
                    }
                });
            }
        }
        catch (IOException e) {
            LOGGER.error("\uac8c\uc2dc\ubb3c\uc744 \uac00\uc838\uc624\ub294 \uc911 \uc624\ub958\uac00 \ubc1c\uc0dd\ud588\uc2b5\ub2c8\ub2e4: {}", (Object)e.getMessage());
        }
    }
}

