package org.codeberg.zenxarch.skyblock.mixin.magma;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3611;
import net.minecraft.class_5689;
import net.minecraft.class_5689.class_7381;
import org.codeberg.zenxarch.skyblock.DripstoneUtils;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_5689.class)
public abstract class PointedDripstoneBlockMixin {

  @ModifyReturnValue(method = "getFluid", at = @At("RETURN"))
  private static Optional<class_7381> zenxarch$modifyFluid(Optional<class_7381> original) {
    return original.map(DripstoneUtils::remapFluid);
  }

  @WrapOperation(
      method = "dripTick",
      at =
          @At(
              value = "INVOKE",
              target =
                  "Lnet/minecraft/block/PointedDripstoneBlock;getCauldronPos(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/fluid/Fluid;)Lnet/minecraft/util/math/BlockPos;"))
  private static class_2338 zenxarch$maybeConvertToNetherrack(
      class_1937 world,
      class_2338 pos,
      class_3611 fluid,
      Operation<class_2338> op,
      @Local Optional<class_7381> dripFluid) {
    if (world instanceof class_3218 serverWorld
        && dripFluid.get().comp_711().method_27852(class_2246.field_10092)
        && serverWorld.field_9229.method_43056()) {
      DripstoneUtils.convertToNetherrack(
          serverWorld, dripFluid.get().comp_709(), dripFluid.get().comp_711());
      return null;
    }
    return op.call(world, pos, fluid);
  }
}
