/*
 * Decompiled with CFR 0.152.
 */
package org.codeberg.zenxarch.skyblock.gen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.stream.IntStream;
import net.minecraft.class_156;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3233;
import net.minecraft.class_3532;
import net.minecraft.class_3754;
import net.minecraft.class_39;
import net.minecraft.class_5138;
import net.minecraft.class_5268;
import net.minecraft.class_5281;
import net.minecraft.class_5284;
import net.minecraft.class_5321;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6748;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import net.minecraft.class_7871;
import net.minecraft.class_7924;
import net.minecraft.class_8934;
import org.codeberg.zenxarch.skyblock.Skyblock;
import org.codeberg.zenxarch.skyblock.gen.SpawnPlatform;
import org.jetbrains.annotations.NotNull;

public class SkyblockChunkGenerator
extends class_3754 {
    public static final MapCodec<SkyblockChunkGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1966.field_24713.fieldOf("biome_source").forGetter(class_2794::method_12098), (App)class_5284.field_24781.fieldOf("settings").forGetter(class_3754::method_41541), (App)Codec.INT.optionalFieldOf("spawnHeight", (Object)0).forGetter(SkyblockChunkGenerator::getSpawnHeight)).apply((Applicative)instance, instance.stable(SkyblockChunkGenerator::new)));
    private final int spawnHeight;

    public SkyblockChunkGenerator(class_1966 biomeSource, class_6880<class_5284> settings, int spawnHeight) {
        super(biomeSource, settings);
        this.spawnHeight = spawnHeight;
    }

    public int getSpawnHeight() {
        return this.spawnHeight;
    }

    public int method_12100(class_5539 world) {
        return class_3532.method_15340((int)this.spawnHeight, (int)world.method_31607(), (int)world.method_31600());
    }

    @NotNull
    protected MapCodec<? extends class_2794> method_28506() {
        return CODEC;
    }

    public void method_12110(class_3233 region, class_5138 structures, class_7138 noiseConfig, class_2791 chunk) {
    }

    public CompletableFuture<class_2791> method_12088(class_6748 blender, class_7138 noiseConfig, class_5138 structureAccessor, class_2791 chunk) {
        return CompletableFuture.completedFuture(chunk);
    }

    public void method_12102(class_5281 world, class_2791 chunk, class_5138 structureAccessor) {
    }

    public void method_12107(class_3233 region) {
    }

    public int getBaseHeightInEquivalentNoiseWorld(int x, int z, class_2902.class_2903 heightmap, class_5281 world) {
        class_7138 randomState = class_7138.method_41556((class_5284)((class_5284)this.method_41541().comp_349()), (class_7871)world.method_30349().method_30530(class_7924.field_41244), (long)world.method_8412());
        return super.method_16397(x, z, heightmap, (class_5539)world, randomState);
    }

    protected class_2960 getStructurePieceId() {
        return Skyblock.id("spawn_platform");
    }

    public void generateSpawnPlatform(class_3218 world, class_5268 worldProperties, boolean bonusChest, class_1923 chunkPos) {
        int spawnHeight = this.method_12100((class_5539)world);
        class_2338 spawnPos = worldProperties.method_56126().method_33096(spawnHeight);
        SpawnPlatform.generateSpawnPlatform(world, chunkPos, spawnPos, this.getStructurePieceId());
        worldProperties.method_187(spawnPos, 0.0f);
        if (bonusChest) {
            this.spawnBonusChest(world, spawnHeight, chunkPos, world.method_8409());
        }
    }

    private void spawnBonusChest(class_3218 world, int spawnHeight, class_1923 chunkPos, class_5819 random) {
        IntArrayList xposz = class_156.method_43251((IntStream)IntStream.range(chunkPos.method_8326(), chunkPos.method_8327()), (class_5819)random);
        IntArrayList zposz = class_156.method_43251((IntStream)IntStream.range(chunkPos.method_8328(), chunkPos.method_8329()), (class_5819)random);
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        for (Integer x : xposz) {
            for (Integer z : zposz) {
                blockPos.method_10103(x.intValue(), 0, z.intValue());
                if (!this.isValidPosForBonusChest(world, (class_2338)blockPos, spawnHeight) || !this.summonBonusChestAt(world, world.method_8598(class_2902.class_2903.field_13203, (class_2338)blockPos), random)) continue;
                return;
            }
        }
    }

    private boolean summonBonusChestAt(class_3218 world, class_2338 pos, class_5819 random) {
        if (!world.method_22347(pos)) {
            return false;
        }
        world.method_8652(pos, class_2246.field_10034.method_9564(), 3);
        class_8934.method_54868((class_1922)world, (class_5819)random, (class_2338)pos, (class_5321)class_39.field_850);
        return true;
    }

    private boolean isValidPosForBonusChest(class_3218 world, class_2338 pos, int spawnHeight) {
        return Math.abs(world.method_8624(class_2902.class_2903.field_13203, pos.method_10263(), pos.method_10260()) - spawnHeight) < 16;
    }
}

