package org.codeberg.zenxarch.skyblock;

import net.fabricmc.fabric.api.gamerule.v1.CustomGameRuleCategory;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleFactory;
import net.fabricmc.fabric.api.gamerule.v1.GameRuleRegistry;
import net.minecraft.class_124;
import net.minecraft.class_1928;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.class_8828;

public abstract class SkyblockGamerules {
  public static final CustomGameRuleCategory SKYBLOCK_GENERAL =
      new CustomGameRuleCategory(
          Skyblock.id("skyblock"),
          class_5250.method_43477(class_8828.method_54232("ZenXArch's Skyblock"))
              .method_10862(class_2583.field_24360.method_10977(class_124.field_1054)));

  public static class_1928.class_4313<class_1928.class_4312> newGameRule(String name, int defaultValue) {
    return GameRuleRegistry.register(
        name, SKYBLOCK_GENERAL, GameRuleFactory.createIntRule(defaultValue));
  }

  public static class_1928.class_4313<class_1928.class_4310> newGameRule(
      String name, boolean defaultValue) {
    return GameRuleRegistry.register(
        name, SKYBLOCK_GENERAL, GameRuleFactory.createBooleanRule(defaultValue));
  }

  public static final class_1928.class_4313<class_1928.class_4312> WANDERING_TRADER_SPAWN_CHANCE =
      newGameRule("zenxarch.skyblock.wanderingTraderSpawnChance", 10);

  public static final class_1928.class_4313<class_1928.class_4312> WANDERING_TRADER_SPAWN_DELAY =
      newGameRule("zenxarch.skyblock.wanderingTraderSpawnDelay", 20);

  public static final class_1928.class_4313<class_1928.class_4310> FIX_WANDERING_TRADER_SPAWNING_IN_SNOW =
      newGameRule("zenxarch.skyblock.fixWanderingTraderSpawningInSnow", true);

  public static final class_1928.class_4313<class_1928.class_4310> NETTHERRACK_EXTENSIONS_FOR_PORTALS =
      newGameRule("zenxarch.skyblock.netherrackExtensionsForPortals", false);

  public static void initialize() {
    /* Force load static members of this class */
  }
}
