package org.codeberg.zenxarch.skyblock.mixin.gen;

import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.class_11545;
import net.minecraft.class_1923;
import net.minecraft.class_3218;
import net.minecraft.class_5268;
import net.minecraft.server.MinecraftServer;
import org.codeberg.zenxarch.skyblock.gen.SkyblockChunkGenerator;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(MinecraftServer.class)
public abstract class MinecraftServerMixin {
  @Inject(
      method = "setupSpawn",
      at =
          @At(
              value = "INVOKE",
              target =
                  "Lnet/minecraft/world/level/ServerWorldProperties;setSpawnPos(Lnet/minecraft/util/math/BlockPos;F)V",
              ordinal = 1,
              shift = At.Shift.AFTER),
      cancellable = true)
  private static void zenxarch$setInitialSpawn(
      class_3218 world,
      class_5268 worldProperties,
      boolean bonusChest,
      boolean debugWorld,
      class_11545 progress,
      CallbackInfo ci,
      @Local class_1923 chunkPos) {
    switch (world.getChunkManager().getChunkGenerator()) {
      case SkyblockChunkGenerator skyblock -> {
        skyblock.generateSpawnPlatform(world, worldProperties, bonusChest, chunkPos);
        ci.cancel();
      }
      default -> {}
    }
  }
}
