package org.codeberg.zenxarch.skyblock.gen;

import com.google.common.collect.Lists;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.class_1966;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3229;
import net.minecraft.class_3232;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5284;
import net.minecraft.class_5539;
import net.minecraft.class_6880;
import org.codeberg.zenxarch.skyblock.Skyblock;
import org.jetbrains.annotations.NotNull;

public class FlatblockChunkGenerator extends SkyblockChunkGenerator {

  public static final MapCodec<FlatblockChunkGenerator> field_24773 =
      RecordCodecBuilder.mapCodec(
          instance ->
              instance
                  .group(
                      class_1966.field_24713
                          .fieldOf("biome_source")
                          .forGetter(FlatblockChunkGenerator::method_12098),
                      class_5284.field_24781
                          .fieldOf("settings")
                          .forGetter(FlatblockChunkGenerator::method_41541),
                      class_3229.field_24974
                          .listOf()
                          .fieldOf("layers")
                          .forGetter(FlatblockChunkGenerator::getLayers))
                  .apply(instance, instance.stable(FlatblockChunkGenerator::new)));

  private final List<class_3229> layers;
  private final List<class_2680> layerBlocks;

  public FlatblockChunkGenerator(
      class_1966 biomeSource,
      class_6880<class_5284> settings,
      List<class_3229> layers) {
    super(biomeSource, settings, 0);
    this.layers = layers;
    this.layerBlocks = Lists.newArrayList();

    for (var layer : layers) {
      for (int i = 0; i < layer.method_14289(); i++) layerBlocks.add(layer.method_14286());
    }
  }

  public FlatblockChunkGenerator with(class_3232 config) {
    return new FlatblockChunkGenerator(method_12098(), method_41541(), config.method_14327());
  }

  public class_3232 fakeConfig(class_3232 config) {
    return config.method_46727(getLayers(), config.method_41139(), config.method_14326());
  }

  @Override
  protected @NotNull MapCodec<? extends class_2794> method_28506() {
    return field_24773;
  }

  @Override
  public void method_12102(
      class_5281 world, class_2791 chunk, class_5138 structureAccessor) {
    var oceanHeightmap = chunk.method_12032(class_2902.class_2903.field_13195);
    var surfaceHeightmap = chunk.method_12032(class_2902.class_2903.field_13194);

    var layersSize = Math.min(chunk.method_31605(), this.layerBlocks.size());

    var minY = world.method_31607();
    for (var pos : class_2338.method_10094(0, minY, 0, 15, minY + layersSize - 1, 15)) {
      var idx = pos.method_10264() - minY;
      var state = layerBlocks.get(idx);
      chunk.method_66480(pos, state);
      oceanHeightmap.method_12597(pos.method_10263(), pos.method_10264(), pos.method_10260(), state);
      surfaceHeightmap.method_12597(pos.method_10263(), pos.method_10264(), pos.method_10260(), state);
    }
  }

  @Override
  public int method_12100(class_5539 world) {
    return world.method_31607() + Math.min(world.method_31605(), this.layerBlocks.size());
  }

  public List<class_3229> getLayers() {
    return this.layers;
  }

  @Override
  protected class_2960 getStructurePieceId() {
    return Skyblock.id("flat_platform");
  }
}
