package org.codeberg.zenxarch.skyblock.gen;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.concurrent.CompletableFuture;
import java.util.stream.IntStream;
import net.minecraft.class_156;
import net.minecraft.class_1923;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3233;
import net.minecraft.class_3532;
import net.minecraft.class_3754;
import net.minecraft.class_39;
import net.minecraft.class_5138;
import net.minecraft.class_5217.class_12064;
import net.minecraft.class_5268;
import net.minecraft.class_5281;
import net.minecraft.class_5284;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6748;
import net.minecraft.class_6880;
import net.minecraft.class_7138;
import net.minecraft.class_7924;
import net.minecraft.class_8934;
import org.codeberg.zenxarch.skyblock.Skyblock;
import org.jetbrains.annotations.NotNull;

public class SkyblockChunkGenerator extends class_3754 {
  public static final MapCodec<SkyblockChunkGenerator> field_24773 =
      RecordCodecBuilder.mapCodec(
          instance ->
              instance
                  .group(
                      class_1966.field_24713
                          .fieldOf("biome_source")
                          .forGetter(SkyblockChunkGenerator::method_12098),
                      class_5284.field_24781
                          .fieldOf("settings")
                          .forGetter(SkyblockChunkGenerator::method_41541),
                      Codec.INT
                          .optionalFieldOf("spawnHeight", 0)
                          .forGetter(SkyblockChunkGenerator::getSpawnHeight))
                  .apply(instance, instance.stable(SkyblockChunkGenerator::new)));

  private final int spawnHeight;

  public SkyblockChunkGenerator(
      class_1966 biomeSource, class_6880<class_5284> settings, int spawnHeight) {
    super(biomeSource, settings);
    this.spawnHeight = spawnHeight;
  }

  public int getSpawnHeight() {
    return spawnHeight;
  }

  @Override
  public int method_12100(class_5539 world) {
    return class_3532.method_15340(this.spawnHeight, world.method_31607(), world.method_31600());
  }

  @Override
  protected @NotNull MapCodec<? extends class_2794> method_28506() {
    return field_24773;
  }

  @Override
  public void method_12110(
      class_3233 region, class_5138 structures, class_7138 noiseConfig, class_2791 chunk) {
    /* skip worldgen */
  }

  @Override
  public CompletableFuture<class_2791> method_12088(
      class_6748 blender, class_7138 noiseConfig, class_5138 structureAccessor, class_2791 chunk) {
    return CompletableFuture.completedFuture(chunk);
  }

  @Override
  public void method_12102(
      class_5281 world, class_2791 chunk, class_5138 structureAccessor) {
    /* skip feature/structure gen */
  }

  @Override
  public void method_12107(class_3233 region) {
    /* skip entity gen in void */
  }

  public int getBaseHeightInEquivalentNoiseWorld(
      int x, int z, class_2902.class_2903 heightmap, class_5281 world) {
    var randomState =
        class_7138.method_41556(
            method_41541().comp_349(),
            world.method_30349().method_30530(class_7924.field_41244),
            world.method_8412());
    return super.method_16397(x, z, heightmap, world, randomState);
  }

  protected class_2960 getStructurePieceId() {
    return Skyblock.id("spawn_platform");
  }

  public void generateSpawnPlatform(
      class_3218 world,
      class_5268 worldProperties,
      boolean bonusChest,
      class_1923 chunkPos) {
    var spawnHeight = method_12100(world);
    var spawnPos = worldProperties.method_74893().method_74897().method_33096(spawnHeight);
    SpawnPlatform.generateSpawnPlatform(world, chunkPos, spawnPos, getStructurePieceId());
    worldProperties.method_187(class_12064.method_74895(world.method_27983(), spawnPos, 0.0F, 0.0F));
    if (bonusChest) spawnBonusChest(world, spawnHeight, chunkPos, world.method_8409());
  }

  private void spawnBonusChest(
      class_3218 world, int spawnHeight, class_1923 chunkPos, class_5819 random) {
    var xposz = class_156.method_43251(IntStream.range(chunkPos.method_8326(), chunkPos.method_8327()), random);
    var zposz = class_156.method_43251(IntStream.range(chunkPos.method_8328(), chunkPos.method_8329()), random);
    var blockPos = new class_2338.class_2339();

    for (var x : xposz) {
      for (var z : zposz) {
        blockPos.method_10103(x, 0, z);
        if (!isValidPosForBonusChest(world, blockPos, spawnHeight)) continue;
        if (summonBonusChestAt(
            world,
            world.method_8598(class_2902.class_2903.field_13203, blockPos),
            random)) return;
      }
    }
  }

  private boolean summonBonusChestAt(class_3218 world, class_2338 pos, class_5819 random) {
    if (!world.method_22347(pos)) return false;
    world.method_8652(pos, class_2246.field_10034.method_9564(), class_2248.field_31036);
    class_8934.method_54868(world, random, pos, class_39.field_850);
    return true;
  }

  private boolean isValidPosForBonusChest(class_3218 world, class_2338 pos, int spawnHeight) {
    return Math.abs(
            world.method_8624(class_2902.class_2903.field_13203, pos.method_10263(), pos.method_10260())
                - spawnHeight)
        < 16;
  }
}
