package org.codeberg.zenxarch.skyblock.mixin.gen;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import net.minecraft.class_1510;
import net.minecraft.class_2338;
import net.minecraft.class_2881;
import net.minecraft.class_2902;
import net.minecraft.class_3218;
import org.codeberg.zenxarch.skyblock.gen.SkyblockChunkGenerator;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_2881.class)
public abstract class EnderDragonFightMixin {
  @Shadow @Final private class_3218 world;

  @Shadow @Nullable private class_2338 exitPortalLocation;

  @Shadow private boolean dragonKilled;

  @Inject(method = "generateEndPortal", at = @At("HEAD"), cancellable = true)
  private void zenxarch$setExitPortalLocation(boolean previouslyKilled, CallbackInfo ci) {
    if (!(world.method_14178().method_12129() instanceof SkyblockChunkGenerator generator))
      return;
    if (exitPortalLocation != null) return;
    exitPortalLocation =
        class_2338.field_10980.method_33096(
            generator.getBaseHeightInEquivalentNoiseWorld(
                    0, 0, class_2902.class_2903.field_13203, world)
                - 1);
    if (!previouslyKilled) ci.cancel();
  }

  @WrapOperation(
      method = "checkDragonSeen",
      at =
          @At(
              value = "INVOKE",
              target =
                  "Lnet/minecraft/entity/boss/dragon/EnderDragonFight;createDragon()Lnet/minecraft/entity/boss/dragon/EnderDragonEntity;"))
  private class_1510 zenxarch$stopDragonSpawn(
      class_2881 instance, Operation<class_1510> original) {
    if (!(world.method_14178().method_12129() instanceof SkyblockChunkGenerator))
      return original.call(instance);
    dragonKilled = true;
    return null;
  }
}
