package org.codeberg.zenxarch.skyblock.mixin.gen;

import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_5281;
import net.minecraft.class_5444;
import org.codeberg.zenxarch.skyblock.gen.SkyblockChunkGenerator;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_5444.class)
public abstract class FeaturePlacementContextMixin {
  @Shadow @Final private class_2794 generator;

  @Shadow @Final private class_5281 world;

  @Inject(method = "getTopY", cancellable = true, at = @At(value = "HEAD"))
  private void zenxarch$useGenerationHeightmap(
      class_2902.class_2903 heightmap, int x, int z, CallbackInfoReturnable<Integer> cir) {
    if (generator instanceof SkyblockChunkGenerator chunkGenerator)
      cir.setReturnValue(
          chunkGenerator.getBaseHeightInEquivalentNoiseWorld(x, z, heightmap, world));
  }
}
