/*
 * Decompiled with CFR 0.152.
 */
package org.codeberg.zenxarch.skyblock.gen;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.class_1966;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3229;
import net.minecraft.class_3232;
import net.minecraft.class_3754;
import net.minecraft.class_5138;
import net.minecraft.class_5281;
import net.minecraft.class_5284;
import net.minecraft.class_5539;
import net.minecraft.class_6880;
import org.codeberg.zenxarch.skyblock.Skyblock;
import org.codeberg.zenxarch.skyblock.gen.SkyblockChunkGenerator;
import org.jetbrains.annotations.NotNull;

public class FlatblockChunkGenerator
extends SkyblockChunkGenerator {
    public static final MapCodec<FlatblockChunkGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1966.field_24713.fieldOf("biome_source").forGetter(class_2794::method_12098), (App)class_5284.field_24781.fieldOf("settings").forGetter(class_3754::method_41541), (App)class_3229.field_24974.listOf().fieldOf("layers").forGetter(FlatblockChunkGenerator::getLayers)).apply((Applicative)instance, instance.stable(FlatblockChunkGenerator::new)));
    private final List<class_3229> layers;
    private final List<class_2680> layerBlocks;

    public FlatblockChunkGenerator(class_1966 biomeSource, class_6880<class_5284> settings, List<class_3229> layers) {
        super(biomeSource, settings, 0);
        this.layers = layers;
        this.layerBlocks = Lists.newArrayList();
        for (class_3229 layer : layers) {
            for (int i = 0; i < layer.method_14289(); ++i) {
                this.layerBlocks.add(layer.method_14286());
            }
        }
    }

    public FlatblockChunkGenerator with(class_3232 config) {
        return new FlatblockChunkGenerator(this.method_12098(), (class_6880<class_5284>)this.method_41541(), config.method_14327());
    }

    public class_3232 fakeConfig(class_3232 config) {
        return config.method_46727(this.getLayers(), config.method_41139(), config.method_14326());
    }

    @Override
    @NotNull
    protected MapCodec<? extends class_2794> method_28506() {
        return CODEC;
    }

    @Override
    public void method_12102(class_5281 world, class_2791 chunk, class_5138 structureAccessor) {
        class_2902 oceanHeightmap = chunk.method_12032(class_2902.class_2903.field_13195);
        class_2902 surfaceHeightmap = chunk.method_12032(class_2902.class_2903.field_13194);
        int layersSize = Math.min(chunk.method_31605(), this.layerBlocks.size());
        int minY = world.method_31607();
        for (class_2338 pos : class_2338.method_10094((int)0, (int)minY, (int)0, (int)15, (int)(minY + layersSize - 1), (int)15)) {
            int idx = pos.method_10264() - minY;
            class_2680 state = this.layerBlocks.get(idx);
            chunk.method_66480(pos, state);
            oceanHeightmap.method_12597(pos.method_10263(), pos.method_10264(), pos.method_10260(), state);
            surfaceHeightmap.method_12597(pos.method_10263(), pos.method_10264(), pos.method_10260(), state);
        }
    }

    @Override
    public int method_12100(class_5539 world) {
        return world.method_31607() + Math.min(world.method_31605(), this.layerBlocks.size());
    }

    public List<class_3229> getLayers() {
        return this.layers;
    }

    @Override
    protected class_2960 getStructurePieceId() {
        return Skyblock.id("flat_platform");
    }
}

