/*
 * Decompiled with CFR 0.152.
 */
package me.fridtjof.minecarttrains.events;

import me.fridtjof.minecarttrains.MinecartTrains;
import me.fridtjof.puddingapi.bukkit.items.HopperUtils;
import org.bukkit.Material;
import org.bukkit.block.Hopper;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.inventory.Inventory;

public class OnInventoryMoveItemEvent
implements Listener {
    static MinecartTrains plugin = MinecartTrains.getInstance();
    private final String FUEL_CART_NAME;
    boolean doHopperLogic;

    public OnInventoryMoveItemEvent() {
        this.FUEL_CART_NAME = OnInventoryMoveItemEvent.plugin.configManager.mainConfig.getConfig().getString("trains.fuel.cart_name");
        this.doHopperLogic = OnInventoryMoveItemEvent.plugin.configManager.mainConfig.getConfig().getBoolean("trains.fuel.do_hopper_logic");
    }

    @EventHandler
    public void onMoveItemOutOffFuelCartEvent(InventoryMoveItemEvent event) {
        if (!this.doHopperLogic) {
            return;
        }
        if (!(event.getSource().getHolder() instanceof StorageMinecart)) {
            return;
        }
        if (!(event.getDestination().getHolder() instanceof Hopper)) {
            return;
        }
        if (this.isFuelCart((StorageMinecart)event.getSource().getHolder())) {
            event.setCancelled(true);
        }
    }

    @EventHandler
    public void onMoveItemIntoFuelCartEvent(InventoryMoveItemEvent event) {
        if (!this.doHopperLogic) {
            return;
        }
        if (!(event.getDestination().getHolder() instanceof StorageMinecart)) {
            return;
        }
        if (!(event.getSource().getHolder() instanceof Hopper)) {
            return;
        }
        if (event.getItem().getType() == Material.COAL || event.getItem().getType() == Material.CHARCOAL) {
            return;
        }
        if (this.isFuelCart((StorageMinecart)event.getDestination().getHolder())) {
            event.setCancelled(true);
            if (!HopperUtils.rearrangeHopper((Inventory)event.getSource(), (Material)Material.COAL) && !HopperUtils.rearrangeHopper((Inventory)event.getSource(), (Material)Material.CHARCOAL)) {
                return;
            }
        }
    }

    public boolean isFuelCart(StorageMinecart cart) {
        if (cart.getCustomName() == null) {
            return false;
        }
        return cart.getCustomName().equalsIgnoreCase(this.FUEL_CART_NAME);
    }
}

