/*
 * Decompiled with CFR 0.152.
 */
package me.fridtjof.minecarttrains.events;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import me.fridtjof.minecarttrains.MinecartTrains;
import me.fridtjof.minecarttrains.managers.LinkageManager;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.EquipmentSlot;

public class OnPlayerInteractEntityEvent
implements Listener {
    static MinecartTrains plugin = MinecartTrains.getInstance();
    Map<String, Integer> selectedCarts = new HashMap<String, Integer>();
    Map<String, UUID> firstCarts = new HashMap<String, UUID>();
    Map<String, UUID> secondCarts = new HashMap<String, UUID>();
    Map<String, Long> lastCouplings = new HashMap<String, Long>();
    Material couplingTool;
    double maxDistance;
    LinkageManager linkageManager;

    public OnPlayerInteractEntityEvent() {
        this.couplingTool = Material.getMaterial((String)OnPlayerInteractEntityEvent.plugin.configManager.mainConfig.getConfig().getString("trains.coupling.tool"));
        this.maxDistance = OnPlayerInteractEntityEvent.plugin.configManager.physicsConfig.getConfig().getDouble("coupling.max_distance");
        this.linkageManager = new LinkageManager();
    }

    @EventHandler
    public void onPlayerInteractEntityEvent(PlayerInteractEntityEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player player = event.getPlayer();
        String playerId = String.valueOf(player.getUniqueId());
        Material material = player.getInventory().getItemInMainHand().getType();
        Entity target = event.getRightClicked();
        if (material != this.couplingTool) {
            return;
        }
        if (!(target instanceof Minecart)) {
            return;
        }
        Minecart minecart = (Minecart)target;
        event.setCancelled(true);
        if (this.selectedCarts.get(playerId) == null) {
            this.selectedCarts.put(playerId, 1);
            this.lastCouplings.put(playerId, System.currentTimeMillis());
        } else if (this.lastCouplings.get(playerId) < System.currentTimeMillis() - 10000L) {
            this.selectedCarts.put(playerId, 1);
            this.lastCouplings.put(playerId, System.currentTimeMillis());
        }
        int selectedCart = this.selectedCarts.get(playerId);
        if (selectedCart == 1) {
            this.firstCarts.put(playerId, minecart.getUniqueId());
            this.selectedCarts.put(String.valueOf(player.getUniqueId()), 2);
            player.sendMessage(OnPlayerInteractEntityEvent.plugin.configManager.messagesFile.getConfig().getString("trains.coupling_1-2") + minecart.getName());
        } else if (selectedCart == 2) {
            this.secondCarts.put(playerId, minecart.getUniqueId());
            this.selectedCarts.put(String.valueOf(player.getUniqueId()), 1);
            player.sendMessage(OnPlayerInteractEntityEvent.plugin.configManager.messagesFile.getConfig().getString("trains.coupling_2-2") + minecart.getName());
            Entity firstCart = Bukkit.getEntity((UUID)this.firstCarts.get(playerId));
            Entity secondCart = Bukkit.getEntity((UUID)this.secondCarts.get(playerId));
            if (firstCart.getLocation().distance(secondCart.getLocation()) > this.maxDistance) {
                player.sendMessage(OnPlayerInteractEntityEvent.plugin.configManager.messagesFile.getConfig().getString("trains.coupling_failed_distance"));
                return;
            }
            if (firstCart == secondCart) {
                player.sendMessage(OnPlayerInteractEntityEvent.plugin.configManager.messagesFile.getConfig().getString("trains.coupling_failed_self"));
                return;
            }
            this.linkageManager.setLink((Minecart)secondCart, String.valueOf(this.firstCarts.get(playerId)));
            player.sendMessage(OnPlayerInteractEntityEvent.plugin.configManager.messagesFile.getConfig().getString("trains.coupling_successful"));
        }
    }
}

