/*
 * Decompiled with CFR 0.152.
 */
package me.fridtjof.minecarttrains.events;

import me.fridtjof.minecarttrains.MinecartTrains;
import org.bukkit.entity.Damageable;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.minecart.RideableMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleEntityCollisionEvent;

public class OnVehicleEntityCollisionEvent
implements Listener {
    static MinecartTrains plugin = MinecartTrains.getInstance();
    boolean runOver;
    double damage;
    double minVelocity;

    public OnVehicleEntityCollisionEvent() {
        this.runOver = OnVehicleEntityCollisionEvent.plugin.configManager.mainConfig.getConfig().getBoolean("trains.run_over.entities");
        this.damage = OnVehicleEntityCollisionEvent.plugin.configManager.mainConfig.getConfig().getDouble("trains.run_over.damage");
        this.minVelocity = OnVehicleEntityCollisionEvent.plugin.configManager.mainConfig.getConfig().getDouble("trains.run_over.min_velocity");
    }

    @EventHandler
    public void onVehicleEntityCollision(VehicleEntityCollisionEvent event) {
        if (!this.runOver) {
            return;
        }
        Vehicle vehicle = event.getVehicle();
        Entity entity = event.getEntity();
        if (!(vehicle instanceof Minecart)) {
            return;
        }
        if (entity instanceof Minecart) {
            return;
        }
        if (!(entity instanceof Damageable)) {
            return;
        }
        if (vehicle instanceof RideableMinecart && vehicle.getPassenger() == null) {
            return;
        }
        if (entity.isInsideVehicle()) {
            return;
        }
        if (vehicle.getVelocity().length() < this.minVelocity) {
            return;
        }
        Damageable damageable = (Damageable)entity;
        damageable.damage(this.damage, (Entity)vehicle);
    }
}

