/*
 * Decompiled with CFR 0.152.
 */
package me.fridtjof.minecarttrains.events;

import java.util.UUID;
import me.fridtjof.minecarttrains.MinecartTrains;
import me.fridtjof.minecarttrains.managers.LinkageManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Minecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleMoveEvent;

public class OnVehicleMoveEvent
implements Listener {
    static MinecartTrains plugin = MinecartTrains.getInstance();
    LinkageManager linkageManager;
    double defaultSpeed;
    boolean doHighSpeed;
    Material highSpeedBlock;
    double maxHighSpeedSpeed;
    double acceleration;

    public OnVehicleMoveEvent() {
        this.linkageManager = OnVehicleMoveEvent.plugin.linkageManager;
        this.defaultSpeed = 0.4;
        this.doHighSpeed = OnVehicleMoveEvent.plugin.configManager.mainConfig.getConfig().getBoolean("tracks.high_speed_tracks.enable");
        this.highSpeedBlock = Material.getMaterial((String)OnVehicleMoveEvent.plugin.configManager.mainConfig.getConfig().getString("tracks.high_speed_tracks.bed_block"));
        this.maxHighSpeedSpeed = OnVehicleMoveEvent.plugin.configManager.physicsConfig.getConfig().getDouble("track.high_speed.max_speed");
        this.acceleration = OnVehicleMoveEvent.plugin.configManager.physicsConfig.getConfig().getDouble("track.high_speed.acceleration");
    }

    @EventHandler
    public void onVehicleMove(VehicleMoveEvent event) {
        if (!this.doHighSpeed) {
            return;
        }
        if (!(event.getVehicle() instanceof Minecart)) {
            return;
        }
        Minecart minecart = (Minecart)event.getVehicle();
        World world = minecart.getWorld();
        Location location = minecart.getLocation();
        if (this.linkageManager.hasLink(minecart)) {
            Minecart parent = (Minecart)Bukkit.getEntity((UUID)this.linkageManager.getLinkUniqueId(minecart));
            minecart.setMaxSpeed(parent.getMaxSpeed());
            return;
        }
        Block track = world.getBlockAt(location);
        Block bed = world.getBlockAt(location.add(0.0, -1.0, 0.0));
        if (track.getType() != Material.POWERED_RAIL) {
            return;
        }
        if (bed.getType() != this.highSpeedBlock) {
            minecart.setMaxSpeed(this.defaultSpeed);
            return;
        }
        double currentMaxSpeed = minecart.getMaxSpeed();
        if (currentMaxSpeed < this.maxHighSpeedSpeed) {
            minecart.setMaxSpeed(currentMaxSpeed + this.acceleration);
        }
        if (currentMaxSpeed > this.maxHighSpeedSpeed) {
            minecart.setMaxSpeed(this.maxHighSpeedSpeed);
        }
    }
}

