/*
 * Decompiled with CFR 0.152.
 */
package me.fridtjof.minecarttrains.events;

import java.util.UUID;
import me.fridtjof.minecarttrains.MinecartTrains;
import me.fridtjof.minecarttrains.managers.LinkageManager;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.type.RedstoneRail;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Minecart;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.minecart.PoweredMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleUpdateEvent;
import org.bukkit.util.Vector;

public class OnVehicleUpdateEvent
implements Listener {
    static MinecartTrains plugin = MinecartTrains.getInstance();
    LinkageManager linkageManager;
    int fuelPerTick;
    double maxDistance;
    double minDistance;
    double couplingPullSpeedLowSpeed;
    double couplingPushSpeedLowSpeed;
    double aimedDistanceLowSpeed;
    double aimedDistanceToleranceLowSpeed;
    double couplingPullSpeedHighSpeed;
    double couplingPushSpeedHighSpeed;
    double aimedDistanceHighSpeed;
    double aimedDistanceToleranceHighSpeed;
    double highSpeedGate;

    public OnVehicleUpdateEvent() {
        this.linkageManager = OnVehicleUpdateEvent.plugin.linkageManager;
        this.fuelPerTick = OnVehicleUpdateEvent.plugin.configManager.mainConfig.getConfig().getInt("trains.fuel.consumption_per_tick");
        this.maxDistance = OnVehicleUpdateEvent.plugin.configManager.physicsConfig.getConfig().getDouble("link.distance.max");
        this.minDistance = OnVehicleUpdateEvent.plugin.configManager.physicsConfig.getConfig().getDouble("link.distance.min");
        this.couplingPullSpeedLowSpeed = OnVehicleUpdateEvent.plugin.configManager.physicsConfig.getConfig().getDouble("link.low_speed.speed.pull");
        this.couplingPushSpeedLowSpeed = OnVehicleUpdateEvent.plugin.configManager.physicsConfig.getConfig().getDouble("link.low_speed.speed.push");
        this.aimedDistanceLowSpeed = OnVehicleUpdateEvent.plugin.configManager.physicsConfig.getConfig().getDouble("link.low_speed.distance.aimed");
        this.aimedDistanceToleranceLowSpeed = OnVehicleUpdateEvent.plugin.configManager.physicsConfig.getConfig().getDouble("link.low_speed.distance.aimed_tolerance");
        this.couplingPullSpeedHighSpeed = OnVehicleUpdateEvent.plugin.configManager.physicsConfig.getConfig().getDouble("link.high_speed.speed.pull");
        this.couplingPushSpeedHighSpeed = OnVehicleUpdateEvent.plugin.configManager.physicsConfig.getConfig().getDouble("link.high_speed.speed.push");
        this.aimedDistanceHighSpeed = OnVehicleUpdateEvent.plugin.configManager.physicsConfig.getConfig().getDouble("link.high_speed.distance.aimed");
        this.aimedDistanceToleranceHighSpeed = OnVehicleUpdateEvent.plugin.configManager.physicsConfig.getConfig().getDouble("link.high_speed.distance.aimed_tolerance");
        this.highSpeedGate = OnVehicleUpdateEvent.plugin.configManager.physicsConfig.getConfig().getDouble("link.high_speed.gate_speed");
    }

    @EventHandler
    public void onVehicleUpdate(VehicleUpdateEvent event) {
        double aimedDistanceTolerance;
        double aimedDistance;
        double pullSpeed;
        World parentWorld;
        Vehicle vehicle = event.getVehicle();
        if (!(vehicle instanceof Minecart)) {
            return;
        }
        Minecart minecart = (Minecart)vehicle;
        if (!this.linkageManager.hasLink(minecart)) {
            if (!(minecart instanceof PoweredMinecart)) {
                return;
            }
            PoweredMinecart poweredCart = (PoweredMinecart)minecart;
            int fuelAfterConsumption = poweredCart.getFuel() - this.fuelPerTick + 1;
            if (fuelAfterConsumption < 0) {
                fuelAfterConsumption = 0;
            }
            poweredCart.setFuel(fuelAfterConsumption);
            Block block = poweredCart.getLocation().getBlock();
            if (block.getType() != Material.POWERED_RAIL) {
                return;
            }
            RedstoneRail redstoneRail = (RedstoneRail)block.getBlockData();
            if (redstoneRail.isPowered()) {
                return;
            }
            poweredCart.setVelocity(new Vector(0, 0, 0));
            poweredCart.setFuel(poweredCart.getFuel() + this.fuelPerTick);
            return;
        }
        Entity parent = Bukkit.getEntity((UUID)this.linkageManager.getLinkUniqueId(minecart));
        if (parent == null) {
            this.linkageManager.removeLink(minecart);
            return;
        }
        if (parent == minecart) {
            plugin.getLogger().warning(OnVehicleUpdateEvent.plugin.configManager.mainConfig.getConfig().getString("trains.coupling_already_coupled_with_itself"));
            this.linkageManager.removeLink(minecart);
            return;
        }
        World childWorld = minecart.getWorld();
        if (childWorld != (parentWorld = parent.getWorld())) {
            this.linkageManager.removeLink(minecart);
            return;
        }
        Location minecartLocation = minecart.getLocation();
        Material parentTrack = parentWorld.getBlockAt(parent.getLocation()).getType();
        Material parentTrackOnHill = parentWorld.getBlockAt(parent.getLocation().add(0.0, -1.0, 0.0)).getType();
        if (!this.isAnyKindOfTrack(parentTrack) && !this.isAnyKindOfTrack(parentTrackOnHill)) {
            this.linkageManager.removeLink(minecart);
            return;
        }
        double distance = minecart.getLocation().distance(parent.getLocation());
        if (parent.getVelocity().length() <= this.highSpeedGate) {
            pullSpeed = this.couplingPullSpeedLowSpeed;
            aimedDistance = this.aimedDistanceLowSpeed;
            aimedDistanceTolerance = this.aimedDistanceToleranceLowSpeed;
        } else {
            pullSpeed = this.couplingPullSpeedHighSpeed;
            aimedDistance = this.aimedDistanceHighSpeed;
            aimedDistanceTolerance = this.aimedDistanceToleranceHighSpeed;
        }
        double pushSpeed = minecart.getVelocity().length() <= this.highSpeedGate ? this.couplingPushSpeedLowSpeed : this.couplingPushSpeedHighSpeed;
        if (distance > this.maxDistance || distance < this.minDistance) {
            this.linkageManager.removeLink(minecart);
            minecart.setVelocity(new Vector(0, 0, 0));
            parent.setVelocity(new Vector(0, 0, 0));
        } else if (distance < aimedDistance - aimedDistanceTolerance) {
            this.moveToward((Entity)minecart, parent, pushSpeed, distance - aimedDistance);
        } else if (distance > aimedDistance + aimedDistanceTolerance) {
            this.moveToward((Entity)minecart, parent, pullSpeed, distance - aimedDistance);
        }
    }

    public void moveToward(Entity child, Entity parent, double speed, double distance) {
        Location childLoc = child.getLocation();
        Location parentLoc = parent.getLocation();
        double x = childLoc.getX() - parentLoc.getX();
        double y = childLoc.getY() - parentLoc.getY();
        double z = childLoc.getZ() - parentLoc.getZ();
        Vector velocity = new Vector(x, y, z).normalize().multiply(-speed);
        child.setVelocity(velocity.multiply(distance * distance * distance));
    }

    public boolean isAnyKindOfTrack(Material material) {
        if (material == Material.POWERED_RAIL) {
            return true;
        }
        if (material == Material.RAIL) {
            return true;
        }
        if (material == Material.ACTIVATOR_RAIL) {
            return true;
        }
        return material == Material.DETECTOR_RAIL;
    }
}

