/*
 * Decompiled with CFR 0.152.
 */
package me.fridtjof.minecarttrains.events;

import java.util.List;
import me.fridtjof.minecarttrains.MinecartTrains;
import me.fridtjof.minecarttrains.managers.LinkageManager;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Vehicle;
import org.bukkit.entity.minecart.PoweredMinecart;
import org.bukkit.entity.minecart.StorageMinecart;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.vehicle.VehicleUpdateEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;

public class OnVehicleUpdateEventLowestPriority
implements Listener {
    static MinecartTrains plugin = MinecartTrains.getInstance();
    LinkageManager linkageManager = new LinkageManager();
    private final int FUEL_PER_TICK;
    private final boolean REFILL_ONLY_FROM_TENDER;
    private final String FUEL_CART_NAME;

    public OnVehicleUpdateEventLowestPriority() {
        this.FUEL_PER_TICK = OnVehicleUpdateEventLowestPriority.plugin.configManager.mainConfig.getConfig().getInt("trains.fuel.consumption_per_tick");
        this.REFILL_ONLY_FROM_TENDER = OnVehicleUpdateEventLowestPriority.plugin.configManager.mainConfig.getConfig().getBoolean("trains.fuel.refill_only_from_fuel_cart");
        this.FUEL_CART_NAME = OnVehicleUpdateEventLowestPriority.plugin.configManager.mainConfig.getConfig().getString("trains.fuel.cart_name");
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void OnFuelEmptyEvent(VehicleUpdateEvent event) {
        Vehicle vehicle = event.getVehicle();
        if (!(vehicle instanceof PoweredMinecart)) {
            return;
        }
        PoweredMinecart cart = (PoweredMinecart)vehicle;
        if (cart.getFuel() < 2 || cart.getFuel() > this.FUEL_PER_TICK + 1) {
            return;
        }
        List cartsInRange = vehicle.getNearbyEntities(3.0, 3.0, 3.0);
        for (Entity entity : cartsInRange) {
            if (!(entity instanceof StorageMinecart) || this.REFILL_ONLY_FROM_TENDER && !this.isCartTender((StorageMinecart)entity)) continue;
            Inventory inventory = ((StorageMinecart)entity).getInventory();
            if (inventory.contains(Material.COAL)) {
                inventory.removeItem(new ItemStack[]{new ItemStack(Material.COAL, 1)});
                cart.setFuel(cart.getFuel() + 3600);
                return;
            }
            if (!inventory.contains(Material.CHARCOAL)) continue;
            inventory.removeItem(new ItemStack[]{new ItemStack(Material.CHARCOAL, 1)});
            cart.setFuel(cart.getFuel() + 3600);
            return;
        }
    }

    private boolean isCartTender(StorageMinecart cart) {
        if (cart.getCustomName() == null) {
            return false;
        }
        return cart.getCustomName().equalsIgnoreCase(this.FUEL_CART_NAME);
    }
}

