/*
 * Decompiled with CFR 0.152.
 */
package me.fridtjof.minecarttrains.managers;

import java.io.File;
import java.util.Collections;
import me.fridtjof.puddingapi.bukkit.utils.Logger;
import me.fridtjof.puddingapi.bukkit.utils.YamlConfig;
import org.bukkit.Material;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigManager {
    JavaPlugin plugin;
    private Logger logger;
    public YamlConfig mainConfig;
    public YamlConfig physicsConfig;
    public YamlConfig messagesFile;
    public static int mainConfigVersion = 4;
    public static int physicsConfigVersion = 4;
    public static String versionStringName = "config_version";

    public ConfigManager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.logger = new Logger(plugin);
        this.setupConfigs();
        this.checkConfigVersions();
        this.setupConfigs();
        this.reloadConfigs();
    }

    private void setupConfigs() {
        this.mainConfig = new YamlConfig(this.plugin.getDataFolder(), "config");
        this.physicsConfig = new YamlConfig(this.plugin.getDataFolder(), "physics");
        this.messagesFile = new YamlConfig(this.plugin.getDataFolder(), "messages");
    }

    private void checkConfigVersions() {
        this.checkConfigVersion(this.mainConfig, versionStringName, mainConfigVersion);
        this.checkConfigVersion(this.physicsConfig, versionStringName, physicsConfigVersion);
    }

    private void checkConfigVersion(YamlConfig config, String versionStringName, int wantedVersion) {
        if (!config.getConfig().contains(versionStringName)) {
            return;
        }
        if (config.getConfig().getInt(versionStringName) == wantedVersion) {
            return;
        }
        String filePath = config.getFile().getAbsolutePath();
        File renamedFile = new File(filePath + "_backup");
        int backupCount = 0;
        while (renamedFile.exists()) {
            renamedFile = new File(filePath + "_backup_" + ++backupCount);
        }
        config.getFile().renameTo(renamedFile);
        this.logger.warn("The old " + config.getName() + " was replaced by a new version of the default file due to an update");
    }

    private void reloadConfigs() {
        this.loadMainConfig();
        this.loadPhysicsConfig();
        this.loadMessagesFile();
    }

    private void loadMainConfig() {
        this.mainConfig.getConfig().options().setHeader(Collections.singletonList("This is the main configuration file"));
        this.mainConfig.getConfig().addDefault(versionStringName, (Object)mainConfigVersion);
        this.mainConfig.getConfig().addDefault("trains.run_over.entities", (Object)true);
        this.mainConfig.getConfig().addDefault("trains.run_over.min_velocity", (Object)1.8);
        this.mainConfig.getConfig().addDefault("trains.run_over.damage", (Object)10000);
        this.mainConfig.getConfig().addDefault("trains.coupling.tool", (Object)Material.CHAIN.toString());
        this.mainConfig.getConfig().addDefault("trains.can_get_hit_by_arrows", (Object)false);
        this.mainConfig.getConfig().addDefault("trains.fuel.consumption_per_tick", (Object)1);
        this.mainConfig.getConfig().addDefault("trains.fuel.refill_only_from_fuel_cart", (Object)true);
        this.mainConfig.getConfig().addDefault("trains.fuel.cart_name", (Object)"Coal Cart");
        this.mainConfig.getConfig().addDefault("trains.fuel.do_hopper_logic", (Object)true);
        this.mainConfig.getConfig().addDefault("tracks.high_speed_tracks.enable", (Object)true);
        this.mainConfig.getConfig().addDefault("tracks.high_speed_tracks.bed_block", (Object)Material.REDSTONE_BLOCK.toString());
        this.mainConfig.getConfig().options().copyDefaults(true);
        this.mainConfig.save();
        this.logger.info("Successfully (re)loaded config.yml");
    }

    private void loadPhysicsConfig() {
        this.physicsConfig.getConfig().options().setHeader(Collections.singletonList("This is the physics configuration file - Handle with care! - Default values by @Wallaceman105"));
        this.physicsConfig.getConfig().addDefault(versionStringName, (Object)physicsConfigVersion);
        this.physicsConfig.getConfig().addDefault("coupling.max_distance", (Object)3.5);
        this.physicsConfig.getConfig().addDefault("link.distance.max", (Object)9.5);
        this.physicsConfig.getConfig().addDefault("link.distance.min", (Object)0.7);
        this.physicsConfig.getConfig().addDefault("link.low_speed.speed.pull", (Object)1);
        this.physicsConfig.getConfig().addDefault("link.low_speed.speed.push", (Object)32);
        this.physicsConfig.getConfig().addDefault("link.low_speed.distance.aimed", (Object)1.3);
        this.physicsConfig.getConfig().addDefault("link.low_speed.distance.aimed_tolerance", (Object)0.001);
        this.physicsConfig.getConfig().addDefault("link.high_speed.speed.pull", (Object)4);
        this.physicsConfig.getConfig().addDefault("link.high_speed.speed.push", (Object)4);
        this.physicsConfig.getConfig().addDefault("link.high_speed.distance.aimed", (Object)1.5);
        this.physicsConfig.getConfig().addDefault("link.high_speed.distance.aimed_tolerance", (Object)0.001);
        this.physicsConfig.getConfig().addDefault("link.high_speed.gate_speed", (Object)1.5);
        this.physicsConfig.getConfig().addDefault("track.high_speed.max_speed", (Object)4);
        this.physicsConfig.getConfig().addDefault("track.high_speed.acceleration", (Object)0.008);
        this.physicsConfig.getConfig().options().copyDefaults(true);
        this.physicsConfig.save();
        this.logger.info("Successfully (re)loaded physics.yml");
    }

    private void loadMessagesFile() {
        this.messagesFile.getConfig().options().header("This is the localization file.");
        this.messagesFile.getConfig().addDefault("trains.coupling_successful", (Object)"Coupling successful!");
        this.messagesFile.getConfig().addDefault("trains.coupling_failed_distance", (Object)"Coupling failed! - The minecarts are too far apart!");
        this.messagesFile.getConfig().addDefault("trains.coupling_failed_self", (Object)"Coupling failed! - Can't be coupled with itself!");
        this.messagesFile.getConfig().addDefault("trains.coupling_already_coupled_with_itself", (Object)"Minecart is coupled with itself! - this shouldn't be possible!");
        this.messagesFile.getConfig().addDefault("trains.coupling_1-2", (Object)"Coupling (1/2) activated for ");
        this.messagesFile.getConfig().addDefault("trains.coupling_2-2", (Object)"Coupling (2/2) activated for ");
        this.messagesFile.getConfig().options().copyDefaults(true);
        this.messagesFile.save();
        this.logger.info("Successfully (re)loaded messages.yml");
    }
}

