/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.dyemobdye.handler;

import com.mrbysco.dyemobdye.AttachmentHandler;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.sheep.Sheep;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class InteractionHandler {
    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Level level = event.getLevel();
        Player player = event.getEntity();
        ItemStack stack = event.getItemStack();
        Entity entity = event.getTarget();
        Item item = event.getItemStack().getItem();
        if (item instanceof DyeItem) {
            DyeItem dyeItem = (DyeItem)item;
            if (!level.isClientSide() && entity.isAlive()) {
                DyeColor mobColor;
                DyeColor dyeColor = dyeItem.getDyeColor();
                if (!(entity instanceof Sheep) && (mobColor = (DyeColor)entity.getData(AttachmentHandler.COLOR)) != dyeColor) {
                    Cat cat;
                    Wolf wolf;
                    level.playSound((Entity)player, entity, SoundEvents.DYE_USE, SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (entity instanceof Wolf && (wolf = (Wolf)entity).isOwnedBy((LivingEntity)player) && wolf.getCollarColor() != dyeColor) {
                        wolf.setCollarColor(dyeColor);
                    }
                    if (entity instanceof Cat && (cat = (Cat)entity).isOwnedBy((LivingEntity)player) && cat.getCollarColor() != dyeColor) {
                        cat.setCollarColor(dyeColor);
                    }
                    entity.setData(AttachmentHandler.COLOR, (Object)dyeColor);
                    entity.syncData(AttachmentHandler.COLOR);
                    if (!player.getAbilities().instabuild) {
                        stack.shrink(1);
                    }
                    event.setCancellationResult((InteractionResult)InteractionResult.SUCCESS_SERVER);
                }
            }
        }
    }
}

