/*
 * Decompiled with CFR 0.152.
 */
package net.luckyowlstudios.locksmith.block.chest;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import it.unimi.dsi.fastutil.floats.Float2FloatFunction;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import net.luckyowlstudios.locksmith.init.ModBlocks;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.BrightnessCombiner;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.client.resources.model.Material;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.DoubleBlockCombiner;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.LidBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;

public abstract class DyeableChestRenderer
extends ChestRenderer<ChestBlockEntity> {
    protected final ModelPart chest;
    protected final ModelPart left;
    protected final ModelPart right;

    public DyeableChestRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
        this.chest = context.bakeLayer(ModelLayers.CHEST);
        this.left = context.bakeLayer(ModelLayers.DOUBLE_CHEST_LEFT);
        this.right = context.bakeLayer(ModelLayers.DOUBLE_CHEST_RIGHT);
    }

    protected abstract DyedItemColor defaultColor();

    public void render(ChestBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        super.render((BlockEntity)blockEntity, partialTick, poseStack, bufferSource, packedLight, packedOverlay);
        DyedItemColor dyedComponent = (DyedItemColor)blockEntity.components().getOrDefault(DataComponents.DYED_COLOR, (Object)this.defaultColor());
        int color = dyedComponent.rgb();
        Level level = blockEntity.getLevel();
        boolean flag = level != null;
        BlockState blockstate = flag ? blockEntity.getBlockState() : (BlockState)Blocks.CHEST.defaultBlockState().setValue((Property)ChestBlock.FACING, (Comparable)Direction.SOUTH);
        ChestType chesttype = blockstate.hasProperty((Property)ChestBlock.TYPE) ? (ChestType)blockstate.getValue((Property)ChestBlock.TYPE) : ChestType.SINGLE;
        Block var12 = blockstate.getBlock();
        if (var12 instanceof AbstractChestBlock) {
            AbstractChestBlock abstractchestblock = (AbstractChestBlock)var12;
            boolean flag1 = chesttype != ChestType.SINGLE;
            poseStack.pushPose();
            float f = ((Direction)blockstate.getValue((Property)ChestBlock.FACING)).toYRot();
            poseStack.translate(0.5f, 0.5f, 0.5f);
            poseStack.mulPose(Axis.YP.rotationDegrees(-f));
            poseStack.translate(-0.5f, -0.5f, -0.5f);
            DoubleBlockCombiner.NeighborCombineResult neighborcombineresult = flag ? abstractchestblock.combine(blockstate, level, blockEntity.getBlockPos(), true) : DoubleBlockCombiner.Combiner::acceptNone;
            float f1 = ((Float2FloatFunction)neighborcombineresult.apply(ChestBlock.opennessCombiner((LidBlockEntity)blockEntity))).get(partialTick);
            f1 = 1.0f - f1;
            f1 = 1.0f - f1 * f1 * f1;
            int i = ((Int2IntFunction)neighborcombineresult.apply((DoubleBlockCombiner.Combiner)new BrightnessCombiner())).applyAsInt(packedLight);
            Material existingMaterial = this.getMaterial(blockEntity, chesttype);
            ResourceLocation dyeOverlay = switch (chesttype) {
                default -> throw new MatchException(null, null);
                case ChestType.LEFT -> ResourceLocation.fromNamespaceAndPath((String)"locksmith", (String)"entity/chest/dye_left");
                case ChestType.RIGHT -> ResourceLocation.fromNamespaceAndPath((String)"locksmith", (String)"entity/chest/dye_right");
                case ChestType.SINGLE -> ResourceLocation.fromNamespaceAndPath((String)"locksmith", (String)"entity/chest/dye");
            };
            Material dyeMaterial = new Material(existingMaterial.atlasLocation(), dyeOverlay);
            VertexConsumer vertexconsumer = dyeMaterial.buffer(bufferSource, RenderType::entityCutout);
            if (flag1) {
                if (chesttype == ChestType.LEFT) {
                    this.render(poseStack, vertexconsumer, this.left.getChild("lid"), this.left.getChild("lock"), this.left.getChild("bottom"), f1, i, packedOverlay, color);
                } else {
                    this.render(poseStack, vertexconsumer, this.right.getChild("lid"), this.right.getChild("lock"), this.right.getChild("bottom"), f1, i, packedOverlay, color);
                }
            } else {
                this.render(poseStack, vertexconsumer, this.chest.getChild("lid"), this.chest.getChild("lock"), this.chest.getChild("bottom"), f1, i, packedOverlay, color);
            }
            poseStack.popPose();
        }
    }

    private void render(PoseStack poseStack, VertexConsumer consumer, ModelPart lidPart, ModelPart lockPart, ModelPart bottomPart, float lidAngle, int packedLight, int packedOverlay, int color) {
        lockPart.xRot = lidPart.xRot = -(lidAngle * 1.5707964f);
        lidPart.render(poseStack, consumer, packedLight, packedOverlay, color);
        lockPart.render(poseStack, consumer, packedLight, packedOverlay, color);
        bottomPart.render(poseStack, consumer, packedLight, packedOverlay, color);
    }

    protected Material getMaterial(ChestBlockEntity blockEntity, ChestType chestType) {
        if (blockEntity.getBlockState().getBlock() == ModBlocks.IRON_CHEST.get()) {
            return switch (chestType) {
                default -> throw new MatchException(null, null);
                case ChestType.LEFT -> new Material(Sheets.CHEST_SHEET, ResourceLocation.fromNamespaceAndPath((String)"locksmith", (String)"entity/chest/iron_left"));
                case ChestType.RIGHT -> new Material(Sheets.CHEST_SHEET, ResourceLocation.fromNamespaceAndPath((String)"locksmith", (String)"entity/chest/iron_right"));
                case ChestType.SINGLE -> new Material(Sheets.CHEST_SHEET, ResourceLocation.fromNamespaceAndPath((String)"locksmith", (String)"entity/chest/iron"));
            };
        }
        return switch (chestType) {
            default -> throw new MatchException(null, null);
            case ChestType.LEFT -> new Material(Sheets.CHEST_SHEET, ResourceLocation.fromNamespaceAndPath((String)"locksmith", (String)"entity/chest/golden_left"));
            case ChestType.RIGHT -> new Material(Sheets.CHEST_SHEET, ResourceLocation.fromNamespaceAndPath((String)"locksmith", (String)"entity/chest/golden_right"));
            case ChestType.SINGLE -> new Material(Sheets.CHEST_SHEET, ResourceLocation.fromNamespaceAndPath((String)"locksmith", (String)"entity/chest/golden"));
        };
    }
}

