/*
 * Decompiled with CFR 0.152.
 */
package net.luckyowlstudios.locksmith.init;

import java.util.function.Supplier;
import net.luckyowlstudios.locksmith.block.chest.gold.GoldenChestBlock;
import net.luckyowlstudios.locksmith.block.chest.gold_trapped.GoldenTrappedChestBlock;
import net.luckyowlstudios.locksmith.block.chest.iron.IronChestBlock;
import net.luckyowlstudios.locksmith.block.chest.iron_trapped.IronTrappedChestBlock;
import net.luckyowlstudios.locksmith.init.ModItems;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ModBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"locksmith");
    public static final DeferredBlock<Block> IRON_CHEST = ModBlocks.registerBlock("iron_chest", () -> new IronChestBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).sound(SoundType.WOOD)));
    public static final DeferredBlock<Block> GOLDEN_CHEST = ModBlocks.registerBlock("golden_chest", () -> new GoldenChestBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GOLD_BLOCK).sound(SoundType.WOOD)));
    public static final DeferredBlock<Block> IRON_TRAPPED_CHEST = ModBlocks.registerBlock("iron_trapped_chest", () -> new IronTrappedChestBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.IRON_BLOCK).sound(SoundType.WOOD)));
    public static final DeferredBlock<Block> GOLDEN_TRAPPED_CHEST = ModBlocks.registerBlock("golden_trapped_chest", () -> new GoldenTrappedChestBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.GOLD_BLOCK).sound(SoundType.WOOD)));

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        ModBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        ModItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

