/*
 * Decompiled with CFR 0.152.
 */
package net.luckyowlstudios.locksmith.item;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.LockCode;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurioItem;

public class KeyItem
extends Item
implements ICurioItem {
    public KeyItem(Item.Properties properties) {
        super(properties.stacksTo(1));
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int slotId, boolean isSelected) {
        super.inventoryTick(stack, level, entity, slotId, isSelected);
        if (!stack.getComponents().has(DataComponents.LOCK)) {
            LockCode lockCode = KeyItem.generateRandomCode();
            stack.set(DataComponents.LOCK, (Object)lockCode);
        }
    }

    private static LockCode generateRandomCode() {
        String code = String.valueOf((int)(Math.random() * 90000.0 + 10000.0));
        return new LockCode(code);
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        LockCode lockCode = (LockCode)stack.get(DataComponents.LOCK);
        if (Screen.hasShiftDown()) {
            if (lockCode != null && !lockCode.key().isEmpty()) {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.locksmith.code", (Object[])new Object[]{lockCode.key()}).withStyle(ChatFormatting.GRAY));
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.locksmith.key_duplicate", (Object[])new Object[]{lockCode.key()}).withStyle(ChatFormatting.GRAY));
            } else {
                tooltipComponents.add((Component)Component.translatable((String)"tooltip.locksmith.no_code").withStyle(ChatFormatting.GRAY));
            }
        } else {
            tooltipComponents.add((Component)Component.translatable((String)"tooltip.locksmith.reveal_code", (Object[])new Object[]{Component.keybind((String)Minecraft.getInstance().options.keyShift.getName())}).withStyle(ChatFormatting.GRAY));
        }
    }

    public boolean canEquipFromUse(SlotContext slotContext, ItemStack stack) {
        return true;
    }
}

