/*
 * Decompiled with CFR 0.152.
 */
package net.luckyowlstudios.locksmith.mixin;

import java.util.function.Supplier;
import net.luckyowlstudios.locksmith.util.LockHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ChestBlock.class})
public abstract class ChestBlockMixin
extends AbstractChestBlock<ChestBlockEntity> {
    protected ChestBlockMixin(BlockBehaviour.Properties properties, Supplier<BlockEntityType<? extends ChestBlockEntity>> blockEntityType) {
        super(properties, blockEntityType);
    }

    @Inject(method={"updateShape"}, at={@At(value="HEAD")}, cancellable=true)
    private void locksmith$updateShapeToPreventConnectingToLockedChest(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos, CallbackInfoReturnable<BlockState> cir) {
        BlockEntity blockEntity = level.getBlockEntity(currentPos);
        if (blockEntity instanceof BaseContainerBlockEntity) {
            BaseContainerBlockEntity baseContainerBlockEntity = (BaseContainerBlockEntity)blockEntity;
            if (state.getValue((Property)ChestBlock.TYPE) == ChestType.SINGLE && LockHandler.containerHasLock(baseContainerBlockEntity)) {
                cir.setReturnValue((Object)state);
            }
        }
    }

    @Inject(method={"candidatePartnerFacing"}, at={@At(value="HEAD")}, cancellable=true)
    private void locksmith$modifyCandidatePartnerFacing(BlockPlaceContext context, Direction direction, CallbackInfoReturnable<Direction> cir) {
        BaseContainerBlockEntity baseContainerBlockEntity;
        BlockPos blockPos = context.getClickedPos().relative(direction);
        Level level = context.getLevel();
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof BaseContainerBlockEntity && LockHandler.containerHasLock(baseContainerBlockEntity = (BaseContainerBlockEntity)blockEntity)) {
            cir.setReturnValue(null);
        }
    }
}

