/*
 * Decompiled with CFR 0.152.
 */
package net.luckyowlstudios.locksmith.mixin;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.luckyowlstudios.locksmith.Locksmith;
import net.luckyowlstudios.locksmith.init.ModDataComponents;
import net.luckyowlstudios.locksmith.overrides.LockModel;
import net.luckyowlstudios.locksmith.util.LockHandler;
import net.luckyowlstudios.locksmith.util.LockType;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.ChestRenderer;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ChestRenderer.class})
public abstract class ChestRendererMixin<T extends BlockEntity>
implements BlockEntityRenderer<T> {
    @Unique
    private ModelPart locksmith$lock;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void locksmith$initRenderer(BlockEntityRendererProvider.Context context, CallbackInfo ci) {
        ModelPart modelPart = context.bakeLayer(LockModel.LAYER_LOCATION);
        this.locksmith$lock = modelPart.getChild("lock");
    }

    @Inject(method={"render(Lnet/minecraft/world/level/block/entity/BlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V"}, at={@At(value="TAIL")})
    private void locksmith$renderLock(T blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, CallbackInfo ci) {
        if (!(blockEntity instanceof ChestBlockEntity)) {
            return;
        }
        ChestBlockEntity chestBlockEntity = (ChestBlockEntity)blockEntity;
        if (LockHandler.containerHasLock((BaseContainerBlockEntity)chestBlockEntity)) {
            BlockState blockState = blockEntity.getBlockState();
            ChestType chestType = (ChestType)blockState.getValue((Property)ChestBlock.TYPE);
            if (chestType == ChestType.LEFT) {
                return;
            }
            poseStack.pushPose();
            poseStack.translate(0.5f, 1.5f, 0.5f);
            poseStack.mulPose(Axis.XP.rotationDegrees(180.0f));
            float f = ((Direction)blockEntity.getBlockState().getValue((Property)ChestBlock.FACING)).toYRot();
            poseStack.mulPose(Axis.YP.rotationDegrees(f));
            if (chestType != ChestType.SINGLE) {
                poseStack.translate(0.5f, 0.0f, 0.0f);
            }
            VertexConsumer consumer = bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)Objects.requireNonNull(ChestRendererMixin.luckys_locksmith$getTexture((BaseContainerBlockEntity)chestBlockEntity))));
            this.locksmith$lock.render(poseStack, consumer, packedLight, packedOverlay);
            poseStack.popPose();
        }
    }

    @Unique
    private static ResourceLocation luckys_locksmith$getTexture(BaseContainerBlockEntity containerBlockEntity) {
        if (containerBlockEntity.components().has((DataComponentType)ModDataComponents.LOCK_TYPE.get())) {
            LockType lockType = (LockType)((Object)containerBlockEntity.components().get((DataComponentType)ModDataComponents.LOCK_TYPE.get()));
            int n = 0;
            return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"GOLDEN", "TRIAL"}, (LockType)lockType, n)) {
                case 0 -> Locksmith.id("textures/entity/lock/chest/golden_lock.png");
                case 1 -> Locksmith.id("textures/entity/lock/chest/trial_lock.png");
                case -1 -> null;
                default -> Locksmith.id("textures/entity/lock/chest/lock.png");
            };
        }
        return Locksmith.id("textures/entity/lock/chest/lock.png");
    }
}

