/*
 * Decompiled with CFR 0.152.
 */
package net.luckyowlstudios.locksmith.overrides;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.luckyowlstudios.locksmith.Locksmith;
import net.luckyowlstudios.locksmith.init.ModDataComponents;
import net.luckyowlstudios.locksmith.util.LockHandler;
import net.luckyowlstudios.locksmith.util.LockType;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class AddBarrelRenderer<T extends BlockEntity>
implements BlockEntityRenderer<BarrelBlockEntity> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(Locksmith.id("barrel_lock"), "main");
    private final ModelPart lock;

    public AddBarrelRenderer(BlockEntityRendererProvider.Context context) {
        ModelPart modelpart = context.bakeLayer(LAYER_LOCATION);
        this.lock = modelpart.getChild("lock");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition lock = partdefinition.addOrReplaceChild("lock", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -16.0f, -8.0f, 5.0f, 16.0f, 16.0f, new CubeDeformation(0.1f)), PartPose.offset((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition cube_r1 = lock.addOrReplaceChild("cube_r1", CubeListBuilder.create().texOffs(12, 32).addBox(-2.0f, -4.0f, -9.5f, 4.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)).texOffs(0, 32).addBox(-2.5f, -2.0f, -10.0f, 5.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0f, (float)-7.0f, (float)-2.0f, (float)-1.5708f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = lock.addOrReplaceChild("cube_r2", CubeListBuilder.create().texOffs(0, 0).addBox(-2.5f, -8.0f, -8.0f, 5.0f, 16.0f, 16.0f, new CubeDeformation(0.1f)), PartPose.offsetAndRotation((float)0.0f, (float)-8.0f, (float)0.0f, (float)0.0f, (float)1.5708f, (float)0.0f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void render(BarrelBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        if (LockHandler.containerHasLock((BaseContainerBlockEntity)blockEntity)) {
            poseStack.pushPose();
            BlockState state = blockEntity.getBlockState();
            Direction facing = (Direction)state.getValue((Property)BarrelBlock.FACING);
            Direction.Axis axis = facing.getAxis();
            boolean isUpsideDown = facing == Direction.DOWN;
            poseStack.translate(0.5f, isUpsideDown ? -0.5f : 1.5f, 0.5f);
            poseStack.mulPose(Axis.XP.rotationDegrees(isUpsideDown ? 0.0f : 180.0f));
            if (axis != Direction.Axis.Y) {
                if (facing == Direction.NORTH) {
                    poseStack.mulPose(Axis.XP.rotationDegrees(-90.0f));
                    poseStack.translate(0.0f, -1.0f, 1.0f);
                } else if (facing == Direction.SOUTH) {
                    poseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
                    poseStack.translate(0.0f, -1.0f, -1.0f);
                } else if (facing == Direction.WEST) {
                    poseStack.mulPose(Axis.ZP.rotationDegrees(-90.0f));
                    poseStack.translate(-1.0f, -1.0f, 0.0f);
                } else if (facing == Direction.EAST) {
                    poseStack.mulPose(Axis.ZP.rotationDegrees(90.0f));
                    poseStack.translate(1.0f, -1.0f, 0.0f);
                }
            }
            float f = ((Direction)blockEntity.getBlockState().getValue((Property)BarrelBlock.FACING)).toYRot();
            poseStack.mulPose(Axis.YP.rotationDegrees(f));
            VertexConsumer consumer = bufferSource.getBuffer(RenderType.entityCutout((ResourceLocation)AddBarrelRenderer.getTexture((BaseContainerBlockEntity)blockEntity)));
            int light = this.getFrontLightLevel(blockEntity);
            this.lock.render(poseStack, consumer, light, packedOverlay);
            poseStack.popPose();
        }
    }

    public static ResourceLocation getTexture(BaseContainerBlockEntity containerBlockEntity) {
        if (containerBlockEntity.components().has((DataComponentType)ModDataComponents.LOCK_TYPE.get())) {
            return switch ((LockType)((Object)containerBlockEntity.components().get((DataComponentType)ModDataComponents.LOCK_TYPE.get()))) {
                case LockType.GOLDEN -> Locksmith.id("textures/entity/lock/barrel/golden_lock.png");
                case LockType.TRIAL -> Locksmith.id("textures/entity/lock/barrel/trial_lock.png");
                default -> Locksmith.id("textures/entity/lock/barrel/lock.png");
            };
        }
        return Locksmith.id("textures/entity/lock/barrel/lock.png");
    }

    private int getFrontLightLevel(BarrelBlockEntity blockEntity) {
        Level level = blockEntity.getLevel();
        if (level == null) {
            return 0xF000F0;
        }
        BlockState state = blockEntity.getBlockState();
        Direction facing = (Direction)state.getValue((Property)BarrelBlock.FACING);
        BlockPos frontPos = blockEntity.getBlockPos().relative(facing);
        BlockState frontState = level.getBlockState(frontPos);
        boolean frontOpaque = frontState.isSolidRender((BlockGetter)level, frontPos);
        BlockPos lightSamplePos = frontOpaque ? blockEntity.getBlockPos() : frontPos;
        int blockLight = level.getBrightness(LightLayer.BLOCK, lightSamplePos);
        int skyLight = level.getBrightness(LightLayer.SKY, lightSamplePos);
        return blockLight | skyLight << 20;
    }
}

