/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi;

import cn.coostack.cooparticlesapi.CooParticlesConstants;
import cn.coostack.cooparticlesapi.animation.AnimateManager;
import cn.coostack.cooparticlesapi.network.particle.emitters.ParticleEmittersManager;
import cn.coostack.cooparticlesapi.network.particle.style.ParticleStyleManager;
import cn.coostack.cooparticlesapi.particles.CooModParticles;
import cn.coostack.cooparticlesapi.particles.control.group.ClientParticleGroupManager;
import cn.coostack.cooparticlesapi.platform.CooParticlesServices;
import cn.coostack.cooparticlesapi.renderer.client.ClientRenderEntityManager;
import cn.coostack.cooparticlesapi.renderer.client.ClientRenderPipelineManager;
import cn.coostack.cooparticlesapi.renderer.client.ShaderPipeManagers;
import cn.coostack.cooparticlesapi.scheduler.CooScheduler;
import cn.coostack.cooparticlesapi.test.particle.client.BarrierSwordGroupClient;
import cn.coostack.cooparticlesapi.test.particle.client.ScaleCircleGroupClient;
import cn.coostack.cooparticlesapi.test.particle.client.SequencedMagicCircleClient;
import cn.coostack.cooparticlesapi.test.particle.client.TestGroupClient;
import cn.coostack.cooparticlesapi.test.particle.style.ExampleSequencedStyle;
import cn.coostack.cooparticlesapi.test.particle.style.ExampleStyle;
import cn.coostack.cooparticlesapi.test.particle.style.PointStyle;
import cn.coostack.cooparticlesapi.test.particle.style.RomaMagicTestStyle;
import cn.coostack.cooparticlesapi.test.particle.style.RotateTestStyle;
import cn.coostack.cooparticlesapi.test.particle.style.TestShapeUtilStyle;
import cn.coostack.cooparticlesapi.test.renderer.TestRendererEntity;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.irisshaders.iris.api.v0.IrisApi;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.TickRateManager;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u0006\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\b\u001a\u00020\tH\u0007J\b\u0010\n\u001a\u00020\u0007H\u0007J\b\u0010\u000b\u001a\u00020\tH\u0002J\b\u0010\f\u001a\u00020\tH\u0002J\b\u0010\r\u001a\u00020\tH\u0002J\b\u0010\u0010\u001a\u00020\tH\u0007J\b\u0010\u0011\u001a\u00020\tH\u0002J\u0006\u0010\u0012\u001a\u00020\tJ\u0006\u0010\u0013\u001a\u00020\tJ\u000e\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\u001cR\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u00020\u00078\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u000e\u001a\u00020\u00078\u0002@\u0002X\u0083\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000f\u0010\u0003R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001d"}, d2={"Lcn/coostack/cooparticlesapi/CooParticlesAPIClient;", "", "<init>", "()V", "scheduler", "Lcn/coostack/cooparticlesapi/scheduler/CooScheduler;", "irisLoaded", "", "init", "", "checkIrisShaderPackUsed", "initParticleType", "initGroup", "initStyle", "renderInit", "getRenderInit$annotations", "initShaderPrograms", "initRender", "onDisconnect", "afterClientWorldChange", "subTicks", "", "getSubTicks", "()D", "setSubTicks", "(D)V", "tickClient", "world", "Lnet/minecraft/client/multiplayer/ClientLevel;", "cooparticlesapi-neoforge-1.21.1"})
public final class CooParticlesAPIClient {
    @NotNull
    public static final CooParticlesAPIClient INSTANCE = new CooParticlesAPIClient();
    @JvmField
    @NotNull
    public static final CooScheduler scheduler = new CooScheduler();
    @JvmField
    public static boolean irisLoaded;
    private static boolean renderInit;
    private static double subTicks;

    private CooParticlesAPIClient() {
    }

    @JvmStatic
    public static final void init() {
        INSTANCE.initGroup();
        INSTANCE.initStyle();
        INSTANCE.initParticleType();
        INSTANCE.initRender();
        irisLoaded = CooParticlesServices.PLATFORM.isModLoaded("iris");
    }

    @JvmStatic
    public static final boolean checkIrisShaderPackUsed() {
        return irisLoaded && IrisApi.getInstance().isShaderPackInUse();
    }

    private final void initParticleType() {
        ParticleEmittersManager.INSTANCE.init$cooparticlesapi_neoforge_1_21_1();
        CooModParticles.INSTANCE.reg();
    }

    private final void initGroup() {
        ClientParticleGroupManager.INSTANCE.register(TestGroupClient.class, new TestGroupClient.Provider());
        ClientParticleGroupManager.INSTANCE.register(ScaleCircleGroupClient.class, new ScaleCircleGroupClient.Provider());
        ClientParticleGroupManager.INSTANCE.register(BarrierSwordGroupClient.class, new BarrierSwordGroupClient.Provider());
        ClientParticleGroupManager.INSTANCE.register(SequencedMagicCircleClient.class, new SequencedMagicCircleClient.Provider());
    }

    private final void initStyle() {
        ParticleStyleManager.INSTANCE.register(ExampleStyle.class, new ExampleStyle.Provider());
        ParticleStyleManager.INSTANCE.register(ExampleSequencedStyle.class, new ExampleSequencedStyle.Provider());
        ParticleStyleManager.INSTANCE.register(RomaMagicTestStyle.class, new RomaMagicTestStyle.Provider());
        ParticleStyleManager.INSTANCE.register(RotateTestStyle.class, new RotateTestStyle.Provider());
        ParticleStyleManager.INSTANCE.register(TestShapeUtilStyle.class, new TestShapeUtilStyle.Provider());
        ParticleStyleManager.INSTANCE.register(PointStyle.class, new PointStyle.Provider());
    }

    @JvmStatic
    private static /* synthetic */ void getRenderInit$annotations() {
    }

    @JvmStatic
    public static final void initShaderPrograms() {
        if (renderInit) {
            return;
        }
        renderInit = true;
        ShaderPipeManagers.INSTANCE.init();
        ClientRenderPipelineManager.INSTANCE.init();
        ClientRenderEntityManager.INSTANCE.init();
        CooParticlesConstants.logger.info("\u521d\u59cb\u5316\u6e32\u67d3\u7ba1\u7ebf");
    }

    private final void initRender() {
        ClientRenderEntityManager.INSTANCE.register(TestRendererEntity.Companion.getId(), TestRendererEntity.Companion.getCodec());
        ClientRenderEntityManager.INSTANCE.bindEntityRenderPipe(TestRendererEntity.Companion.getId(), ShaderPipeManagers.INSTANCE.getSimpleBloom().getPipeID());
    }

    public final void onDisconnect() {
        ParticleEmittersManager.INSTANCE.getClientEmitters().clear();
        ParticleStyleManager.INSTANCE.clearAllVisible();
        ClientRenderEntityManager.INSTANCE.clear();
        ClientParticleGroupManager.INSTANCE.clearAllVisible();
    }

    public final void afterClientWorldChange() {
        ParticleEmittersManager.INSTANCE.getClientEmitters().clear();
        ParticleStyleManager.INSTANCE.clearAllVisible();
        ClientParticleGroupManager.INSTANCE.clearAllVisible();
        ClientRenderEntityManager.INSTANCE.clear();
    }

    public final double getSubTicks() {
        return subTicks;
    }

    public final void setSubTicks(double d) {
        subTicks = d;
    }

    public final void tickClient(@NotNull ClientLevel world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        TickRateManager tickManager = world.tickRateManager();
        if (!tickManager.runsNormally()) {
            return;
        }
        float rate = tickManager.tickrate();
        double preInvokeTimes = (double)rate / 20.0;
        if ((subTicks += preInvokeTimes) >= 1.0) {
            int toInt = (int)subTicks;
            subTicks -= (double)toInt;
            int n = 0;
            while (n < toInt) {
                int it = n++;
                boolean bl = false;
                scheduler.doTick$cooparticlesapi_neoforge_1_21_1();
                ClientParticleGroupManager.INSTANCE.doClientTick();
                ParticleStyleManager.INSTANCE.doTickClient();
                ParticleEmittersManager.INSTANCE.doTickClient();
                AnimateManager.INSTANCE.tickClient();
                ClientRenderEntityManager.INSTANCE.tick();
            }
        }
    }
}

