/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.animation;

import cn.coostack.cooparticlesapi.animation.AnimateContext;
import cn.coostack.cooparticlesapi.animation.animate.Animate;
import java.util.Collection;
import java.util.LinkedList;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0019J\u0006\u0010&\u001a\u00020\u0000J\u0006\u0010'\u001a\u00020\u000bJ\u0006\u0010(\u001a\u00020\u0000J\u0006\u0010)\u001a\u00020\u0000J\u0006\u0010*\u001a\u00020+R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u000b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\rR\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0017\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001a\u0010!\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u0007\"\u0004\b#\u0010\t\u00a8\u0006,"}, d2={"Lcn/coostack/cooparticlesapi/animation/StreamAnimation;", "", "<init>", "()V", "time", "", "getTime", "()I", "setTime", "(I)V", "displayed", "", "getDisplayed", "()Z", "setDisplayed", "(Z)V", "value", "canceled", "getCanceled", "context", "Lcn/coostack/cooparticlesapi/animation/AnimateContext;", "getContext", "()Lcn/coostack/cooparticlesapi/animation/AnimateContext;", "animateQueue", "Ljava/util/LinkedList;", "Lcn/coostack/cooparticlesapi/animation/animate/Animate;", "getAnimateQueue", "()Ljava/util/LinkedList;", "currentAnimate", "getCurrentAnimate", "()Lcn/coostack/cooparticlesapi/animation/animate/Animate;", "setCurrentAnimate", "(Lcn/coostack/cooparticlesapi/animation/animate/Animate;)V", "displayDelay", "getDisplayDelay", "setDisplayDelay", "addAnimate", "animate", "next", "hasNext", "cancel", "display", "tick", "", "cooparticlesapi-neoforge-1.21.1"})
public final class StreamAnimation {
    private int time;
    private boolean displayed;
    private boolean canceled;
    @NotNull
    private final AnimateContext context = new AnimateContext(this);
    @NotNull
    private final LinkedList<Animate> animateQueue = new LinkedList();
    @Nullable
    private Animate currentAnimate;
    private int displayDelay;

    public final int getTime() {
        return this.time;
    }

    public final void setTime(int n) {
        this.time = n;
    }

    public final boolean getDisplayed() {
        return this.displayed;
    }

    public final void setDisplayed(boolean bl) {
        this.displayed = bl;
    }

    public final boolean getCanceled() {
        return this.canceled;
    }

    @NotNull
    public final AnimateContext getContext() {
        return this.context;
    }

    @NotNull
    public final LinkedList<Animate> getAnimateQueue() {
        return this.animateQueue;
    }

    @Nullable
    public final Animate getCurrentAnimate() {
        return this.currentAnimate;
    }

    public final void setCurrentAnimate(@Nullable Animate animate) {
        this.currentAnimate = animate;
    }

    public final int getDisplayDelay() {
        return this.displayDelay;
    }

    public final void setDisplayDelay(int n) {
        this.displayDelay = n;
    }

    @NotNull
    public final StreamAnimation addAnimate(@NotNull Animate animate) {
        Intrinsics.checkNotNullParameter((Object)animate, (String)"animate");
        this.animateQueue.addLast(animate);
        return this;
    }

    @NotNull
    public final StreamAnimation next() {
        if (!this.hasNext()) {
            return this;
        }
        if (this.currentAnimate != null) {
            Animate animate = this.currentAnimate;
            Intrinsics.checkNotNull((Object)animate);
            boolean normalOver = animate.getOver();
            if (normalOver) {
                Animate animate2 = this.currentAnimate;
                Intrinsics.checkNotNull((Object)animate2);
                if (animate2.getDisplayed()) {
                    Animate animate3 = this.currentAnimate;
                    Intrinsics.checkNotNull((Object)animate3);
                    if (!animate3.getCanceled()) {
                        Animate animate4 = this.currentAnimate;
                        Intrinsics.checkNotNull((Object)animate4);
                        animate4.cancel(this.context);
                    }
                }
            }
        }
        Animate animate = this.currentAnimate = this.animateQueue.poll();
        Intrinsics.checkNotNull((Object)animate);
        animate.beforeStart(this.context);
        return this;
    }

    public final boolean hasNext() {
        return !((Collection)this.animateQueue).isEmpty();
    }

    @NotNull
    public final StreamAnimation cancel() {
        if (!this.displayed) {
            return this;
        }
        if (this.canceled) {
            return this;
        }
        this.canceled = true;
        Animate animate = this.currentAnimate;
        if (animate == null) {
            return this;
        }
        Animate current = animate;
        if (!current.getDisplayed() || current.getOver()) {
            return this;
        }
        current.cancel(this.context);
        return this;
    }

    @NotNull
    public final StreamAnimation display() {
        if (this.displayed) {
            return this;
        }
        this.displayed = true;
        this.displayDelay = 0;
        return this;
    }

    public final void tick() {
        if (!this.displayed) {
            return;
        }
        if (this.canceled) {
            return;
        }
        int n = this.time;
        this.time = n + 1;
        if (this.hasNext() && this.currentAnimate == null) {
            this.next();
        }
        Animate animate = this.currentAnimate;
        if (animate == null) {
            return;
        }
        Animate currentAnimate = animate;
        int n2 = this.displayDelay;
        this.displayDelay = n2 + -1;
        if (n2 <= 0 && !currentAnimate.getDisplayed()) {
            currentAnimate.display(this.context);
        }
        if (currentAnimate.getDisplayed() && !currentAnimate.getOver() && !currentAnimate.getCanceled()) {
            currentAnimate.onTick(this.context);
        }
        if (currentAnimate.isFinished(this.context)) {
            currentAnimate.over(this.context);
            this.currentAnimate = null;
            this.next();
        }
    }
}

