/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.barrages;

import cn.coostack.cooparticlesapi.barrages.Barrage;
import cn.coostack.cooparticlesapi.barrages.BarrageHitResult;
import cn.coostack.cooparticlesapi.barrages.BarrageManager;
import cn.coostack.cooparticlesapi.barrages.BarrageOption;
import cn.coostack.cooparticlesapi.barrages.HitBox;
import cn.coostack.cooparticlesapi.network.particle.ServerControler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B3\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\u0010\b\u001a\u0006\u0012\u0002\b\u00030\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u00108\u001a\u00020&2\u0006\u00109\u001a\u00020\u001dH&J\u0010\u0010:\u001a\u00020&2\u0006\u0010;\u001a\u00020\u0001H\u0016J\b\u0010<\u001a\u00020=H\u0016J\u0010\u0010>\u001a\u00020=2\u0006\u0010?\u001a\u00020@H\u0016J\u0006\u0010A\u001a\u00020=J\b\u0010B\u001a\u00020&H\u0016J\f\u0010C\u001a\b\u0012\u0004\u0012\u00020\u001d0DJ\u001a\u0010C\u001a\b\u0012\u0004\u0012\u00020\u001d0D2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020\u001d0FR\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0006\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0018\u0010\b\u001a\u0006\u0012\u0002\b\u00030\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\n\u001a\u00020\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u001c\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u000f\"\u0004\b$\u0010\u0011R\u001a\u0010%\u001a\u00020&X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u000e\u0010+\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010-\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010.\u001a\u00020&X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010(\"\u0004\b0\u0010*R\u0014\u00101\u001a\u00020&8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u0010(R\u000e\u00103\u001a\u00020,X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u00104\u001a\u000205X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107\u00a8\u0006G"}, d2={"Lcn/coostack/cooparticlesapi/barrages/AbstractBarrage;", "Lcn/coostack/cooparticlesapi/barrages/Barrage;", "loc", "Lnet/minecraft/world/phys/Vec3;", "world", "Lnet/minecraft/server/level/ServerLevel;", "hitBox", "Lcn/coostack/cooparticlesapi/barrages/HitBox;", "bindControl", "Lcn/coostack/cooparticlesapi/network/particle/ServerControler;", "options", "Lcn/coostack/cooparticlesapi/barrages/BarrageOption;", "<init>", "(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/server/level/ServerLevel;Lcn/coostack/cooparticlesapi/barrages/HitBox;Lcn/coostack/cooparticlesapi/network/particle/ServerControler;Lcn/coostack/cooparticlesapi/barrages/BarrageOption;)V", "getLoc", "()Lnet/minecraft/world/phys/Vec3;", "setLoc", "(Lnet/minecraft/world/phys/Vec3;)V", "getWorld", "()Lnet/minecraft/server/level/ServerLevel;", "getHitBox", "()Lcn/coostack/cooparticlesapi/barrages/HitBox;", "setHitBox", "(Lcn/coostack/cooparticlesapi/barrages/HitBox;)V", "getBindControl", "()Lcn/coostack/cooparticlesapi/network/particle/ServerControler;", "getOptions", "()Lcn/coostack/cooparticlesapi/barrages/BarrageOption;", "shooter", "Lnet/minecraft/world/entity/LivingEntity;", "getShooter", "()Lnet/minecraft/world/entity/LivingEntity;", "setShooter", "(Lnet/minecraft/world/entity/LivingEntity;)V", "direction", "getDirection", "setDirection", "lunch", "", "getLunch", "()Z", "setLunch", "(Z)V", "currentTick", "", "spawnTick", "isValid", "isValid$cooparticlesapi_neoforge_1_21_1", "setValid$cooparticlesapi_neoforge_1_21_1", "valid", "getValid", "currentAcrossCount", "uuid", "Ljava/util/UUID;", "getUuid", "()Ljava/util/UUID;", "filterHitEntity", "livingEntity", "filterHitBarrage", "barrage", "tick", "", "hit", "result", "Lcn/coostack/cooparticlesapi/barrages/BarrageHitResult;", "remove", "noclip", "hitBoxEntities", "", "filter", "Lcom/google/common/base/Predicate;", "cooparticlesapi-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nAbstractBarrage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractBarrage.kt\ncn/coostack/cooparticlesapi/barrages/AbstractBarrage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,159:1\n774#2:160\n865#2,2:161\n774#2:163\n865#2,2:164\n1869#2:166\n1870#2:168\n1#3:167\n*S KotlinDebug\n*F\n+ 1 AbstractBarrage.kt\ncn/coostack/cooparticlesapi/barrages/AbstractBarrage\n*L\n97#1:160\n97#1:161,2\n106#1:163\n106#1:164,2\n127#1:166\n127#1:168\n*E\n"})
public abstract class AbstractBarrage
implements Barrage {
    @NotNull
    private Vec3 loc;
    @NotNull
    private final ServerLevel world;
    @NotNull
    private HitBox hitBox;
    @NotNull
    private final ServerControler<?> bindControl;
    @NotNull
    private final BarrageOption options;
    @Nullable
    private LivingEntity shooter;
    @NotNull
    private Vec3 direction;
    private boolean lunch;
    private int currentTick;
    private int spawnTick;
    private boolean isValid;
    private int currentAcrossCount;
    @NotNull
    private final UUID uuid;

    public AbstractBarrage(@NotNull Vec3 loc, @NotNull ServerLevel world, @NotNull HitBox hitBox, @NotNull ServerControler<?> bindControl, @NotNull BarrageOption options) {
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)hitBox, (String)"hitBox");
        Intrinsics.checkNotNullParameter(bindControl, (String)"bindControl");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.loc = loc;
        this.world = world;
        this.hitBox = hitBox;
        this.bindControl = bindControl;
        this.options = options;
        Vec3 vec3 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        this.direction = vec3;
        this.isValid = true;
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        this.uuid = uUID;
    }

    @Override
    @NotNull
    public Vec3 getLoc() {
        return this.loc;
    }

    @Override
    public void setLoc(@NotNull Vec3 vec3) {
        Intrinsics.checkNotNullParameter((Object)vec3, (String)"<set-?>");
        this.loc = vec3;
    }

    @Override
    @NotNull
    public ServerLevel getWorld() {
        return this.world;
    }

    @Override
    @NotNull
    public HitBox getHitBox() {
        return this.hitBox;
    }

    @Override
    public void setHitBox(@NotNull HitBox hitBox) {
        Intrinsics.checkNotNullParameter((Object)hitBox, (String)"<set-?>");
        this.hitBox = hitBox;
    }

    @Override
    @NotNull
    public ServerControler<?> getBindControl() {
        return this.bindControl;
    }

    @Override
    @NotNull
    public BarrageOption getOptions() {
        return this.options;
    }

    @Override
    @Nullable
    public LivingEntity getShooter() {
        return this.shooter;
    }

    @Override
    public void setShooter(@Nullable LivingEntity livingEntity) {
        this.shooter = livingEntity;
    }

    @Override
    @NotNull
    public Vec3 getDirection() {
        return this.direction;
    }

    @Override
    public void setDirection(@NotNull Vec3 vec3) {
        Intrinsics.checkNotNullParameter((Object)vec3, (String)"<set-?>");
        this.direction = vec3;
    }

    @Override
    public boolean getLunch() {
        return this.lunch;
    }

    @Override
    public void setLunch(boolean bl) {
        this.lunch = bl;
    }

    public final boolean isValid$cooparticlesapi_neoforge_1_21_1() {
        return this.isValid;
    }

    public final void setValid$cooparticlesapi_neoforge_1_21_1(boolean bl) {
        this.isValid = bl;
    }

    @Override
    public boolean getValid() {
        return this.isValid;
    }

    @Override
    @NotNull
    public UUID getUuid() {
        return this.uuid;
    }

    public abstract boolean filterHitEntity(@NotNull LivingEntity var1);

    public boolean filterHitBarrage(@NotNull Barrage barrage) {
        Intrinsics.checkNotNullParameter((Object)barrage, (String)"barrage");
        return !Intrinsics.areEqual((Object)barrage.getShooter(), (Object)this.getShooter()) && !Intrinsics.areEqual((Object)barrage, (Object)this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void tick() {
        void $this$filterTo$iv$iv;
        BlockState block2;
        if (!this.getLunch() || !this.getValid()) {
            return;
        }
        if (!this.getWorld().hasChunk((int)this.getLoc().x >> 4, (int)this.getLoc().z >> 4)) {
            return;
        }
        if (this.getOptions().getEnableSpeed()) {
            Vec3 vec3 = this.getLoc().add(this.getDirection().normalize().scale(this.getOptions().getSpeed()));
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
            this.setLoc(vec3);
            BarrageOption barrageOption = this.getOptions();
            barrageOption.setSpeed(barrageOption.getSpeed() + this.getOptions().getAcceleration());
            if (this.getOptions().getAccelerationMaxSpeedEnabled()) {
                this.getOptions().setSpeed(Math.max(this.getOptions().getAccelerationMaxSpeed(), this.getOptions().getSpeed()));
            }
        } else {
            Vec3 vec3 = this.getLoc().add(this.getDirection());
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
            this.setLoc(vec3);
        }
        this.getBindControl().teleportTo(this.getLoc());
        if (this.getOptions().getMaxLivingTick() != -1) {
            int n = this.currentTick;
            this.currentTick = n + 1;
            if (n > this.getOptions().getMaxLivingTick()) {
                this.hit(new BarrageHitResult());
                return;
            }
        }
        boolean hit = false;
        BlockPos blockPos = new BlockPos((int)this.getLoc().x, (int)this.getLoc().y, (int)this.getLoc().z);
        BarrageHitResult result = new BarrageHitResult();
        if (this.getWorld().shouldTickBlocksAt(blockPos) && this.getWorld().isPositionEntityTicking(blockPos) && !(block2 = this.getWorld().getBlockState(blockPos)).isAir()) {
            VoxelShape shape = block2.getCollisionShape((BlockGetter)this.getWorld(), blockPos);
            if (!block2.isSolid()) {
                if (!this.getOptions().getAcrossLiquid()) {
                    result.setHitBlockState(block2);
                    hit = true;
                }
            } else if (!(this.getOptions().getAcrossBlock() || shape.isEmpty() && this.getOptions().getAcrossEmptyCollectionShape())) {
                result.setHitBlockState(block2);
                hit = true;
            }
        }
        if (this.spawnTick < this.getOptions().getNoneHitBoxTick()) {
            int block2 = this.spawnTick;
            this.spawnTick = block2 + 1;
            return;
        }
        Iterable $this$filter$iv = this.hitBoxEntities();
        boolean $i$f$filter2 = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LivingEntity it = (LivingEntity)element$iv$iv;
            boolean bl = false;
            if (!this.filterHitEntity(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List collection = (List)destination$iv$iv;
        if (!((Collection)collection).isEmpty()) {
            result.getEntities().addAll(collection);
            hit = true;
        }
        if (!this.getOptions().getBarrageIgnored()) {
            void $this$filterTo$iv$iv2;
            void $this$filter$iv2;
            Iterable $i$f$filter2 = BarrageManager.INSTANCE.collectClipBarrages(this.getWorld(), this.getHitBox().ofBox(this.getLoc()));
            boolean $i$f$filter3 = false;
            destination$iv$iv = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                Barrage p0 = (Barrage)element$iv$iv;
                boolean bl = false;
                if (!this.filterHitBarrage(p0)) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List otherBarrages = (List)destination$iv$iv2;
            result.getBarrages().addAll(otherBarrages);
            hit = true;
        }
        if (hit) {
            this.hit(result);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void hit(@NotNull BarrageHitResult result) {
        boolean timeoutHit;
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        this.onHit(result);
        boolean bl = timeoutHit = this.getOptions().getMaxLivingTick() <= this.currentTick && this.getOptions().getMaxLivingTick() != -1;
        if (this.getOptions().getAcrossable() && !timeoutHit) {
            if (this.getOptions().getMaxAcrossCount() == -1) {
                return;
            }
            int n = this.currentAcrossCount;
            this.currentAcrossCount = n + 1;
            if (n < this.getOptions().getMaxAcrossCount()) {
                return;
            }
        }
        if (!((Collection)result.getBarrages()).isEmpty()) {
            Iterable $this$forEach$iv = result.getBarrages();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void it;
                BarrageHitResult barrageHitResult;
                Barrage barrage = (Barrage)element$iv;
                boolean bl2 = false;
                if (barrage.getOptions().getBarrageIgnored() || !(barrage instanceof AbstractBarrage) || Intrinsics.areEqual((Object)barrage, (Object)this)) continue;
                BarrageHitResult barrageHitResult2 = barrageHitResult = new BarrageHitResult();
                AbstractBarrage abstractBarrage = (AbstractBarrage)barrage;
                boolean bl3 = false;
                it.getBarrages().add(this);
                abstractBarrage.hit(barrageHitResult);
            }
        }
        this.remove();
    }

    public final void remove() {
        this.getBindControl().remove();
        this.isValid = false;
    }

    @Override
    public boolean noclip() {
        return this.spawnTick < this.getOptions().getNoneHitBoxTick();
    }

    @NotNull
    public final Set<LivingEntity> hitBoxEntities() {
        HashSet res = new HashSet();
        res.addAll(this.getWorld().getEntitiesOfClass(LivingEntity.class, this.getHitBox().ofBox(this.getLoc()), arg_0 -> AbstractBarrage.hitBoxEntities$lambda$4(AbstractBarrage::hitBoxEntities$lambda$3, arg_0)));
        return res;
    }

    @NotNull
    public final Set<LivingEntity> hitBoxEntities(@NotNull com.google.common.base.Predicate<LivingEntity> filter) {
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        HashSet res = new HashSet();
        res.addAll(this.getWorld().getEntitiesOfClass(LivingEntity.class, this.getHitBox().ofBox(this.getLoc()), (Predicate)filter));
        return res;
    }

    private static final boolean hitBoxEntities$lambda$3(LivingEntity it) {
        return true;
    }

    private static final boolean hitBoxEntities$lambda$4(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }
}

