/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.mixin;

import cn.coostack.cooparticlesapi.CooParticlesAPIClient;
import cn.coostack.cooparticlesapi.renderer.client.ClientRenderEntityManager;
import net.minecraft.client.Camera;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.LightTexture;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LevelRenderer.class})
public class LevelRendererMixin {
    @Shadow
    @Nullable
    private ClientLevel level;

    @Inject(method={"renderLevel"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/profiling/ProfilerFiller;popPush(Ljava/lang/String;)V", ordinal=11)})
    public void renderBeforeEntity(DeltaTracker deltaTracker, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f frustumMatrix, Matrix4f projectionMatrix, CallbackInfo info) {
        if (CooParticlesAPIClient.checkIrisShaderPackUsed()) {
            return;
        }
        if (this.level == null) {
            return;
        }
        CooParticlesAPIClient.initShaderPrograms();
        boolean shouldTick = this.level.tickRateManager().runsNormally();
        float tickDelta = deltaTracker.getGameTimeDeltaPartialTick(!shouldTick);
        ClientRenderEntityManager.INSTANCE.renderTick(tickDelta, frustumMatrix, projectionMatrix);
    }

    @Inject(method={"renderLevel"}, at={@At(value="RETURN")})
    public void renderOnTail(DeltaTracker deltaTracker, boolean renderBlockOutline, Camera camera, GameRenderer gameRenderer, LightTexture lightTexture, Matrix4f frustumMatrix, Matrix4f projectionMatrix, CallbackInfo info) {
        boolean irisLoaded = CooParticlesAPIClient.irisLoaded;
        if (!CooParticlesAPIClient.checkIrisShaderPackUsed()) {
            return;
        }
        if (!irisLoaded) {
            return;
        }
        if (this.level == null) {
            return;
        }
        CooParticlesAPIClient.initShaderPrograms();
        boolean shouldTick = this.level.tickRateManager().runsNormally();
        float tickDelta = deltaTracker.getGameTimeDeltaPartialTick(!shouldTick);
        ClientRenderEntityManager.INSTANCE.renderTick(tickDelta, frustumMatrix, projectionMatrix);
    }
}

