/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.network.particle;

import cn.coostack.cooparticlesapi.CooParticlesAPI;
import cn.coostack.cooparticlesapi.network.buffer.ParticleControlerDataBuffer;
import cn.coostack.cooparticlesapi.network.buffer.ParticleControlerDataBuffers;
import cn.coostack.cooparticlesapi.network.packet.PacketParticleGroupS2C;
import cn.coostack.cooparticlesapi.network.particle.ServerParticleGroup;
import cn.coostack.cooparticlesapi.particles.control.ControlType;
import cn.coostack.cooparticlesapi.particles.control.group.ControlableParticleGroup;
import cn.coostack.cooparticlesapi.platform.CooParticlesServices;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u0006J\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0015J\u0006\u0010\u0016\u001a\u00020\rJ\u0014\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u00182\u0006\u0010\u000e\u001a\u00020\u0007J\b\u0010\u0019\u001a\u00020\rH\u0002J\b\u0010\u001a\u001a\u00020\rH\u0002J\u0018\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0018\u0010\u001e\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u0007H\u0002J\u0018\u0010 \u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\u0007H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\t0\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006!"}, d2={"Lcn/coostack/cooparticlesapi/network/particle/ServerParticleGroupManager;", "", "<init>", "()V", "serverGroups", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/UUID;", "Lcn/coostack/cooparticlesapi/network/particle/ServerParticleGroup;", "visible", "", "getVisible$cooparticlesapi_neoforge_1_21_1", "()Ljava/util/concurrent/ConcurrentHashMap;", "addParticleGroup", "", "group", "pos", "Lnet/minecraft/world/phys/Vec3;", "world", "Lnet/minecraft/server/level/ServerLevel;", "getParticleGroup", "getGroups", "", "upgrade", "filterVisiblePlayer", "", "upgradeGroups", "clearOfflineVisible", "togglePacketView", "target", "Lnet/minecraft/server/level/ServerPlayer;", "removeGroupPlayerView", "targetGroup", "addGroupPlayerView", "cooparticlesapi-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nServerParticleGroupManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ServerParticleGroupManager.kt\ncn/coostack/cooparticlesapi/network/particle/ServerParticleGroupManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,190:1\n774#2:191\n865#2,2:192\n1869#2,2:194\n1869#2:200\n1870#2:204\n216#3,2:196\n216#3,2:198\n72#4,2:201\n72#4,2:205\n1#5:203\n1#5:207\n*S KotlinDebug\n*F\n+ 1 ServerParticleGroupManager.kt\ncn/coostack/cooparticlesapi/network/particle/ServerParticleGroupManager\n*L\n35#1:191\n35#1:192,2\n36#1:194,2\n83#1:200\n83#1:204\n57#1:196,2\n72#1:198,2\n84#1:201,2\n171#1:205,2\n84#1:203\n171#1:207\n*E\n"})
public final class ServerParticleGroupManager {
    @NotNull
    public static final ServerParticleGroupManager INSTANCE = new ServerParticleGroupManager();
    @NotNull
    private static final ConcurrentHashMap<UUID, ServerParticleGroup> serverGroups = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentHashMap<UUID, Set<ServerParticleGroup>> visible = new ConcurrentHashMap();

    private ServerParticleGroupManager() {
    }

    @NotNull
    public final ConcurrentHashMap<UUID, Set<ServerParticleGroup>> getVisible$cooparticlesapi_neoforge_1_21_1() {
        return visible;
    }

    /*
     * WARNING - void declaration
     */
    public final void addParticleGroup(@NotNull ServerParticleGroup group, @NotNull Vec3 pos, @NotNull ServerLevel world) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        ((Map)serverGroups).put(group.getUuid(), group);
        ServerParticleGroup.initServerGroup$default(group, pos, (Level)world, 0, 4, null);
        List list = world.players();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"players(...)");
        Iterable $this$filter$iv = list;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ServerPlayer it = (ServerPlayer)element$iv$iv;
            boolean bl = false;
            if (!(it.position().distanceTo(pos) <= group.getVisibleRange())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ServerPlayer receiver = (ServerPlayer)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)receiver);
            INSTANCE.addGroupPlayerView(receiver, group);
        }
        group.onGroupDisplay(pos, world);
    }

    @Nullable
    public final ServerParticleGroup getParticleGroup(@NotNull UUID group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        return serverGroups.get(group);
    }

    @NotNull
    public final Map<UUID, ServerParticleGroup> getGroups() {
        Map<UUID, ServerParticleGroup> map = Collections.unmodifiableMap((Map)serverGroups);
        Intrinsics.checkNotNullExpressionValue(map, (String)"unmodifiableMap(...)");
        return map;
    }

    public final void upgrade() {
        this.upgradeGroups();
        this.clearOfflineVisible();
    }

    @NotNull
    public final Set<UUID> filterVisiblePlayer(@NotNull ServerParticleGroup group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        HashSet set = new HashSet();
        Map $this$forEach$iv = visible;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            if (!((Set)it.getValue()).contains(group)) continue;
            set.add(it.getKey());
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    private final void upgradeGroups() {
        Iterator iterator = ((Map)serverGroups).entrySet().iterator();
        while (iterator.hasNext()) {
            ServerParticleGroup value = (ServerParticleGroup)iterator.next().getValue();
            if (value.getCanceled() || !value.getValid()) {
                Level level = value.getWorld();
                if (level == null || (level = level.getServer()) == null) continue;
                Level server = level;
                Map $this$forEach$iv = visible;
                boolean $i$f$forEach = false;
                Iterator iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    ServerPlayer player;
                    Map.Entry element$iv;
                    Map.Entry entry = element$iv = iterator2.next();
                    boolean bl2 = false;
                    UUID t = (UUID)entry.getKey();
                    Set u = (Set)entry.getValue();
                    if (server.getPlayerList().getPlayer(t) == null || !u.contains(value)) continue;
                    INSTANCE.removeGroupPlayerView(player, value);
                    u.remove(value);
                }
                iterator.remove();
                continue;
            }
            Level level = value.getWorld();
            Intrinsics.checkNotNull((Object)level);
            MinecraftServer minecraftServer = level.getServer();
            Intrinsics.checkNotNull((Object)minecraftServer);
            List list = minecraftServer.getPlayerList().getPlayers();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$getOrPut$iv;
                ServerPlayer p = (ServerPlayer)element$iv;
                boolean bl = false;
                ConcurrentMap bl2 = visible;
                UUID key$iv = p.getUUID();
                boolean $i$f$getOrPut = false;
                Object object = $this$getOrPut$iv.get(key$iv);
                if (object == null) {
                    boolean bl3 = false;
                    Set default$iv = new HashSet();
                    boolean bl4 = false;
                    object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                    if (object == null) {
                        object = default$iv;
                    }
                }
                Set visibleSet = (Set)object;
                if (!Intrinsics.areEqual((Object)p.level(), (Object)value.getWorld())) {
                    if (visibleSet.contains(value)) {
                        Intrinsics.checkNotNull((Object)p);
                        INSTANCE.removeGroupPlayerView(p, value);
                    }
                    Set set = visibleSet;
                    Intrinsics.checkNotNull((Object)set);
                    set.remove(value);
                    continue;
                }
                if (p.isDeadOrDying()) {
                    if (!visibleSet.contains(value)) continue;
                    Intrinsics.checkNotNull((Object)p);
                    INSTANCE.removeGroupPlayerView(p, value);
                    Set set = visibleSet;
                    Intrinsics.checkNotNull((Object)set);
                    set.remove(value);
                    continue;
                }
                if (value.getPos().distanceTo(p.position()) <= value.getVisibleRange()) {
                    if (visibleSet.contains(value)) continue;
                    Intrinsics.checkNotNull((Object)p);
                    INSTANCE.addGroupPlayerView(p, value);
                    INSTANCE.togglePacketView(p, value);
                    continue;
                }
                if (visibleSet.contains(value)) {
                    Intrinsics.checkNotNull((Object)p);
                    INSTANCE.removeGroupPlayerView(p, value);
                }
                visibleSet.remove(value);
            }
            value.tick();
        }
    }

    private final void clearOfflineVisible() {
        MinecraftServer server = CooParticlesAPI.INSTANCE.getServer();
        Iterator visibleIterator = ((Map)visible).entrySet().iterator();
        while (visibleIterator.hasNext()) {
            Map.Entry entry = visibleIterator.next();
            ServerPlayer player = server.getPlayerList().getPlayer((UUID)entry.getKey());
            if (player != null && !player.hasDisconnected()) continue;
            visibleIterator.remove();
        }
    }

    private final void togglePacketView(ServerPlayer target, ServerParticleGroup group) {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)PacketParticleGroupS2C.PacketArgsType.POS.getOfArgs(), (Object)ParticleControlerDataBuffers.INSTANCE.vec3d(group.getPos())), TuplesKt.to((Object)PacketParticleGroupS2C.PacketArgsType.AXIS.getOfArgs(), (Object)ParticleControlerDataBuffers.INSTANCE.vec3d(group.getAxis().toVector())), TuplesKt.to((Object)PacketParticleGroupS2C.PacketArgsType.CURRENT_TICK.getOfArgs(), (Object)ParticleControlerDataBuffers.INSTANCE.int(group.getClientTick())), TuplesKt.to((Object)PacketParticleGroupS2C.PacketArgsType.MAX_TICK.getOfArgs(), (Object)ParticleControlerDataBuffers.INSTANCE.int(group.getClientMaxTick()))};
        PacketParticleGroupS2C packet = new PacketParticleGroupS2C(group.getUuid(), ControlType.CHANGE, MapsKt.mutableMapOf((Pair[])pairArray));
        CooParticlesServices.SERVER_NETWORK.send(packet, target);
    }

    private final void removeGroupPlayerView(ServerPlayer target, ServerParticleGroup targetGroup) {
        PacketParticleGroupS2C packet = new PacketParticleGroupS2C(targetGroup.getUuid(), ControlType.REMOVE, MapsKt.emptyMap());
        CooParticlesServices.SERVER_NETWORK.send(packet, target);
    }

    /*
     * WARNING - void declaration
     */
    private final void addGroupPlayerView(ServerPlayer target, ServerParticleGroup targetGroup) {
        void $this$addGroupPlayerView_u24lambda_u247;
        void $this$getOrPut$iv;
        ConcurrentMap concurrentMap = visible;
        UUID key$iv = target.getUUID();
        boolean $i$f$getOrPut22 = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            Set default$iv = new HashSet();
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Set visibleSet = (Set)object;
        visibleSet.add(targetGroup);
        UUID uUID = targetGroup.getUuid();
        Object object2 = new Pair[5];
        object2[0] = TuplesKt.to((Object)PacketParticleGroupS2C.PacketArgsType.POS.getOfArgs(), (Object)ParticleControlerDataBuffers.INSTANCE.vec3d(targetGroup.getPos()));
        String string = PacketParticleGroupS2C.PacketArgsType.GROUP_TYPE.getOfArgs();
        Class<? extends ControlableParticleGroup> clazz = targetGroup.getClientType();
        Intrinsics.checkNotNull(clazz);
        String string2 = clazz.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        object2[1] = TuplesKt.to((Object)string, (Object)ParticleControlerDataBuffers.INSTANCE.string(string2));
        object2[2] = TuplesKt.to((Object)PacketParticleGroupS2C.PacketArgsType.CURRENT_TICK.getOfArgs(), (Object)ParticleControlerDataBuffers.INSTANCE.int(targetGroup.getClientTick()));
        object2[3] = TuplesKt.to((Object)PacketParticleGroupS2C.PacketArgsType.MAX_TICK.getOfArgs(), (Object)ParticleControlerDataBuffers.INSTANCE.int(targetGroup.getClientMaxTick()));
        object2[4] = TuplesKt.to((Object)PacketParticleGroupS2C.PacketArgsType.SCALE.getOfArgs(), (Object)ParticleControlerDataBuffers.INSTANCE.double(targetGroup.getScale()));
        Object $i$f$getOrPut22 = object2 = MapsKt.mutableMapOf((Pair[])object2);
        ControlType controlType = ControlType.CREATE;
        UUID uUID2 = uUID;
        boolean bl = false;
        $this$addGroupPlayerView_u24lambda_u247.putAll(targetGroup.otherPacketArgs());
        Unit unit = Unit.INSTANCE;
        Object object3 = object2;
        ControlType controlType2 = controlType;
        UUID uUID3 = uUID2;
        PacketParticleGroupS2C packet = new PacketParticleGroupS2C(uUID3, controlType2, (Map<String, ? extends ParticleControlerDataBuffer<?>>)object3);
        CooParticlesServices.SERVER_NETWORK.send(packet, target);
    }
}

