/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.network.particle.emitters;

import cn.coostack.cooparticlesapi.CooParticlesConstants;
import cn.coostack.cooparticlesapi.particles.ControlableParticleEffect;
import cn.coostack.cooparticlesapi.particles.ControlableParticleEffectManager;
import cn.coostack.cooparticlesapi.particles.impl.ControlableEndRodEffect;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u0000 E2\u00020\u0001:\u0001EB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010<\u001a\u000203J\u0006\u0010=\u001a\u00020;J\u000e\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u000203J\u000e\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020;J\u0016\u0010A\u001a\u0010\u0012\u0004\u0012\u00020C\u0012\u0006\b\u0001\u0012\u00020\u00000BH\u0016J\b\u0010D\u001a\u00020\u0000H\u0016R\"\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0011\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\u00020\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u001a\u0010\u001d\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u0014\"\u0004\b\u001f\u0010\u0016R\u001a\u0010 \u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%R\u001a\u0010&\u001a\u00020!X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010#\"\u0004\b(\u0010%R\u001a\u0010)\u001a\u00020\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010\u0014\"\u0004\b+\u0010\u0016R\u001a\u0010,\u001a\u00020-X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b.\u0010/\"\u0004\b0\u00101R\u000e\u00102\u001a\u000203X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u00104\u001a\u000205X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00107\"\u0004\b8\u00109\u00a8\u0006F"}, d2={"Lcn/coostack/cooparticlesapi/network/particle/emitters/ControlableParticleData;", "", "<init>", "()V", "uuid", "Ljava/util/UUID;", "kotlin.jvm.PlatformType", "getUuid", "()Ljava/util/UUID;", "setUuid", "(Ljava/util/UUID;)V", "velocity", "Lnet/minecraft/world/phys/Vec3;", "getVelocity", "()Lnet/minecraft/world/phys/Vec3;", "setVelocity", "(Lnet/minecraft/world/phys/Vec3;)V", "size", "", "getSize", "()F", "setSize", "(F)V", "color", "Lorg/joml/Vector3f;", "getColor", "()Lorg/joml/Vector3f;", "setColor", "(Lorg/joml/Vector3f;)V", "alpha", "getAlpha", "setAlpha", "age", "", "getAge", "()I", "setAge", "(I)V", "maxAge", "getMaxAge", "setMaxAge", "visibleRange", "getVisibleRange", "setVisibleRange", "effect", "Lcn/coostack/cooparticlesapi/particles/ControlableParticleEffect;", "getEffect", "()Lcn/coostack/cooparticlesapi/particles/ControlableParticleEffect;", "setEffect", "(Lcn/coostack/cooparticlesapi/particles/ControlableParticleEffect;)V", "textureSheet", "", "speed", "", "getSpeed", "()D", "setSpeed", "(D)V", "textureSheetFromString", "Lnet/minecraft/client/particle/ParticleRenderType;", "sheet", "getTextureSheet", "setTextureSheet", "", "value", "getCodec", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/FriendlyByteBuf;", "clone", "Companion", "cooparticlesapi-neoforge-1.21.1"})
public class ControlableParticleData {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private UUID uuid = UUID.randomUUID();
    @NotNull
    private Vec3 velocity;
    private float size;
    @NotNull
    private Vector3f color;
    private float alpha;
    private int age;
    private int maxAge;
    private float visibleRange;
    @NotNull
    private ControlableParticleEffect effect;
    @NotNull
    private String textureSheet;
    private double speed;
    @NotNull
    private static final StreamCodec<FriendlyByteBuf, ControlableParticleData> PACKET_CODEC;

    public ControlableParticleData() {
        Vec3 vec3 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        this.velocity = vec3;
        this.size = 0.2f;
        this.color = new Vector3f(1.0f, 1.0f, 1.0f);
        this.alpha = 1.0f;
        this.maxAge = 120;
        this.visibleRange = 128.0f;
        UUID uUID = this.uuid;
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"uuid");
        this.effect = new ControlableEndRodEffect(uUID, false, 2, null);
        this.textureSheet = "PARTICLE_SHEET_TRANSLUCENT";
        this.speed = 1.0;
    }

    public final UUID getUuid() {
        return this.uuid;
    }

    public final void setUuid(UUID uUID) {
        this.uuid = uUID;
    }

    @NotNull
    public final Vec3 getVelocity() {
        return this.velocity;
    }

    public final void setVelocity(@NotNull Vec3 vec3) {
        Intrinsics.checkNotNullParameter((Object)vec3, (String)"<set-?>");
        this.velocity = vec3;
    }

    public final float getSize() {
        return this.size;
    }

    public final void setSize(float f) {
        this.size = f;
    }

    @NotNull
    public final Vector3f getColor() {
        return this.color;
    }

    public final void setColor(@NotNull Vector3f vector3f) {
        Intrinsics.checkNotNullParameter((Object)vector3f, (String)"<set-?>");
        this.color = vector3f;
    }

    public final float getAlpha() {
        return this.alpha;
    }

    public final void setAlpha(float f) {
        this.alpha = f;
    }

    public final int getAge() {
        return this.age;
    }

    public final void setAge(int n) {
        this.age = n;
    }

    public final int getMaxAge() {
        return this.maxAge;
    }

    public final void setMaxAge(int n) {
        this.maxAge = n;
    }

    public final float getVisibleRange() {
        return this.visibleRange;
    }

    public final void setVisibleRange(float f) {
        this.visibleRange = f;
    }

    @NotNull
    public final ControlableParticleEffect getEffect() {
        return this.effect;
    }

    public final void setEffect(@NotNull ControlableParticleEffect controlableParticleEffect) {
        Intrinsics.checkNotNullParameter((Object)controlableParticleEffect, (String)"<set-?>");
        this.effect = controlableParticleEffect;
    }

    public final double getSpeed() {
        return this.speed;
    }

    public final void setSpeed(double d) {
        this.speed = d;
    }

    @Nullable
    public final ParticleRenderType textureSheetFromString(@NotNull String sheet) {
        Intrinsics.checkNotNullParameter((Object)sheet, (String)"sheet");
        String string = sheet;
        return Intrinsics.areEqual((Object)string, (Object)ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT.toString()) ? ParticleRenderType.PARTICLE_SHEET_TRANSLUCENT : (Intrinsics.areEqual((Object)string, (Object)ParticleRenderType.PARTICLE_SHEET_OPAQUE.toString()) ? ParticleRenderType.PARTICLE_SHEET_OPAQUE : (Intrinsics.areEqual((Object)string, (Object)ParticleRenderType.CUSTOM.toString()) ? ParticleRenderType.CUSTOM : (Intrinsics.areEqual((Object)string, (Object)ParticleRenderType.NO_RENDER.toString()) ? ParticleRenderType.NO_RENDER : (Intrinsics.areEqual((Object)string, (Object)ParticleRenderType.PARTICLE_SHEET_LIT.toString()) ? ParticleRenderType.PARTICLE_SHEET_LIT : (Intrinsics.areEqual((Object)string, (Object)ParticleRenderType.TERRAIN_SHEET.toString()) ? ParticleRenderType.TERRAIN_SHEET : null)))));
    }

    @NotNull
    public final ParticleRenderType getTextureSheet() {
        ParticleRenderType particleRenderType = this.textureSheetFromString(this.textureSheet);
        if (particleRenderType == null) {
            ControlableParticleData it = this;
            boolean bl = false;
            CooParticlesConstants.logger.error("can not find textureSheet " + this.textureSheet);
            ParticleRenderType particleRenderType2 = ParticleRenderType.PARTICLE_SHEET_OPAQUE;
            particleRenderType = particleRenderType2;
            Intrinsics.checkNotNullExpressionValue((Object)particleRenderType2, (String)"let(...)");
        }
        return particleRenderType;
    }

    public final void setTextureSheet(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.textureSheet = value;
    }

    public final void setTextureSheet(@NotNull ParticleRenderType value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.textureSheet = value.toString();
    }

    @NotNull
    public StreamCodec<FriendlyByteBuf, ? extends ControlableParticleData> getCodec() {
        return PACKET_CODEC;
    }

    @NotNull
    public ControlableParticleData clone() {
        ControlableParticleData controlableParticleData;
        ControlableParticleData it = controlableParticleData = new ControlableParticleData();
        boolean bl = false;
        it.uuid = UUID.randomUUID();
        it.velocity = this.velocity;
        it.size = this.size;
        it.color = this.color;
        it.alpha = this.alpha;
        it.visibleRange = this.visibleRange;
        it.effect = this.effect;
        it.age = this.age;
        it.maxAge = this.maxAge;
        it.effect = this.effect.clone();
        it.textureSheet = this.textureSheet;
        it.speed = this.speed;
        return controlableParticleData;
    }

    @NotNull
    public static final StreamCodec<FriendlyByteBuf, ControlableParticleData> getPACKET_CODEC() {
        return Companion.getPACKET_CODEC();
    }

    static {
        StreamCodec streamCodec = StreamCodec.of((arg_0, arg_1) -> Companion.access$encode(Companion, arg_0, arg_1), arg_0 -> Companion.access$decode(Companion, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"of(...)");
        PACKET_CODEC = streamCodec;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0007H\u0002J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u0006H\u0002R(\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\b\u0010\u0003\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0010"}, d2={"Lcn/coostack/cooparticlesapi/network/particle/emitters/ControlableParticleData$Companion;", "", "<init>", "()V", "PACKET_CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/FriendlyByteBuf;", "Lcn/coostack/cooparticlesapi/network/particle/emitters/ControlableParticleData;", "getPACKET_CODEC$annotations", "getPACKET_CODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "encode", "", "buf", "data", "decode", "cooparticlesapi-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final StreamCodec<FriendlyByteBuf, ControlableParticleData> getPACKET_CODEC() {
            return PACKET_CODEC;
        }

        @JvmStatic
        public static /* synthetic */ void getPACKET_CODEC$annotations() {
        }

        private final void encode(FriendlyByteBuf buf, ControlableParticleData data) {
            buf.writeUUID(data.getUuid());
            buf.writeVec3(data.getVelocity());
            buf.writeFloat(data.getSize());
            buf.writeFloat(data.getVisibleRange());
            buf.writeVector3f(data.getColor());
            buf.writeFloat(data.getAlpha());
            buf.writeInt(data.getAge());
            buf.writeInt(data.getMaxAge());
            buf.writeUtf(data.textureSheet.toString());
            buf.writeUtf(data.getEffect().getClass().getName());
            buf.writeUUID(data.getUuid());
            buf.writeDouble(data.getSpeed());
        }

        private final ControlableParticleData decode(FriendlyByteBuf buf) {
            ControlableParticleData controlableParticleData;
            UUID uuid = buf.readUUID();
            Vec3 velocity = buf.readVec3();
            float size = buf.readFloat();
            float visibleRange = buf.readFloat();
            Vector3f color = buf.readVector3f();
            float alpha = buf.readFloat();
            int age = buf.readInt();
            int maxAge = buf.readInt();
            String textureSheet = buf.readUtf();
            String effectType = buf.readUtf();
            UUID effectUUID = buf.readUUID();
            Intrinsics.checkNotNull((Object)effectUUID);
            Class<?> clazz = Class.forName(effectType);
            Intrinsics.checkNotNull(clazz, (String)"null cannot be cast to non-null type java.lang.Class<cn.coostack.cooparticlesapi.particles.ControlableParticleEffect>");
            ControlableParticleEffect effect = ControlableParticleEffectManager.INSTANCE.createWithUUID(effectUUID, clazz);
            double speed = buf.readDouble();
            ControlableParticleData $this$decode_u24lambda_u240 = controlableParticleData = new ControlableParticleData();
            boolean bl = false;
            $this$decode_u24lambda_u240.setUuid(uuid);
            Intrinsics.checkNotNull((Object)velocity);
            $this$decode_u24lambda_u240.setVelocity(velocity);
            Intrinsics.checkNotNull((Object)color);
            $this$decode_u24lambda_u240.setColor(color);
            $this$decode_u24lambda_u240.setAlpha(alpha);
            $this$decode_u24lambda_u240.setSize(size);
            $this$decode_u24lambda_u240.setVisibleRange(visibleRange);
            $this$decode_u24lambda_u240.setAge(age);
            $this$decode_u24lambda_u240.setMaxAge(maxAge);
            Intrinsics.checkNotNull((Object)textureSheet);
            $this$decode_u24lambda_u240.textureSheet = textureSheet;
            $this$decode_u24lambda_u240.setEffect(effect);
            $this$decode_u24lambda_u240.setSpeed(speed);
            return controlableParticleData;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ void access$encode(Companion $this, FriendlyByteBuf buf, ControlableParticleData data) {
            $this.encode(buf, data);
        }

        public static final /* synthetic */ ControlableParticleData access$decode(Companion $this, FriendlyByteBuf buf) {
            return $this.decode(buf);
        }
    }
}

