/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.network.particle.emitters;

import cn.coostack.cooparticlesapi.CooParticlesAPI;
import cn.coostack.cooparticlesapi.network.packet.PacketParticleEmittersS2C;
import cn.coostack.cooparticlesapi.network.particle.emitters.ParticleEmitters;
import cn.coostack.cooparticlesapi.network.particle.emitters.impl.DefendClassParticleEmitters;
import cn.coostack.cooparticlesapi.network.particle.emitters.impl.ExampleClassParticleEmitters;
import cn.coostack.cooparticlesapi.network.particle.emitters.impl.ExplodeClassParticleEmitters;
import cn.coostack.cooparticlesapi.network.particle.emitters.impl.FireClassParticleEmitters;
import cn.coostack.cooparticlesapi.network.particle.emitters.impl.LightningClassParticleEmitters;
import cn.coostack.cooparticlesapi.network.particle.emitters.impl.PhysicsParticleEmitters;
import cn.coostack.cooparticlesapi.network.particle.emitters.impl.PresetLaserEmitters;
import cn.coostack.cooparticlesapi.network.particle.emitters.impl.PresetTestEmitters;
import cn.coostack.cooparticlesapi.network.particle.emitters.impl.SimpleParticleEmitters;
import cn.coostack.cooparticlesapi.platform.CooParticlesServices;
import cn.coostack.cooparticlesapi.test.particle.emitter.TestEmitter;
import cn.coostack.cooparticlesapi.test.particle.emitter.TestEventEmitter;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0017\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t\u0018\u00010\u00072\u0006\u0010\u0018\u001a\u00020\u0006J.\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u0018\u001a\u00020\u00062\u0012\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\tJ\u000e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\tJ\u0016\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010 \u001a\u00020!J\u0006\u0010\"\u001a\u00020\u001cJ\u0006\u0010#\u001a\u00020\u001cJ\u0014\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000e0%2\u0006\u0010&\u001a\u00020\tJ\u000e\u0010'\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\tJ\u000e\u0010(\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\tJ\u0016\u0010)\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\t2\u0006\u0010*\u001a\u00020+J\u0018\u0010,\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020+2\u0006\u0010\u001d\u001a\u00020\tH\u0002J\u0006\u0010.\u001a\u00020\u001cJ\u0018\u0010/\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020+2\u0006\u0010\u001d\u001a\u00020\tH\u0002J\r\u00100\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b1RE\u0010\u0004\u001a6\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0005j\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR-\u0010\r\u001a\u001e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\t0\u0005j\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\t`\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\fR&\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00120\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001d\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\t0\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0014\u00a8\u00062"}, d2={"Lcn/coostack/cooparticlesapi/network/particle/emitters/ParticleEmittersManager;", "", "<init>", "()V", "emittersCodec", "Ljava/util/HashMap;", "", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/FriendlyByteBuf;", "Lcn/coostack/cooparticlesapi/network/particle/emitters/ParticleEmitters;", "Lkotlin/collections/HashMap;", "getEmittersCodec", "()Ljava/util/HashMap;", "serverEmitters", "Ljava/util/UUID;", "getServerEmitters", "visible", "Ljava/util/concurrent/ConcurrentHashMap;", "", "getVisible$cooparticlesapi_neoforge_1_21_1", "()Ljava/util/concurrent/ConcurrentHashMap;", "clientEmitters", "getClientEmitters", "getCodecFromID", "id", "register", "codec", "addEmitters", "", "emitters", "spawnEmitters", "createOrChangeClient", "viewWorld", "Lnet/minecraft/world/level/Level;", "doTickServer", "doTickClient", "filterVisiblePlayer", "", "group", "updateClientVisible", "updateEmitters", "sendChange", "to", "Lnet/minecraft/server/level/ServerPlayer;", "addView", "player", "clearAllVisible", "removeView", "init", "init$cooparticlesapi_neoforge_1_21_1", "cooparticlesapi-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nParticleEmittersManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ParticleEmittersManager.kt\ncn/coostack/cooparticlesapi/network/particle/emitters/ParticleEmittersManager\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 5 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,226:1\n1869#2,2:227\n1869#2:231\n1870#2:235\n1869#2,2:236\n216#3,2:229\n640#3:238\n72#4,2:232\n1#5:234\n1#5:239\n*S KotlinDebug\n*F\n+ 1 ParticleEmittersManager.kt\ncn/coostack/cooparticlesapi/network/particle/emitters/ParticleEmittersManager\n*L\n98#1:227,2\n135#1:231\n135#1:235\n160#1:236,2\n126#1:229,2\n196#1:238\n136#1:232,2\n136#1:234\n196#1:239\n*E\n"})
public final class ParticleEmittersManager {
    @NotNull
    public static final ParticleEmittersManager INSTANCE = new ParticleEmittersManager();
    @NotNull
    private static final HashMap<String, StreamCodec<FriendlyByteBuf, ParticleEmitters>> emittersCodec = new HashMap();
    @NotNull
    private static final HashMap<UUID, ParticleEmitters> serverEmitters = new HashMap();
    @NotNull
    private static final ConcurrentHashMap<UUID, Set<ParticleEmitters>> visible = new ConcurrentHashMap();
    @NotNull
    private static final ConcurrentHashMap<UUID, ParticleEmitters> clientEmitters = new ConcurrentHashMap();

    private ParticleEmittersManager() {
    }

    @NotNull
    public final HashMap<String, StreamCodec<FriendlyByteBuf, ParticleEmitters>> getEmittersCodec() {
        return emittersCodec;
    }

    @NotNull
    public final HashMap<UUID, ParticleEmitters> getServerEmitters() {
        return serverEmitters;
    }

    @NotNull
    public final ConcurrentHashMap<UUID, Set<ParticleEmitters>> getVisible$cooparticlesapi_neoforge_1_21_1() {
        return visible;
    }

    @NotNull
    public final ConcurrentHashMap<UUID, ParticleEmitters> getClientEmitters() {
        return clientEmitters;
    }

    @Nullable
    public final StreamCodec<FriendlyByteBuf, ParticleEmitters> getCodecFromID(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return emittersCodec.get(id);
    }

    @NotNull
    public final StreamCodec<FriendlyByteBuf, ParticleEmitters> register(@NotNull String id, @NotNull StreamCodec<FriendlyByteBuf, ParticleEmitters> codec) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(codec, (String)"codec");
        ((Map)emittersCodec).put(id, codec);
        return codec;
    }

    public final void addEmitters(@NotNull ParticleEmitters emitters) {
        Intrinsics.checkNotNullParameter((Object)emitters, (String)"emitters");
        if (emitters.getWorld() == null) {
            return;
        }
        Level level = emitters.getWorld();
        Intrinsics.checkNotNull((Object)level);
        if (!level.isClientSide) {
            return;
        }
        ((Map)clientEmitters).put(emitters.getUuid(), emitters);
        emitters.start();
    }

    public final void spawnEmitters(@NotNull ParticleEmitters emitters) {
        Intrinsics.checkNotNullParameter((Object)emitters, (String)"emitters");
        if (emitters.getWorld() == null) {
            return;
        }
        Level level = emitters.getWorld();
        Intrinsics.checkNotNull((Object)level);
        if (level.isClientSide) {
            return;
        }
        ((Map)serverEmitters).put(emitters.getUuid(), emitters);
        emitters.start();
        this.updateClientVisible(emitters);
    }

    public final void createOrChangeClient(@NotNull ParticleEmitters emitters, @NotNull Level viewWorld) {
        Intrinsics.checkNotNullParameter((Object)emitters, (String)"emitters");
        Intrinsics.checkNotNullParameter((Object)viewWorld, (String)"viewWorld");
        if (emitters.getCancelled()) {
            clientEmitters.remove(emitters.getUuid());
            return;
        }
        if (clientEmitters.containsKey(emitters.getUuid())) {
            ParticleEmitters particleEmitters;
            ParticleEmitters particleEmitters2 = clientEmitters.get(emitters.getUuid());
            Intrinsics.checkNotNull((Object)particleEmitters2);
            ParticleEmitters $this$createOrChangeClient_u24lambda_u240 = particleEmitters = particleEmitters2;
            boolean bl = false;
            $this$createOrChangeClient_u24lambda_u240.update(emitters);
            $this$createOrChangeClient_u24lambda_u240.setWorld(viewWorld);
        } else {
            ((Map)clientEmitters).put(emitters.getUuid(), emitters);
        }
    }

    public final void doTickServer() {
        Iterator iterator = ((Map)serverEmitters).entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry emitter = iterator.next();
            ParticleEmitters emitters = (ParticleEmitters)emitter.getValue();
            this.updateClientVisible((ParticleEmitters)emitter.getValue());
            emitters.tick();
            if (!((ParticleEmitters)emitter.getValue()).getCancelled()) continue;
            Iterable $this$forEach$iv = this.filterVisiblePlayer(emitters);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Player player;
                UUID it = (UUID)element$iv;
                boolean bl = false;
                Level level = emitters.getWorld();
                Intrinsics.checkNotNull((Object)level);
                if (level.getPlayerByUUID(it) == null) continue;
                Intrinsics.checkNotNull((Object)player, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
                INSTANCE.removeView((ServerPlayer)player, emitters);
                Set<ParticleEmitters> set = visible.get(it);
                if (set == null) continue;
                set.remove(emitters);
            }
            iterator.remove();
        }
    }

    public final void doTickClient() {
        LocalPlayer localPlayer = Minecraft.getInstance().player;
        if (localPlayer == null) {
            return;
        }
        LocalPlayer player = localPlayer;
        if (player.isDeadOrDying()) {
            clientEmitters.clear();
            return;
        }
        Iterator iterator = ((Map)clientEmitters).entrySet().iterator();
        while (iterator.hasNext()) {
            ParticleEmitters emitters = (ParticleEmitters)iterator.next().getValue();
            emitters.tick();
            if (!emitters.getCancelled()) continue;
            iterator.remove();
        }
    }

    @NotNull
    public final Set<UUID> filterVisiblePlayer(@NotNull ParticleEmitters group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        HashSet set = new HashSet();
        Map $this$forEach$iv = visible;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl = false;
            if (!((Set)it.getValue()).contains(group)) continue;
            set.add(it.getKey());
        }
        return set;
    }

    /*
     * WARNING - void declaration
     */
    public final void updateClientVisible(@NotNull ParticleEmitters emitters) {
        Intrinsics.checkNotNullParameter((Object)emitters, (String)"emitters");
        List list = CooParticlesAPI.INSTANCE.getServer().getPlayerList().getPlayers();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getPlayers(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$getOrPut$iv;
            ServerPlayer p = (ServerPlayer)element$iv;
            boolean bl = false;
            ConcurrentMap concurrentMap = visible;
            UUID key$iv = p.getUUID();
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(key$iv);
            if (object == null) {
                boolean bl2 = false;
                Set default$iv = new HashSet();
                boolean bl3 = false;
                object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            Set visibleSet = (Set)object;
            if (!Intrinsics.areEqual((Object)p.level(), (Object)emitters.getWorld())) {
                if (!visibleSet.contains(emitters)) continue;
                Intrinsics.checkNotNull((Object)p);
                INSTANCE.removeView(p, emitters);
                Set set = visibleSet;
                Intrinsics.checkNotNull((Object)set);
                set.remove(emitters);
                continue;
            }
            if (p.isDeadOrDying()) {
                if (!visibleSet.contains(emitters)) continue;
                Intrinsics.checkNotNull((Object)p);
                INSTANCE.removeView(p, emitters);
                Set set = visibleSet;
                Intrinsics.checkNotNull((Object)set);
                set.remove(emitters);
                continue;
            }
            if (visibleSet.contains(emitters)) continue;
            Intrinsics.checkNotNull((Object)p);
            INSTANCE.addView(p, emitters);
        }
    }

    public final void updateEmitters(@NotNull ParticleEmitters emitters) {
        Intrinsics.checkNotNullParameter((Object)emitters, (String)"emitters");
        Iterable $this$forEach$iv = this.filterVisiblePlayer(emitters);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player player;
            UUID it = (UUID)element$iv;
            boolean bl = false;
            Level level = emitters.getWorld();
            Intrinsics.checkNotNull((Object)level);
            if (level.getPlayerByUUID(it) == null) continue;
            FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
            emitters.getCodec().encode((Object)buf, (Object)emitters);
            PacketParticleEmittersS2C packet = new PacketParticleEmittersS2C(buf, emitters.getEmittersID(), PacketParticleEmittersS2C.PacketType.CHANGE_OR_CREATE);
            CustomPacketPayload customPacketPayload = packet;
            Intrinsics.checkNotNull((Object)player, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
            CooParticlesServices.SERVER_NETWORK.send(customPacketPayload, (ServerPlayer)player);
        }
    }

    public final void sendChange(@NotNull ParticleEmitters emitters, @NotNull ServerPlayer to) {
        Intrinsics.checkNotNullParameter((Object)emitters, (String)"emitters");
        Intrinsics.checkNotNullParameter((Object)to, (String)"to");
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        emitters.getCodec().encode((Object)buf, (Object)emitters);
        PacketParticleEmittersS2C packet = new PacketParticleEmittersS2C(buf, emitters.getEmittersID(), PacketParticleEmittersS2C.PacketType.CHANGE_OR_CREATE);
        CooParticlesServices.SERVER_NETWORK.send(packet, to);
    }

    private final void addView(ServerPlayer player, ParticleEmitters emitters) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        emitters.getCodec().encode((Object)buf, (Object)emitters);
        PacketParticleEmittersS2C packet = new PacketParticleEmittersS2C(buf, emitters.getEmittersID(), PacketParticleEmittersS2C.PacketType.CHANGE_OR_CREATE);
        CooParticlesServices.SERVER_NETWORK.send(packet, player);
    }

    public final void clearAllVisible() {
        Map map;
        Map $this$onEach$iv = clientEmitters;
        boolean $i$f$onEach = false;
        Map $this$onEach_u24lambda_u242$iv = map = $this$onEach$iv;
        boolean bl = false;
        Iterator iterator = $this$onEach_u24lambda_u242$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry it = element$iv = iterator.next();
            boolean bl2 = false;
            ((ParticleEmitters)it.getValue()).setCancelled(true);
        }
        ((ConcurrentHashMap)map).clear();
    }

    private final void removeView(ServerPlayer player, ParticleEmitters emitters) {
        FriendlyByteBuf buf = new FriendlyByteBuf(Unpooled.buffer());
        emitters.getCodec().encode((Object)buf, (Object)emitters);
        PacketParticleEmittersS2C packet = new PacketParticleEmittersS2C(buf, emitters.getEmittersID(), PacketParticleEmittersS2C.PacketType.REMOVE);
        CooParticlesServices.SERVER_NETWORK.send(packet, player);
    }

    public final void init$cooparticlesapi_neoforge_1_21_1() {
        this.register(PhysicsParticleEmitters.Companion.getID(), PhysicsParticleEmitters.Companion.getCODEC());
        this.register(SimpleParticleEmitters.Companion.getID(), SimpleParticleEmitters.Companion.getCODEC());
        StreamCodec<FriendlyByteBuf, ParticleEmitters> streamCodec = ExampleClassParticleEmitters.Companion.getCODEC();
        Intrinsics.checkNotNullExpressionValue(streamCodec, (String)"<get-CODEC>(...)");
        this.register("example-class-particle-emitters", streamCodec);
        StreamCodec<FriendlyByteBuf, ParticleEmitters> streamCodec2 = ExplodeClassParticleEmitters.Companion.getCODEC();
        Intrinsics.checkNotNullExpressionValue(streamCodec2, (String)"<get-CODEC>(...)");
        this.register("explode-class-particle-emitters", streamCodec2);
        StreamCodec<FriendlyByteBuf, ParticleEmitters> streamCodec3 = LightningClassParticleEmitters.Companion.getCODEC();
        Intrinsics.checkNotNullExpressionValue(streamCodec3, (String)"<get-CODEC>(...)");
        this.register("lightning-class-particle-emitters", streamCodec3);
        StreamCodec<FriendlyByteBuf, ParticleEmitters> streamCodec4 = DefendClassParticleEmitters.Companion.getCODEC();
        Intrinsics.checkNotNullExpressionValue(streamCodec4, (String)"<get-CODEC>(...)");
        this.register("defend-class-particle-emitters", streamCodec4);
        StreamCodec<FriendlyByteBuf, ParticleEmitters> streamCodec5 = PresetTestEmitters.Companion.getCODEC();
        Intrinsics.checkNotNullExpressionValue(streamCodec5, (String)"<get-CODEC>(...)");
        this.register("preset-test-emitters", streamCodec5);
        StreamCodec<FriendlyByteBuf, ParticleEmitters> streamCodec6 = FireClassParticleEmitters.Companion.getCODEC();
        Intrinsics.checkNotNullExpressionValue(streamCodec6, (String)"<get-CODEC>(...)");
        this.register("fire-class-particle-emitters", streamCodec6);
        StreamCodec<FriendlyByteBuf, ParticleEmitters> streamCodec7 = PresetLaserEmitters.Companion.getCODEC();
        Intrinsics.checkNotNullExpressionValue(streamCodec7, (String)"<get-CODEC>(...)");
        this.register("coo-particles-api-preset-laser-emitters", streamCodec7);
        StreamCodec<FriendlyByteBuf, ParticleEmitters> streamCodec8 = TestEventEmitter.Companion.getCODEC();
        Intrinsics.checkNotNullExpressionValue(streamCodec8, (String)"<get-CODEC>(...)");
        this.register("test-event-particle-emitters", streamCodec8);
        this.register("test-particle-emitters", TestEmitter.Companion.getCODEC());
    }
}

