/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.network.particle.emitters.environment.wind;

import cn.coostack.cooparticlesapi.network.particle.emitters.environment.wind.BallWindDirection;
import cn.coostack.cooparticlesapi.network.particle.emitters.environment.wind.BoxWindDirection;
import cn.coostack.cooparticlesapi.network.particle.emitters.environment.wind.GlobalWindDirection;
import cn.coostack.cooparticlesapi.network.particle.emitters.environment.wind.WindDirection;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J8\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\u00172\b\b\u0002\u0010\u001a\u001a\u00020\u0013J\u001a\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u001c\u001a\u00020\u0006J.\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00072\u0006\u0010\u001c\u001a\u00020\u00062\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007J\u0006\u0010\u001f\u001a\u00020 RB\u0010\u0004\u001a6\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u00070\u0005j\u001a\u0012\u0004\u0012\u00020\u0006\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007`\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u001d\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\r\u00a8\u0006!"}, d2={"Lcn/coostack/cooparticlesapi/network/particle/emitters/environment/wind/WindDirections;", "", "<init>", "()V", "packets", "Ljava/util/HashMap;", "", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/FriendlyByteBuf;", "Lcn/coostack/cooparticlesapi/network/particle/emitters/environment/wind/WindDirection;", "Lkotlin/collections/HashMap;", "GLOBAL", "getGLOBAL", "()Lnet/minecraft/network/codec/StreamCodec;", "BOX", "getBOX", "BALL", "getBALL", "handleWindForce", "Lnet/minecraft/world/phys/Vec3;", "wind", "pos", "airDensity", "", "dragCoefficient", "crossSectionalArea", "v", "getCodecFromID", "id", "register", "codec", "init", "", "cooparticlesapi-neoforge-1.21.1"})
public final class WindDirections {
    @NotNull
    public static final WindDirections INSTANCE = new WindDirections();
    @NotNull
    private static final HashMap<String, StreamCodec<FriendlyByteBuf, WindDirection>> packets = new HashMap();
    @NotNull
    private static final StreamCodec<FriendlyByteBuf, WindDirection> GLOBAL;
    @NotNull
    private static final StreamCodec<FriendlyByteBuf, WindDirection> BOX;
    @NotNull
    private static final StreamCodec<FriendlyByteBuf, WindDirection> BALL;

    private WindDirections() {
    }

    @NotNull
    public final StreamCodec<FriendlyByteBuf, WindDirection> getGLOBAL() {
        return GLOBAL;
    }

    @NotNull
    public final StreamCodec<FriendlyByteBuf, WindDirection> getBOX() {
        return BOX;
    }

    @NotNull
    public final StreamCodec<FriendlyByteBuf, WindDirection> getBALL() {
        return BALL;
    }

    @NotNull
    public final Vec3 handleWindForce(@NotNull WindDirection wind, @NotNull Vec3 pos, double airDensity, double dragCoefficient, double crossSectionalArea, @NotNull Vec3 v) {
        Vec3 vec3;
        Intrinsics.checkNotNullParameter((Object)wind, (String)"wind");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)v, (String)"v");
        if (!wind.inRange(pos)) {
            Vec3 vec32 = Vec3.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"ZERO");
            return vec32;
        }
        Vec3 windVec = wind.getWind(pos);
        if (windVec.lengthSqr() > 0.0) {
            Vec3 relativeWind = windVec.subtract(v);
            double windMagnitude = 0.5 * airDensity * dragCoefficient * crossSectionalArea * relativeWind.lengthSqr() * 0.05;
            Vec3 vec33 = relativeWind.normalize().scale(windMagnitude);
            Intrinsics.checkNotNull((Object)vec33);
            vec3 = vec33;
        } else {
            Vec3 vec34 = Vec3.ZERO;
            Intrinsics.checkNotNull((Object)vec34);
            vec3 = vec34;
        }
        return vec3;
    }

    public static /* synthetic */ Vec3 handleWindForce$default(WindDirections windDirections, WindDirection windDirection, Vec3 vec3, double d, double d2, double d3, Vec3 vec32, int n, Object object) {
        if ((n & 0x20) != 0) {
            Vec3 vec33 = Vec3.ZERO;
            Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"ZERO");
            vec32 = vec33;
        }
        return windDirections.handleWindForce(windDirection, vec3, d, d2, d3, vec32);
    }

    @NotNull
    public final StreamCodec<FriendlyByteBuf, WindDirection> getCodecFromID(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        StreamCodec<FriendlyByteBuf, WindDirection> streamCodec = packets.get(id);
        Intrinsics.checkNotNull(streamCodec);
        return streamCodec;
    }

    @NotNull
    public final StreamCodec<FriendlyByteBuf, WindDirection> register(@NotNull String id, @NotNull StreamCodec<FriendlyByteBuf, WindDirection> codec) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter(codec, (String)"codec");
        ((Map)packets).put(id, codec);
        return codec;
    }

    public final void init() {
    }

    static {
        StreamCodec<FriendlyByteBuf, WindDirection> streamCodec = GlobalWindDirection.Companion.getCODEC();
        Intrinsics.checkNotNullExpressionValue(streamCodec, (String)"<get-CODEC>(...)");
        GLOBAL = INSTANCE.register("global", streamCodec);
        StreamCodec<FriendlyByteBuf, WindDirection> streamCodec2 = BoxWindDirection.Companion.getCODEC();
        Intrinsics.checkNotNullExpressionValue(streamCodec2, (String)"<get-CODEC>(...)");
        BOX = INSTANCE.register("box", streamCodec2);
        StreamCodec<FriendlyByteBuf, WindDirection> streamCodec3 = BallWindDirection.Companion.getCODEC();
        Intrinsics.checkNotNullExpressionValue(streamCodec3, (String)"<get-CODEC>(...)");
        BALL = INSTANCE.register("ball", streamCodec3);
    }
}

