/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.network.particle.emitters.impl;

import cn.coostack.cooparticlesapi.extend.BlockPosExtendsKt;
import cn.coostack.cooparticlesapi.network.particle.emitters.ControlableParticleData;
import cn.coostack.cooparticlesapi.network.particle.emitters.ParticleEmitters;
import cn.coostack.cooparticlesapi.network.particle.emitters.ParticleEmittersManager;
import cn.coostack.cooparticlesapi.network.particle.emitters.environment.wind.GlobalWindDirection;
import cn.coostack.cooparticlesapi.network.particle.emitters.environment.wind.WindDirection;
import cn.coostack.cooparticlesapi.network.particle.emitters.environment.wind.WindDirections;
import cn.coostack.cooparticlesapi.network.particle.emitters.event.ParticleEventHandler;
import cn.coostack.cooparticlesapi.network.particle.emitters.event.ParticleEventHandlerManager;
import cn.coostack.cooparticlesapi.network.particle.emitters.event.ParticleHitEntityEvent;
import cn.coostack.cooparticlesapi.network.particle.emitters.event.ParticleOnGroundEvent;
import cn.coostack.cooparticlesapi.network.particle.emitters.event.ParticleOnLiquidEvent;
import cn.coostack.cooparticlesapi.network.particle.emitters.type.EmittersShootType;
import cn.coostack.cooparticlesapi.network.particle.emitters.type.EmittersShootTypes;
import cn.coostack.cooparticlesapi.particles.ControlableParticle;
import cn.coostack.cooparticlesapi.particles.ControlableParticleEffect;
import cn.coostack.cooparticlesapi.particles.ParticleDisplayer;
import cn.coostack.cooparticlesapi.particles.control.ControlParticleManager;
import cn.coostack.cooparticlesapi.particles.control.ParticleControler;
import cn.coostack.cooparticlesapi.utils.RelativeLocation;
import com.ezylang.evalex.Expression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u0084\u00012\u00020\u0001:\u0002\u0084\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u00101\u001a\u000202H\u0016J\u0018\u00109\u001a\u00020:2\u0006\u0010;\u001a\u0002062\u0006\u0010<\u001a\u00020)H\u0016J\u0016\u0010=\u001a\u00020:2\f\u0010>\u001a\b\u0012\u0004\u0012\u0002060?H\u0002J\u000e\u0010@\u001a\b\u0012\u0004\u0012\u0002060AH\u0002J\u0006\u0010v\u001a\u00020:J\b\u0010w\u001a\u00020:H\u0016J\b\u0010x\u001a\u00020:H\u0016J\b\u0010\u0016\u001a\u00020:H\u0016J\u0018\u0010y\u001a\u00020:2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010z\u001a\u00020{H\u0016J \u0010y\u001a\u00020:2\u0006\u0010\u0004\u001a\u00020|2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010}\u001a\u00020\u0007H\u0002J\u0018\u0010~\u001a\u00020:2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010}\u001a\u00020\u0007H\u0002J\u0011\u0010\u007f\u001a\u00020:2\u0007\u0010\u0080\u0001\u001a\u00020\u0001H\u0016J\u0017\u0010\u0081\u0001\u001a\u0010\u0012\u0005\u0012\u00030\u0083\u0001\u0012\u0004\u0012\u00020\u00010\u0082\u0001H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0017X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\u00020\u0017X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0019\"\u0004\b\u001e\u0010\u001bR\u001a\u0010\u001f\u001a\u00020\u0017X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010\u0019\"\u0004\b!\u0010\u001bR\u001a\u0010\"\u001a\u00020#X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020)X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u001a\u0010.\u001a\u00020)X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u0010+\"\u0004\b0\u0010-R)\u00103\u001a\u001a\u0012\u0004\u0012\u000202\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000206\u0012\u0004\u0012\u00020)0504\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108R\u001a\u0010B\u001a\u00020CX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010E\"\u0004\bF\u0010GR\u001a\u0010H\u001a\u000202X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bI\u0010J\"\u0004\bK\u0010LR\u001a\u0010M\u001a\u000202X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bN\u0010J\"\u0004\bO\u0010LR\u001a\u0010P\u001a\u000202X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010J\"\u0004\bR\u0010LR\u001a\u0010S\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bT\u0010\u000b\"\u0004\bU\u0010\rR\u001a\u0010V\u001a\u00020WX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bX\u0010Y\"\u0004\bZ\u0010[R\u0011\u0010\\\u001a\u00020]\u00a2\u0006\b\n\u0000\u001a\u0004\b^\u0010_R\u001a\u0010`\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\ba\u0010\u0019\"\u0004\bb\u0010\u001bR\u001a\u0010c\u001a\u00020\u0017X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bd\u0010\u0019\"\u0004\be\u0010\u001bR\u001a\u0010f\u001a\u00020WX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bg\u0010Y\"\u0004\bh\u0010[R\u001a\u0010i\u001a\u00020jX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bk\u0010l\"\u0004\bm\u0010nR\u001a\u0010o\u001a\u00020WX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bp\u0010Y\"\u0004\bq\u0010[R\u000e\u0010r\u001a\u00020sX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010t\u001a\u00020sX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010u\u001a\u00020sX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0085\u0001"}, d2={"Lcn/coostack/cooparticlesapi/network/particle/emitters/impl/PhysicsParticleEmitters;", "Lcn/coostack/cooparticlesapi/network/particle/emitters/ParticleEmitters;", "pos", "Lnet/minecraft/world/phys/Vec3;", "world", "Lnet/minecraft/world/level/Level;", "templateData", "Lcn/coostack/cooparticlesapi/network/particle/emitters/ControlableParticleData;", "<init>", "(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/level/Level;Lcn/coostack/cooparticlesapi/network/particle/emitters/ControlableParticleData;)V", "getPos", "()Lnet/minecraft/world/phys/Vec3;", "setPos", "(Lnet/minecraft/world/phys/Vec3;)V", "getWorld", "()Lnet/minecraft/world/level/Level;", "setWorld", "(Lnet/minecraft/world/level/Level;)V", "getTemplateData", "()Lcn/coostack/cooparticlesapi/network/particle/emitters/ControlableParticleData;", "setTemplateData", "(Lcn/coostack/cooparticlesapi/network/particle/emitters/ControlableParticleData;)V", "tick", "", "getTick", "()I", "setTick", "(I)V", "maxTick", "getMaxTick", "setMaxTick", "delay", "getDelay", "setDelay", "uuid", "Ljava/util/UUID;", "getUuid", "()Ljava/util/UUID;", "setUuid", "(Ljava/util/UUID;)V", "cancelled", "", "getCancelled", "()Z", "setCancelled", "(Z)V", "playing", "getPlaying", "setPlaying", "getEmittersID", "", "handlerList", "Ljava/util/concurrent/ConcurrentHashMap;", "Ljava/util/SortedMap;", "Lcn/coostack/cooparticlesapi/network/particle/emitters/event/ParticleEventHandler;", "getHandlerList", "()Ljava/util/concurrent/ConcurrentHashMap;", "addEventHandler", "", "handler", "innerClass", "addEventHandlerList", "list", "", "collectEventHandles", "", "shootType", "Lcn/coostack/cooparticlesapi/network/particle/emitters/type/EmittersShootType;", "getShootType", "()Lcn/coostack/cooparticlesapi/network/particle/emitters/type/EmittersShootType;", "setShootType", "(Lcn/coostack/cooparticlesapi/network/particle/emitters/type/EmittersShootType;)V", "evalEmittersXWithT", "getEvalEmittersXWithT", "()Ljava/lang/String;", "setEvalEmittersXWithT", "(Ljava/lang/String;)V", "evalEmittersYWithT", "getEvalEmittersYWithT", "setEvalEmittersYWithT", "evalEmittersZWithT", "getEvalEmittersZWithT", "setEvalEmittersZWithT", "offset", "getOffset", "setOffset", "gravity", "", "getGravity", "()D", "setGravity", "(D)V", "random", "Ljava/util/Random;", "getRandom", "()Ljava/util/Random;", "count", "getCount", "setCount", "countRandom", "getCountRandom", "setCountRandom", "airDensity", "getAirDensity", "setAirDensity", "wind", "Lcn/coostack/cooparticlesapi/network/particle/emitters/environment/wind/WindDirection;", "getWind", "()Lcn/coostack/cooparticlesapi/network/particle/emitters/environment/wind/WindDirection;", "setWind", "(Lcn/coostack/cooparticlesapi/network/particle/emitters/environment/wind/WindDirection;)V", "mass", "getMass", "setMass", "bufferX", "Lcom/ezylang/evalex/Expression;", "bufferY", "bufferZ", "setup", "start", "stop", "spawnParticle", "lerpProgress", "", "Lnet/minecraft/client/multiplayer/ClientLevel;", "data", "updatePhysics", "update", "emitters", "getCodec", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/FriendlyByteBuf;", "Companion", "cooparticlesapi-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nPhysicsParticleEmitters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PhysicsParticleEmitters.kt\ncn/coostack/cooparticlesapi/network/particle/emitters/impl/PhysicsParticleEmitters\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,467:1\n72#2,2:468\n72#2,2:472\n1#3:470\n1#3:474\n1869#4:471\n1870#4:475\n1011#4,2:477\n1869#4,2:493\n1869#4,2:495\n216#5:476\n217#5:479\n77#5:480\n97#5,2:481\n99#5,3:490\n536#6:483\n521#6,6:484\n*S KotlinDebug\n*F\n+ 1 PhysicsParticleEmitters.kt\ncn/coostack/cooparticlesapi/network/particle/emitters/impl/PhysicsParticleEmitters\n*L\n58#1:468,2\n70#1:472,2\n58#1:470\n70#1:474\n64#1:471\n64#1:475\n74#1:477,2\n294#1:493,2\n149#1:495,2\n73#1:476\n73#1:479\n79#1:480\n79#1:481,2\n79#1:490,3\n81#1:483\n81#1:484,6\n*E\n"})
public final class PhysicsParticleEmitters
implements ParticleEmitters {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Vec3 pos;
    @Nullable
    private Level world;
    @NotNull
    private ControlableParticleData templateData;
    private int tick;
    private int maxTick;
    private int delay;
    @NotNull
    private UUID uuid;
    private boolean cancelled;
    private boolean playing;
    @NotNull
    private final ConcurrentHashMap<String, SortedMap<ParticleEventHandler, Boolean>> handlerList;
    @NotNull
    private EmittersShootType shootType;
    @NotNull
    private String evalEmittersXWithT;
    @NotNull
    private String evalEmittersYWithT;
    @NotNull
    private String evalEmittersZWithT;
    @NotNull
    private Vec3 offset;
    private double gravity;
    @NotNull
    private final Random random;
    private int count;
    private int countRandom;
    private double airDensity;
    @NotNull
    private WindDirection wind;
    private double mass;
    @NotNull
    private Expression bufferX;
    @NotNull
    private Expression bufferY;
    @NotNull
    private Expression bufferZ;
    public static final double EARTH_GRAVITY = 0.05;
    public static final double SEA_AIR_DENSITY = 1.225;
    public static final double DRAG_COEFFICIENT = 0.01;
    public static final double CROSS_SECTIONAL_AREA = 0.01;
    @NotNull
    private static final String ID = "physics-emitters";
    @NotNull
    private static final StreamCodec<FriendlyByteBuf, ParticleEmitters> CODEC;

    public PhysicsParticleEmitters(@NotNull Vec3 pos, @Nullable Level world, @NotNull ControlableParticleData templateData) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)templateData, (String)"templateData");
        this.pos = pos;
        this.world = world;
        this.templateData = templateData;
        this.maxTick = 120;
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        this.uuid = uUID;
        this.handlerList = new ConcurrentHashMap();
        this.shootType = EmittersShootTypes.point();
        this.evalEmittersXWithT = "0";
        this.evalEmittersYWithT = "0";
        this.evalEmittersZWithT = "0";
        this.offset = new Vec3(0.0, 0.0, 0.0);
        this.random = new Random(System.currentTimeMillis());
        this.count = 1;
        Vec3 vec3 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        this.wind = new GlobalWindDirection(vec3);
        this.mass = 1.0;
        this.bufferX = new Expression(this.evalEmittersXWithT);
        this.bufferY = new Expression(this.evalEmittersYWithT);
        this.bufferZ = new Expression(this.evalEmittersZWithT);
    }

    @Override
    @NotNull
    public Vec3 getPos() {
        return this.pos;
    }

    @Override
    public void setPos(@NotNull Vec3 vec3) {
        Intrinsics.checkNotNullParameter((Object)vec3, (String)"<set-?>");
        this.pos = vec3;
    }

    @Override
    @Nullable
    public Level getWorld() {
        return this.world;
    }

    @Override
    public void setWorld(@Nullable Level level) {
        this.world = level;
    }

    @NotNull
    public final ControlableParticleData getTemplateData() {
        return this.templateData;
    }

    public final void setTemplateData(@NotNull ControlableParticleData controlableParticleData) {
        Intrinsics.checkNotNullParameter((Object)controlableParticleData, (String)"<set-?>");
        this.templateData = controlableParticleData;
    }

    @Override
    public int getTick() {
        return this.tick;
    }

    @Override
    public void setTick(int n) {
        this.tick = n;
    }

    @Override
    public int getMaxTick() {
        return this.maxTick;
    }

    @Override
    public void setMaxTick(int n) {
        this.maxTick = n;
    }

    @Override
    public int getDelay() {
        return this.delay;
    }

    @Override
    public void setDelay(int n) {
        this.delay = n;
    }

    @Override
    @NotNull
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public void setUuid(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
        this.uuid = uUID;
    }

    @Override
    public boolean getCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean bl) {
        this.cancelled = bl;
    }

    @Override
    public boolean getPlaying() {
        return this.playing;
    }

    @Override
    public void setPlaying(boolean bl) {
        this.playing = bl;
    }

    @Override
    @NotNull
    public String getEmittersID() {
        return ID;
    }

    @NotNull
    public final ConcurrentHashMap<String, SortedMap<ParticleEventHandler, Boolean>> getHandlerList() {
        return this.handlerList;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addEventHandler(@NotNull ParticleEventHandler handler, boolean innerClass) {
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        String handlerID = handler.getHandlerID();
        if (!ParticleEventHandlerManager.INSTANCE.hasRegister(handlerID)) {
            ParticleEventHandlerManager.INSTANCE.register(handler);
        }
        String eventID = handler.getTargetEventID();
        ConcurrentMap concurrentMap = this.handlerList;
        String key$iv = eventID;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            SortedMap default$iv = new TreeMap();
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        SortedMap handlerList = (SortedMap)object;
        Intrinsics.checkNotNull((Object)handlerList);
        ((Map)handlerList).put(handler, innerClass);
    }

    /*
     * WARNING - void declaration
     */
    private final void addEventHandlerList(List<ParticleEventHandler> list) {
        Object element$iv;
        HashMap dirtyLists = new HashMap();
        Object $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        Iterator<Object> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            void $this$getOrPut$iv;
            element$iv = iterator.next();
            ParticleEventHandler handler = (ParticleEventHandler)element$iv;
            boolean bl = false;
            String handlerID = handler.getHandlerID();
            if (!ParticleEventHandlerManager.INSTANCE.hasRegister(handlerID)) {
                ParticleEventHandlerManager.INSTANCE.register(handler);
            }
            String eventID = handler.getTargetEventID();
            ConcurrentMap concurrentMap = this.handlerList;
            String key$iv = eventID;
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(key$iv);
            if (object == null) {
                boolean bl2 = false;
                SortedMap default$iv = new TreeMap();
                boolean bl3 = false;
                object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            SortedMap handlerList = (SortedMap)object;
            Intrinsics.checkNotNull((Object)handlerList);
            ((Map)handlerList).put(handler, false);
        }
        $this$forEach$iv = dirtyLists;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object it = element$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            List $this$sortBy$iv = (List)it.getValue();
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() <= 1) continue;
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ParticleEventHandler it = (ParticleEventHandler)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getPriority());
                    it = (ParticleEventHandler)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPriority()));
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<ParticleEventHandler> collectEventHandles() {
        void $this$flatMapTo$iv$iv;
        Map $this$flatMap$iv = this.handlerList;
        boolean $i$f$flatMap = false;
        Map map = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$filterTo$iv$iv;
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            Map $this$filter$iv = (Map)it.getValue();
            boolean $i$f$filter = false;
            Map map2 = $this$filter$iv;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv$iv2;
                Map.Entry it2 = element$iv$iv2 = iterator2.next();
                boolean bl2 = false;
                if (!((Boolean)it2.getValue() == false)) continue;
                destination$iv$iv2.put(element$iv$iv2.getKey(), element$iv$iv2.getValue());
            }
            Iterable list$iv$iv = destination$iv$iv2.keySet();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final EmittersShootType getShootType() {
        return this.shootType;
    }

    public final void setShootType(@NotNull EmittersShootType emittersShootType) {
        Intrinsics.checkNotNullParameter((Object)emittersShootType, (String)"<set-?>");
        this.shootType = emittersShootType;
    }

    @NotNull
    public final String getEvalEmittersXWithT() {
        return this.evalEmittersXWithT;
    }

    public final void setEvalEmittersXWithT(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.evalEmittersXWithT = string;
    }

    @NotNull
    public final String getEvalEmittersYWithT() {
        return this.evalEmittersYWithT;
    }

    public final void setEvalEmittersYWithT(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.evalEmittersYWithT = string;
    }

    @NotNull
    public final String getEvalEmittersZWithT() {
        return this.evalEmittersZWithT;
    }

    public final void setEvalEmittersZWithT(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.evalEmittersZWithT = string;
    }

    @NotNull
    public final Vec3 getOffset() {
        return this.offset;
    }

    public final void setOffset(@NotNull Vec3 vec3) {
        Intrinsics.checkNotNullParameter((Object)vec3, (String)"<set-?>");
        this.offset = vec3;
    }

    public final double getGravity() {
        return this.gravity;
    }

    public final void setGravity(double d) {
        this.gravity = d;
    }

    @NotNull
    public final Random getRandom() {
        return this.random;
    }

    public final int getCount() {
        return this.count;
    }

    public final void setCount(int n) {
        this.count = n;
    }

    public final int getCountRandom() {
        return this.countRandom;
    }

    public final void setCountRandom(int n) {
        this.countRandom = n;
    }

    public final double getAirDensity() {
        return this.airDensity;
    }

    public final void setAirDensity(double d) {
        this.airDensity = d;
    }

    @NotNull
    public final WindDirection getWind() {
        return this.wind;
    }

    public final void setWind(@NotNull WindDirection windDirection) {
        Intrinsics.checkNotNullParameter((Object)windDirection, (String)"<set-?>");
        this.wind = windDirection;
    }

    public final double getMass() {
        return this.mass;
    }

    public final void setMass(double d) {
        this.mass = d;
    }

    public final void setup() {
        this.bufferX = new Expression(this.evalEmittersXWithT);
        this.bufferY = new Expression(this.evalEmittersYWithT);
        this.bufferZ = new Expression(this.evalEmittersZWithT);
    }

    @Override
    public void start() {
        this.wind.loadEmitters(this);
        if (this.getPlaying()) {
            return;
        }
        this.setPlaying(true);
    }

    @Override
    public void stop() {
        this.setCancelled(true);
        Level level = this.getWorld();
        boolean bl = level != null ? !level.isClientSide : false;
        if (bl) {
            ParticleEmittersManager.INSTANCE.updateEmitters(this);
        }
    }

    @Override
    public void tick() {
        if (this.getCancelled() || !this.getPlaying()) {
            return;
        }
        int n = this.getTick();
        this.setTick(n + 1);
        if (n >= this.getMaxTick() && this.getMaxTick() != -1) {
            this.stop();
            return;
        }
        this.offset = new Vec3(this.bufferX.with("t", (Object)this.getTick()).evaluate().getNumberValue().doubleValue(), this.bufferY.with("t", (Object)this.getTick()).evaluate().getNumberValue().doubleValue(), this.bufferZ.with("t", (Object)this.getTick()).evaluate().getNumberValue().doubleValue());
        if (this.getWorld() == null) {
            return;
        }
        Level level = this.getWorld();
        Intrinsics.checkNotNull((Object)level);
        if (!level.isClientSide) {
            return;
        }
        if (this.getTick() % Math.max(1, this.getDelay()) == 0) {
            this.spawnParticle(this.getPos(), 1.0f);
        }
    }

    @Override
    public void spawnParticle(@NotNull Vec3 pos, float lerpProgress) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Level level = this.getWorld();
        Intrinsics.checkNotNull((Object)level);
        if (!level.isClientSide) {
            return;
        }
        Level level2 = this.getWorld();
        Intrinsics.checkNotNull((Object)level2, (String)"null cannot be cast to non-null type net.minecraft.client.multiplayer.ClientLevel");
        ClientLevel world = (ClientLevel)level2;
        Vec3 currentPos = pos.add(this.offset);
        int actualCount = this.count + (this.countRandom != 0 ? this.random.nextInt(this.countRandom) : 0);
        Intrinsics.checkNotNull((Object)currentPos);
        List<Vec3> actualPositions = this.shootType.getPositions(currentPos, this.getTick(), actualCount);
        Iterable $this$forEach$iv = actualPositions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Vec3 it = (Vec3)element$iv;
            boolean bl = false;
            ControlableParticleData newData = this.templateData.clone();
            Vec3 v = this.shootType.getDefaultDirection(newData.getVelocity(), this.getTick(), it, currentPos).normalize().scale(newData.getSpeed());
            Intrinsics.checkNotNull((Object)v);
            newData.setVelocity(v);
            this.spawnParticle(world, it, newData);
        }
    }

    private final void spawnParticle(ClientLevel world, Vec3 pos, ControlableParticleData data) {
        ControlableParticleEffect effect = data.getEffect();
        UUID uUID = data.getUuid();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-uuid>(...)");
        effect.setControlUUID(uUID);
        ParticleDisplayer displayer = ParticleDisplayer.Companion.withSingle(effect);
        ParticleControler control = ControlParticleManager.INSTANCE.createControl(effect.getControlUUID());
        control.setInitInvoker((Function1<? super ControlableParticle, Unit>)((Function1)arg_0 -> PhysicsParticleEmitters.spawnParticle$lambda$8(data, arg_0)));
        control.addPreTickAction((Function1<? super ControlableParticle, Unit>)((Function1)arg_0 -> PhysicsParticleEmitters.spawnParticle$lambda$9(world, arg_0)));
        control.addPreTickAction((Function1<? super ControlableParticle, Unit>)((Function1)arg_0 -> PhysicsParticleEmitters.spawnParticle$lambda$12(this, world, data, arg_0)));
        control.addPreTickAction((Function1<? super ControlableParticle, Unit>)((Function1)arg_0 -> PhysicsParticleEmitters.spawnParticle$lambda$13(this, data, arg_0)));
        control.addPreTickAction((Function1<? super ControlableParticle, Unit>)((Function1)arg_0 -> PhysicsParticleEmitters.spawnParticle$lambda$14(this, control, world, data, arg_0)));
        control.addPreTickAction((Function1<? super ControlableParticle, Unit>)((Function1)arg_0 -> PhysicsParticleEmitters.spawnParticle$lambda$15(data, this, arg_0)));
        displayer.display(pos, world);
    }

    private final void updatePhysics(Vec3 pos, ControlableParticleData data) {
        Vec3 airResistanceForce;
        double m = this.mass / (double)1000;
        Vec3 v = data.getVelocity();
        double speed = v.length();
        Vec3 gravityForce = new Vec3(0.0, -m * this.gravity, 0.0);
        if (speed > 0.01) {
            double dragMagnitude = 0.5 * this.airDensity * 0.01 * 0.01 * Math.pow(speed, 2) * 0.05;
            v0 = v.normalize().scale(-dragMagnitude);
        } else {
            v0 = airResistanceForce = Vec3.ZERO;
        }
        if (!this.wind.hasLoadedEmitters()) {
            this.wind.loadEmitters(this);
        }
        Vec3 windForce = WindDirections.INSTANCE.handleWindForce(this.wind, pos, this.airDensity, 0.01, 0.01, v);
        Vec3 a = gravityForce.add(airResistanceForce).add(windForce).scale(1.0 / m);
        Vec3 vec3 = v.add(a);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
        data.setVelocity(vec3);
    }

    @Override
    public void update(@NotNull ParticleEmitters emitters) {
        Intrinsics.checkNotNullParameter((Object)emitters, (String)"emitters");
        if (!(emitters instanceof PhysicsParticleEmitters)) {
            return;
        }
        this.setTick(((PhysicsParticleEmitters)emitters).getTick());
        this.setMaxTick(((PhysicsParticleEmitters)emitters).getMaxTick());
        this.setDelay(((PhysicsParticleEmitters)emitters).getDelay());
        this.setPlaying(((PhysicsParticleEmitters)emitters).getPlaying());
        this.setCancelled(((PhysicsParticleEmitters)emitters).getCancelled());
        this.templateData = ((PhysicsParticleEmitters)emitters).templateData;
        this.handlerList.putAll((Map<String, SortedMap<ParticleEventHandler, Boolean>>)((PhysicsParticleEmitters)emitters).handlerList);
        this.setPos(((PhysicsParticleEmitters)emitters).getPos());
    }

    @Override
    @NotNull
    public StreamCodec<FriendlyByteBuf, ParticleEmitters> getCodec() {
        return CODEC;
    }

    @Override
    @NotNull
    public ParticleEmitters getValue() {
        return ParticleEmitters.super.getValue();
    }

    @Override
    public void remove() {
        ParticleEmitters.super.remove();
    }

    @Override
    public void spawn(@NotNull Level world, @NotNull Vec3 pos) {
        ParticleEmitters.super.spawn(world, pos);
    }

    @Override
    public void rotateParticlesAsAxis(double angle) {
        ParticleEmitters.super.rotateParticlesAsAxis(angle);
    }

    @Override
    public void rotateParticlesToPoint(@NotNull RelativeLocation to) {
        ParticleEmitters.super.rotateParticlesToPoint(to);
    }

    @Override
    public void rotateToWithAngle(@NotNull RelativeLocation to, double angle) {
        ParticleEmitters.super.rotateToWithAngle(to, angle);
    }

    @Override
    public void teleportTo(@NotNull Vec3 to) {
        ParticleEmitters.super.teleportTo(to);
    }

    @Override
    public void teleportTo(double x, double y, double z) {
        ParticleEmitters.super.teleportTo(x, y, z);
    }

    private static final Unit spawnParticle$lambda$8(ControlableParticleData $data, ControlableParticle controlableParticle) {
        Intrinsics.checkNotNullParameter((Object)((Object)controlableParticle), (String)"<this>");
        controlableParticle.setSize($data.getSize());
        controlableParticle.setColor($data.getColor());
        controlableParticle.setCurrentAge($data.getAge());
        controlableParticle.setLifetime($data.getMaxAge());
        controlableParticle.setTextureSheet($data.getTextureSheet());
        controlableParticle.setParticleAlpha($data.getAlpha());
        return Unit.INSTANCE;
    }

    private static final Unit spawnParticle$lambda$9(ClientLevel $world, ControlableParticle $this$addPreTickAction) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$addPreTickAction), (String)"$this$addPreTickAction");
        if ($this$addPreTickAction.getMinecraftTick()) {
            return Unit.INSTANCE;
        }
        if ($this$addPreTickAction.getBounding().hasNaN()) {
            return Unit.INSTANCE;
        }
        BlockPos blockPos = BlockPosExtendsKt.ofFloored($this$addPreTickAction.getLoc());
        Vec3 vec3 = $this$addPreTickAction.getLoc().subtract($this$addPreTickAction.getBounding().maxX - $this$addPreTickAction.getBounding().minX, $this$addPreTickAction.getBounding().maxY - $this$addPreTickAction.getBounding().minY, $this$addPreTickAction.getBounding().maxZ - $this$addPreTickAction.getBounding().minZ);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"subtract(...)");
        BlockPos down = BlockPosExtendsKt.ofFloored(vec3);
        if ($world.getChunk(blockPos) == null || $world.getChunk(down) == null) {
            return Unit.INSTANCE;
        }
        BlockState statusPos = $world.getBlockState(blockPos);
        BlockState statusDown = $world.getBlockState(down);
        $this$addPreTickAction.setOnTheGround(!statusDown.getCollisionShape((BlockGetter)$world, down).isEmpty() || !statusPos.getCollisionShape((BlockGetter)$world, blockPos).isEmpty());
        return Unit.INSTANCE;
    }

    private static final boolean spawnParticle$lambda$12$lambda$10(Entity it) {
        return true;
    }

    private static final boolean spawnParticle$lambda$12$lambda$11(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit spawnParticle$lambda$12(PhysicsParticleEmitters this$0, ClientLevel $world, ControlableParticleData $data, ControlableParticle $this$addPreTickAction) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$addPreTickAction), (String)"$this$addPreTickAction");
        SortedMap<ParticleEventHandler, Boolean> sortedMap = this$0.handlerList.get("ParticleHitEntityEvent");
        if (sortedMap == null) {
            return Unit.INSTANCE;
        }
        SortedMap<ParticleEventHandler, Boolean> hitEntityHandlers = sortedMap;
        if (hitEntityHandlers.isEmpty()) {
            return Unit.INSTANCE;
        }
        List entities = $world.getEntities(null, $this$addPreTickAction.getBounding(), arg_0 -> PhysicsParticleEmitters.spawnParticle$lambda$12$lambda$11(PhysicsParticleEmitters::spawnParticle$lambda$12$lambda$10, arg_0));
        if (entities.isEmpty()) {
            return Unit.INSTANCE;
        }
        Intrinsics.checkNotNull((Object)entities);
        Entity first = (Entity)CollectionsKt.first((List)entities);
        Intrinsics.checkNotNull((Object)first);
        ParticleHitEntityEvent event = new ParticleHitEntityEvent($this$addPreTickAction, $data, first);
        Iterator iterator = ((Map)hitEntityHandlers).entrySet().iterator();
        while (iterator.hasNext()) {
            ParticleEventHandler handler = (ParticleEventHandler)iterator.next().getKey();
            if (!Intrinsics.areEqual((Object)handler.getTargetEventID(), (Object)"ParticleHitEntityEvent")) continue;
            handler.handle(event);
            if (!event.getCanceled()) continue;
            break;
        }
        return Unit.INSTANCE;
    }

    private static final Unit spawnParticle$lambda$13(PhysicsParticleEmitters this$0, ControlableParticleData $data, ControlableParticle $this$addPreTickAction) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$addPreTickAction), (String)"$this$addPreTickAction");
        SortedMap<ParticleEventHandler, Boolean> sortedMap = this$0.handlerList.get("ParticleOnGroundEvent");
        if (sortedMap == null) {
            return Unit.INSTANCE;
        }
        SortedMap<ParticleEventHandler, Boolean> hitEntityHandlers = sortedMap;
        if (hitEntityHandlers.isEmpty()) {
            return Unit.INSTANCE;
        }
        if (!$this$addPreTickAction.getOnTheGround()) {
            return Unit.INSTANCE;
        }
        ParticleOnGroundEvent event = new ParticleOnGroundEvent($this$addPreTickAction, $data, BlockPosExtendsKt.ofFloored($this$addPreTickAction.getLoc()));
        Iterator iterator = ((Map)hitEntityHandlers).entrySet().iterator();
        while (iterator.hasNext()) {
            ParticleEventHandler handler = (ParticleEventHandler)iterator.next().getKey();
            if (!Intrinsics.areEqual((Object)handler.getTargetEventID(), (Object)"ParticleOnGroundEvent")) continue;
            handler.handle(event);
            if (!event.getCanceled()) continue;
            break;
        }
        return Unit.INSTANCE;
    }

    private static final Unit spawnParticle$lambda$14(PhysicsParticleEmitters this$0, ParticleControler $control, ClientLevel $world, ControlableParticleData $data, ControlableParticle $this$addPreTickAction) {
        boolean beforeLiquid;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$addPreTickAction), (String)"$this$addPreTickAction");
        SortedMap<ParticleEventHandler, Boolean> sortedMap = this$0.handlerList.get("ParticleOnLiquidEvent");
        if (sortedMap == null) {
            return Unit.INSTANCE;
        }
        SortedMap<ParticleEventHandler, Boolean> hitEntityHandlers = sortedMap;
        if (hitEntityHandlers.isEmpty()) {
            return Unit.INSTANCE;
        }
        BlockPos blockPos = BlockPosExtendsKt.ofFloored($this$addPreTickAction.getLoc());
        Object object = $control.getBufferedData().get("cross_liquid");
        Boolean bl = object instanceof Boolean ? (Boolean)object : null;
        boolean bl2 = beforeLiquid = bl != null ? bl : false;
        if (!$world.shouldTickBlocksAt(blockPos)) {
            return Unit.INSTANCE;
        }
        BlockState state = $world.getBlockState(blockPos);
        boolean currentLiquid = !state.isSolid();
        ((Map)$control.getBufferedData()).put("cross_liquid", currentLiquid);
        if (beforeLiquid || !currentLiquid) {
            return Unit.INSTANCE;
        }
        ParticleOnLiquidEvent event = new ParticleOnLiquidEvent($this$addPreTickAction, $data, blockPos);
        Iterator iterator = ((Map)hitEntityHandlers).entrySet().iterator();
        while (iterator.hasNext()) {
            ParticleEventHandler handler = (ParticleEventHandler)iterator.next().getKey();
            if (!Intrinsics.areEqual((Object)handler.getTargetEventID(), (Object)"ParticleOnLiquidEvent")) continue;
            handler.handle(event);
            if (!event.getCanceled()) continue;
            break;
        }
        return Unit.INSTANCE;
    }

    private static final Unit spawnParticle$lambda$15(ControlableParticleData $data, PhysicsParticleEmitters this$0, ControlableParticle $this$addPreTickAction) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$addPreTickAction), (String)"$this$addPreTickAction");
        Vec3 vec3 = $this$addPreTickAction.getLoc().add($data.getVelocity());
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
        $this$addPreTickAction.teleportTo(vec3);
        this$0.updatePhysics($this$addPreTickAction.getLoc(), $data);
        int n = $this$addPreTickAction.getCurrentAge();
        $this$addPreTickAction.setCurrentAge(n + 1);
        if (n >= $this$addPreTickAction.getLifetime()) {
            $this$addPreTickAction.remove();
        }
        return Unit.INSTANCE;
    }

    private static final void CODEC$lambda$17(FriendlyByteBuf buf, ParticleEmitters data) {
        Intrinsics.checkNotNull((Object)data, (String)"null cannot be cast to non-null type cn.coostack.cooparticlesapi.network.particle.emitters.impl.PhysicsParticleEmitters");
        PhysicsParticleEmitters cfr_ignored_0 = (PhysicsParticleEmitters)data;
        List<ParticleEventHandler> handles = ((PhysicsParticleEmitters)data).collectEventHandles();
        buf.writeInt(handles.size());
        Iterable $this$forEach$iv = handles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ParticleEventHandler it = (ParticleEventHandler)element$iv;
            boolean bl = false;
            String id = it.getHandlerID();
            buf.writeUtf(id);
        }
        buf.writeInt(((PhysicsParticleEmitters)data).count);
        buf.writeInt(((PhysicsParticleEmitters)data).countRandom);
        buf.writeVec3(((PhysicsParticleEmitters)data).getPos());
        buf.writeInt(((PhysicsParticleEmitters)data).getTick());
        buf.writeInt(((PhysicsParticleEmitters)data).getMaxTick());
        buf.writeInt(((PhysicsParticleEmitters)data).getDelay());
        buf.writeUUID(((PhysicsParticleEmitters)data).getUuid());
        buf.writeBoolean(((PhysicsParticleEmitters)data).getPlaying());
        buf.writeBoolean(((PhysicsParticleEmitters)data).getCancelled());
        buf.writeDouble(((PhysicsParticleEmitters)data).gravity);
        buf.writeDouble(((PhysicsParticleEmitters)data).airDensity);
        buf.writeDouble(((PhysicsParticleEmitters)data).mass);
        buf.writeUtf(((PhysicsParticleEmitters)data).wind.getID());
        ((PhysicsParticleEmitters)data).wind.getCodec().encode((Object)buf, (Object)((PhysicsParticleEmitters)data).wind);
        buf.writeUtf(((PhysicsParticleEmitters)data).evalEmittersXWithT, Short.MAX_VALUE);
        buf.writeUtf(((PhysicsParticleEmitters)data).evalEmittersYWithT, Short.MAX_VALUE);
        buf.writeUtf(((PhysicsParticleEmitters)data).evalEmittersZWithT, Short.MAX_VALUE);
        buf.writeVec3(((PhysicsParticleEmitters)data).offset);
        buf.writeUtf(((PhysicsParticleEmitters)data).shootType.getID(), Short.MAX_VALUE);
        ((PhysicsParticleEmitters)data).shootType.getCodec().encode((Object)buf, (Object)((PhysicsParticleEmitters)data).shootType);
        ControlableParticleData.Companion.getPACKET_CODEC().encode((Object)buf, (Object)((PhysicsParticleEmitters)data).templateData);
    }

    private static final ParticleEmitters CODEC$lambda$20(FriendlyByteBuf it) {
        PhysicsParticleEmitters physicsParticleEmitters;
        int handlerCount = it.readInt();
        ArrayList<ParticleEventHandler> handlerList = new ArrayList<ParticleEventHandler>();
        int n = 0;
        while (n < handlerCount) {
            ParticleEventHandler handler;
            int index = n++;
            boolean bl = false;
            String handleID = it.readUtf();
            Intrinsics.checkNotNull((Object)handleID);
            Intrinsics.checkNotNull((Object)ParticleEventHandlerManager.INSTANCE.getHandlerById(handleID));
            handlerList.add(handler);
        }
        int count = it.readInt();
        int countRandom = it.readInt();
        Vec3 pos = it.readVec3();
        int tick = it.readInt();
        int maxTick = it.readInt();
        int delay = it.readInt();
        UUID uuid = it.readUUID();
        boolean play = it.readBoolean();
        boolean cancelled = it.readBoolean();
        double gravity = it.readDouble();
        double airDensity = it.readDouble();
        double mass = it.readDouble();
        String windID = it.readUtf();
        Intrinsics.checkNotNull((Object)windID);
        StreamCodec<FriendlyByteBuf, WindDirection> from = WindDirections.INSTANCE.getCodecFromID(windID);
        WindDirection wind = (WindDirection)from.decode((Object)it);
        String xE = it.readUtf(Short.MAX_VALUE);
        String yE = it.readUtf(Short.MAX_VALUE);
        String zE = it.readUtf(Short.MAX_VALUE);
        Vec3 offset = it.readVec3();
        String typeID = it.readUtf(Short.MAX_VALUE);
        Intrinsics.checkNotNull((Object)typeID);
        StreamCodec<FriendlyByteBuf, EmittersShootType> streamCodec = EmittersShootTypes.INSTANCE.fromID(typeID);
        Intrinsics.checkNotNull(streamCodec);
        StreamCodec<FriendlyByteBuf, EmittersShootType> codec = streamCodec;
        EmittersShootType type = (EmittersShootType)codec.decode((Object)it);
        ControlableParticleData templateData = (ControlableParticleData)ControlableParticleData.Companion.getPACKET_CODEC().decode((Object)it);
        Intrinsics.checkNotNull((Object)pos);
        Intrinsics.checkNotNull((Object)templateData);
        PhysicsParticleEmitters $this$CODEC_u24lambda_u2420_u24lambda_u2419 = physicsParticleEmitters = new PhysicsParticleEmitters(pos, null, templateData);
        boolean bl = false;
        $this$CODEC_u24lambda_u2420_u24lambda_u2419.count = count;
        $this$CODEC_u24lambda_u2420_u24lambda_u2419.countRandom = countRandom;
        $this$CODEC_u24lambda_u2420_u24lambda_u2419.setTick(tick);
        Intrinsics.checkNotNull((Object)type);
        $this$CODEC_u24lambda_u2420_u24lambda_u2419.shootType = type;
        $this$CODEC_u24lambda_u2420_u24lambda_u2419.setMaxTick(maxTick);
        $this$CODEC_u24lambda_u2420_u24lambda_u2419.setDelay(delay);
        Intrinsics.checkNotNull((Object)uuid);
        $this$CODEC_u24lambda_u2420_u24lambda_u2419.setUuid(uuid);
        $this$CODEC_u24lambda_u2420_u24lambda_u2419.setPlaying(play);
        $this$CODEC_u24lambda_u2420_u24lambda_u2419.setCancelled(cancelled);
        $this$CODEC_u24lambda_u2420_u24lambda_u2419.gravity = gravity;
        $this$CODEC_u24lambda_u2420_u24lambda_u2419.airDensity = airDensity;
        Intrinsics.checkNotNull((Object)wind);
        $this$CODEC_u24lambda_u2420_u24lambda_u2419.wind = wind;
        $this$CODEC_u24lambda_u2420_u24lambda_u2419.mass = mass;
        Intrinsics.checkNotNull((Object)xE);
        $this$CODEC_u24lambda_u2420_u24lambda_u2419.evalEmittersXWithT = xE;
        Intrinsics.checkNotNull((Object)yE);
        $this$CODEC_u24lambda_u2420_u24lambda_u2419.evalEmittersYWithT = yE;
        Intrinsics.checkNotNull((Object)zE);
        $this$CODEC_u24lambda_u2420_u24lambda_u2419.evalEmittersZWithT = zE;
        Intrinsics.checkNotNull((Object)offset);
        $this$CODEC_u24lambda_u2420_u24lambda_u2419.offset = offset;
        $this$CODEC_u24lambda_u2420_u24lambda_u2419.setup();
        return physicsParticleEmitters;
    }

    static {
        StreamCodec streamCodec = StreamCodec.of(PhysicsParticleEmitters::CODEC$lambda$17, PhysicsParticleEmitters::CODEC$lambda$20);
        Intrinsics.checkNotNullExpressionValue((Object)streamCodec, (String)"of(...)");
        CODEC = streamCodec;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0016\u0010\u0004\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0003R\u0016\u0010\u0007\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0003R\u0016\u0010\t\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u0003R\u0016\u0010\u000b\u001a\u00020\u00058\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\f\u0010\u0003R\u0014\u0010\r\u001a\u00020\u000eX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001d\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00140\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcn/coostack/cooparticlesapi/network/particle/emitters/impl/PhysicsParticleEmitters$Companion;", "", "<init>", "()V", "EARTH_GRAVITY", "", "getEARTH_GRAVITY$annotations", "SEA_AIR_DENSITY", "getSEA_AIR_DENSITY$annotations", "DRAG_COEFFICIENT", "getDRAG_COEFFICIENT$annotations", "CROSS_SECTIONAL_AREA", "getCROSS_SECTIONAL_AREA$annotations", "ID", "", "getID", "()Ljava/lang/String;", "CODEC", "Lnet/minecraft/network/codec/StreamCodec;", "Lnet/minecraft/network/FriendlyByteBuf;", "Lcn/coostack/cooparticlesapi/network/particle/emitters/ParticleEmitters;", "getCODEC", "()Lnet/minecraft/network/codec/StreamCodec;", "cooparticlesapi-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @Deprecated(message="use PhysicContent")
        public static /* synthetic */ void getEARTH_GRAVITY$annotations() {
        }

        @Deprecated(message="use PhysicContent")
        public static /* synthetic */ void getSEA_AIR_DENSITY$annotations() {
        }

        @Deprecated(message="use PhysicContent")
        public static /* synthetic */ void getDRAG_COEFFICIENT$annotations() {
        }

        @Deprecated(message="use PhysicContent")
        public static /* synthetic */ void getCROSS_SECTIONAL_AREA$annotations() {
        }

        @NotNull
        public final String getID() {
            return ID;
        }

        @NotNull
        public final StreamCodec<FriendlyByteBuf, ParticleEmitters> getCODEC() {
            return CODEC;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

