/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.mixin;

import cn.coostack.cooparticlesapi.CooParticlesConstants;
import cn.coostack.cooparticlesapi.platform.CooParticlesServices;
import com.google.common.collect.EvictingQueue;
import java.util.Map;
import java.util.Queue;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleEngine;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.core.particles.ParticleGroup;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ParticleEngine.class})
public abstract class ParticleEngineMixin {
    @Final
    @Shadow
    private Map<ParticleRenderType, Queue<Particle>> particles;
    @Final
    @Shadow
    private Queue<Particle> particlesToAdd;

    @Shadow
    protected abstract void updateCount(ParticleGroup var1, int var2);

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Ljava/util/Queue;poll()Ljava/lang/Object;"))
    public Object changeMaxParticles(Queue<Object> queue) {
        Particle particle;
        int limit = CooParticlesServices.API_CONFIG_MANAGER.getConfig().getParticleCountLimit();
        while ((particle = this.particlesToAdd.poll()) != null) {
            Particle poll;
            Queue queue1 = this.particles.computeIfAbsent(particle.getRenderType(), sheet -> EvictingQueue.create((int)limit));
            if (queue1.size() == limit && (poll = (Particle)queue1.poll()) != null) {
                this.cooParticlesAPI$onEvict(poll);
            }
            queue1.add(particle);
        }
        return null;
    }

    @Inject(method={"clearParticles"}, at={@At(value="HEAD")})
    public void onClear(CallbackInfo ci) {
        this.particles.values().forEach(q -> q.forEach(p -> {
            if (p != null) {
                this.cooParticlesAPI$onEvict((Particle)p);
            }
        }));
        this.particlesToAdd.forEach(p -> {
            if (p != null) {
                this.cooParticlesAPI$onEvict((Particle)p);
            }
        });
        CooParticlesConstants.logger.info("ParticleManager: clearParticles invoked");
    }

    @Unique
    private void cooParticlesAPI$onEvict(Particle p) {
        if (p.isAlive()) {
            p.remove();
            p.getParticleGroup().ifPresent(group -> this.updateCount((ParticleGroup)group, -1));
        }
    }
}

