/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.network.particle.emitters;

import cn.coostack.cooparticlesapi.extend.BlockPosExtendsKt;
import cn.coostack.cooparticlesapi.network.particle.emitters.ControlableParticleData;
import cn.coostack.cooparticlesapi.network.particle.emitters.ParticleEmitters;
import cn.coostack.cooparticlesapi.network.particle.emitters.ParticleEmittersManager;
import cn.coostack.cooparticlesapi.network.particle.emitters.environment.wind.GlobalWindDirection;
import cn.coostack.cooparticlesapi.network.particle.emitters.environment.wind.WindDirection;
import cn.coostack.cooparticlesapi.network.particle.emitters.environment.wind.WindDirections;
import cn.coostack.cooparticlesapi.network.particle.emitters.event.ParticleEventHandler;
import cn.coostack.cooparticlesapi.network.particle.emitters.event.ParticleEventHandlerManager;
import cn.coostack.cooparticlesapi.network.particle.emitters.event.ParticleHitEntityEvent;
import cn.coostack.cooparticlesapi.network.particle.emitters.event.ParticleOnGroundEvent;
import cn.coostack.cooparticlesapi.network.particle.emitters.event.ParticleOnLiquidEvent;
import cn.coostack.cooparticlesapi.particles.ControlableParticle;
import cn.coostack.cooparticlesapi.particles.ControlableParticleEffect;
import cn.coostack.cooparticlesapi.particles.ParticleDisplayer;
import cn.coostack.cooparticlesapi.particles.control.ControlParticleManager;
import cn.coostack.cooparticlesapi.particles.control.ParticleControler;
import cn.coostack.cooparticlesapi.utils.RelativeLocation;
import cn.coostack.cooparticlesapi.utils.interpolator.LineInterpolator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0098\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0010\u0006\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b&\u0018\u0000 m2\u00020\u0001:\u0001mB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u0002082\u0006\u0010E\u001a\u00020#H\u0016J\u0016\u0010F\u001a\u00020C2\f\u0010G\u001a\b\u0012\u0004\u0012\u0002080HH\u0002J\u000e\u0010I\u001a\b\u0012\u0004\u0012\u0002080JH\u0002J\b\u0010T\u001a\u00020CH\u0016J\b\u0010U\u001a\u00020CH\u0016J\b\u0010\u0010\u001a\u00020CH\u0016J\b\u0010V\u001a\u00020CH\u0002J\u0018\u0010W\u001a\u00020C2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010X\u001a\u00020YH\u0016J\b\u0010Z\u001a\u00020CH&J\u001a\u0010[\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020]\u0012\u0004\u0012\u00020^0\\0JH&J\u0010\u0010_\u001a\u00020C2\u0006\u0010`\u001a\u00020\u0003H\u0014J8\u0010a\u001a\u00020C2\u0006\u0010b\u001a\u00020c2\u0006\u0010d\u001a\u00020]2\u0006\u0010e\u001a\u00020^2\u0006\u0010f\u001a\u00020\u00052\u0006\u0010g\u001a\u00020Y2\u0006\u0010h\u001a\u00020YH&J0\u0010W\u001a\u00020C2\u0006\u0010\u0004\u001a\u00020i2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010d\u001a\u00020]2\u0006\u0010g\u001a\u00020Y2\u0006\u0010h\u001a\u00020YH\u0002J\u0018\u0010j\u001a\u00020C2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010d\u001a\u00020]H\u0004J\u0010\u0010k\u001a\u00020C2\u0006\u0010l\u001a\u00020\u0001H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0011X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0013\"\u0004\b\u0018\u0010\u0015R\u001a\u0010\u0019\u001a\u00020\u0011X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0013\"\u0004\b\u001b\u0010\u0015R\u001a\u0010\u001c\u001a\u00020\u001dX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u001a\u0010\"\u001a\u00020#X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u001a\u0010(\u001a\u00020#X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010%\"\u0004\b*\u0010'R\u001a\u0010+\u001a\u00020,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001a\u00101\u001a\u00020,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b2\u0010.\"\u0004\b3\u00100R)\u00104\u001a\u001a\u0012\u0004\u0012\u000206\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u000208\u0012\u0004\u0012\u00020#0705\u00a2\u0006\b\n\u0000\u001a\u0004\b9\u0010:R\u001a\u0010;\u001a\u00020#X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b<\u0010%\"\u0004\b=\u0010'R\u0011\u0010>\u001a\u00020?\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010AR\u001a\u0010K\u001a\u00020LX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010N\"\u0004\bO\u0010PR\u001a\u0010Q\u001a\u00020,X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bR\u0010.\"\u0004\bS\u00100\u00a8\u0006n"}, d2={"Lcn/coostack/cooparticlesapi/network/particle/emitters/ClassParticleEmitters;", "Lcn/coostack/cooparticlesapi/network/particle/emitters/ParticleEmitters;", "pos", "Lnet/minecraft/world/phys/Vec3;", "world", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/level/Level;)V", "getPos", "()Lnet/minecraft/world/phys/Vec3;", "setPos", "(Lnet/minecraft/world/phys/Vec3;)V", "getWorld", "()Lnet/minecraft/world/level/Level;", "setWorld", "(Lnet/minecraft/world/level/Level;)V", "tick", "", "getTick", "()I", "setTick", "(I)V", "maxTick", "getMaxTick", "setMaxTick", "delay", "getDelay", "setDelay", "uuid", "Ljava/util/UUID;", "getUuid", "()Ljava/util/UUID;", "setUuid", "(Ljava/util/UUID;)V", "cancelled", "", "getCancelled", "()Z", "setCancelled", "(Z)V", "playing", "getPlaying", "setPlaying", "airDensity", "", "getAirDensity", "()D", "setAirDensity", "(D)V", "gravity", "getGravity", "setGravity", "handlerList", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Ljava/util/SortedMap;", "Lcn/coostack/cooparticlesapi/network/particle/emitters/event/ParticleEventHandler;", "getHandlerList", "()Ljava/util/concurrent/ConcurrentHashMap;", "enableInterpolator", "getEnableInterpolator", "setEnableInterpolator", "emittersInterpolator", "Lcn/coostack/cooparticlesapi/utils/interpolator/LineInterpolator;", "getEmittersInterpolator", "()Lcn/coostack/cooparticlesapi/utils/interpolator/LineInterpolator;", "addEventHandler", "", "handler", "innerClass", "addEventHandlerList", "list", "", "collectEventHandles", "", "wind", "Lcn/coostack/cooparticlesapi/network/particle/emitters/environment/wind/WindDirection;", "getWind", "()Lcn/coostack/cooparticlesapi/network/particle/emitters/environment/wind/WindDirection;", "setWind", "(Lcn/coostack/cooparticlesapi/network/particle/emitters/environment/wind/WindDirection;)V", "mass", "getMass", "setMass", "start", "stop", "increaseTick", "spawnParticle", "lerpProgress", "", "doTick", "genParticles", "Lkotlin/Pair;", "Lcn/coostack/cooparticlesapi/network/particle/emitters/ControlableParticleData;", "Lcn/coostack/cooparticlesapi/utils/RelativeLocation;", "doSubtick", "current", "singleParticleAction", "controler", "Lcn/coostack/cooparticlesapi/particles/control/ParticleControler;", "data", "spawnPos", "spawnWorld", "particleLerpProgress", "posLerpProgress", "Lnet/minecraft/client/multiplayer/ClientLevel;", "updatePhysics", "update", "emitters", "Companion", "cooparticlesapi-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nClassParticleEmitters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassParticleEmitters.kt\ncn/coostack/cooparticlesapi/network/particle/emitters/ClassParticleEmitters\n+ 2 MapsJVM.kt\nkotlin/collections/MapsKt__MapsJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 6 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,460:1\n72#2,2:461\n72#2,2:465\n1#3:463\n1#3:467\n1869#4:464\n1870#4:468\n1011#4,2:470\n1878#4,3:486\n1869#4,2:489\n216#5:469\n217#5:472\n77#5:473\n97#5,2:474\n99#5,3:483\n536#6:476\n521#6,6:477\n*S KotlinDebug\n*F\n+ 1 ClassParticleEmitters.kt\ncn/coostack/cooparticlesapi/network/particle/emitters/ClassParticleEmitters\n*L\n70#1:461,2\n82#1:465,2\n70#1:463\n82#1:467\n76#1:464\n76#1:468\n86#1:470,2\n218#1:486,3\n245#1:489,2\n85#1:469\n85#1:472\n91#1:473\n91#1:474,2\n91#1:483,3\n93#1:476\n93#1:477,6\n*E\n"})
public abstract class ClassParticleEmitters
implements ParticleEmitters {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Vec3 pos;
    @Nullable
    private Level world;
    private int tick;
    private int maxTick;
    private int delay;
    @NotNull
    private UUID uuid;
    private boolean cancelled;
    private boolean playing;
    private double airDensity;
    private double gravity;
    @NotNull
    private final ConcurrentHashMap<String, SortedMap<ParticleEventHandler, Boolean>> handlerList;
    private boolean enableInterpolator;
    @NotNull
    private final LineInterpolator emittersInterpolator;
    @NotNull
    private WindDirection wind;
    private double mass;

    /*
     * WARNING - void declaration
     */
    public ClassParticleEmitters(@NotNull Vec3 pos, @Nullable Level world) {
        void it;
        GlobalWindDirection globalWindDirection;
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        this.pos = pos;
        this.world = world;
        this.maxTick = 120;
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        this.uuid = uUID;
        this.handlerList = new ConcurrentHashMap();
        this.emittersInterpolator = new LineInterpolator().setRefiner(5.0);
        Vec3 vec3 = Vec3.ZERO;
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"ZERO");
        GlobalWindDirection globalWindDirection2 = globalWindDirection = new GlobalWindDirection(vec3);
        ClassParticleEmitters classParticleEmitters = this;
        boolean bl = false;
        it.loadEmitters(this);
        classParticleEmitters.wind = globalWindDirection;
        this.mass = 1.0;
    }

    @Override
    @NotNull
    public Vec3 getPos() {
        return this.pos;
    }

    @Override
    public void setPos(@NotNull Vec3 vec3) {
        Intrinsics.checkNotNullParameter((Object)vec3, (String)"<set-?>");
        this.pos = vec3;
    }

    @Override
    @Nullable
    public Level getWorld() {
        return this.world;
    }

    @Override
    public void setWorld(@Nullable Level level) {
        this.world = level;
    }

    @Override
    public int getTick() {
        return this.tick;
    }

    @Override
    public void setTick(int n) {
        this.tick = n;
    }

    @Override
    public int getMaxTick() {
        return this.maxTick;
    }

    @Override
    public void setMaxTick(int n) {
        this.maxTick = n;
    }

    @Override
    public int getDelay() {
        return this.delay;
    }

    @Override
    public void setDelay(int n) {
        this.delay = n;
    }

    @Override
    @NotNull
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public void setUuid(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
        this.uuid = uUID;
    }

    @Override
    public boolean getCancelled() {
        return this.cancelled;
    }

    @Override
    public void setCancelled(boolean bl) {
        this.cancelled = bl;
    }

    @Override
    public boolean getPlaying() {
        return this.playing;
    }

    @Override
    public void setPlaying(boolean bl) {
        this.playing = bl;
    }

    public final double getAirDensity() {
        return this.airDensity;
    }

    public final void setAirDensity(double d) {
        this.airDensity = d;
    }

    public final double getGravity() {
        return this.gravity;
    }

    public final void setGravity(double d) {
        this.gravity = d;
    }

    @NotNull
    public final ConcurrentHashMap<String, SortedMap<ParticleEventHandler, Boolean>> getHandlerList() {
        return this.handlerList;
    }

    public final boolean getEnableInterpolator() {
        return this.enableInterpolator;
    }

    public final void setEnableInterpolator(boolean bl) {
        this.enableInterpolator = bl;
    }

    @NotNull
    public final LineInterpolator getEmittersInterpolator() {
        return this.emittersInterpolator;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void addEventHandler(@NotNull ParticleEventHandler handler, boolean innerClass) {
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
        String handlerID = handler.getHandlerID();
        if (!ParticleEventHandlerManager.INSTANCE.hasRegister(handlerID)) {
            ParticleEventHandlerManager.INSTANCE.register(handler);
        }
        String eventID = handler.getTargetEventID();
        ConcurrentMap concurrentMap = this.handlerList;
        String key$iv = eventID;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(key$iv);
        if (object == null) {
            boolean bl = false;
            SortedMap default$iv = new TreeMap();
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        SortedMap handlerList = (SortedMap)object;
        Intrinsics.checkNotNull((Object)handlerList);
        ((Map)handlerList).put(handler, innerClass);
    }

    /*
     * WARNING - void declaration
     */
    private final void addEventHandlerList(List<ParticleEventHandler> list) {
        Object element$iv;
        HashMap dirtyLists = new HashMap();
        Object $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        Iterator<Object> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            void $this$getOrPut$iv;
            element$iv = iterator.next();
            ParticleEventHandler handler = (ParticleEventHandler)element$iv;
            boolean bl = false;
            String handlerID = handler.getHandlerID();
            if (!ParticleEventHandlerManager.INSTANCE.hasRegister(handlerID)) {
                ParticleEventHandlerManager.INSTANCE.register(handler);
            }
            String eventID = handler.getTargetEventID();
            ConcurrentMap concurrentMap = this.handlerList;
            String key$iv = eventID;
            boolean $i$f$getOrPut = false;
            Object object = $this$getOrPut$iv.get(key$iv);
            if (object == null) {
                boolean bl2 = false;
                SortedMap default$iv = new TreeMap();
                boolean bl3 = false;
                object = $this$getOrPut$iv.putIfAbsent(key$iv, default$iv);
                if (object == null) {
                    object = default$iv;
                }
            }
            SortedMap handlerList = (SortedMap)object;
            Intrinsics.checkNotNull((Object)handlerList);
            ((Map)handlerList).put(handler, false);
        }
        $this$forEach$iv = dirtyLists;
        $i$f$forEach = false;
        iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Object it = element$iv = (Map.Entry)iterator.next();
            boolean bl = false;
            List $this$sortBy$iv = (List)it.getValue();
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() <= 1) continue;
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    ParticleEventHandler it = (ParticleEventHandler)a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(it.getPriority());
                    it = (ParticleEventHandler)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(it.getPriority()));
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<ParticleEventHandler> collectEventHandles() {
        void $this$flatMapTo$iv$iv;
        Map $this$flatMap$iv = this.handlerList;
        boolean $i$f$flatMap = false;
        Map map = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        Iterator iterator = $this$flatMapTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            void $this$filterTo$iv$iv;
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            Map $this$filter$iv = (Map)it.getValue();
            boolean $i$f$filter = false;
            Map map2 = $this$filter$iv;
            Map destination$iv$iv2 = new LinkedHashMap();
            boolean $i$f$filterTo = false;
            Iterator iterator2 = $this$filterTo$iv$iv.entrySet().iterator();
            while (iterator2.hasNext()) {
                Map.Entry element$iv$iv2;
                Map.Entry it2 = element$iv$iv2 = iterator2.next();
                boolean bl2 = false;
                if (!((Boolean)it2.getValue() == false)) continue;
                destination$iv$iv2.put(element$iv$iv2.getKey(), element$iv$iv2.getValue());
            }
            Iterable list$iv$iv = destination$iv$iv2.keySet();
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final WindDirection getWind() {
        return this.wind;
    }

    public final void setWind(@NotNull WindDirection windDirection) {
        Intrinsics.checkNotNullParameter((Object)windDirection, (String)"<set-?>");
        this.wind = windDirection;
    }

    public final double getMass() {
        return this.mass;
    }

    public final void setMass(double d) {
        this.mass = d;
    }

    @Override
    public void start() {
        if (this.getPlaying()) {
            return;
        }
        this.setPlaying(true);
        Level level = this.getWorld();
        boolean bl = level != null ? !level.isClientSide : false;
        if (bl) {
            ParticleEmittersManager.INSTANCE.updateEmitters(this);
        }
    }

    @Override
    public void stop() {
        this.setCancelled(true);
        Level level = this.getWorld();
        boolean bl = level != null ? !level.isClientSide : false;
        if (bl) {
            ParticleEmittersManager.INSTANCE.updateEmitters(this);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void tick() {
        if (this.getCancelled() || !this.getPlaying()) {
            return;
        }
        if (this.getWorld() == null) {
            return;
        }
        this.doTick();
        Level level = this.getWorld();
        Intrinsics.checkNotNull((Object)level);
        if (!level.isClientSide) {
            this.increaseTick();
            return;
        }
        this.emittersInterpolator.insertPoint(this.getPos());
        if (this.getTick() % Math.max(1, this.getDelay()) == 0) {
            if (this.enableInterpolator) {
                List<RelativeLocation> res = this.emittersInterpolator.getRefinedResult();
                int count = res.size();
                Iterable $this$forEachIndexed$iv = res;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void it;
                    int n;
                    if ((n = index$iv++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    RelativeLocation relativeLocation = (RelativeLocation)item$iv;
                    int index = n;
                    boolean bl = false;
                    Vec3 pos = it.toVector();
                    this.doSubtick(pos);
                    this.spawnParticle(pos, ((float)index + 1.0f) / (float)count);
                }
            } else {
                this.spawnParticle(this.getPos(), 1.0f);
            }
        }
        this.increaseTick();
    }

    private final void increaseTick() {
        this.setTick(this.getTick() + 1);
        if (this.getTick() >= this.getMaxTick() && this.getMaxTick() != -1) {
            this.stop();
        }
    }

    @Override
    public void spawnParticle(@NotNull Vec3 pos, float lerpProgress) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Level level = this.getWorld();
        Intrinsics.checkNotNull((Object)level);
        if (!level.isClientSide) {
            return;
        }
        Level level2 = this.getWorld();
        Intrinsics.checkNotNull((Object)level2, (String)"null cannot be cast to non-null type net.minecraft.client.multiplayer.ClientLevel");
        ClientLevel world = (ClientLevel)level2;
        float spawnedCount = 0.0f;
        List<Pair<ControlableParticleData, RelativeLocation>> particles = this.genParticles();
        int total = particles.size();
        Iterable $this$forEach$iv = particles;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair it = (Pair)element$iv;
            boolean bl = false;
            Vec3 vec3 = pos.add(((RelativeLocation)it.getSecond()).toVector());
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
            this.spawnParticle(world, vec3, (ControlableParticleData)it.getFirst(), (spawnedCount += 1.0f) / (float)total, lerpProgress);
        }
    }

    public abstract void doTick();

    @NotNull
    public abstract List<Pair<ControlableParticleData, RelativeLocation>> genParticles();

    protected void doSubtick(@NotNull Vec3 current) {
        Intrinsics.checkNotNullParameter((Object)current, (String)"current");
    }

    public abstract void singleParticleAction(@NotNull ParticleControler var1, @NotNull ControlableParticleData var2, @NotNull RelativeLocation var3, @NotNull Level var4, float var5, float var6);

    private final void spawnParticle(ClientLevel world, Vec3 pos, ControlableParticleData data, float particleLerpProgress, float posLerpProgress) {
        ControlableParticleEffect effect = data.getEffect();
        UUID uUID = data.getUuid();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-uuid>(...)");
        effect.setControlUUID(uUID);
        ParticleDisplayer displayer = ParticleDisplayer.Companion.withSingle(effect);
        ParticleControler control = ControlParticleManager.INSTANCE.createControl(effect.getControlUUID());
        control.setInitInvoker((Function1<? super ControlableParticle, Unit>)((Function1)arg_0 -> ClassParticleEmitters.spawnParticle$lambda$10(data, arg_0)));
        control.addPreTickAction((Function1<? super ControlableParticle, Unit>)((Function1)arg_0 -> ClassParticleEmitters.spawnParticle$lambda$11(world, arg_0)));
        control.addPreTickAction((Function1<? super ControlableParticle, Unit>)((Function1)arg_0 -> ClassParticleEmitters.spawnParticle$lambda$14(this, world, data, arg_0)));
        control.addPreTickAction((Function1<? super ControlableParticle, Unit>)((Function1)arg_0 -> ClassParticleEmitters.spawnParticle$lambda$15(this, data, arg_0)));
        control.addPreTickAction((Function1<? super ControlableParticle, Unit>)((Function1)arg_0 -> ClassParticleEmitters.spawnParticle$lambda$16(this, control, world, data, arg_0)));
        RelativeLocation p = RelativeLocation.Companion.of(pos);
        this.singleParticleAction(control, data, p, (Level)world, particleLerpProgress, posLerpProgress);
        control.addPreTickAction((Function1<? super ControlableParticle, Unit>)((Function1)arg_0 -> ClassParticleEmitters.spawnParticle$lambda$17(data, arg_0)));
        displayer.display(p.toVector(), world);
    }

    protected final void updatePhysics(@NotNull Vec3 pos, @NotNull ControlableParticleData data) {
        Vec3 airResistanceForce;
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        double m = this.mass / (double)1000;
        Vec3 v = data.getVelocity();
        double speed = v.length();
        Vec3 gravityForce = new Vec3(0.0, -m * this.gravity, 0.0);
        if (speed > 0.01) {
            double dragMagnitude = 0.5 * this.airDensity * 0.01 * 0.01 * Math.pow(speed, 2) * 0.05;
            v0 = v.normalize().scale(-dragMagnitude);
        } else {
            v0 = airResistanceForce = Vec3.ZERO;
        }
        if (!this.wind.hasLoadedEmitters()) {
            this.wind.loadEmitters(this);
        }
        Vec3 windForce = WindDirections.INSTANCE.handleWindForce(this.wind, pos, this.airDensity, 0.01, 0.01, v);
        Vec3 a = gravityForce.add(airResistanceForce).add(windForce).scale(1.0 / m);
        Vec3 vec3 = v.add(a);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
        data.setVelocity(vec3);
    }

    @Override
    public void update(@NotNull ParticleEmitters emitters) {
        Intrinsics.checkNotNullParameter((Object)emitters, (String)"emitters");
        if (!(emitters instanceof ClassParticleEmitters)) {
            return;
        }
        this.setPos(((ClassParticleEmitters)emitters).getPos());
        this.setWorld(((ClassParticleEmitters)emitters).getWorld());
        this.setTick(((ClassParticleEmitters)emitters).getTick());
        this.setMaxTick(((ClassParticleEmitters)emitters).getMaxTick());
        this.setDelay(((ClassParticleEmitters)emitters).getDelay());
        this.setUuid(((ClassParticleEmitters)emitters).getUuid());
        this.setCancelled(((ClassParticleEmitters)emitters).getCancelled());
        this.setPlaying(((ClassParticleEmitters)emitters).getPlaying());
        this.handlerList.putAll((Map<String, SortedMap<ParticleEventHandler, Boolean>>)((ClassParticleEmitters)emitters).handlerList);
    }

    @Override
    @NotNull
    public ParticleEmitters getValue() {
        return ParticleEmitters.super.getValue();
    }

    @Override
    public void remove() {
        ParticleEmitters.super.remove();
    }

    @Override
    public void spawn(@NotNull Level world, @NotNull Vec3 pos) {
        ParticleEmitters.super.spawn(world, pos);
    }

    @Override
    public void rotateParticlesAsAxis(double angle) {
        ParticleEmitters.super.rotateParticlesAsAxis(angle);
    }

    @Override
    public void rotateParticlesToPoint(@NotNull RelativeLocation to) {
        ParticleEmitters.super.rotateParticlesToPoint(to);
    }

    @Override
    public void rotateToWithAngle(@NotNull RelativeLocation to, double angle) {
        ParticleEmitters.super.rotateToWithAngle(to, angle);
    }

    @Override
    public void teleportTo(@NotNull Vec3 to) {
        ParticleEmitters.super.teleportTo(to);
    }

    @Override
    public void teleportTo(double x, double y, double z) {
        ParticleEmitters.super.teleportTo(x, y, z);
    }

    private static final Unit spawnParticle$lambda$10(ControlableParticleData $data, ControlableParticle controlableParticle) {
        Intrinsics.checkNotNullParameter((Object)((Object)controlableParticle), (String)"<this>");
        controlableParticle.setSize($data.getSize());
        controlableParticle.setColor($data.getColor());
        controlableParticle.setCurrentAge($data.getAge());
        controlableParticle.setLifetime($data.getMaxAge());
        controlableParticle.setTextureSheet($data.getTextureSheet());
        controlableParticle.setParticleAlpha($data.getAlpha());
        return Unit.INSTANCE;
    }

    private static final Unit spawnParticle$lambda$11(ClientLevel $world, ControlableParticle $this$addPreTickAction) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$addPreTickAction), (String)"$this$addPreTickAction");
        if ($this$addPreTickAction.getMinecraftTick()) {
            return Unit.INSTANCE;
        }
        if ($this$addPreTickAction.getBounding().hasNaN()) {
            return Unit.INSTANCE;
        }
        BlockPos blockPos = BlockPosExtendsKt.ofFloored($this$addPreTickAction.getLoc());
        Vec3 vec3 = $this$addPreTickAction.getLoc().subtract($this$addPreTickAction.getBounding().maxX - $this$addPreTickAction.getBounding().minX, $this$addPreTickAction.getBounding().maxY - $this$addPreTickAction.getBounding().minY, $this$addPreTickAction.getBounding().maxZ - $this$addPreTickAction.getBounding().minZ);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"subtract(...)");
        BlockPos down = BlockPosExtendsKt.ofFloored(vec3);
        if ($world.getChunk(blockPos) == null || $world.getChunk(down) == null) {
            return Unit.INSTANCE;
        }
        BlockState statusPos = $world.getBlockState(blockPos);
        BlockState statusDown = $world.getBlockState(down);
        $this$addPreTickAction.setOnTheGround(!statusDown.getCollisionShape((BlockGetter)$world, down).isEmpty() || !statusPos.getCollisionShape((BlockGetter)$world, blockPos).isEmpty());
        return Unit.INSTANCE;
    }

    private static final boolean spawnParticle$lambda$14$lambda$12(Entity it) {
        return true;
    }

    private static final boolean spawnParticle$lambda$14$lambda$13(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Unit spawnParticle$lambda$14(ClassParticleEmitters this$0, ClientLevel $world, ControlableParticleData $data, ControlableParticle $this$addPreTickAction) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$addPreTickAction), (String)"$this$addPreTickAction");
        SortedMap<ParticleEventHandler, Boolean> sortedMap = this$0.handlerList.get("ParticleHitEntityEvent");
        if (sortedMap == null) {
            return Unit.INSTANCE;
        }
        SortedMap<ParticleEventHandler, Boolean> hitEntityHandlers = sortedMap;
        if (hitEntityHandlers.isEmpty()) {
            return Unit.INSTANCE;
        }
        List entities = $world.getEntitiesOfClass(Entity.class, $this$addPreTickAction.getBounding().expandTowards(0.5, 0.5, 0.5), arg_0 -> ClassParticleEmitters.spawnParticle$lambda$14$lambda$13(ClassParticleEmitters::spawnParticle$lambda$14$lambda$12, arg_0));
        if (entities.isEmpty()) {
            return Unit.INSTANCE;
        }
        Intrinsics.checkNotNull((Object)entities);
        Entity first = (Entity)CollectionsKt.first((List)entities);
        Intrinsics.checkNotNull((Object)first);
        ParticleHitEntityEvent event = new ParticleHitEntityEvent($this$addPreTickAction, $data, first);
        Iterator iterator = ((Map)hitEntityHandlers).entrySet().iterator();
        while (iterator.hasNext()) {
            ParticleEventHandler handler = (ParticleEventHandler)iterator.next().getKey();
            if (!Intrinsics.areEqual((Object)handler.getTargetEventID(), (Object)"ParticleHitEntityEvent")) continue;
            handler.handle(event);
            if (!event.getCanceled()) continue;
            break;
        }
        return Unit.INSTANCE;
    }

    private static final Unit spawnParticle$lambda$15(ClassParticleEmitters this$0, ControlableParticleData $data, ControlableParticle $this$addPreTickAction) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$addPreTickAction), (String)"$this$addPreTickAction");
        SortedMap<ParticleEventHandler, Boolean> sortedMap = this$0.handlerList.get("ParticleOnGroundEvent");
        if (sortedMap == null) {
            return Unit.INSTANCE;
        }
        SortedMap<ParticleEventHandler, Boolean> hitEntityHandlers = sortedMap;
        if (hitEntityHandlers.isEmpty()) {
            return Unit.INSTANCE;
        }
        if (!$this$addPreTickAction.getOnTheGround()) {
            return Unit.INSTANCE;
        }
        ParticleOnGroundEvent event = new ParticleOnGroundEvent($this$addPreTickAction, $data, BlockPosExtendsKt.ofFloored($this$addPreTickAction.getLoc()));
        Iterator iterator = ((Map)hitEntityHandlers).entrySet().iterator();
        while (iterator.hasNext()) {
            ParticleEventHandler handler = (ParticleEventHandler)iterator.next().getKey();
            if (!Intrinsics.areEqual((Object)handler.getTargetEventID(), (Object)"ParticleOnGroundEvent")) continue;
            handler.handle(event);
            if (!event.getCanceled()) continue;
            break;
        }
        return Unit.INSTANCE;
    }

    private static final Unit spawnParticle$lambda$16(ClassParticleEmitters this$0, ParticleControler $control, ClientLevel $world, ControlableParticleData $data, ControlableParticle $this$addPreTickAction) {
        boolean beforeLiquid;
        Intrinsics.checkNotNullParameter((Object)((Object)$this$addPreTickAction), (String)"$this$addPreTickAction");
        SortedMap<ParticleEventHandler, Boolean> sortedMap = this$0.handlerList.get("ParticleOnLiquidEvent");
        if (sortedMap == null) {
            return Unit.INSTANCE;
        }
        SortedMap<ParticleEventHandler, Boolean> hitEntityHandlers = sortedMap;
        if (hitEntityHandlers.isEmpty()) {
            return Unit.INSTANCE;
        }
        BlockPos blockPos = BlockPosExtendsKt.ofFloored($this$addPreTickAction.getLoc());
        Object object = $control.getBufferedData().get("cross_liquid");
        Boolean bl = object instanceof Boolean ? (Boolean)object : null;
        boolean bl2 = beforeLiquid = bl != null ? bl : false;
        if (!$world.shouldTickBlocksAt(blockPos)) {
            return Unit.INSTANCE;
        }
        BlockState state = $world.getBlockState(blockPos);
        boolean currentLiquid = !state.isSolid();
        ((Map)$control.getBufferedData()).put("cross_liquid", currentLiquid);
        if (beforeLiquid || !currentLiquid) {
            return Unit.INSTANCE;
        }
        ParticleOnLiquidEvent event = new ParticleOnLiquidEvent($this$addPreTickAction, $data, blockPos);
        Iterator iterator = ((Map)hitEntityHandlers).entrySet().iterator();
        while (iterator.hasNext()) {
            ParticleEventHandler handler = (ParticleEventHandler)iterator.next().getKey();
            if (!Intrinsics.areEqual((Object)handler.getTargetEventID(), (Object)"ParticleOnLiquidEvent")) continue;
            handler.handle(event);
            if (!event.getCanceled()) continue;
            break;
        }
        return Unit.INSTANCE;
    }

    private static final Unit spawnParticle$lambda$17(ControlableParticleData $data, ControlableParticle $this$addPreTickAction) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$addPreTickAction), (String)"$this$addPreTickAction");
        Vec3 vec3 = $this$addPreTickAction.getLoc().add($data.getVelocity());
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
        $this$addPreTickAction.teleportTo(vec3);
        int n = $this$addPreTickAction.getCurrentAge();
        $this$addPreTickAction.setCurrentAge(n + 1);
        if (n >= $this$addPreTickAction.getLifetime()) {
            $this$addPreTickAction.remove();
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u0016\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\f"}, d2={"Lcn/coostack/cooparticlesapi/network/particle/emitters/ClassParticleEmitters$Companion;", "", "<init>", "()V", "encodeBase", "", "data", "Lcn/coostack/cooparticlesapi/network/particle/emitters/ClassParticleEmitters;", "buf", "Lnet/minecraft/network/FriendlyByteBuf;", "decodeBase", "container", "cooparticlesapi-neoforge-1.21.1"})
    @SourceDebugExtension(value={"SMAP\nClassParticleEmitters.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassParticleEmitters.kt\ncn/coostack/cooparticlesapi/network/particle/emitters/ClassParticleEmitters$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,460:1\n1869#2,2:461\n*S KotlinDebug\n*F\n+ 1 ClassParticleEmitters.kt\ncn/coostack/cooparticlesapi/network/particle/emitters/ClassParticleEmitters$Companion\n*L\n104#1:461,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final void encodeBase(@NotNull ClassParticleEmitters data, @NotNull FriendlyByteBuf buf) {
            Intrinsics.checkNotNullParameter((Object)data, (String)"data");
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            List handles = data.collectEventHandles();
            buf.writeInt(handles.size());
            Iterable $this$forEach$iv = handles;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                ParticleEventHandler it = (ParticleEventHandler)element$iv;
                boolean bl = false;
                String id = it.getHandlerID();
                buf.writeUtf(id);
            }
            buf.writeVec3(data.getPos());
            buf.writeInt(data.getTick());
            buf.writeInt(data.getMaxTick());
            buf.writeInt(data.getDelay());
            buf.writeUUID(data.getUuid());
            buf.writeBoolean(data.getCancelled());
            buf.writeBoolean(data.getPlaying());
            buf.writeDouble(data.getGravity());
            buf.writeDouble(data.getAirDensity());
            buf.writeDouble(data.getMass());
            buf.writeBoolean(data.getEnableInterpolator());
            buf.writeUtf(data.getWind().getID());
            data.getWind().getCodec().encode((Object)buf, (Object)data.getWind());
        }

        public final void decodeBase(@NotNull ClassParticleEmitters container, @NotNull FriendlyByteBuf buf) {
            ClassParticleEmitters classParticleEmitters;
            Intrinsics.checkNotNullParameter((Object)container, (String)"container");
            Intrinsics.checkNotNullParameter((Object)buf, (String)"buf");
            int handlerCount = buf.readInt();
            ArrayList<ParticleEventHandler> handlerList = new ArrayList<ParticleEventHandler>();
            int n = 0;
            while (n < handlerCount) {
                ParticleEventHandler handler;
                int it = n++;
                boolean bl = false;
                String handleID = buf.readUtf();
                Intrinsics.checkNotNull((Object)handleID);
                Intrinsics.checkNotNull((Object)ParticleEventHandlerManager.INSTANCE.getHandlerById(handleID));
                handlerList.add(handler);
            }
            container.addEventHandlerList(handlerList);
            Vec3 pos = buf.readVec3();
            int tick = buf.readInt();
            int maxTick = buf.readInt();
            int delay = buf.readInt();
            UUID uuid = buf.readUUID();
            boolean canceled = buf.readBoolean();
            boolean playing = buf.readBoolean();
            double gravity = buf.readDouble();
            double airDensity = buf.readDouble();
            double mass = buf.readDouble();
            boolean enableInterpolator = buf.readBoolean();
            String id = buf.readUtf();
            Intrinsics.checkNotNull((Object)id);
            WindDirection wind = (WindDirection)WindDirections.INSTANCE.getCodecFromID(id).decode((Object)buf);
            ClassParticleEmitters $this$decodeBase_u24lambda_u242 = classParticleEmitters = container;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)pos);
            $this$decodeBase_u24lambda_u242.setPos(pos);
            $this$decodeBase_u24lambda_u242.setTick(tick);
            $this$decodeBase_u24lambda_u242.setMaxTick(maxTick);
            $this$decodeBase_u24lambda_u242.setDelay(delay);
            Intrinsics.checkNotNull((Object)uuid);
            $this$decodeBase_u24lambda_u242.setUuid(uuid);
            $this$decodeBase_u24lambda_u242.setCancelled(canceled);
            $this$decodeBase_u24lambda_u242.setAirDensity(airDensity);
            $this$decodeBase_u24lambda_u242.setGravity(gravity);
            $this$decodeBase_u24lambda_u242.setMass(mass);
            $this$decodeBase_u24lambda_u242.setPlaying(playing);
            $this$decodeBase_u24lambda_u242.setAirDensity(airDensity);
            Intrinsics.checkNotNull((Object)wind);
            $this$decodeBase_u24lambda_u242.setWind(wind);
            $this$decodeBase_u24lambda_u242.setEnableInterpolator(enableInterpolator);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

