/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.test.barrier;

import cn.coostack.cooparticlesapi.barrages.AbstractBarrage;
import cn.coostack.cooparticlesapi.barrages.BarrageHitResult;
import cn.coostack.cooparticlesapi.barrages.BarrageOption;
import cn.coostack.cooparticlesapi.barrages.HitBox;
import cn.coostack.cooparticlesapi.network.particle.ServerParticleGroup;
import java.util.Collection;
import java.util.List;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\u0006\u0010\u000f\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u000eH\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020 H\u0002J\u0016\u0010!\u001a\u00020\u001a2\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u000e0#H\u0002R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u000f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006$"}, d2={"Lcn/coostack/cooparticlesapi/test/barrier/SwordBarrage;", "Lcn/coostack/cooparticlesapi/barrages/AbstractBarrage;", "loc", "Lnet/minecraft/world/phys/Vec3;", "world", "Lnet/minecraft/server/level/ServerLevel;", "hitBox", "Lcn/coostack/cooparticlesapi/barrages/HitBox;", "bindControl", "Lcn/coostack/cooparticlesapi/network/particle/ServerParticleGroup;", "options", "Lcn/coostack/cooparticlesapi/barrages/BarrageOption;", "filter", "Ljava/util/function/Predicate;", "Lnet/minecraft/world/entity/LivingEntity;", "searchBox", "<init>", "(Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/server/level/ServerLevel;Lcn/coostack/cooparticlesapi/barrages/HitBox;Lcn/coostack/cooparticlesapi/network/particle/ServerParticleGroup;Lcn/coostack/cooparticlesapi/barrages/BarrageOption;Ljava/util/function/Predicate;Lcn/coostack/cooparticlesapi/barrages/HitBox;)V", "getFilter", "()Ljava/util/function/Predicate;", "getSearchBox", "()Lcn/coostack/cooparticlesapi/barrages/HitBox;", "filterHitEntity", "", "livingEntity", "tick", "", "onHit", "result", "Lcn/coostack/cooparticlesapi/barrages/BarrageHitResult;", "handleBlock", "hit", "Lnet/minecraft/world/level/block/state/BlockState;", "handleEntities", "entities", "", "cooparticlesapi-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nSwordBarrage.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SwordBarrage.kt\ncn/coostack/cooparticlesapi/test/barrier/SwordBarrage\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,106:1\n1869#2,2:107\n*S KotlinDebug\n*F\n+ 1 SwordBarrage.kt\ncn/coostack/cooparticlesapi/test/barrier/SwordBarrage\n*L\n79#1:107,2\n*E\n"})
public final class SwordBarrage
extends AbstractBarrage {
    @NotNull
    private final Predicate<LivingEntity> filter;
    @NotNull
    private final HitBox searchBox;

    public SwordBarrage(@NotNull Vec3 loc, @NotNull ServerLevel world, @NotNull HitBox hitBox, @NotNull ServerParticleGroup bindControl, @NotNull BarrageOption options, @NotNull Predicate<LivingEntity> filter, @NotNull HitBox searchBox) {
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)hitBox, (String)"hitBox");
        Intrinsics.checkNotNullParameter((Object)bindControl, (String)"bindControl");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Intrinsics.checkNotNullParameter(filter, (String)"filter");
        Intrinsics.checkNotNullParameter((Object)searchBox, (String)"searchBox");
        super(loc, world, hitBox, bindControl, options);
        this.filter = filter;
        this.searchBox = searchBox;
    }

    @NotNull
    public final Predicate<LivingEntity> getFilter() {
        return this.filter;
    }

    @NotNull
    public final HitBox getSearchBox() {
        return this.searchBox;
    }

    @Override
    public boolean filterHitEntity(@NotNull LivingEntity livingEntity) {
        Intrinsics.checkNotNullParameter((Object)livingEntity, (String)"livingEntity");
        return this.filter.test(livingEntity);
    }

    @Override
    public void tick() {
        super.tick();
        List entities = this.getWorld().getEntitiesOfClass(LivingEntity.class, this.searchBox.ofBox(this.getLoc()), this.filter);
        LivingEntity closestEntity = null;
        for (LivingEntity entity : entities) {
            if (closestEntity == null) {
                closestEntity = entity;
                continue;
            }
            if (!(this.getLoc().distanceTo(closestEntity.position()) > this.getLoc().distanceTo(entity.position()))) continue;
            closestEntity = entity;
        }
        if (closestEntity == null) {
            return;
        }
        Vec3 vec3 = closestEntity.position().subtract(this.getLoc()).normalize().scale(0.5);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"scale(...)");
        this.setDirection(vec3);
    }

    @Override
    public void onHit(@NotNull BarrageHitResult result) {
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        BlockState hitBlock = result.getHitBlockState();
        if (hitBlock != null) {
            this.handleBlock(hitBlock);
        }
        if (!((Collection)result.getEntities()).isEmpty()) {
            this.handleEntities((List<? extends LivingEntity>)result.getEntities());
        }
    }

    private final void handleBlock(BlockState hit) {
        LivingEntity livingEntity = this.getShooter();
        this.getWorld().explode((Entity)this.getShooter(), (DamageSource)(livingEntity != null ? livingEntity.getLastDamageSource() : null), new ExplosionDamageCalculator(), this.getLoc().x, this.getLoc().y, this.getLoc().z, 3.0f, false, Level.ExplosionInteraction.TRIGGER);
    }

    private final void handleEntities(List<? extends LivingEntity> entities) {
        float attackAmount = 10.0f;
        Iterable $this$forEach$iv = entities;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            boolean bl;
            LivingEntity entity = (LivingEntity)element$iv;
            boolean bl2 = false;
            entity.setLastHurtByMob(this.getShooter());
            if (this.getShooter() != null) {
                DamageSource damageSource;
                if (this.getShooter() instanceof Player) {
                    DamageSources damageSources = entity.damageSources();
                    LivingEntity livingEntity = this.getShooter();
                    Intrinsics.checkNotNull((Object)livingEntity, (String)"null cannot be cast to non-null type net.minecraft.world.entity.player.Player");
                    damageSource = damageSources.playerAttack((Player)livingEntity);
                } else {
                    DamageSources damageSources = entity.damageSources();
                    LivingEntity livingEntity = this.getShooter();
                    Intrinsics.checkNotNull((Object)livingEntity);
                    damageSource = damageSources.mobAttack(livingEntity);
                }
                DamageSource sources = damageSource;
                bl = entity.hurt(sources, attackAmount);
                continue;
            }
            bl = entity.hurt(this.getWorld().damageSources().generic(), attackAmount);
        }
        LivingEntity livingEntity = this.getShooter();
        this.getWorld().explode((Entity)this.getShooter(), (DamageSource)(livingEntity != null ? livingEntity.getLastDamageSource() : null), new ExplosionDamageCalculator(), this.getLoc().x, this.getLoc().y, this.getLoc().z, 3.0f, false, Level.ExplosionInteraction.TRIGGER);
    }
}

