/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.test.particle.client;

import cn.coostack.cooparticlesapi.network.buffer.ParticleControlerDataBuffer;
import cn.coostack.cooparticlesapi.particles.ControlableParticle;
import cn.coostack.cooparticlesapi.particles.ParticleDisplayer;
import cn.coostack.cooparticlesapi.particles.control.group.ControlableParticleGroup;
import cn.coostack.cooparticlesapi.particles.control.group.ControlableParticleGroupProvider;
import cn.coostack.cooparticlesapi.particles.impl.ControlableEndRodEffect;
import cn.coostack.cooparticlesapi.utils.Math3DUtil;
import cn.coostack.cooparticlesapi.utils.RelativeLocation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0006\n\u0002\b\u000b\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001.B\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0014\u0010&\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u00020)0'H\u0016J\u000e\u0010*\u001a\b\u0012\u0004\u0012\u00020)0+H\u0002J\b\u0010,\u001a\u00020-H\u0016R\u001e\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\f\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0011\"\u0004\b\u0016\u0010\u0013R\u001a\u0010\u0017\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0011\"\u0004\b\u0019\u0010\u0013R\u001a\u0010\u001a\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010 \u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b!\u0010\u0011\"\u0004\b\"\u0010\u0013R\u001a\u0010#\u001a\u00020\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b$\u0010\u001d\"\u0004\b%\u0010\u001f\u00a8\u0006/"}, d2={"Lcn/coostack/cooparticlesapi/test/particle/client/BarrierSwordGroupClient;", "Lcn/coostack/cooparticlesapi/particles/control/group/ControlableParticleGroup;", "uuid", "Ljava/util/UUID;", "targetEntityID", "", "<init>", "(Ljava/util/UUID;Ljava/lang/Integer;)V", "getTargetEntityID", "()Ljava/lang/Integer;", "setTargetEntityID", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "defaultDirection", "Lnet/minecraft/world/phys/Vec3;", "hilt", "getHilt", "()I", "setHilt", "(I)V", "swordBody", "getSwordBody", "setSwordBody", "swordHeadLen", "getSwordHeadLen", "setSwordHeadLen", "bodySize", "", "getBodySize", "()D", "setBodySize", "(D)V", "tail", "getTail", "setTail", "step", "getStep", "setStep", "loadParticleLocations", "", "Lcn/coostack/cooparticlesapi/particles/control/group/ControlableParticleGroup$ParticleRelativeData;", "Lcn/coostack/cooparticlesapi/utils/RelativeLocation;", "genSword", "", "onGroupDisplay", "", "Provider", "cooparticlesapi-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nBarrierSwordGroupClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BarrierSwordGroupClient.kt\ncn/coostack/cooparticlesapi/test/particle/client/BarrierSwordGroupClient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,124:1\n1208#2,2:125\n1236#2,4:127\n*S KotlinDebug\n*F\n+ 1 BarrierSwordGroupClient.kt\ncn/coostack/cooparticlesapi/test/particle/client/BarrierSwordGroupClient\n*L\n49#1:125,2\n49#1:127,4\n*E\n"})
public final class BarrierSwordGroupClient
extends ControlableParticleGroup {
    @Nullable
    private Integer targetEntityID;
    @NotNull
    private Vec3 defaultDirection;
    private int hilt;
    private int swordBody;
    private int swordHeadLen;
    private double bodySize;
    private int tail;
    private double step;

    public BarrierSwordGroupClient(@NotNull UUID uuid, @Nullable Integer targetEntityID) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        super(uuid);
        this.targetEntityID = targetEntityID;
        this.defaultDirection = new Vec3(0.0, 1.0, 0.0);
        this.hilt = 2;
        this.swordBody = 6;
        this.swordHeadLen = 3;
        this.bodySize = 1.0;
        this.tail = 4;
        this.step = 0.25;
        this.setAxis(RelativeLocation.Companion.zAxis());
    }

    @Nullable
    public final Integer getTargetEntityID() {
        return this.targetEntityID;
    }

    public final void setTargetEntityID(@Nullable Integer n) {
        this.targetEntityID = n;
    }

    public final int getHilt() {
        return this.hilt;
    }

    public final void setHilt(int n) {
        this.hilt = n;
    }

    public final int getSwordBody() {
        return this.swordBody;
    }

    public final void setSwordBody(int n) {
        this.swordBody = n;
    }

    public final int getSwordHeadLen() {
        return this.swordHeadLen;
    }

    public final void setSwordHeadLen(int n) {
        this.swordHeadLen = n;
    }

    public final double getBodySize() {
        return this.bodySize;
    }

    public final void setBodySize(double d) {
        this.bodySize = d;
    }

    public final int getTail() {
        return this.tail;
    }

    public final void setTail(int n) {
        this.tail = n;
    }

    public final double getStep() {
        return this.step;
    }

    public final void setStep(double d) {
        this.step = d;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public Map<ControlableParticleGroup.ParticleRelativeData, RelativeLocation> loadParticleLocations() {
        void $this$associateByTo$iv$iv;
        Iterable $this$associateBy$iv = this.genSword();
        boolean $i$f$associateBy = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
        Iterable iterable = $this$associateBy$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv : $this$associateByTo$iv$iv) {
            RelativeLocation relativeLocation = (RelativeLocation)element$iv$iv;
            Map map = destination$iv$iv;
            boolean bl = false;
            map.put(this.withEffect((Function1<? super UUID, ? extends ParticleDisplayer>)((Function1)BarrierSwordGroupClient::loadParticleLocations$lambda$2$lambda$0), (Function1<? super ControlableParticle, Unit>)((Function1)BarrierSwordGroupClient::loadParticleLocations$lambda$2$lambda$1)), element$iv$iv);
        }
        return destination$iv$iv;
    }

    private final List<RelativeLocation> genSword() {
        List res = new ArrayList();
        for (double c = (double)(-this.hilt) + 0.0; c < (double)this.hilt; c += this.step) {
            res.add(new RelativeLocation(c, 0.0, 0.0));
        }
        int i = 1;
        int n = this.swordBody;
        if (i <= n) {
            while (true) {
                res.add(new RelativeLocation(-this.bodySize * this.step, 0.0, this.step * (double)i));
                res.add(new RelativeLocation(this.bodySize * this.step, 0.0, this.step * (double)i));
                if (i == n) break;
                ++i;
            }
        }
        if ((i = 1) <= (n = this.tail)) {
            while (true) {
                res.add(new RelativeLocation(0.0, 0.0, -this.step * (double)i));
                if (i == n) break;
                ++i;
            }
        }
        RelativeLocation highest = new RelativeLocation(0.0, 0.0, this.step * (double)(this.swordBody + this.swordHeadLen));
        RelativeLocation l = new RelativeLocation(-this.bodySize * this.step, 0.0, this.step * (double)this.swordBody);
        RelativeLocation r = new RelativeLocation(this.bodySize * this.step, 0.0, this.step * (double)this.swordBody);
        res.addAll((Collection)Math3DUtil.INSTANCE.getLineLocations(highest.toVector(), l.toVector(), this.swordBody));
        res.addAll((Collection)Math3DUtil.INSTANCE.getLineLocations(highest.toVector(), r.toVector(), this.swordBody));
        return res;
    }

    @Override
    public void onGroupDisplay() {
        this.setAxis(RelativeLocation.Companion.yAxis());
        this.addPreTickAction((Function1<? super ControlableParticleGroup, Unit>)((Function1)arg_0 -> BarrierSwordGroupClient.onGroupDisplay$lambda$3(this, arg_0)));
    }

    private static final ParticleDisplayer loadParticleLocations$lambda$2$lambda$0(UUID u) {
        Intrinsics.checkNotNullParameter((Object)u, (String)"u");
        return ParticleDisplayer.Companion.withSingle(new ControlableEndRodEffect(u, false, 2, null));
    }

    private static final Unit loadParticleLocations$lambda$2$lambda$1(ControlableParticle $this$withEffect) {
        Intrinsics.checkNotNullParameter((Object)((Object)$this$withEffect), (String)"$this$withEffect");
        $this$withEffect.setColor(new Vector3f(1.0f, 1.0f, 1.0f));
        return Unit.INSTANCE;
    }

    private static final Unit onGroupDisplay$lambda$3(BarrierSwordGroupClient this$0, ControlableParticleGroup it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.targetEntityID != null) {
            ClientLevel clientLevel = this$0.getWorld();
            Intrinsics.checkNotNull((Object)clientLevel);
            Integer n = this$0.targetEntityID;
            Intrinsics.checkNotNull((Object)n);
            Entity entity = clientLevel.getEntity(n.intValue());
            if (entity == null) {
                return Unit.INSTANCE;
            }
            Entity entity2 = entity;
            Vec3 direction = entity2.position().subtract(this$0.getOrigin());
            Intrinsics.checkNotNull((Object)direction);
            this$0.rotateParticlesToPoint(RelativeLocation.Companion.of(direction));
        } else {
            this$0.rotateParticlesToPoint(RelativeLocation.Companion.of(this$0.defaultDirection));
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\tH\u0016J(\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00052\u0016\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\n\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u000b0\tH\u0016\u00a8\u0006\u000f"}, d2={"Lcn/coostack/cooparticlesapi/test/particle/client/BarrierSwordGroupClient$Provider;", "Lcn/coostack/cooparticlesapi/particles/control/group/ControlableParticleGroupProvider;", "<init>", "()V", "createGroup", "Lcn/coostack/cooparticlesapi/particles/control/group/ControlableParticleGroup;", "uuid", "Ljava/util/UUID;", "args", "", "", "Lcn/coostack/cooparticlesapi/network/buffer/ParticleControlerDataBuffer;", "changeGroup", "", "group", "cooparticlesapi-neoforge-1.21.1"})
    public static final class Provider
    implements ControlableParticleGroupProvider {
        @Override
        @NotNull
        public ControlableParticleGroup createGroup(@NotNull UUID uuid, @NotNull Map<String, ? extends ParticleControlerDataBuffer<?>> args) {
            BarrierSwordGroupClient barrierSwordGroupClient;
            Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
            Intrinsics.checkNotNullParameter(args, (String)"args");
            BarrierSwordGroupClient it = barrierSwordGroupClient = new BarrierSwordGroupClient(uuid, null);
            boolean bl = false;
            ParticleControlerDataBuffer<?> particleControlerDataBuffer = args.get("direction");
            Intrinsics.checkNotNull(particleControlerDataBuffer);
            Object obj = particleControlerDataBuffer.getLoadedValue();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type net.minecraft.world.phys.Vec3");
            it.defaultDirection = (Vec3)obj;
            return barrierSwordGroupClient;
        }

        @Override
        public void changeGroup(@NotNull ControlableParticleGroup group, @NotNull Map<String, ? extends ParticleControlerDataBuffer<?>> args) {
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            Intrinsics.checkNotNullParameter(args, (String)"args");
            BarrierSwordGroupClient cfr_ignored_0 = (BarrierSwordGroupClient)group;
            if (args.containsKey("target_entity_id")) {
                BarrierSwordGroupClient barrierSwordGroupClient = (BarrierSwordGroupClient)group;
                ParticleControlerDataBuffer<?> particleControlerDataBuffer = args.get("target_entity_id");
                Intrinsics.checkNotNull(particleControlerDataBuffer);
                Object obj = particleControlerDataBuffer.getLoadedValue();
                Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type kotlin.Int");
                barrierSwordGroupClient.setTargetEntityID((Integer)obj);
            }
        }
    }
}

