/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.utils;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010(\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u001bB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0013\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0012J\u0016\u0010\u0013\u001a\u00028\u00002\u0006\u0010\u0014\u001a\u00020\u0004H\u0086\u0002\u00a2\u0006\u0002\u0010\u0015J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0004J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001aH\u0096\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0018\u0010\t\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\nX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\fR\u000e\u0010\r\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lcn/coostack/cooparticlesapi/utils/CircularQueue;", "T", "", "capacity", "", "<init>", "(I)V", "getCapacity", "()I", "data", "", "", "[Ljava/lang/Object;", "size", "head", "addFirst", "", "value", "(Ljava/lang/Object;)V", "get", "index", "(I)Ljava/lang/Object;", "empty", "", "notNullSize", "iterator", "", "CircularIterator", "cooparticlesapi-neoforge-1.21.1"})
public final class CircularQueue<T>
implements Iterable<T>,
KMappedMarker {
    private final int capacity;
    @NotNull
    private final Object[] data;
    private int size;
    private int head;

    public CircularQueue(int capacity) {
        this.capacity = capacity;
        this.data = new Object[this.capacity];
    }

    public final int getCapacity() {
        return this.capacity;
    }

    public final void addFirst(T value) {
        if (this.size < this.capacity) {
            int n = this.head;
            this.head = n + 1;
            this.data[n] = value;
            n = this.size;
            this.size = n + 1;
            return;
        }
        this.head %= this.capacity;
        int n = this.head;
        this.head = n + 1;
        this.data[n] = value;
    }

    public final T get(int index) {
        if (index > this.size) {
            throw new IndexOutOfBoundsException("\u8d85\u8fc7\u4f60\u8bbe\u5b9a\u7684capacity\u6216\u8005\u4f60\u8fd8\u6ca1\u8f93\u5165\u90a3\u4e48\u591a\u5143\u7d20 size: " + this.size + ", index: " + index);
        }
        int i = this.size < this.capacity ? index : (index + this.head) % this.capacity;
        return (T)this.data[i];
    }

    public final boolean empty() {
        return this.notNullSize() == 0;
    }

    public final int notNullSize() {
        return this.size;
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return new CircularIterator(this);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\u0018\u0000*\u0004\b\u0001\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u000e\u0010\t\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\nJ\t\u0010\u000b\u001a\u00020\fH\u0096\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcn/coostack/cooparticlesapi/utils/CircularQueue$CircularIterator;", "T", "", "queue", "Lcn/coostack/cooparticlesapi/utils/CircularQueue;", "<init>", "(Lcn/coostack/cooparticlesapi/utils/CircularQueue;)V", "current", "", "next", "()Ljava/lang/Object;", "hasNext", "", "cooparticlesapi-neoforge-1.21.1"})
    public static final class CircularIterator<T>
    implements Iterator<T>,
    KMappedMarker {
        @NotNull
        private final CircularQueue<T> queue;
        private int current;

        public CircularIterator(@NotNull CircularQueue<T> queue) {
            Intrinsics.checkNotNullParameter(queue, (String)"queue");
            this.queue = queue;
        }

        @Override
        public T next() {
            int n = this.current;
            this.current = n + 1;
            return this.queue.get(n);
        }

        @Override
        public boolean hasNext() {
            return ((CircularQueue)this.queue).size > this.current;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }
}

