/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.cooparticlesapi.utils;

import cn.coostack.cooparticlesapi.utils.RelativeLocation;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0016\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005J\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\nJ\"\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\nJ\"\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\nJ \u0010\u0014\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0012H\u0002\u00a8\u0006\u0017"}, d2={"Lcn/coostack/cooparticlesapi/utils/ImageUtil;", "", "<init>", "()V", "loadFromIdentifier", "Ljava/awt/image/BufferedImage;", "id", "Lnet/minecraft/resources/ResourceLocation;", "scale", "scalePrecent", "", "image", "toPoints", "", "Lcn/coostack/cooparticlesapi/utils/RelativeLocation;", "step", "toPointsWithAlpha", "", "", "toPointsWithRGBA", "getAlpha", "x", "y", "cooparticlesapi-neoforge-1.21.1"})
public final class ImageUtil {
    @NotNull
    public static final ImageUtil INSTANCE = new ImageUtil();

    private ImageUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final BufferedImage loadFromIdentifier(@NotNull ResourceLocation id) {
        BufferedImage bufferedImage;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        String namespace = id.getNamespace();
        String path = "assets/" + namespace + "/" + id.getPath();
        InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream(path);
        if (inputStream == null) {
            return null;
        }
        InputStream stream = inputStream;
        Closeable closeable = stream;
        Throwable throwable = null;
        try {
            InputStream it = (InputStream)closeable;
            boolean bl = false;
            bufferedImage = ImageIO.read(it);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return bufferedImage;
    }

    @NotNull
    public final BufferedImage scale(double scalePrecent, @NotNull BufferedImage image) {
        Graphics2D graphics2D;
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        BufferedImage bufferedImage = new BufferedImage(MathKt.roundToInt((double)((double)image.getWidth() * scalePrecent)), MathKt.roundToInt((double)((double)image.getHeight() * scalePrecent)), image.getType());
        Graphics2D $this$scale_u24lambda_u241 = graphics2D = bufferedImage.createGraphics();
        boolean bl = false;
        $this$scale_u24lambda_u241.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        $this$scale_u24lambda_u241.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        $this$scale_u24lambda_u241.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Graphics2D graphics = graphics2D;
        graphics.drawImage(image, 0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null);
        graphics.dispose();
        return bufferedImage;
    }

    @NotNull
    public final List<RelativeLocation> toPoints(@NotNull BufferedImage image, double step) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        ArrayList<RelativeLocation> res = new ArrayList<RelativeLocation>();
        int n = image.getWidth();
        for (int x = 0; x < n; ++x) {
            int n2 = image.getHeight();
            for (int y = 0; y < n2; ++y) {
                int alpha = this.getAlpha(image, x, y);
                if (alpha == 0) continue;
                res.add(new RelativeLocation((double)x * step, 0.0, (double)y * step));
            }
        }
        return res;
    }

    @NotNull
    public final Map<RelativeLocation, Integer> toPointsWithAlpha(@NotNull BufferedImage image, double step) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        HashMap res = new HashMap();
        int n = image.getWidth();
        for (int x = 0; x < n; ++x) {
            int n2 = image.getHeight();
            for (int y = 0; y < n2; ++y) {
                int alpha = this.getAlpha(image, x, y);
                if (alpha == 0) continue;
                ((Map)res).put(new RelativeLocation((double)x * step, 0.0, (double)y * step), alpha);
            }
        }
        return res;
    }

    @NotNull
    public final Map<RelativeLocation, Integer> toPointsWithRGBA(@NotNull BufferedImage image, double step) {
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        HashMap res = new HashMap();
        int n = image.getWidth();
        for (int x = 0; x < n; ++x) {
            int n2 = image.getHeight();
            for (int y = 0; y < n2; ++y) {
                int alpha = this.getAlpha(image, x, y);
                if (alpha == 0) continue;
                ((Map)res).put(new RelativeLocation((double)x * step, 0.0, (double)y * step), image.getRGB(x, y));
            }
        }
        return res;
    }

    private final int getAlpha(BufferedImage image, int x, int y) {
        if (!image.getColorModel().hasAlpha()) {
            return 255;
        }
        int pixel = image.getRGB(x, y);
        return pixel >> 24 & 0xFF;
    }
}

